"use strict";

// Methods to work with vendor prefixes
module.exports = {

    // Return vendor prefix from property name, if it exists
    //
    //   vendor.prefix('-moz-box-sizing') #=> '-moz-'
    //   vendor.prefix('box-sizing')      #=> ''
    prefix: function prefix(prop) {
        if (prop[0] == "-") {
            var sep = prop.indexOf("-", 1);
            return prop.substr(0, sep + 1);
        } else {
            return "";
        }
    },

    // Remove prefix from property name
    //
    //   vendor.prefix('-moz-box-sizing') #=> 'box-sizing'
    //   vendor.prefix('box-sizing')      #=> 'box-sizing'
    unprefixed: function unprefixed(prop) {
        if (prop[0] == "-") {
            var sep = prop.indexOf("-", 1);
            return prop.substr(sep + 1);
        } else {
            return prop;
        }
    }

};