"use strict";

var _interopRequire = function (obj) { return obj && obj.__esModule ? obj["default"] : obj; };

var _prototypeProperties = function (child, staticProps, instanceProps) { if (staticProps) Object.defineProperties(child, staticProps); if (instanceProps) Object.defineProperties(child.prototype, instanceProps); };

var _classCallCheck = function (instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } };

var MapGenerator = _interopRequire(require("./map-generator"));

// Object with processed CSS

var Result = (function () {
    function Result(root) {
        var opts = arguments[1] === undefined ? {} : arguments[1];

        _classCallCheck(this, Result);

        this.root = root;
        this.opts = opts;
    }

    // Return CSS string on any try to print

    Result.prototype.toString = function toString() {
        return this.css;
    };

    // Generate CSS and map

    Result.prototype.stringify = function stringify() {
        var map = new MapGenerator(this.root, this.opts);
        var generated = map.generate();
        this.cssCached = generated[0];
        this.mapCached = generated[1];
    };

    _prototypeProperties(Result, null, {
        map: {

            // Lazy method to return source map

            get: function () {
                if (!this.cssCached) this.stringify();
                return this.mapCached;
            },
            configurable: true
        },
        css: {

            // Lazy method to return CSS string

            get: function () {
                if (!this.cssCached) this.stringify();
                return this.cssCached;
            },
            configurable: true
        }
    });

    return Result;
})();

module.exports = Result;