"""Generated message classes for compute version alpha.

Creates and runs virtual machines on Google Cloud Platform.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from googlecloudsdk.third_party.apitools.base.protorpclite import messages as _messages
from googlecloudsdk.third_party.apitools.base.py import encoding


package = 'compute'


class AccessConfig(_messages.Message):
  """An access configuration attached to an instance's network interface. Only
  one access config per instance is supported.

  Enums:
    TypeValueValuesEnum: The type of configuration. The default and only
      option is ONE_TO_ONE_NAT.

  Fields:
    kind: [Output Only] Type of the resource. Always compute#accessConfig for
      access configs.
    name: Name of this access configuration.
    natIP: An external IP address associated with this instance. Specify an
      unused static external IP address available to the project or leave this
      field undefined to use an IP from a shared ephemeral IP address pool. If
      you specify a static external IP address, it must live in the same
      region as the zone of the instance.
    type: The type of configuration. The default and only option is
      ONE_TO_ONE_NAT.
  """

  class TypeValueValuesEnum(_messages.Enum):
    """The type of configuration. The default and only option is
    ONE_TO_ONE_NAT.

    Values:
      ONE_TO_ONE_NAT: <no description>
    """
    ONE_TO_ONE_NAT = 0

  kind = _messages.StringField(1, default=u'compute#accessConfig')
  name = _messages.StringField(2)
  natIP = _messages.StringField(3)
  type = _messages.EnumField('TypeValueValuesEnum', 4, default=u'ONE_TO_ONE_NAT')


class Address(_messages.Message):
  """A reserved address resource.

  Enums:
    StatusValueValuesEnum: [Output Only] The status of the address, which can
      be either IN_USE or RESERVED. An address that is RESERVED is currently
      reserved and available to use. An IN_USE address is currently being used
      by another resource and is not available.

  Fields:
    address: The static external IP address represented by this resource.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] Type of the resource. Always compute#address for
      addresses.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    region: [Output Only] URL of the region where the regional address
      resides. This field is not applicable to global addresses.
    selfLink: [Output Only] Server-defined URL for the resource.
    status: [Output Only] The status of the address, which can be either
      IN_USE or RESERVED. An address that is RESERVED is currently reserved
      and available to use. An IN_USE address is currently being used by
      another resource and is not available.
    users: [Output Only] The URLs of the resources that are using this
      address.
  """

  class StatusValueValuesEnum(_messages.Enum):
    """[Output Only] The status of the address, which can be either IN_USE or
    RESERVED. An address that is RESERVED is currently reserved and available
    to use. An IN_USE address is currently being used by another resource and
    is not available.

    Values:
      IN_USE: <no description>
      RESERVED: <no description>
    """
    IN_USE = 0
    RESERVED = 1

  address = _messages.StringField(1)
  creationTimestamp = _messages.StringField(2)
  description = _messages.StringField(3)
  id = _messages.IntegerField(4, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(5, default=u'compute#address')
  name = _messages.StringField(6)
  region = _messages.StringField(7)
  selfLink = _messages.StringField(8)
  status = _messages.EnumField('StatusValueValuesEnum', 9)
  users = _messages.StringField(10, repeated=True)


class AddressAggregatedList(_messages.Message):
  """A AddressAggregatedList object.

  Messages:
    ItemsValue: [Output Only] A map of scoped address lists.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: [Output Only] A map of scoped address lists.
    kind: [Output Only] Type of resource. Always compute#addressAggregatedList
      for aggregated lists of addresses.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    """[Output Only] A map of scoped address lists.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: [Output Only] Name of the scope containing this
        set of addresses.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A AddressesScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('AddressesScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default=u'compute#addressAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class AddressList(_messages.Message):
  """Contains a list of addresses.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: [Output Only] A list of addresses.
    kind: [Output Only] Type of resource. Always compute#addressList for lists
      of addresses.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for the resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('Address', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#addressList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class AddressesScopedList(_messages.Message):
  """A AddressesScopedList object.

  Messages:
    WarningValue: [Output Only] Informational warning which replaces the list
      of addresses when the list is empty.

  Fields:
    addresses: [Output Only] List of addresses contained in this scope.
    warning: [Output Only] Informational warning which replaces the list of
      addresses when the list is empty.
  """

  class WarningValue(_messages.Message):
    """[Output Only] Informational warning which replaces the list of
    addresses when the list is empty.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      """[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 2
      INJECTED_KERNELS_DEPRECATED = 3
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 4
      NEXT_HOP_CANNOT_IP_FORWARD = 5
      NEXT_HOP_INSTANCE_NOT_FOUND = 6
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 7
      NEXT_HOP_NOT_RUNNING = 8
      NOT_CRITICAL_ERROR = 9
      NO_RESULTS_ON_PAGE = 10
      REQUIRED_TOS_AGREEMENT = 11
      RESOURCE_NOT_DELETED = 12
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 13
      UNREACHABLE = 14

    class DataValueListEntry(_messages.Message):
      """A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  addresses = _messages.MessageField('Address', 1, repeated=True)
  warning = _messages.MessageField('WarningValue', 2)


class AttachedDisk(_messages.Message):
  """An instance-attached disk resource.

  Enums:
    InterfaceValueValuesEnum: Specifies the disk interface to use for
      attaching this disk, which is either SCSI or NVME. The default is SCSI.
      Persistent disks must always use SCSI and the request will fail if you
      attempt to attach a persistent disk in any other format than SCSI. Local
      SSDs can use either NVME or SCSI. For performance characteristics of
      SCSI over NVMe, see Local SSD performance.
    ModeValueValuesEnum: The mode in which to attach this disk, either
      READ_WRITE or READ_ONLY. If not specified, the default is to attach the
      disk in READ_WRITE mode.
    TypeValueValuesEnum: Specifies the type of the disk, either SCRATCH or
      PERSISTENT. If not specified, the default is PERSISTENT.

  Fields:
    autoDelete: Specifies whether the disk will be auto-deleted when the
      instance is deleted (but not when the disk is detached from the
      instance).
    boot: Indicates that this is a boot disk. The virtual machine will use the
      first partition of the disk for its root filesystem.
    deviceName: Specifies a unique device name of your choice that is
      reflected into the /dev/disk/by-id/google-* tree of a Linux operating
      system running within the instance. This name can be used to reference
      the device for mounting, resizing, and so on, from within the instance.
      If not specified, the server chooses a default device name to apply to
      this disk, in the form persistent-disks-x, where x is a number assigned
      by Google Compute Engine. This field is only applicable for persistent
      disks.
    diskEncryptionKey: Encrypts or decrypts a disk using a customer-supplied
      encryption key.  If you are creating a new disk, this field encrypts the
      new disk using an encryption key that you provide. If you are attaching
      an existing disk that is already encrypted, this field decrypts the disk
      using the customer-supplied encryption key.  If you encrypt a disk using
      a customer-supplied key, you must provide the same key again when you
      attempt to use this resource at a later time. For example, you must
      provide the key when you create a snapshot or an image from the disk or
      when you attach the disk to a virtual machine instance.  If you do not
      provide an encryption key, then the disk will be encrypted using an
      automatically generated key and you do not need to provide a key to use
      the disk later.  Instance templates do not store customer-supplied
      encryption keys, so you cannot use your own keys to encrypt disks in a
      managed instance group.
    index: Assigns a zero-based index to this disk, where 0 is reserved for
      the boot disk. For example, if you have many disks attached to an
      instance, each disk would have a unique index number. If not specified,
      the server will choose an appropriate value.
    initializeParams: [Input Only] Specifies the parameters for a new disk
      that will be created alongside the new instance. Use initialization
      parameters to create boot disks or local SSDs attached to the new
      instance.  This property is mutually exclusive with the source property;
      you can only define one or the other, but not both.
    interface: Specifies the disk interface to use for attaching this disk,
      which is either SCSI or NVME. The default is SCSI. Persistent disks must
      always use SCSI and the request will fail if you attempt to attach a
      persistent disk in any other format than SCSI. Local SSDs can use either
      NVME or SCSI. For performance characteristics of SCSI over NVMe, see
      Local SSD performance.
    kind: [Output Only] Type of the resource. Always compute#attachedDisk for
      attached disks.
    licenses: [Output Only] Any valid publicly visible licenses.
    mode: The mode in which to attach this disk, either READ_WRITE or
      READ_ONLY. If not specified, the default is to attach the disk in
      READ_WRITE mode.
    source: Specifies a valid partial or full URL to an existing Persistent
      Disk resource. This field is only applicable for persistent disks.
    type: Specifies the type of the disk, either SCRATCH or PERSISTENT. If not
      specified, the default is PERSISTENT.
  """

  class InterfaceValueValuesEnum(_messages.Enum):
    """Specifies the disk interface to use for attaching this disk, which is
    either SCSI or NVME. The default is SCSI. Persistent disks must always use
    SCSI and the request will fail if you attempt to attach a persistent disk
    in any other format than SCSI. Local SSDs can use either NVME or SCSI. For
    performance characteristics of SCSI over NVMe, see Local SSD performance.

    Values:
      NVME: <no description>
      SCSI: <no description>
    """
    NVME = 0
    SCSI = 1

  class ModeValueValuesEnum(_messages.Enum):
    """The mode in which to attach this disk, either READ_WRITE or READ_ONLY.
    If not specified, the default is to attach the disk in READ_WRITE mode.

    Values:
      READ_ONLY: <no description>
      READ_WRITE: <no description>
    """
    READ_ONLY = 0
    READ_WRITE = 1

  class TypeValueValuesEnum(_messages.Enum):
    """Specifies the type of the disk, either SCRATCH or PERSISTENT. If not
    specified, the default is PERSISTENT.

    Values:
      PERSISTENT: <no description>
      SCRATCH: <no description>
    """
    PERSISTENT = 0
    SCRATCH = 1

  autoDelete = _messages.BooleanField(1)
  boot = _messages.BooleanField(2)
  deviceName = _messages.StringField(3)
  diskEncryptionKey = _messages.MessageField('CustomerEncryptionKey', 4)
  index = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  initializeParams = _messages.MessageField('AttachedDiskInitializeParams', 6)
  interface = _messages.EnumField('InterfaceValueValuesEnum', 7)
  kind = _messages.StringField(8, default=u'compute#attachedDisk')
  licenses = _messages.StringField(9, repeated=True)
  mode = _messages.EnumField('ModeValueValuesEnum', 10)
  source = _messages.StringField(11)
  type = _messages.EnumField('TypeValueValuesEnum', 12)


class AttachedDiskInitializeParams(_messages.Message):
  """[Input Only] Specifies the parameters for a new disk that will be created
  alongside the new instance. Use initialization parameters to create boot
  disks or local SSDs attached to the new instance.  This property is mutually
  exclusive with the source property; you can only define one or the other,
  but not both.

  Enums:
    DiskStorageTypeValueValuesEnum: [Deprecated] Storage type of the disk.

  Fields:
    diskName: Specifies the disk name. If not specified, the default is to use
      the name of the instance.
    diskSizeGb: Specifies the size of the disk in base-2 GB.
    diskStorageType: [Deprecated] Storage type of the disk.
    diskType: Specifies the disk type to use to create the instance. If not
      specified, the default is pd-standard, specified using the full URL. For
      example:  https://www.googleapis.com/compute/v1/projects/project/zones/z
      one/diskTypes/pd-standard   Other values include pd-ssd and local-ssd.
      If you define this field, you can provide either the full or partial
      URL. For example, the following are valid values:   - https://www.google
      apis.com/compute/v1/projects/project/zones/zone/diskTypes/diskType  -
      projects/project/zones/zone/diskTypes/diskType  -
      zones/zone/diskTypes/diskType
    sourceImage: The source image used to create this disk. If the source
      image is deleted, this field will not be set.  To create a disk with one
      of the public operating system images, specify the image by its family
      name. For example, specify family/debian-8 to use the latest Debian 8
      image:  projects/debian-cloud/global/images/family/debian-8
      Alternatively, use a specific version of a public operating system
      image:  projects/debian-cloud/global/images/debian-8-jessie-vYYYYMMDD
      To create a disk with a private image that you created, specify the
      image name in the following format:  global/images/my-private-image
      You can also specify a private image by its image family, which returns
      the latest version of the image in that family. Replace the image name
      with family/family-name:  global/images/family/my-private-family
    sourceImageEncryptionKey: The customer-supplied encryption key of the
      source image. Required if the source image is protected by a customer-
      supplied encryption key.  Instance templates do not store customer-
      supplied encryption keys, so you cannot create disks for instances in a
      managed instance group if the source images are encrypted with your own
      keys.
  """

  class DiskStorageTypeValueValuesEnum(_messages.Enum):
    """[Deprecated] Storage type of the disk.

    Values:
      HDD: <no description>
      SSD: <no description>
    """
    HDD = 0
    SSD = 1

  diskName = _messages.StringField(1)
  diskSizeGb = _messages.IntegerField(2)
  diskStorageType = _messages.EnumField('DiskStorageTypeValueValuesEnum', 3)
  diskType = _messages.StringField(4)
  sourceImage = _messages.StringField(5)
  sourceImageEncryptionKey = _messages.MessageField('CustomerEncryptionKey', 6)


class AuditConfig(_messages.Message):
  """Enables "data access" audit logging for a service and specifies a list of
  members that are log-exempted.

  Fields:
    exemptedMembers: Specifies the identities that are exempted from "data
      access" audit logging for the `service` specified above. Follows the
      same format of Binding.members.
    service: Specifies a service that will be enabled for "data access" audit
      logging. For example, `resourcemanager`, `storage`, `compute`.
      `allServices` is a special value that covers all services.
  """

  exemptedMembers = _messages.StringField(1, repeated=True)
  service = _messages.StringField(2)


class Autoscaler(_messages.Message):
  """Represents an Autoscaler resource. Autoscalers allow you to automatically
  scale virtual machine instances in managed instance groups according to an
  autoscaling policy that you define. For more information, read Autoscaling
  Groups of Instances.

  Enums:
    StatusValueValuesEnum: [Output Only] The status of the autoscaler
      configuration.

  Fields:
    autoscalingPolicy: The configuration parameters for the autoscaling
      algorithm. You can define one or more of the policies for an autoscaler:
      cpuUtilization, customMetricUtilizations, and loadBalancingUtilization.
      If none of these are specified, the default will be to autoscale based
      on cpuUtilization to 0.8 or 80%.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] Type of the resource. Always compute#autoscaler for
      autoscalers.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    region: [Output Only] URL of the region where the instance group resides
      (for autoscalers living in regional scope).
    selfLink: [Output Only] Server-defined URL for the resource.
    status: [Output Only] The status of the autoscaler configuration.
    statusDetails: [Output Only] Human-readable details about the current
      state of the autoscaler. Examples: ?Error when fetching replicas:
      Replica Pool xxx doesn?t exist.? ?Autoscaling capped at
      min_num_replicas: 2.?
    target: URL of the managed instance group that this autoscaler will scale.
    zone: [Output Only] URL of the zone where the instance group resides.
  """

  class StatusValueValuesEnum(_messages.Enum):
    """[Output Only] The status of the autoscaler configuration.

    Values:
      ACTIVE: <no description>
      DELETING: <no description>
      ERROR: <no description>
      PENDING: <no description>
    """
    ACTIVE = 0
    DELETING = 1
    ERROR = 2
    PENDING = 3

  autoscalingPolicy = _messages.MessageField('AutoscalingPolicy', 1)
  creationTimestamp = _messages.StringField(2)
  description = _messages.StringField(3)
  id = _messages.IntegerField(4, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(5, default=u'compute#autoscaler')
  name = _messages.StringField(6)
  region = _messages.StringField(7)
  selfLink = _messages.StringField(8)
  status = _messages.EnumField('StatusValueValuesEnum', 9)
  statusDetails = _messages.MessageField('AutoscalerStatusDetails', 10, repeated=True)
  target = _messages.StringField(11)
  zone = _messages.StringField(12)


class AutoscalerAggregatedList(_messages.Message):
  """A AutoscalerAggregatedList object.

  Messages:
    ItemsValue: A map of scoped autoscaler lists.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: A map of scoped autoscaler lists.
    kind: [Output Only] Type of resource. Always
      compute#autoscalerAggregatedList for aggregated lists of autoscalers.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    """A map of scoped autoscaler lists.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: [Output Only] Name of the scope containing this
        set of autoscalers.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A AutoscalersScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('AutoscalersScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default=u'compute#autoscalerAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class AutoscalerList(_messages.Message):
  """Contains a list of Autoscaler resources.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: A list of Autoscaler resources.
    kind: [Output Only] Type of resource. Always compute#autoscalerList for
      lists of autoscalers.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('Autoscaler', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#autoscalerList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class AutoscalerStatusDetails(_messages.Message):
  """A AutoscalerStatusDetails object.

  Enums:
    TypeValueValuesEnum:

  Fields:
    message: A string attribute.
    type: A TypeValueValuesEnum attribute.
  """

  class TypeValueValuesEnum(_messages.Enum):
    """TypeValueValuesEnum enum type.

    Values:
      ALL_INSTANCES_UNHEALTHY: <no description>
      BACKEND_SERVICE_DOES_NOT_EXIST: <no description>
      CAPPED_AT_MAX_NUM_REPLICAS: <no description>
      CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE: <no description>
      CUSTOM_METRIC_INVALID: <no description>
      MIN_EQUALS_MAX: <no description>
      MISSING_CUSTOM_METRIC_DATA_POINTS: <no description>
      MISSING_LOAD_BALANCING_DATA_POINTS: <no description>
      MORE_THAN_ONE_BACKEND_SERVICE: <no description>
      NOT_ENOUGH_QUOTA_AVAILABLE: <no description>
      SCALING_TARGET_DOES_NOT_EXIST: <no description>
      UNKNOWN: <no description>
      UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION: <no description>
    """
    ALL_INSTANCES_UNHEALTHY = 0
    BACKEND_SERVICE_DOES_NOT_EXIST = 1
    CAPPED_AT_MAX_NUM_REPLICAS = 2
    CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE = 3
    CUSTOM_METRIC_INVALID = 4
    MIN_EQUALS_MAX = 5
    MISSING_CUSTOM_METRIC_DATA_POINTS = 6
    MISSING_LOAD_BALANCING_DATA_POINTS = 7
    MORE_THAN_ONE_BACKEND_SERVICE = 8
    NOT_ENOUGH_QUOTA_AVAILABLE = 9
    SCALING_TARGET_DOES_NOT_EXIST = 10
    UNKNOWN = 11
    UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION = 12

  message = _messages.StringField(1)
  type = _messages.EnumField('TypeValueValuesEnum', 2)


class AutoscalersScopedList(_messages.Message):
  """A AutoscalersScopedList object.

  Messages:
    WarningValue: [Output Only] Informational warning which replaces the list
      of autoscalers when the list is empty.

  Fields:
    autoscalers: [Output Only] List of autoscalers contained in this scope.
    warning: [Output Only] Informational warning which replaces the list of
      autoscalers when the list is empty.
  """

  class WarningValue(_messages.Message):
    """[Output Only] Informational warning which replaces the list of
    autoscalers when the list is empty.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      """[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 2
      INJECTED_KERNELS_DEPRECATED = 3
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 4
      NEXT_HOP_CANNOT_IP_FORWARD = 5
      NEXT_HOP_INSTANCE_NOT_FOUND = 6
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 7
      NEXT_HOP_NOT_RUNNING = 8
      NOT_CRITICAL_ERROR = 9
      NO_RESULTS_ON_PAGE = 10
      REQUIRED_TOS_AGREEMENT = 11
      RESOURCE_NOT_DELETED = 12
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 13
      UNREACHABLE = 14

    class DataValueListEntry(_messages.Message):
      """A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  autoscalers = _messages.MessageField('Autoscaler', 1, repeated=True)
  warning = _messages.MessageField('WarningValue', 2)


class AutoscalingPolicy(_messages.Message):
  """Cloud Autoscaler policy.

  Fields:
    coolDownPeriodSec: The number of seconds that the autoscaler should wait
      before it starts collecting information from a new instance. This
      prevents the autoscaler from collecting information when the instance is
      initializing, during which the collected usage would not be reliable.
      The default time autoscaler waits is 60 seconds.  Virtual machine
      initialization times might vary because of numerous factors. We
      recommend that you test how long an instance may take to initialize. To
      do this, create an instance and time the startup process.
    cpuUtilization: Defines the CPU utilization policy that allows the
      autoscaler to scale based on the average CPU utilization of a managed
      instance group.
    customMetricUtilizations: Configuration parameters of autoscaling based on
      a custom metric.
    loadBalancingUtilization: Configuration parameters of autoscaling based on
      load balancer.
    maxNumReplicas: The maximum number of instances that the autoscaler can
      scale up to. This is required when creating or updating an autoscaler.
      The maximum number of replicas should not be lower than minimal number
      of replicas.
    minNumReplicas: The minimum number of replicas that the autoscaler can
      scale down to. This cannot be less than 0. If not provided, autoscaler
      will choose a default value depending on maximum number of instances
      allowed.
    queueBasedScaling: Configuration parameters of autoscaling based on
      queuing system.
  """

  coolDownPeriodSec = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  cpuUtilization = _messages.MessageField('AutoscalingPolicyCpuUtilization', 2)
  customMetricUtilizations = _messages.MessageField('AutoscalingPolicyCustomMetricUtilization', 3, repeated=True)
  loadBalancingUtilization = _messages.MessageField('AutoscalingPolicyLoadBalancingUtilization', 4)
  maxNumReplicas = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  minNumReplicas = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  queueBasedScaling = _messages.MessageField('AutoscalingPolicyQueueBasedScaling', 7)


class AutoscalingPolicyCpuUtilization(_messages.Message):
  """CPU utilization policy.

  Fields:
    utilizationTarget: The target CPU utilization that the autoscaler should
      maintain. Must be a float value in the range (0, 1]. If not specified,
      the default is 0.8.  If the CPU level is below the target utilization,
      the autoscaler scales down the number of instances until it reaches the
      minimum number of instances you specified or until the average CPU of
      your instances reaches the target utilization.  If the average CPU is
      above the target utilization, the autoscaler scales up until it reaches
      the maximum number of instances you specified or until the average
      utilization reaches the target utilization.
  """

  utilizationTarget = _messages.FloatField(1)


class AutoscalingPolicyCustomMetricUtilization(_messages.Message):
  """Custom utilization metric policy.

  Enums:
    UtilizationTargetTypeValueValuesEnum: Defines how target utilization value
      is expressed for a Cloud Monitoring metric. Either GAUGE,
      DELTA_PER_SECOND, or DELTA_PER_MINUTE. If not specified, the default is
      GAUGE.

  Fields:
    metric: The identifier of the Cloud Monitoring metric. The metric cannot
      have negative values and should be a utilization metric, which means
      that the number of virtual machines handling requests should increase or
      decrease proportionally to the metric. The metric must also have a label
      of compute.googleapis.com/resource_id with the value of the instance's
      unique ID, although this alone does not guarantee that the metric is
      valid.  For example, the following is a valid metric:
      compute.googleapis.com/instance/network/received_bytes_count   The
      following is not a valid metric because it does not increase or decrease
      based on usage: compute.googleapis.com/instance/cpu/reserved_cores
    utilizationTarget: Target value of the metric which autoscaler should
      maintain. Must be a positive value.
    utilizationTargetType: Defines how target utilization value is expressed
      for a Cloud Monitoring metric. Either GAUGE, DELTA_PER_SECOND, or
      DELTA_PER_MINUTE. If not specified, the default is GAUGE.
  """

  class UtilizationTargetTypeValueValuesEnum(_messages.Enum):
    """Defines how target utilization value is expressed for a Cloud
    Monitoring metric. Either GAUGE, DELTA_PER_SECOND, or DELTA_PER_MINUTE. If
    not specified, the default is GAUGE.

    Values:
      DELTA_PER_MINUTE: <no description>
      DELTA_PER_SECOND: <no description>
      GAUGE: <no description>
    """
    DELTA_PER_MINUTE = 0
    DELTA_PER_SECOND = 1
    GAUGE = 2

  metric = _messages.StringField(1)
  utilizationTarget = _messages.FloatField(2)
  utilizationTargetType = _messages.EnumField('UtilizationTargetTypeValueValuesEnum', 3)


class AutoscalingPolicyLoadBalancingUtilization(_messages.Message):
  """Configuration parameters of autoscaling based on load balancing.

  Fields:
    utilizationTarget: Fraction of backend capacity utilization (set in
      HTTP(s) load balancing configuration) that autoscaler should maintain.
      Must be a positive float value. If not defined, the default is 0.8.
  """

  utilizationTarget = _messages.FloatField(1)


class AutoscalingPolicyQueueBasedScaling(_messages.Message):
  """Configuration parameters of autoscaling based on queuing system.

  Fields:
    acceptableBacklogPerInstance: Scaling based on the average number of tasks
      in the queue per each active instance. The autoscaler keeps the average
      number of tasks per instance below this number, based on data collected
      in the last couple of minutes. The autoscaler will also take into
      account incoming tasks when calculating when to scale.
    cloudPubSub: Configuration for Cloud Pub/Sub subscription queue.
    singleWorkerThroughputPerSec: The scaling algorithm will also calculate
      throughput estimates on its own; if you explicitly provide this value,
      the autoscaler will take into account your value as well as automatic
      estimates when deciding how to scale.
  """

  acceptableBacklogPerInstance = _messages.FloatField(1)
  cloudPubSub = _messages.MessageField('AutoscalingPolicyQueueBasedScalingCloudPubSub', 2)
  singleWorkerThroughputPerSec = _messages.FloatField(3)


class AutoscalingPolicyQueueBasedScalingCloudPubSub(_messages.Message):
  """Configuration parameters for scaling based on Cloud Pub/Sub subscription
  queue.

  Fields:
    subscription: Cloud Pub/Sub subscription used for scaling. Provide the
      partial URL (starting with projects/) or just the subscription name. The
      subscription must be assigned to the topic specified in topicName and
      must be in a pull configuration. The subscription must belong to the
      same project as the Autoscaler.
    topic: Cloud Pub/Sub topic used for scaling. Provide the partial URL or
      partial URL (starting with projects/) or just the topic name. The topic
      must belong to the same project as the Autoscaler resource.
  """

  subscription = _messages.StringField(1)
  topic = _messages.StringField(2)


class Backend(_messages.Message):
  """Message containing information of one individual backend.

  Enums:
    BalancingModeValueValuesEnum: Specifies the balancing mode for this
      backend. For global HTTP(S) load balancing, the default is UTILIZATION.
      Valid values are UTILIZATION and RATE.  This cannot be used for internal
      load balancing.

  Fields:
    balancingMode: Specifies the balancing mode for this backend. For global
      HTTP(S) load balancing, the default is UTILIZATION. Valid values are
      UTILIZATION and RATE.  This cannot be used for internal load balancing.
    capacityScaler: A multiplier applied to the group's maximum servicing
      capacity (either UTILIZATION or RATE). Default value is 1, which means
      the group will serve up to 100% of its configured CPU or RPS (depending
      on balancingMode). A setting of 0 means the group is completely drained,
      offering 0% of its available CPU or RPS. Valid range is [0.0,1.0].  This
      cannot be used for internal load balancing.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    group: The fully-qualified URL of a zonal Instance Group resource. This
      instance group defines the list of instances that serve traffic. Member
      virtual machine instances from each instance group must live in the same
      zone as the instance group itself. No two backends in a backend service
      are allowed to use same Instance Group resource.  Note that you must
      specify an Instance Group resource using the fully-qualified URL, rather
      than a partial URL.  When the BackendService has load balancing scheme
      INTERNAL, the instance group must be in a zone within the same region as
      the BackendService.
    maxConnections: The max number of simultaneous connections for the group.
      Can be used with either CONNECTION or UTILIZATION balancing modes. For
      CONNECTION mode, either maxConnections or maxConnectionsPerInstance must
      be set.  This cannot be used for internal load balancing.
    maxConnectionsPerInstance: The max number of simultaneous connections that
      a single backend instance can handle. This is used to calculate the
      capacity of the group. Can be used in either CONNECTION or UTILIZATION
      balancing modes. For CONNECTION mode, either maxConnections or
      maxConnectionsPerInstance must be set.  This cannot be used for internal
      load balancing.
    maxRate: The max requests per second (RPS) of the group. Can be used with
      either RATE or UTILIZATION balancing modes, but required if RATE mode.
      For RATE mode, either maxRate or maxRatePerInstance must be set.  This
      cannot be used for internal load balancing.
    maxRatePerInstance: The max requests per second (RPS) that a single
      backend instance can handle.This is used to calculate the capacity of
      the group. Can be used in either balancing mode. For RATE mode, either
      maxRate or maxRatePerInstance must be set.  This cannot be used for
      internal load balancing.
    maxUtilization: Used when balancingMode is UTILIZATION. This ratio defines
      the CPU utilization target for the group. The default is 0.8. Valid
      range is [0.0, 1.0].  This cannot be used for internal load balancing.
  """

  class BalancingModeValueValuesEnum(_messages.Enum):
    """Specifies the balancing mode for this backend. For global HTTP(S) load
    balancing, the default is UTILIZATION. Valid values are UTILIZATION and
    RATE.  This cannot be used for internal load balancing.

    Values:
      CONNECTION: <no description>
      RATE: <no description>
      UTILIZATION: <no description>
    """
    CONNECTION = 0
    RATE = 1
    UTILIZATION = 2

  balancingMode = _messages.EnumField('BalancingModeValueValuesEnum', 1)
  capacityScaler = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  description = _messages.StringField(3)
  group = _messages.StringField(4)
  maxConnections = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  maxConnectionsPerInstance = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  maxRate = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  maxRatePerInstance = _messages.FloatField(8, variant=_messages.Variant.FLOAT)
  maxUtilization = _messages.FloatField(9, variant=_messages.Variant.FLOAT)


class BackendBucket(_messages.Message):
  """A BackendBucket resource. This resource defines a Cloud Storage bucket.

  Fields:
    bucketName: Cloud Storage bucket name.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional textual description of the resource; provided by
      the client when the resource is created.
    enableCdn: If true, enable Cloud CDN for this BackendBucket.
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    kind: Type of the resource.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    selfLink: [Output Only] Server-defined URL for the resource.
  """

  bucketName = _messages.StringField(1)
  creationTimestamp = _messages.StringField(2)
  description = _messages.StringField(3)
  enableCdn = _messages.BooleanField(4)
  id = _messages.IntegerField(5, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(6, default=u'compute#backendBucket')
  name = _messages.StringField(7)
  selfLink = _messages.StringField(8)


class BackendBucketList(_messages.Message):
  """Contains a list of BackendBucket resources.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of BackendBucket resources.
    kind: Type of resource.
    nextPageToken: [Output Only] A token used to continue a truncated list
      request.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('BackendBucket', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#backendBucketList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class BackendSSLPolicy(_messages.Message):
  """Message containing backend SSL policies.

  Fields:
    pinnedPeerCertificates: List of PEM-encoded peer certificates, from which
      the public keys are extracted for authenticating the backend service.
  """

  pinnedPeerCertificates = _messages.StringField(1, repeated=True)


class BackendService(_messages.Message):
  """A BackendService resource. This resource defines a group of backend
  virtual machines and their serving capacity.

  Enums:
    LoadBalancingSchemeValueValuesEnum:
    ProtocolValueValuesEnum: The protocol this BackendService uses to
      communicate with backends.  Possible values are HTTP, HTTPS, HTTP2, TCP
      and SSL. The default is HTTP.  For internal load balancing, the possible
      values are TCP and UDP, and the default is TCP.
    SessionAffinityValueValuesEnum: Type of session affinity to use. The
      default is NONE.  When the load balancing scheme is EXTERNAL, can be
      NONE, CLIENT_IP, or GENERATED_COOKIE.  When the load balancing scheme is
      INTERNAL, can be NONE, CLIENT_IP, CLIENT_IP_PROTO, or
      CLIENT_IP_PORT_PROTO.  When the protocol is UDP, this field is not used.

  Fields:
    affinityCookieTtlSec: Lifetime of cookies in seconds if session_affinity
      is GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
      only until the end of the browser session (or equivalent). The maximum
      allowed value for TTL is one day.  When the load balancing scheme is
      INTERNAL, this field is not used.
    backendSslPolicy: Backend SSL policies to enforce.
    backends: The list of backends that serve this BackendService.
    connectionDraining: A ConnectionDraining attribute.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    enableCDN: If true, enable Cloud CDN for this BackendService.  When the
      load balancing scheme is INTERNAL, this field is not used.
    fingerprint: Fingerprint of this resource. A hash of the contents stored
      in this object. This field is used in optimistic locking. This field
      will be ignored when inserting a BackendService. An up-to-date
      fingerprint must be provided in order to update the BackendService.
    healthChecks: The list of URLs to the HttpHealthCheck or HttpsHealthCheck
      resource for health checking this BackendService. Currently at most one
      health check can be specified, and a health check is required.  For
      internal load balancing, a URL to a HealthCheck resource must be
      specified instead.
    iaap: A BackendServiceIAAP attribute.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] Type of resource. Always compute#backendService for
      backend services.
    loadBalancingScheme: A LoadBalancingSchemeValueValuesEnum attribute.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    port: Deprecated in favor of portName. The TCP port to connect on the
      backend. The default value is 80.  This cannot be used for internal load
      balancing.
    portName: Name of backend port. The same name should appear in the
      instance groups referenced by this service. Required when the load
      balancing scheme is EXTERNAL.  When the load balancing scheme is
      INTERNAL, this field is not used.
    protocol: The protocol this BackendService uses to communicate with
      backends.  Possible values are HTTP, HTTPS, HTTP2, TCP and SSL. The
      default is HTTP.  For internal load balancing, the possible values are
      TCP and UDP, and the default is TCP.
    region: [Output Only] URL of the region where the regional backend service
      resides. This field is not applicable to global backend services.
    selfLink: [Output Only] Server-defined URL for the resource.
    sessionAffinity: Type of session affinity to use. The default is NONE.
      When the load balancing scheme is EXTERNAL, can be NONE, CLIENT_IP, or
      GENERATED_COOKIE.  When the load balancing scheme is INTERNAL, can be
      NONE, CLIENT_IP, CLIENT_IP_PROTO, or CLIENT_IP_PORT_PROTO.  When the
      protocol is UDP, this field is not used.
    timeoutSec: How many seconds to wait for the backend before considering it
      a failed request. Default is 30 seconds.
  """

  class LoadBalancingSchemeValueValuesEnum(_messages.Enum):
    """LoadBalancingSchemeValueValuesEnum enum type.

    Values:
      EXTERNAL: <no description>
      INTERNAL: <no description>
      INVALID_LOAD_BALANCING_SCHEME: <no description>
    """
    EXTERNAL = 0
    INTERNAL = 1
    INVALID_LOAD_BALANCING_SCHEME = 2

  class ProtocolValueValuesEnum(_messages.Enum):
    """The protocol this BackendService uses to communicate with backends.
    Possible values are HTTP, HTTPS, HTTP2, TCP and SSL. The default is HTTP.
    For internal load balancing, the possible values are TCP and UDP, and the
    default is TCP.

    Values:
      HTTP: <no description>
      HTTPS: <no description>
      SSL: <no description>
      TCP: <no description>
      UDP: <no description>
    """
    HTTP = 0
    HTTPS = 1
    SSL = 2
    TCP = 3
    UDP = 4

  class SessionAffinityValueValuesEnum(_messages.Enum):
    """Type of session affinity to use. The default is NONE.  When the load
    balancing scheme is EXTERNAL, can be NONE, CLIENT_IP, or GENERATED_COOKIE.
    When the load balancing scheme is INTERNAL, can be NONE, CLIENT_IP,
    CLIENT_IP_PROTO, or CLIENT_IP_PORT_PROTO.  When the protocol is UDP, this
    field is not used.

    Values:
      CLIENT_IP: <no description>
      CLIENT_IP_PORT_PROTO: <no description>
      CLIENT_IP_PROTO: <no description>
      GENERATED_COOKIE: <no description>
      NONE: <no description>
    """
    CLIENT_IP = 0
    CLIENT_IP_PORT_PROTO = 1
    CLIENT_IP_PROTO = 2
    GENERATED_COOKIE = 3
    NONE = 4

  affinityCookieTtlSec = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  backendSslPolicy = _messages.MessageField('BackendSSLPolicy', 2)
  backends = _messages.MessageField('Backend', 3, repeated=True)
  connectionDraining = _messages.MessageField('ConnectionDraining', 4)
  creationTimestamp = _messages.StringField(5)
  description = _messages.StringField(6)
  enableCDN = _messages.BooleanField(7)
  fingerprint = _messages.BytesField(8)
  healthChecks = _messages.StringField(9, repeated=True)
  iaap = _messages.MessageField('BackendServiceIAAP', 10)
  id = _messages.IntegerField(11, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(12, default=u'compute#backendService')
  loadBalancingScheme = _messages.EnumField('LoadBalancingSchemeValueValuesEnum', 13)
  name = _messages.StringField(14)
  port = _messages.IntegerField(15, variant=_messages.Variant.INT32)
  portName = _messages.StringField(16)
  protocol = _messages.EnumField('ProtocolValueValuesEnum', 17)
  region = _messages.StringField(18)
  selfLink = _messages.StringField(19)
  sessionAffinity = _messages.EnumField('SessionAffinityValueValuesEnum', 20)
  timeoutSec = _messages.IntegerField(21, variant=_messages.Variant.INT32)


class BackendServiceGroupHealth(_messages.Message):
  """A BackendServiceGroupHealth object.

  Fields:
    healthStatus: A HealthStatus attribute.
    kind: [Output Only] Type of resource. Always
      compute#backendServiceGroupHealth for the health of backend services.
  """

  healthStatus = _messages.MessageField('HealthStatus', 1, repeated=True)
  kind = _messages.StringField(2, default=u'compute#backendServiceGroupHealth')


class BackendServiceIAAP(_messages.Message):
  """Identity Aware Application Proxy (Cloud Gatekeeper)

  Fields:
    enabled: A boolean attribute.
    oauth2ClientId: A string attribute.
    oauth2ClientSecret: A string attribute.
    oauth2ClientSecretSha256: A string attribute.
  """

  enabled = _messages.BooleanField(1)
  oauth2ClientId = _messages.StringField(2)
  oauth2ClientSecret = _messages.StringField(3)
  oauth2ClientSecretSha256 = _messages.StringField(4)


class BackendServiceList(_messages.Message):
  """Contains a list of BackendService resources.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of BackendService resources.
    kind: [Output Only] Type of resource. Always compute#backendServiceList
      for lists of backend services.
    nextPageToken: [Output Only] A token used to continue a truncated list
      request.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('BackendService', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#backendServiceList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class Binding(_messages.Message):
  """Associates `members` with a `role`.

  Fields:
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google account. For example, `alice@gmail.com` or
      `joe@example.com`.  * `serviceAccount:{emailid}`: An email address that
      represents a service account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group. For example, `admins@example.com`.  *
      `domain:{domain}`: A Google Apps domain name that represents all the
      users of that domain. For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  members = _messages.StringField(1, repeated=True)
  role = _messages.StringField(2)


class CacheInvalidationRule(_messages.Message):
  """A CacheInvalidationRule object.

  Fields:
    path: A string attribute.
  """

  path = _messages.StringField(1)


class ComputeAddressesAggregatedListRequest(_messages.Message):
  """A ComputeAddressesAggregatedListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeAddressesDeleteRequest(_messages.Message):
  """A ComputeAddressesDeleteRequest object.

  Fields:
    address: Name of the address resource to delete.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  address = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeAddressesGetRequest(_messages.Message):
  """A ComputeAddressesGetRequest object.

  Fields:
    address: Name of the address resource to return.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  address = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeAddressesInsertRequest(_messages.Message):
  """A ComputeAddressesInsertRequest object.

  Fields:
    address: A Address resource to be passed as the request body.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  address = _messages.MessageField('Address', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeAddressesListRequest(_messages.Message):
  """A ComputeAddressesListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeAddressesTestIamPermissionsRequest(_messages.Message):
  """A ComputeAddressesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeAutoscalersAggregatedListRequest(_messages.Message):
  """A ComputeAutoscalersAggregatedListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeAutoscalersDeleteRequest(_messages.Message):
  """A ComputeAutoscalersDeleteRequest object.

  Fields:
    autoscaler: Name of the autoscaler to delete.
    project: Project ID for this request.
    zone: Name of the zone for this request.
  """

  autoscaler = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeAutoscalersGetRequest(_messages.Message):
  """A ComputeAutoscalersGetRequest object.

  Fields:
    autoscaler: Name of the autoscaler to return.
    project: Project ID for this request.
    zone: Name of the zone for this request.
  """

  autoscaler = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeAutoscalersInsertRequest(_messages.Message):
  """A ComputeAutoscalersInsertRequest object.

  Fields:
    autoscaler: A Autoscaler resource to be passed as the request body.
    project: Project ID for this request.
    zone: Name of the zone for this request.
  """

  autoscaler = _messages.MessageField('Autoscaler', 1)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeAutoscalersListRequest(_messages.Message):
  """A ComputeAutoscalersListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    zone: Name of the zone for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  zone = _messages.StringField(6, required=True)


class ComputeAutoscalersPatchRequest(_messages.Message):
  """A ComputeAutoscalersPatchRequest object.

  Fields:
    autoscaler: Name of the autoscaler to update.
    autoscalerResource: A Autoscaler resource to be passed as the request
      body.
    project: Project ID for this request.
    zone: Name of the zone for this request.
  """

  autoscaler = _messages.StringField(1, required=True)
  autoscalerResource = _messages.MessageField('Autoscaler', 2)
  project = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ComputeAutoscalersTestIamPermissionsRequest(_messages.Message):
  """A ComputeAutoscalersTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
    zone: The name of the zone for this request.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)
  zone = _messages.StringField(4, required=True)


class ComputeAutoscalersUpdateRequest(_messages.Message):
  """A ComputeAutoscalersUpdateRequest object.

  Fields:
    autoscaler: Name of the autoscaler to update.
    autoscalerResource: A Autoscaler resource to be passed as the request
      body.
    project: Project ID for this request.
    zone: Name of the zone for this request.
  """

  autoscaler = _messages.StringField(1)
  autoscalerResource = _messages.MessageField('Autoscaler', 2)
  project = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ComputeBackendBucketsDeleteRequest(_messages.Message):
  """A ComputeBackendBucketsDeleteRequest object.

  Fields:
    backendBucket: Name of the BackendBucket resource to delete.
    project: Project ID for this request.
  """

  backendBucket = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeBackendBucketsGetIamPolicyRequest(_messages.Message):
  """A ComputeBackendBucketsGetIamPolicyRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)


class ComputeBackendBucketsGetRequest(_messages.Message):
  """A ComputeBackendBucketsGetRequest object.

  Fields:
    backendBucket: Name of the BackendBucket resource to return.
    project: Project ID for this request.
  """

  backendBucket = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeBackendBucketsInsertRequest(_messages.Message):
  """A ComputeBackendBucketsInsertRequest object.

  Fields:
    backendBucket: A BackendBucket resource to be passed as the request body.
    project: Project ID for this request.
  """

  backendBucket = _messages.MessageField('BackendBucket', 1)
  project = _messages.StringField(2, required=True)


class ComputeBackendBucketsListRequest(_messages.Message):
  """A ComputeBackendBucketsListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeBackendBucketsPatchRequest(_messages.Message):
  """A ComputeBackendBucketsPatchRequest object.

  Fields:
    backendBucket: Name of the BackendBucket resource to update.
    backendBucketResource: A BackendBucket resource to be passed as the
      request body.
    project: Project ID for this request.
  """

  backendBucket = _messages.StringField(1, required=True)
  backendBucketResource = _messages.MessageField('BackendBucket', 2)
  project = _messages.StringField(3, required=True)


class ComputeBackendBucketsSetIamPolicyRequest(_messages.Message):
  """A ComputeBackendBucketsSetIamPolicyRequest object.

  Fields:
    policy: A Policy resource to be passed as the request body.
    project: Project ID for this request.
    resource: Name of the resource for this request.
  """

  policy = _messages.MessageField('Policy', 1)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeBackendBucketsTestIamPermissionsRequest(_messages.Message):
  """A ComputeBackendBucketsTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeBackendBucketsUpdateRequest(_messages.Message):
  """A ComputeBackendBucketsUpdateRequest object.

  Fields:
    backendBucket: Name of the BackendBucket resource to update.
    backendBucketResource: A BackendBucket resource to be passed as the
      request body.
    project: Project ID for this request.
  """

  backendBucket = _messages.StringField(1, required=True)
  backendBucketResource = _messages.MessageField('BackendBucket', 2)
  project = _messages.StringField(3, required=True)


class ComputeBackendServicesDeleteRequest(_messages.Message):
  """A ComputeBackendServicesDeleteRequest object.

  Fields:
    backendService: Name of the BackendService resource to delete.
    project: Project ID for this request.
  """

  backendService = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeBackendServicesGetHealthRequest(_messages.Message):
  """A ComputeBackendServicesGetHealthRequest object.

  Fields:
    backendService: Name of the BackendService resource to which the queried
      instance belongs.
    project: A string attribute.
    resourceGroupReference: A ResourceGroupReference resource to be passed as
      the request body.
  """

  backendService = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  resourceGroupReference = _messages.MessageField('ResourceGroupReference', 3)


class ComputeBackendServicesGetRequest(_messages.Message):
  """A ComputeBackendServicesGetRequest object.

  Fields:
    backendService: Name of the BackendService resource to return.
    project: Project ID for this request.
  """

  backendService = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeBackendServicesInsertRequest(_messages.Message):
  """A ComputeBackendServicesInsertRequest object.

  Fields:
    backendService: A BackendService resource to be passed as the request
      body.
    project: Project ID for this request.
  """

  backendService = _messages.MessageField('BackendService', 1)
  project = _messages.StringField(2, required=True)


class ComputeBackendServicesListRequest(_messages.Message):
  """A ComputeBackendServicesListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeBackendServicesPatchRequest(_messages.Message):
  """A ComputeBackendServicesPatchRequest object.

  Fields:
    backendService: Name of the BackendService resource to update.
    backendServiceResource: A BackendService resource to be passed as the
      request body.
    project: Project ID for this request.
  """

  backendService = _messages.StringField(1, required=True)
  backendServiceResource = _messages.MessageField('BackendService', 2)
  project = _messages.StringField(3, required=True)


class ComputeBackendServicesTestIamPermissionsRequest(_messages.Message):
  """A ComputeBackendServicesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeBackendServicesUpdateRequest(_messages.Message):
  """A ComputeBackendServicesUpdateRequest object.

  Fields:
    backendService: Name of the BackendService resource to update.
    backendServiceResource: A BackendService resource to be passed as the
      request body.
    project: Project ID for this request.
  """

  backendService = _messages.StringField(1, required=True)
  backendServiceResource = _messages.MessageField('BackendService', 2)
  project = _messages.StringField(3, required=True)


class ComputeDiskTypesAggregatedListRequest(_messages.Message):
  """A ComputeDiskTypesAggregatedListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeDiskTypesGetRequest(_messages.Message):
  """A ComputeDiskTypesGetRequest object.

  Fields:
    diskType: Name of the disk type to return.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  diskType = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeDiskTypesListRequest(_messages.Message):
  """A ComputeDiskTypesListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  zone = _messages.StringField(6, required=True)


class ComputeDisksAggregatedListRequest(_messages.Message):
  """A ComputeDisksAggregatedListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeDisksCreateSnapshotRequest(_messages.Message):
  """A ComputeDisksCreateSnapshotRequest object.

  Fields:
    disk: Name of the persistent disk to snapshot.
    guestFlush: A boolean attribute.
    project: Project ID for this request.
    snapshot: A Snapshot resource to be passed as the request body.
    zone: The name of the zone for this request.
  """

  disk = _messages.StringField(1, required=True)
  guestFlush = _messages.BooleanField(2)
  project = _messages.StringField(3, required=True)
  snapshot = _messages.MessageField('Snapshot', 4)
  zone = _messages.StringField(5, required=True)


class ComputeDisksDeleteRequest(_messages.Message):
  """A ComputeDisksDeleteRequest object.

  Fields:
    disk: Name of the persistent disk to delete.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  disk = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeDisksGetRequest(_messages.Message):
  """A ComputeDisksGetRequest object.

  Fields:
    disk: Name of the persistent disk to return.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  disk = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeDisksInsertRequest(_messages.Message):
  """A ComputeDisksInsertRequest object.

  Fields:
    disk: A Disk resource to be passed as the request body.
    project: Project ID for this request.
    sourceImage: Optional. Source image to restore onto a disk.
    zone: The name of the zone for this request.
  """

  disk = _messages.MessageField('Disk', 1)
  project = _messages.StringField(2, required=True)
  sourceImage = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ComputeDisksListRequest(_messages.Message):
  """A ComputeDisksListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  zone = _messages.StringField(6, required=True)


class ComputeDisksResizeRequest(_messages.Message):
  """A ComputeDisksResizeRequest object.

  Fields:
    disk: The name of the persistent disk.
    disksResizeRequest: A DisksResizeRequest resource to be passed as the
      request body.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  disk = _messages.StringField(1, required=True)
  disksResizeRequest = _messages.MessageField('DisksResizeRequest', 2)
  project = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ComputeDisksSetLabelsRequest(_messages.Message):
  """A ComputeDisksSetLabelsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    zone: The name of the zone for this request.
    zoneSetLabelsRequest: A ZoneSetLabelsRequest resource to be passed as the
      request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)
  zoneSetLabelsRequest = _messages.MessageField('ZoneSetLabelsRequest', 4)


class ComputeDisksTestIamPermissionsRequest(_messages.Message):
  """A ComputeDisksTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
    zone: The name of the zone for this request.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)
  zone = _messages.StringField(4, required=True)


class ComputeFirewallsDeleteRequest(_messages.Message):
  """A ComputeFirewallsDeleteRequest object.

  Fields:
    firewall: Name of the firewall rule to delete.
    project: Project ID for this request.
  """

  firewall = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeFirewallsGetRequest(_messages.Message):
  """A ComputeFirewallsGetRequest object.

  Fields:
    firewall: Name of the firewall rule to return.
    project: Project ID for this request.
  """

  firewall = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeFirewallsInsertRequest(_messages.Message):
  """A ComputeFirewallsInsertRequest object.

  Fields:
    firewall: A Firewall resource to be passed as the request body.
    project: Project ID for this request.
  """

  firewall = _messages.MessageField('Firewall', 1)
  project = _messages.StringField(2, required=True)


class ComputeFirewallsListRequest(_messages.Message):
  """A ComputeFirewallsListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeFirewallsPatchRequest(_messages.Message):
  """A ComputeFirewallsPatchRequest object.

  Fields:
    firewall: Name of the firewall rule to update.
    firewallResource: A Firewall resource to be passed as the request body.
    project: Project ID for this request.
  """

  firewall = _messages.StringField(1, required=True)
  firewallResource = _messages.MessageField('Firewall', 2)
  project = _messages.StringField(3, required=True)


class ComputeFirewallsTestIamPermissionsRequest(_messages.Message):
  """A ComputeFirewallsTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeFirewallsUpdateRequest(_messages.Message):
  """A ComputeFirewallsUpdateRequest object.

  Fields:
    firewall: Name of the firewall rule to update.
    firewallResource: A Firewall resource to be passed as the request body.
    project: Project ID for this request.
  """

  firewall = _messages.StringField(1, required=True)
  firewallResource = _messages.MessageField('Firewall', 2)
  project = _messages.StringField(3, required=True)


class ComputeForwardingRulesAggregatedListRequest(_messages.Message):
  """A ComputeForwardingRulesAggregatedListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeForwardingRulesDeleteRequest(_messages.Message):
  """A ComputeForwardingRulesDeleteRequest object.

  Fields:
    forwardingRule: Name of the ForwardingRule resource to delete.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  forwardingRule = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeForwardingRulesGetRequest(_messages.Message):
  """A ComputeForwardingRulesGetRequest object.

  Fields:
    forwardingRule: Name of the ForwardingRule resource to return.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  forwardingRule = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeForwardingRulesInsertRequest(_messages.Message):
  """A ComputeForwardingRulesInsertRequest object.

  Fields:
    forwardingRule: A ForwardingRule resource to be passed as the request
      body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  forwardingRule = _messages.MessageField('ForwardingRule', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeForwardingRulesListRequest(_messages.Message):
  """A ComputeForwardingRulesListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeForwardingRulesSetTargetRequest(_messages.Message):
  """A ComputeForwardingRulesSetTargetRequest object.

  Fields:
    forwardingRule: Name of the ForwardingRule resource in which target is to
      be set.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    targetReference: A TargetReference resource to be passed as the request
      body.
  """

  forwardingRule = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  targetReference = _messages.MessageField('TargetReference', 4)


class ComputeForwardingRulesTestIamPermissionsRequest(_messages.Message):
  """A ComputeForwardingRulesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeGlobalAddressesDeleteRequest(_messages.Message):
  """A ComputeGlobalAddressesDeleteRequest object.

  Fields:
    address: Name of the address resource to delete.
    project: Project ID for this request.
  """

  address = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeGlobalAddressesGetRequest(_messages.Message):
  """A ComputeGlobalAddressesGetRequest object.

  Fields:
    address: Name of the address resource to return.
    project: Project ID for this request.
  """

  address = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeGlobalAddressesInsertRequest(_messages.Message):
  """A ComputeGlobalAddressesInsertRequest object.

  Fields:
    address: A Address resource to be passed as the request body.
    project: Project ID for this request.
  """

  address = _messages.MessageField('Address', 1)
  project = _messages.StringField(2, required=True)


class ComputeGlobalAddressesListRequest(_messages.Message):
  """A ComputeGlobalAddressesListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeGlobalAddressesTestIamPermissionsRequest(_messages.Message):
  """A ComputeGlobalAddressesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeGlobalForwardingRulesDeleteRequest(_messages.Message):
  """A ComputeGlobalForwardingRulesDeleteRequest object.

  Fields:
    forwardingRule: Name of the ForwardingRule resource to delete.
    project: Project ID for this request.
  """

  forwardingRule = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeGlobalForwardingRulesGetRequest(_messages.Message):
  """A ComputeGlobalForwardingRulesGetRequest object.

  Fields:
    forwardingRule: Name of the ForwardingRule resource to return.
    project: Project ID for this request.
  """

  forwardingRule = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeGlobalForwardingRulesInsertRequest(_messages.Message):
  """A ComputeGlobalForwardingRulesInsertRequest object.

  Fields:
    forwardingRule: A ForwardingRule resource to be passed as the request
      body.
    project: Project ID for this request.
  """

  forwardingRule = _messages.MessageField('ForwardingRule', 1)
  project = _messages.StringField(2, required=True)


class ComputeGlobalForwardingRulesListRequest(_messages.Message):
  """A ComputeGlobalForwardingRulesListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeGlobalForwardingRulesSetTargetRequest(_messages.Message):
  """A ComputeGlobalForwardingRulesSetTargetRequest object.

  Fields:
    forwardingRule: Name of the ForwardingRule resource in which target is to
      be set.
    project: Project ID for this request.
    targetReference: A TargetReference resource to be passed as the request
      body.
  """

  forwardingRule = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  targetReference = _messages.MessageField('TargetReference', 3)


class ComputeGlobalForwardingRulesTestIamPermissionsRequest(_messages.Message):
  """A ComputeGlobalForwardingRulesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeGlobalOperationsAggregatedListRequest(_messages.Message):
  """A ComputeGlobalOperationsAggregatedListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeGlobalOperationsDeleteRequest(_messages.Message):
  """A ComputeGlobalOperationsDeleteRequest object.

  Fields:
    operation: Name of the Operations resource to delete.
    project: Project ID for this request.
  """

  operation = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeGlobalOperationsDeleteResponse(_messages.Message):
  """An empty ComputeGlobalOperationsDelete response."""


class ComputeGlobalOperationsGetRequest(_messages.Message):
  """A ComputeGlobalOperationsGetRequest object.

  Fields:
    operation: Name of the Operations resource to return.
    project: Project ID for this request.
  """

  operation = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeGlobalOperationsListRequest(_messages.Message):
  """A ComputeGlobalOperationsListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeHealthChecksDeleteRequest(_messages.Message):
  """A ComputeHealthChecksDeleteRequest object.

  Fields:
    healthCheck: Name of the HealthCheck resource to delete.
    project: Project ID for this request.
  """

  healthCheck = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeHealthChecksGetRequest(_messages.Message):
  """A ComputeHealthChecksGetRequest object.

  Fields:
    healthCheck: Name of the HealthCheck resource to return.
    project: Project ID for this request.
  """

  healthCheck = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeHealthChecksInsertRequest(_messages.Message):
  """A ComputeHealthChecksInsertRequest object.

  Fields:
    healthCheck: A HealthCheck resource to be passed as the request body.
    project: Project ID for this request.
  """

  healthCheck = _messages.MessageField('HealthCheck', 1)
  project = _messages.StringField(2, required=True)


class ComputeHealthChecksListRequest(_messages.Message):
  """A ComputeHealthChecksListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeHealthChecksPatchRequest(_messages.Message):
  """A ComputeHealthChecksPatchRequest object.

  Fields:
    healthCheck: Name of the HealthCheck resource to update.
    healthCheckResource: A HealthCheck resource to be passed as the request
      body.
    project: Project ID for this request.
  """

  healthCheck = _messages.StringField(1, required=True)
  healthCheckResource = _messages.MessageField('HealthCheck', 2)
  project = _messages.StringField(3, required=True)


class ComputeHealthChecksTestIamPermissionsRequest(_messages.Message):
  """A ComputeHealthChecksTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeHealthChecksUpdateRequest(_messages.Message):
  """A ComputeHealthChecksUpdateRequest object.

  Fields:
    healthCheck: Name of the HealthCheck resource to update.
    healthCheckResource: A HealthCheck resource to be passed as the request
      body.
    project: Project ID for this request.
  """

  healthCheck = _messages.StringField(1, required=True)
  healthCheckResource = _messages.MessageField('HealthCheck', 2)
  project = _messages.StringField(3, required=True)


class ComputeHttpHealthChecksDeleteRequest(_messages.Message):
  """A ComputeHttpHealthChecksDeleteRequest object.

  Fields:
    httpHealthCheck: Name of the HttpHealthCheck resource to delete.
    project: Project ID for this request.
  """

  httpHealthCheck = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeHttpHealthChecksGetRequest(_messages.Message):
  """A ComputeHttpHealthChecksGetRequest object.

  Fields:
    httpHealthCheck: Name of the HttpHealthCheck resource to return.
    project: Project ID for this request.
  """

  httpHealthCheck = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeHttpHealthChecksInsertRequest(_messages.Message):
  """A ComputeHttpHealthChecksInsertRequest object.

  Fields:
    httpHealthCheck: A HttpHealthCheck resource to be passed as the request
      body.
    project: Project ID for this request.
  """

  httpHealthCheck = _messages.MessageField('HttpHealthCheck', 1)
  project = _messages.StringField(2, required=True)


class ComputeHttpHealthChecksListRequest(_messages.Message):
  """A ComputeHttpHealthChecksListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeHttpHealthChecksPatchRequest(_messages.Message):
  """A ComputeHttpHealthChecksPatchRequest object.

  Fields:
    httpHealthCheck: Name of the HttpHealthCheck resource to update.
    httpHealthCheckResource: A HttpHealthCheck resource to be passed as the
      request body.
    project: Project ID for this request.
  """

  httpHealthCheck = _messages.StringField(1, required=True)
  httpHealthCheckResource = _messages.MessageField('HttpHealthCheck', 2)
  project = _messages.StringField(3, required=True)


class ComputeHttpHealthChecksTestIamPermissionsRequest(_messages.Message):
  """A ComputeHttpHealthChecksTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeHttpHealthChecksUpdateRequest(_messages.Message):
  """A ComputeHttpHealthChecksUpdateRequest object.

  Fields:
    httpHealthCheck: Name of the HttpHealthCheck resource to update.
    httpHealthCheckResource: A HttpHealthCheck resource to be passed as the
      request body.
    project: Project ID for this request.
  """

  httpHealthCheck = _messages.StringField(1, required=True)
  httpHealthCheckResource = _messages.MessageField('HttpHealthCheck', 2)
  project = _messages.StringField(3, required=True)


class ComputeHttpsHealthChecksDeleteRequest(_messages.Message):
  """A ComputeHttpsHealthChecksDeleteRequest object.

  Fields:
    httpsHealthCheck: Name of the HttpsHealthCheck resource to delete.
    project: Project ID for this request.
  """

  httpsHealthCheck = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeHttpsHealthChecksGetRequest(_messages.Message):
  """A ComputeHttpsHealthChecksGetRequest object.

  Fields:
    httpsHealthCheck: Name of the HttpsHealthCheck resource to return.
    project: Project ID for this request.
  """

  httpsHealthCheck = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeHttpsHealthChecksInsertRequest(_messages.Message):
  """A ComputeHttpsHealthChecksInsertRequest object.

  Fields:
    httpsHealthCheck: A HttpsHealthCheck resource to be passed as the request
      body.
    project: Project ID for this request.
  """

  httpsHealthCheck = _messages.MessageField('HttpsHealthCheck', 1)
  project = _messages.StringField(2, required=True)


class ComputeHttpsHealthChecksListRequest(_messages.Message):
  """A ComputeHttpsHealthChecksListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeHttpsHealthChecksPatchRequest(_messages.Message):
  """A ComputeHttpsHealthChecksPatchRequest object.

  Fields:
    httpsHealthCheck: Name of the HttpsHealthCheck resource to update.
    httpsHealthCheckResource: A HttpsHealthCheck resource to be passed as the
      request body.
    project: Project ID for this request.
  """

  httpsHealthCheck = _messages.StringField(1, required=True)
  httpsHealthCheckResource = _messages.MessageField('HttpsHealthCheck', 2)
  project = _messages.StringField(3, required=True)


class ComputeHttpsHealthChecksTestIamPermissionsRequest(_messages.Message):
  """A ComputeHttpsHealthChecksTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeHttpsHealthChecksUpdateRequest(_messages.Message):
  """A ComputeHttpsHealthChecksUpdateRequest object.

  Fields:
    httpsHealthCheck: Name of the HttpsHealthCheck resource to update.
    httpsHealthCheckResource: A HttpsHealthCheck resource to be passed as the
      request body.
    project: Project ID for this request.
  """

  httpsHealthCheck = _messages.StringField(1, required=True)
  httpsHealthCheckResource = _messages.MessageField('HttpsHealthCheck', 2)
  project = _messages.StringField(3, required=True)


class ComputeImagesDeleteRequest(_messages.Message):
  """A ComputeImagesDeleteRequest object.

  Fields:
    image: Name of the image resource to delete.
    project: Project ID for this request.
  """

  image = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeImagesDeprecateRequest(_messages.Message):
  """A ComputeImagesDeprecateRequest object.

  Fields:
    deprecationStatus: A DeprecationStatus resource to be passed as the
      request body.
    image: Image name.
    project: Project ID for this request.
  """

  deprecationStatus = _messages.MessageField('DeprecationStatus', 1)
  image = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)


class ComputeImagesGetFromFamilyRequest(_messages.Message):
  """A ComputeImagesGetFromFamilyRequest object.

  Fields:
    family: Name of the image family to search for.
    project: Project ID for this request.
  """

  family = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeImagesGetRequest(_messages.Message):
  """A ComputeImagesGetRequest object.

  Fields:
    image: Name of the image resource to return.
    project: Project ID for this request.
  """

  image = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeImagesInsertRequest(_messages.Message):
  """A ComputeImagesInsertRequest object.

  Fields:
    image: A Image resource to be passed as the request body.
    project: Project ID for this request.
  """

  image = _messages.MessageField('Image', 1)
  project = _messages.StringField(2, required=True)


class ComputeImagesListRequest(_messages.Message):
  """A ComputeImagesListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeImagesSetLabelsRequest(_messages.Message):
  """A ComputeImagesSetLabelsRequest object.

  Fields:
    globalSetLabelsRequest: A GlobalSetLabelsRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    resource: Name of the resource for this request.
  """

  globalSetLabelsRequest = _messages.MessageField('GlobalSetLabelsRequest', 1)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeImagesTestIamPermissionsRequest(_messages.Message):
  """A ComputeImagesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeInstanceGroupManagersAbandonInstancesRequest(_messages.Message):
  """A ComputeInstanceGroupManagersAbandonInstancesRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group.
    instanceGroupManagersAbandonInstancesRequest: A
      InstanceGroupManagersAbandonInstancesRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagersAbandonInstancesRequest = _messages.MessageField('InstanceGroupManagersAbandonInstancesRequest', 2)
  project = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ComputeInstanceGroupManagersAggregatedListRequest(_messages.Message):
  """A ComputeInstanceGroupManagersAggregatedListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeInstanceGroupManagersDeleteInstancesRequest(_messages.Message):
  """A ComputeInstanceGroupManagersDeleteInstancesRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group.
    instanceGroupManagersDeleteInstancesRequest: A
      InstanceGroupManagersDeleteInstancesRequest resource to be passed as the
      request body.
    project: Project ID for this request.
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagersDeleteInstancesRequest = _messages.MessageField('InstanceGroupManagersDeleteInstancesRequest', 2)
  project = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ComputeInstanceGroupManagersDeleteRequest(_messages.Message):
  """A ComputeInstanceGroupManagersDeleteRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group to delete.
    project: Project ID for this request.
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeInstanceGroupManagersGetRequest(_messages.Message):
  """A ComputeInstanceGroupManagersGetRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group.
    project: Project ID for this request.
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeInstanceGroupManagersInsertRequest(_messages.Message):
  """A ComputeInstanceGroupManagersInsertRequest object.

  Fields:
    instanceGroupManager: A InstanceGroupManager resource to be passed as the
      request body.
    project: Project ID for this request.
    zone: The name of the zone where you want to create the managed instance
      group.
  """

  instanceGroupManager = _messages.MessageField('InstanceGroupManager', 1)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeInstanceGroupManagersListManagedInstancesRequest(_messages.Message):
  """A ComputeInstanceGroupManagersListManagedInstancesRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group.
    project: Project ID for this request.
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeInstanceGroupManagersListRequest(_messages.Message):
  """A ComputeInstanceGroupManagersListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    zone: The name of the zone where the managed instance group is located.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  zone = _messages.StringField(6, required=True)


class ComputeInstanceGroupManagersRecreateInstancesRequest(_messages.Message):
  """A ComputeInstanceGroupManagersRecreateInstancesRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group.
    instanceGroupManagersRecreateInstancesRequest: A
      InstanceGroupManagersRecreateInstancesRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagersRecreateInstancesRequest = _messages.MessageField('InstanceGroupManagersRecreateInstancesRequest', 2)
  project = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ComputeInstanceGroupManagersResizeAdvancedRequest(_messages.Message):
  """A ComputeInstanceGroupManagersResizeAdvancedRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group.
    instanceGroupManagersResizeAdvancedRequest: A
      InstanceGroupManagersResizeAdvancedRequest resource to be passed as the
      request body.
    project: Project ID for this request.
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagersResizeAdvancedRequest = _messages.MessageField('InstanceGroupManagersResizeAdvancedRequest', 2)
  project = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ComputeInstanceGroupManagersResizeRequest(_messages.Message):
  """A ComputeInstanceGroupManagersResizeRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group.
    project: Project ID for this request.
    size: The number of running instances that the managed instance group
      should maintain at any given time. The group automatically adds or
      removes instances to maintain the number of instances specified by this
      parameter.
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  size = _messages.IntegerField(3, required=True, variant=_messages.Variant.INT32)
  zone = _messages.StringField(4, required=True)


class ComputeInstanceGroupManagersSetAutoHealingPoliciesRequest(_messages.Message):
  """A ComputeInstanceGroupManagersSetAutoHealingPoliciesRequest object.

  Fields:
    instanceGroupManager: The name of the instance group manager.
    instanceGroupManagersSetAutoHealingRequest: A
      InstanceGroupManagersSetAutoHealingRequest resource to be passed as the
      request body.
    project: Project ID for this request.
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagersSetAutoHealingRequest = _messages.MessageField('InstanceGroupManagersSetAutoHealingRequest', 2)
  project = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ComputeInstanceGroupManagersSetInstanceTemplateRequest(_messages.Message):
  """A ComputeInstanceGroupManagersSetInstanceTemplateRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group.
    instanceGroupManagersSetInstanceTemplateRequest: A
      InstanceGroupManagersSetInstanceTemplateRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagersSetInstanceTemplateRequest = _messages.MessageField('InstanceGroupManagersSetInstanceTemplateRequest', 2)
  project = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ComputeInstanceGroupManagersSetTargetPoolsRequest(_messages.Message):
  """A ComputeInstanceGroupManagersSetTargetPoolsRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group.
    instanceGroupManagersSetTargetPoolsRequest: A
      InstanceGroupManagersSetTargetPoolsRequest resource to be passed as the
      request body.
    project: Project ID for this request.
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagersSetTargetPoolsRequest = _messages.MessageField('InstanceGroupManagersSetTargetPoolsRequest', 2)
  project = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ComputeInstanceGroupManagersTestIamPermissionsRequest(_messages.Message):
  """A ComputeInstanceGroupManagersTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
    zone: The name of the zone for this request.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)
  zone = _messages.StringField(4, required=True)


class ComputeInstanceGroupsAddInstancesRequest(_messages.Message):
  """A ComputeInstanceGroupsAddInstancesRequest object.

  Fields:
    instanceGroup: The name of the instance group where you are adding
      instances.
    instanceGroupsAddInstancesRequest: A InstanceGroupsAddInstancesRequest
      resource to be passed as the request body.
    project: Project ID for this request.
    zone: The name of the zone where the instance group is located.
  """

  instanceGroup = _messages.StringField(1, required=True)
  instanceGroupsAddInstancesRequest = _messages.MessageField('InstanceGroupsAddInstancesRequest', 2)
  project = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ComputeInstanceGroupsAggregatedListRequest(_messages.Message):
  """A ComputeInstanceGroupsAggregatedListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeInstanceGroupsDeleteRequest(_messages.Message):
  """A ComputeInstanceGroupsDeleteRequest object.

  Fields:
    instanceGroup: The name of the instance group to delete.
    project: Project ID for this request.
    zone: The name of the zone where the instance group is located.
  """

  instanceGroup = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeInstanceGroupsGetRequest(_messages.Message):
  """A ComputeInstanceGroupsGetRequest object.

  Fields:
    instanceGroup: The name of the instance group.
    project: Project ID for this request.
    zone: The name of the zone where the instance group is located.
  """

  instanceGroup = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeInstanceGroupsInsertRequest(_messages.Message):
  """A ComputeInstanceGroupsInsertRequest object.

  Fields:
    instanceGroup: A InstanceGroup resource to be passed as the request body.
    project: Project ID for this request.
    zone: The name of the zone where you want to create the instance group.
  """

  instanceGroup = _messages.MessageField('InstanceGroup', 1)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeInstanceGroupsListInstancesRequest(_messages.Message):
  """A ComputeInstanceGroupsListInstancesRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    instanceGroup: The name of the instance group from which you want to
      generate a list of included instances.
    instanceGroupsListInstancesRequest: A InstanceGroupsListInstancesRequest
      resource to be passed as the request body.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    zone: The name of the zone where the instance group is located.
  """

  filter = _messages.StringField(1)
  instanceGroup = _messages.StringField(2, required=True)
  instanceGroupsListInstancesRequest = _messages.MessageField('InstanceGroupsListInstancesRequest', 3)
  maxResults = _messages.IntegerField(4, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(5)
  pageToken = _messages.StringField(6)
  project = _messages.StringField(7, required=True)
  zone = _messages.StringField(8, required=True)


class ComputeInstanceGroupsListRequest(_messages.Message):
  """A ComputeInstanceGroupsListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    zone: The name of the zone where the instance group is located.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  zone = _messages.StringField(6, required=True)


class ComputeInstanceGroupsRemoveInstancesRequest(_messages.Message):
  """A ComputeInstanceGroupsRemoveInstancesRequest object.

  Fields:
    instanceGroup: The name of the instance group where the specified
      instances will be removed.
    instanceGroupsRemoveInstancesRequest: A
      InstanceGroupsRemoveInstancesRequest resource to be passed as the
      request body.
    project: Project ID for this request.
    zone: The name of the zone where the instance group is located.
  """

  instanceGroup = _messages.StringField(1, required=True)
  instanceGroupsRemoveInstancesRequest = _messages.MessageField('InstanceGroupsRemoveInstancesRequest', 2)
  project = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ComputeInstanceGroupsSetNamedPortsRequest(_messages.Message):
  """A ComputeInstanceGroupsSetNamedPortsRequest object.

  Fields:
    instanceGroup: The name of the instance group where the named ports are
      updated.
    instanceGroupsSetNamedPortsRequest: A InstanceGroupsSetNamedPortsRequest
      resource to be passed as the request body.
    project: Project ID for this request.
    zone: The name of the zone where the instance group is located.
  """

  instanceGroup = _messages.StringField(1, required=True)
  instanceGroupsSetNamedPortsRequest = _messages.MessageField('InstanceGroupsSetNamedPortsRequest', 2)
  project = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ComputeInstanceGroupsTestIamPermissionsRequest(_messages.Message):
  """A ComputeInstanceGroupsTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
    zone: The name of the zone for this request.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)
  zone = _messages.StringField(4, required=True)


class ComputeInstanceTemplatesDeleteRequest(_messages.Message):
  """A ComputeInstanceTemplatesDeleteRequest object.

  Fields:
    instanceTemplate: The name of the instance template to delete.
    project: Project ID for this request.
  """

  instanceTemplate = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeInstanceTemplatesGetRequest(_messages.Message):
  """A ComputeInstanceTemplatesGetRequest object.

  Fields:
    instanceTemplate: The name of the instance template.
    project: Project ID for this request.
  """

  instanceTemplate = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeInstanceTemplatesInsertRequest(_messages.Message):
  """A ComputeInstanceTemplatesInsertRequest object.

  Fields:
    instanceTemplate: A InstanceTemplate resource to be passed as the request
      body.
    project: Project ID for this request.
  """

  instanceTemplate = _messages.MessageField('InstanceTemplate', 1)
  project = _messages.StringField(2, required=True)


class ComputeInstanceTemplatesListRequest(_messages.Message):
  """A ComputeInstanceTemplatesListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeInstanceTemplatesTestIamPermissionsRequest(_messages.Message):
  """A ComputeInstanceTemplatesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeInstancesAddAccessConfigRequest(_messages.Message):
  """A ComputeInstancesAddAccessConfigRequest object.

  Fields:
    accessConfig: A AccessConfig resource to be passed as the request body.
    instance: The instance name for this request.
    networkInterface: The name of the network interface to add to this
      instance.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  accessConfig = _messages.MessageField('AccessConfig', 1)
  instance = _messages.StringField(2, required=True)
  networkInterface = _messages.StringField(3, required=True)
  project = _messages.StringField(4, required=True)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesAggregatedListRequest(_messages.Message):
  """A ComputeInstancesAggregatedListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeInstancesAttachDiskRequest(_messages.Message):
  """A ComputeInstancesAttachDiskRequest object.

  Fields:
    attachedDisk: A AttachedDisk resource to be passed as the request body.
    instance: The instance name for this request.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  attachedDisk = _messages.MessageField('AttachedDisk', 1)
  instance = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ComputeInstancesDeleteAccessConfigRequest(_messages.Message):
  """A ComputeInstancesDeleteAccessConfigRequest object.

  Fields:
    accessConfig: The name of the access config to delete.
    instance: The instance name for this request.
    networkInterface: The name of the network interface.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  accessConfig = _messages.StringField(1, required=True)
  instance = _messages.StringField(2, required=True)
  networkInterface = _messages.StringField(3, required=True)
  project = _messages.StringField(4, required=True)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesDeleteRequest(_messages.Message):
  """A ComputeInstancesDeleteRequest object.

  Fields:
    instance: Name of the instance resource to delete.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeInstancesDetachDiskRequest(_messages.Message):
  """A ComputeInstancesDetachDiskRequest object.

  Fields:
    deviceName: Disk device name to detach.
    instance: Instance name.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  deviceName = _messages.StringField(1, required=True)
  instance = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ComputeInstancesGetIamPolicyRequest(_messages.Message):
  """A ComputeInstancesGetIamPolicyRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    zone: The name of the zone for this request.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeInstancesGetRequest(_messages.Message):
  """A ComputeInstancesGetRequest object.

  Fields:
    instance: Name of the instance resource to return.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeInstancesGetSerialPortOutputRequest(_messages.Message):
  """A ComputeInstancesGetSerialPortOutputRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    port: Specifies which COM or serial port to retrieve data from.
    project: Project ID for this request.
    start: For the initial request, leave this field unspecified. For
      subsequent calls, this field should be set to the next value that was
      returned in the previous call.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  port = _messages.IntegerField(2, variant=_messages.Variant.INT32, default=1)
  project = _messages.StringField(3, required=True)
  start = _messages.IntegerField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesInsertRequest(_messages.Message):
  """A ComputeInstancesInsertRequest object.

  Fields:
    instance: A Instance resource to be passed as the request body.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  instance = _messages.MessageField('Instance', 1)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeInstancesListRequest(_messages.Message):
  """A ComputeInstancesListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  zone = _messages.StringField(6, required=True)


class ComputeInstancesResetRequest(_messages.Message):
  """A ComputeInstancesResetRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeInstancesSetDiskAutoDeleteRequest(_messages.Message):
  """A ComputeInstancesSetDiskAutoDeleteRequest object.

  Fields:
    autoDelete: Whether to auto-delete the disk when the instance is deleted.
    deviceName: The device name of the disk to modify.
    instance: The instance name.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  autoDelete = _messages.BooleanField(1, required=True)
  deviceName = _messages.StringField(2, required=True)
  instance = _messages.StringField(3, required=True)
  project = _messages.StringField(4, required=True)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesSetIamPolicyRequest(_messages.Message):
  """A ComputeInstancesSetIamPolicyRequest object.

  Fields:
    policy: A Policy resource to be passed as the request body.
    project: Project ID for this request.
    resource: Name of the resource for this request.
    zone: The name of the zone for this request.
  """

  policy = _messages.MessageField('Policy', 1)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ComputeInstancesSetLabelsRequest(_messages.Message):
  """A ComputeInstancesSetLabelsRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    instancesSetLabelsRequest: A InstancesSetLabelsRequest resource to be
      passed as the request body.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  instancesSetLabelsRequest = _messages.MessageField('InstancesSetLabelsRequest', 2)
  project = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ComputeInstancesSetMachineTypeRequest(_messages.Message):
  """A ComputeInstancesSetMachineTypeRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    instancesSetMachineTypeRequest: A InstancesSetMachineTypeRequest resource
      to be passed as the request body.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  instancesSetMachineTypeRequest = _messages.MessageField('InstancesSetMachineTypeRequest', 2)
  project = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ComputeInstancesSetMetadataRequest(_messages.Message):
  """A ComputeInstancesSetMetadataRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    metadata: A Metadata resource to be passed as the request body.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  metadata = _messages.MessageField('Metadata', 2)
  project = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ComputeInstancesSetSchedulingRequest(_messages.Message):
  """A ComputeInstancesSetSchedulingRequest object.

  Fields:
    instance: Instance name.
    project: Project ID for this request.
    scheduling: A Scheduling resource to be passed as the request body.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  scheduling = _messages.MessageField('Scheduling', 3)
  zone = _messages.StringField(4, required=True)


class ComputeInstancesSetServiceAccountRequest(_messages.Message):
  """A ComputeInstancesSetServiceAccountRequest object.

  Fields:
    instance: Name of the instance resource to start.
    instancesSetServiceAccountRequest: A InstancesSetServiceAccountRequest
      resource to be passed as the request body.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  instancesSetServiceAccountRequest = _messages.MessageField('InstancesSetServiceAccountRequest', 2)
  project = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ComputeInstancesSetTagsRequest(_messages.Message):
  """A ComputeInstancesSetTagsRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    project: Project ID for this request.
    tags: A Tags resource to be passed as the request body.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  tags = _messages.MessageField('Tags', 3)
  zone = _messages.StringField(4, required=True)


class ComputeInstancesStartRequest(_messages.Message):
  """A ComputeInstancesStartRequest object.

  Fields:
    instance: Name of the instance resource to start.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeInstancesStartWithEncryptionKeyRequest(_messages.Message):
  """A ComputeInstancesStartWithEncryptionKeyRequest object.

  Fields:
    instance: Name of the instance resource to start.
    instancesStartWithEncryptionKeyRequest: A
      InstancesStartWithEncryptionKeyRequest resource to be passed as the
      request body.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  instancesStartWithEncryptionKeyRequest = _messages.MessageField('InstancesStartWithEncryptionKeyRequest', 2)
  project = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ComputeInstancesStopRequest(_messages.Message):
  """A ComputeInstancesStopRequest object.

  Fields:
    instance: Name of the instance resource to stop.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeInstancesSuspendRequest(_messages.Message):
  """A ComputeInstancesSuspendRequest object.

  Fields:
    instance: Name of the instance resource to suspend.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeInstancesTestIamPermissionsRequest(_messages.Message):
  """A ComputeInstancesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
    zone: The name of the zone for this request.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)
  zone = _messages.StringField(4, required=True)


class ComputeLicensesGetRequest(_messages.Message):
  """A ComputeLicensesGetRequest object.

  Fields:
    license: Name of the License resource to return.
    project: Project ID for this request.
  """

  license = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeMachineTypesAggregatedListRequest(_messages.Message):
  """A ComputeMachineTypesAggregatedListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeMachineTypesGetRequest(_messages.Message):
  """A ComputeMachineTypesGetRequest object.

  Fields:
    machineType: Name of the machine type to return.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  machineType = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeMachineTypesListRequest(_messages.Message):
  """A ComputeMachineTypesListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  zone = _messages.StringField(6, required=True)


class ComputeNetworksDeleteRequest(_messages.Message):
  """A ComputeNetworksDeleteRequest object.

  Fields:
    network: Name of the network to delete.
    project: Project ID for this request.
  """

  network = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeNetworksGetRequest(_messages.Message):
  """A ComputeNetworksGetRequest object.

  Fields:
    network: Name of the network to return.
    project: Project ID for this request.
  """

  network = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeNetworksInsertRequest(_messages.Message):
  """A ComputeNetworksInsertRequest object.

  Fields:
    network: A Network resource to be passed as the request body.
    project: Project ID for this request.
  """

  network = _messages.MessageField('Network', 1)
  project = _messages.StringField(2, required=True)


class ComputeNetworksListRequest(_messages.Message):
  """A ComputeNetworksListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeNetworksSwitchToCustomModeRequest(_messages.Message):
  """A ComputeNetworksSwitchToCustomModeRequest object.

  Fields:
    network: Name of the network to be updated.
    project: Project ID for this request.
  """

  network = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeNetworksTestIamPermissionsRequest(_messages.Message):
  """A ComputeNetworksTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeProjectsGetRequest(_messages.Message):
  """A ComputeProjectsGetRequest object.

  Fields:
    project: Project ID for this request.
  """

  project = _messages.StringField(1, required=True)


class ComputeProjectsMoveDiskRequest(_messages.Message):
  """A ComputeProjectsMoveDiskRequest object.

  Fields:
    diskMoveRequest: A DiskMoveRequest resource to be passed as the request
      body.
    project: Project ID for this request.
  """

  diskMoveRequest = _messages.MessageField('DiskMoveRequest', 1)
  project = _messages.StringField(2, required=True)


class ComputeProjectsMoveInstanceRequest(_messages.Message):
  """A ComputeProjectsMoveInstanceRequest object.

  Fields:
    instanceMoveRequest: A InstanceMoveRequest resource to be passed as the
      request body.
    project: Project ID for this request.
  """

  instanceMoveRequest = _messages.MessageField('InstanceMoveRequest', 1)
  project = _messages.StringField(2, required=True)


class ComputeProjectsSetCommonInstanceMetadataRequest(_messages.Message):
  """A ComputeProjectsSetCommonInstanceMetadataRequest object.

  Fields:
    metadata: A Metadata resource to be passed as the request body.
    project: Project ID for this request.
  """

  metadata = _messages.MessageField('Metadata', 1)
  project = _messages.StringField(2, required=True)


class ComputeProjectsSetUsageExportBucketRequest(_messages.Message):
  """A ComputeProjectsSetUsageExportBucketRequest object.

  Fields:
    project: Project ID for this request.
    usageExportLocation: A UsageExportLocation resource to be passed as the
      request body.
  """

  project = _messages.StringField(1, required=True)
  usageExportLocation = _messages.MessageField('UsageExportLocation', 2)


class ComputeRegionAutoscalersDeleteRequest(_messages.Message):
  """A ComputeRegionAutoscalersDeleteRequest object.

  Fields:
    autoscaler: Name of the autoscaler to delete.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  autoscaler = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionAutoscalersGetRequest(_messages.Message):
  """A ComputeRegionAutoscalersGetRequest object.

  Fields:
    autoscaler: Name of the autoscaler to return.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  autoscaler = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionAutoscalersInsertRequest(_messages.Message):
  """A ComputeRegionAutoscalersInsertRequest object.

  Fields:
    autoscaler: A Autoscaler resource to be passed as the request body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  autoscaler = _messages.MessageField('Autoscaler', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionAutoscalersListRequest(_messages.Message):
  """A ComputeRegionAutoscalersListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeRegionAutoscalersPatchRequest(_messages.Message):
  """A ComputeRegionAutoscalersPatchRequest object.

  Fields:
    autoscaler: Name of the autoscaler to update.
    autoscalerResource: A Autoscaler resource to be passed as the request
      body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  autoscaler = _messages.StringField(1, required=True)
  autoscalerResource = _messages.MessageField('Autoscaler', 2)
  project = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)


class ComputeRegionAutoscalersTestIamPermissionsRequest(_messages.Message):
  """A ComputeRegionAutoscalersTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeRegionAutoscalersUpdateRequest(_messages.Message):
  """A ComputeRegionAutoscalersUpdateRequest object.

  Fields:
    autoscaler: Name of the autoscaler to update.
    autoscalerResource: A Autoscaler resource to be passed as the request
      body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  autoscaler = _messages.StringField(1)
  autoscalerResource = _messages.MessageField('Autoscaler', 2)
  project = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)


class ComputeRegionBackendServicesDeleteRequest(_messages.Message):
  """A ComputeRegionBackendServicesDeleteRequest object.

  Fields:
    backendService: Name of the BackendService resource to delete.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  backendService = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionBackendServicesGetHealthRequest(_messages.Message):
  """A ComputeRegionBackendServicesGetHealthRequest object.

  Fields:
    backendService: Name of the BackendService resource to which the queried
      instance belongs.
    project: A string attribute.
    region: Name of the region scoping this request.
    resourceGroupReference: A ResourceGroupReference resource to be passed as
      the request body.
  """

  backendService = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  resourceGroupReference = _messages.MessageField('ResourceGroupReference', 4)


class ComputeRegionBackendServicesGetRequest(_messages.Message):
  """A ComputeRegionBackendServicesGetRequest object.

  Fields:
    backendService: Name of the BackendService resource to return.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  backendService = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionBackendServicesInsertRequest(_messages.Message):
  """A ComputeRegionBackendServicesInsertRequest object.

  Fields:
    backendService: A BackendService resource to be passed as the request
      body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  backendService = _messages.MessageField('BackendService', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionBackendServicesListRequest(_messages.Message):
  """A ComputeRegionBackendServicesListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeRegionBackendServicesPatchRequest(_messages.Message):
  """A ComputeRegionBackendServicesPatchRequest object.

  Fields:
    backendService: Name of the BackendService resource to update.
    backendServiceResource: A BackendService resource to be passed as the
      request body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  backendService = _messages.StringField(1, required=True)
  backendServiceResource = _messages.MessageField('BackendService', 2)
  project = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)


class ComputeRegionBackendServicesTestIamPermissionsRequest(_messages.Message):
  """A ComputeRegionBackendServicesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeRegionBackendServicesUpdateRequest(_messages.Message):
  """A ComputeRegionBackendServicesUpdateRequest object.

  Fields:
    backendService: Name of the BackendService resource to update.
    backendServiceResource: A BackendService resource to be passed as the
      request body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  backendService = _messages.StringField(1, required=True)
  backendServiceResource = _messages.MessageField('BackendService', 2)
  project = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)


class ComputeRegionDiskTypesGetRequest(_messages.Message):
  """A ComputeRegionDiskTypesGetRequest object.

  Fields:
    diskType: Name of the disk type to return.
    project: Project ID for this request.
    region: The name of the region for this request.
  """

  diskType = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionDiskTypesListRequest(_messages.Message):
  """A ComputeRegionDiskTypesListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: The name of the region for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeRegionDisksCreateSnapshotRequest(_messages.Message):
  """A ComputeRegionDisksCreateSnapshotRequest object.

  Fields:
    disk: Name of the regional persistent disk to snapshot.
    guestFlush: A boolean attribute.
    project: Project ID for this request.
    region: Name of the region for this request.
    snapshot: A Snapshot resource to be passed as the request body.
  """

  disk = _messages.StringField(1, required=True)
  guestFlush = _messages.BooleanField(2)
  project = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)
  snapshot = _messages.MessageField('Snapshot', 5)


class ComputeRegionDisksDeleteRequest(_messages.Message):
  """A ComputeRegionDisksDeleteRequest object.

  Fields:
    disk: Name of the regional persistent disk to delete.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  disk = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionDisksGetRequest(_messages.Message):
  """A ComputeRegionDisksGetRequest object.

  Fields:
    disk: Name of the regional persistent disk to return.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  disk = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionDisksInsertRequest(_messages.Message):
  """A ComputeRegionDisksInsertRequest object.

  Fields:
    disk: A Disk resource to be passed as the request body.
    project: Project ID for this request.
    region: Name of the region for this request.
    sourceImage: Optional. Source image to restore onto a disk.
  """

  disk = _messages.MessageField('Disk', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  sourceImage = _messages.StringField(4)


class ComputeRegionDisksListRequest(_messages.Message):
  """A ComputeRegionDisksListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeRegionDisksResizeRequest(_messages.Message):
  """A ComputeRegionDisksResizeRequest object.

  Fields:
    disk: Name of the regional persistent disk.
    project: The project ID for this request.
    region: Name of the region for this request.
    regionDisksResizeRequest: A RegionDisksResizeRequest resource to be passed
      as the request body.
  """

  disk = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionDisksResizeRequest = _messages.MessageField('RegionDisksResizeRequest', 4)


class ComputeRegionDisksSetLabelsRequest(_messages.Message):
  """A ComputeRegionDisksSetLabelsRequest object.

  Fields:
    project: Project ID for this request.
    region: The region for this request.
    regionSetLabelsRequest: A RegionSetLabelsRequest resource to be passed as
      the request body.
    resource: Name of the resource for this request.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  regionSetLabelsRequest = _messages.MessageField('RegionSetLabelsRequest', 3)
  resource = _messages.StringField(4, required=True)


class ComputeRegionDisksTestIamPermissionsRequest(_messages.Message):
  """A ComputeRegionDisksTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeRegionInstanceGroupManagersAbandonInstancesRequest(_messages.Message):
  """A ComputeRegionInstanceGroupManagersAbandonInstancesRequest object.

  Fields:
    instanceGroupManager: Name of the managed instance group.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    regionInstanceGroupManagersAbandonInstancesRequest: A
      RegionInstanceGroupManagersAbandonInstancesRequest resource to be passed
      as the request body.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionInstanceGroupManagersAbandonInstancesRequest = _messages.MessageField('RegionInstanceGroupManagersAbandonInstancesRequest', 4)


class ComputeRegionInstanceGroupManagersDeleteInstancesRequest(_messages.Message):
  """A ComputeRegionInstanceGroupManagersDeleteInstancesRequest object.

  Fields:
    instanceGroupManager: Name of the managed instance group.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    regionInstanceGroupManagersDeleteInstancesRequest: A
      RegionInstanceGroupManagersDeleteInstancesRequest resource to be passed
      as the request body.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionInstanceGroupManagersDeleteInstancesRequest = _messages.MessageField('RegionInstanceGroupManagersDeleteInstancesRequest', 4)


class ComputeRegionInstanceGroupManagersDeleteRequest(_messages.Message):
  """A ComputeRegionInstanceGroupManagersDeleteRequest object.

  Fields:
    instanceGroupManager: Name of the managed instance group to delete.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionInstanceGroupManagersGetRequest(_messages.Message):
  """A ComputeRegionInstanceGroupManagersGetRequest object.

  Fields:
    instanceGroupManager: Name of the managed instance group to return.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionInstanceGroupManagersInsertRequest(_messages.Message):
  """A ComputeRegionInstanceGroupManagersInsertRequest object.

  Fields:
    instanceGroupManager: A InstanceGroupManager resource to be passed as the
      request body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  instanceGroupManager = _messages.MessageField('InstanceGroupManager', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionInstanceGroupManagersListManagedInstancesRequest(_messages.Message):
  """A ComputeRegionInstanceGroupManagersListManagedInstancesRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionInstanceGroupManagersListRequest(_messages.Message):
  """A ComputeRegionInstanceGroupManagersListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeRegionInstanceGroupManagersRecreateInstancesRequest(_messages.Message):
  """A ComputeRegionInstanceGroupManagersRecreateInstancesRequest object.

  Fields:
    instanceGroupManager: Name of the managed instance group.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    regionInstanceGroupManagersRecreateRequest: A
      RegionInstanceGroupManagersRecreateRequest resource to be passed as the
      request body.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionInstanceGroupManagersRecreateRequest = _messages.MessageField('RegionInstanceGroupManagersRecreateRequest', 4)


class ComputeRegionInstanceGroupManagersResizeRequest(_messages.Message):
  """A ComputeRegionInstanceGroupManagersResizeRequest object.

  Fields:
    instanceGroupManager: Name of the managed instance group.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    size: Number of instances that should exist in this instance group
      manager.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  size = _messages.IntegerField(4, required=True, variant=_messages.Variant.INT32)


class ComputeRegionInstanceGroupManagersSetAutoHealingPoliciesRequest(_messages.Message):
  """A ComputeRegionInstanceGroupManagersSetAutoHealingPoliciesRequest object.

  Fields:
    instanceGroupManager: Name of the managed instance group.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    regionInstanceGroupManagersSetAutoHealingRequest: A
      RegionInstanceGroupManagersSetAutoHealingRequest resource to be passed
      as the request body.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionInstanceGroupManagersSetAutoHealingRequest = _messages.MessageField('RegionInstanceGroupManagersSetAutoHealingRequest', 4)


class ComputeRegionInstanceGroupManagersSetInstanceTemplateRequest(_messages.Message):
  """A ComputeRegionInstanceGroupManagersSetInstanceTemplateRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    regionInstanceGroupManagersSetTemplateRequest: A
      RegionInstanceGroupManagersSetTemplateRequest resource to be passed as
      the request body.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionInstanceGroupManagersSetTemplateRequest = _messages.MessageField('RegionInstanceGroupManagersSetTemplateRequest', 4)


class ComputeRegionInstanceGroupManagersSetTargetPoolsRequest(_messages.Message):
  """A ComputeRegionInstanceGroupManagersSetTargetPoolsRequest object.

  Fields:
    instanceGroupManager: Name of the managed instance group.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    regionInstanceGroupManagersSetTargetPoolsRequest: A
      RegionInstanceGroupManagersSetTargetPoolsRequest resource to be passed
      as the request body.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionInstanceGroupManagersSetTargetPoolsRequest = _messages.MessageField('RegionInstanceGroupManagersSetTargetPoolsRequest', 4)


class ComputeRegionInstanceGroupManagersTestIamPermissionsRequest(_messages.Message):
  """A ComputeRegionInstanceGroupManagersTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeRegionInstanceGroupsGetRequest(_messages.Message):
  """A ComputeRegionInstanceGroupsGetRequest object.

  Fields:
    instanceGroup: Name of the instance group resource to return.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  instanceGroup = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionInstanceGroupsListInstancesRequest(_messages.Message):
  """A ComputeRegionInstanceGroupsListInstancesRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    instanceGroup: Name of the regional instance group for which we want to
      list the instances.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    regionInstanceGroupsListInstancesRequest: A
      RegionInstanceGroupsListInstancesRequest resource to be passed as the
      request body.
  """

  filter = _messages.StringField(1)
  instanceGroup = _messages.StringField(2, required=True)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  region = _messages.StringField(7, required=True)
  regionInstanceGroupsListInstancesRequest = _messages.MessageField('RegionInstanceGroupsListInstancesRequest', 8)


class ComputeRegionInstanceGroupsListRequest(_messages.Message):
  """A ComputeRegionInstanceGroupsListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeRegionInstanceGroupsSetNamedPortsRequest(_messages.Message):
  """A ComputeRegionInstanceGroupsSetNamedPortsRequest object.

  Fields:
    instanceGroup: The name of the regional instance group where the named
      ports are updated.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    regionInstanceGroupsSetNamedPortsRequest: A
      RegionInstanceGroupsSetNamedPortsRequest resource to be passed as the
      request body.
  """

  instanceGroup = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionInstanceGroupsSetNamedPortsRequest = _messages.MessageField('RegionInstanceGroupsSetNamedPortsRequest', 4)


class ComputeRegionInstanceGroupsTestIamPermissionsRequest(_messages.Message):
  """A ComputeRegionInstanceGroupsTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeRegionOperationsDeleteRequest(_messages.Message):
  """A ComputeRegionOperationsDeleteRequest object.

  Fields:
    operation: Name of the Operations resource to delete.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  operation = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionOperationsDeleteResponse(_messages.Message):
  """An empty ComputeRegionOperationsDelete response."""


class ComputeRegionOperationsGetRequest(_messages.Message):
  """A ComputeRegionOperationsGetRequest object.

  Fields:
    operation: Name of the Operations resource to return.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  operation = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionOperationsListRequest(_messages.Message):
  """A ComputeRegionOperationsListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeRegionsGetRequest(_messages.Message):
  """A ComputeRegionsGetRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region resource to return.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)


class ComputeRegionsListRequest(_messages.Message):
  """A ComputeRegionsListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeRoutersAggregatedListRequest(_messages.Message):
  """A ComputeRoutersAggregatedListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeRoutersDeleteRequest(_messages.Message):
  """A ComputeRoutersDeleteRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    router: Name of the Router resource to delete.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  router = _messages.StringField(3, required=True)


class ComputeRoutersGetRequest(_messages.Message):
  """A ComputeRoutersGetRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    router: Name of the Router resource to return.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  router = _messages.StringField(3, required=True)


class ComputeRoutersGetRouterStatusRequest(_messages.Message):
  """A ComputeRoutersGetRouterStatusRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    router: Name of the Router resource to query.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  router = _messages.StringField(3, required=True)


class ComputeRoutersInsertRequest(_messages.Message):
  """A ComputeRoutersInsertRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    router: A Router resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  router = _messages.MessageField('Router', 3)


class ComputeRoutersListRequest(_messages.Message):
  """A ComputeRoutersListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeRoutersPatchRequest(_messages.Message):
  """A ComputeRoutersPatchRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    router: Name of the Router resource to update.
    routerResource: A Router resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  router = _messages.StringField(3, required=True)
  routerResource = _messages.MessageField('Router', 4)


class ComputeRoutersPreviewRequest(_messages.Message):
  """A ComputeRoutersPreviewRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    router: Name of the Router resource to query.
    routerResource: A Router resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  router = _messages.StringField(3, required=True)
  routerResource = _messages.MessageField('Router', 4)


class ComputeRoutersTestIamPermissionsRequest(_messages.Message):
  """A ComputeRoutersTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeRoutersUpdateRequest(_messages.Message):
  """A ComputeRoutersUpdateRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    router: Name of the Router resource to update.
    routerResource: A Router resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  router = _messages.StringField(3, required=True)
  routerResource = _messages.MessageField('Router', 4)


class ComputeRoutesDeleteRequest(_messages.Message):
  """A ComputeRoutesDeleteRequest object.

  Fields:
    project: Project ID for this request.
    route: Name of the Route resource to delete.
  """

  project = _messages.StringField(1, required=True)
  route = _messages.StringField(2, required=True)


class ComputeRoutesGetRequest(_messages.Message):
  """A ComputeRoutesGetRequest object.

  Fields:
    project: Project ID for this request.
    route: Name of the Route resource to return.
  """

  project = _messages.StringField(1, required=True)
  route = _messages.StringField(2, required=True)


class ComputeRoutesInsertRequest(_messages.Message):
  """A ComputeRoutesInsertRequest object.

  Fields:
    project: Project ID for this request.
    route: A Route resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  route = _messages.MessageField('Route', 2)


class ComputeRoutesListRequest(_messages.Message):
  """A ComputeRoutesListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeRoutesTestIamPermissionsRequest(_messages.Message):
  """A ComputeRoutesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeSnapshotsDeleteRequest(_messages.Message):
  """A ComputeSnapshotsDeleteRequest object.

  Fields:
    project: Project ID for this request.
    snapshot: Name of the Snapshot resource to delete.
  """

  project = _messages.StringField(1, required=True)
  snapshot = _messages.StringField(2, required=True)


class ComputeSnapshotsGetRequest(_messages.Message):
  """A ComputeSnapshotsGetRequest object.

  Fields:
    project: Project ID for this request.
    snapshot: Name of the Snapshot resource to return.
  """

  project = _messages.StringField(1, required=True)
  snapshot = _messages.StringField(2, required=True)


class ComputeSnapshotsListRequest(_messages.Message):
  """A ComputeSnapshotsListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeSnapshotsSetLabelsRequest(_messages.Message):
  """A ComputeSnapshotsSetLabelsRequest object.

  Fields:
    globalSetLabelsRequest: A GlobalSetLabelsRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    resource: Name of the resource for this request.
  """

  globalSetLabelsRequest = _messages.MessageField('GlobalSetLabelsRequest', 1)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeSnapshotsTestIamPermissionsRequest(_messages.Message):
  """A ComputeSnapshotsTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeSslCertificatesDeleteRequest(_messages.Message):
  """A ComputeSslCertificatesDeleteRequest object.

  Fields:
    project: Project ID for this request.
    sslCertificate: Name of the SslCertificate resource to delete.
  """

  project = _messages.StringField(1, required=True)
  sslCertificate = _messages.StringField(2, required=True)


class ComputeSslCertificatesGetRequest(_messages.Message):
  """A ComputeSslCertificatesGetRequest object.

  Fields:
    project: Project ID for this request.
    sslCertificate: Name of the SslCertificate resource to return.
  """

  project = _messages.StringField(1, required=True)
  sslCertificate = _messages.StringField(2, required=True)


class ComputeSslCertificatesInsertRequest(_messages.Message):
  """A ComputeSslCertificatesInsertRequest object.

  Fields:
    project: Project ID for this request.
    sslCertificate: A SslCertificate resource to be passed as the request
      body.
  """

  project = _messages.StringField(1, required=True)
  sslCertificate = _messages.MessageField('SslCertificate', 2)


class ComputeSslCertificatesListRequest(_messages.Message):
  """A ComputeSslCertificatesListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeSslCertificatesTestIamPermissionsRequest(_messages.Message):
  """A ComputeSslCertificatesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeSubnetworksAggregatedListRequest(_messages.Message):
  """A ComputeSubnetworksAggregatedListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeSubnetworksDeleteRequest(_messages.Message):
  """A ComputeSubnetworksDeleteRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region scoping this request.
    subnetwork: Name of the Subnetwork resource to delete.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  subnetwork = _messages.StringField(3, required=True)


class ComputeSubnetworksExpandIpCidrRangeRequest(_messages.Message):
  """A ComputeSubnetworksExpandIpCidrRangeRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region scoping this request.
    subnetwork: Name of the Subnetwork resource to update.
    subnetworksExpandIpCidrRangeRequest: A SubnetworksExpandIpCidrRangeRequest
      resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  subnetwork = _messages.StringField(3, required=True)
  subnetworksExpandIpCidrRangeRequest = _messages.MessageField('SubnetworksExpandIpCidrRangeRequest', 4)


class ComputeSubnetworksGetIamPolicyRequest(_messages.Message):
  """A ComputeSubnetworksGetIamPolicyRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeSubnetworksGetRequest(_messages.Message):
  """A ComputeSubnetworksGetRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region scoping this request.
    subnetwork: Name of the Subnetwork resource to return.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  subnetwork = _messages.StringField(3, required=True)


class ComputeSubnetworksInsertRequest(_messages.Message):
  """A ComputeSubnetworksInsertRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region scoping this request.
    subnetwork: A Subnetwork resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  subnetwork = _messages.MessageField('Subnetwork', 3)


class ComputeSubnetworksListRequest(_messages.Message):
  """A ComputeSubnetworksListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeSubnetworksSetIamPolicyRequest(_messages.Message):
  """A ComputeSubnetworksSetIamPolicyRequest object.

  Fields:
    policy: A Policy resource to be passed as the request body.
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
  """

  policy = _messages.MessageField('Policy', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  resource = _messages.StringField(4, required=True)


class ComputeSubnetworksTestIamPermissionsRequest(_messages.Message):
  """A ComputeSubnetworksTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeTargetHttpProxiesDeleteRequest(_messages.Message):
  """A ComputeTargetHttpProxiesDeleteRequest object.

  Fields:
    project: Project ID for this request.
    targetHttpProxy: Name of the TargetHttpProxy resource to delete.
  """

  project = _messages.StringField(1, required=True)
  targetHttpProxy = _messages.StringField(2, required=True)


class ComputeTargetHttpProxiesGetRequest(_messages.Message):
  """A ComputeTargetHttpProxiesGetRequest object.

  Fields:
    project: Project ID for this request.
    targetHttpProxy: Name of the TargetHttpProxy resource to return.
  """

  project = _messages.StringField(1, required=True)
  targetHttpProxy = _messages.StringField(2, required=True)


class ComputeTargetHttpProxiesInsertRequest(_messages.Message):
  """A ComputeTargetHttpProxiesInsertRequest object.

  Fields:
    project: Project ID for this request.
    targetHttpProxy: A TargetHttpProxy resource to be passed as the request
      body.
  """

  project = _messages.StringField(1, required=True)
  targetHttpProxy = _messages.MessageField('TargetHttpProxy', 2)


class ComputeTargetHttpProxiesListRequest(_messages.Message):
  """A ComputeTargetHttpProxiesListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeTargetHttpProxiesSetUrlMapRequest(_messages.Message):
  """A ComputeTargetHttpProxiesSetUrlMapRequest object.

  Fields:
    project: Project ID for this request.
    targetHttpProxy: Name of the TargetHttpProxy to set a URL map for.
    urlMapReference: A UrlMapReference resource to be passed as the request
      body.
  """

  project = _messages.StringField(1, required=True)
  targetHttpProxy = _messages.StringField(2, required=True)
  urlMapReference = _messages.MessageField('UrlMapReference', 3)


class ComputeTargetHttpProxiesTestIamPermissionsRequest(_messages.Message):
  """A ComputeTargetHttpProxiesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeTargetHttpsProxiesDeleteRequest(_messages.Message):
  """A ComputeTargetHttpsProxiesDeleteRequest object.

  Fields:
    project: Project ID for this request.
    targetHttpsProxy: Name of the TargetHttpsProxy resource to delete.
  """

  project = _messages.StringField(1, required=True)
  targetHttpsProxy = _messages.StringField(2, required=True)


class ComputeTargetHttpsProxiesGetRequest(_messages.Message):
  """A ComputeTargetHttpsProxiesGetRequest object.

  Fields:
    project: Project ID for this request.
    targetHttpsProxy: Name of the TargetHttpsProxy resource to return.
  """

  project = _messages.StringField(1, required=True)
  targetHttpsProxy = _messages.StringField(2, required=True)


class ComputeTargetHttpsProxiesInsertRequest(_messages.Message):
  """A ComputeTargetHttpsProxiesInsertRequest object.

  Fields:
    project: Project ID for this request.
    targetHttpsProxy: A TargetHttpsProxy resource to be passed as the request
      body.
  """

  project = _messages.StringField(1, required=True)
  targetHttpsProxy = _messages.MessageField('TargetHttpsProxy', 2)


class ComputeTargetHttpsProxiesListRequest(_messages.Message):
  """A ComputeTargetHttpsProxiesListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeTargetHttpsProxiesSetSslCertificatesRequest(_messages.Message):
  """A ComputeTargetHttpsProxiesSetSslCertificatesRequest object.

  Fields:
    project: Project ID for this request.
    targetHttpsProxiesSetSslCertificatesRequest: A
      TargetHttpsProxiesSetSslCertificatesRequest resource to be passed as the
      request body.
    targetHttpsProxy: Name of the TargetHttpsProxy resource to set an
      SslCertificates resource for.
  """

  project = _messages.StringField(1, required=True)
  targetHttpsProxiesSetSslCertificatesRequest = _messages.MessageField('TargetHttpsProxiesSetSslCertificatesRequest', 2)
  targetHttpsProxy = _messages.StringField(3, required=True)


class ComputeTargetHttpsProxiesSetUrlMapRequest(_messages.Message):
  """A ComputeTargetHttpsProxiesSetUrlMapRequest object.

  Fields:
    project: Project ID for this request.
    targetHttpsProxy: Name of the TargetHttpsProxy resource whose URL map is
      to be set.
    urlMapReference: A UrlMapReference resource to be passed as the request
      body.
  """

  project = _messages.StringField(1, required=True)
  targetHttpsProxy = _messages.StringField(2, required=True)
  urlMapReference = _messages.MessageField('UrlMapReference', 3)


class ComputeTargetHttpsProxiesTestIamPermissionsRequest(_messages.Message):
  """A ComputeTargetHttpsProxiesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeTargetInstancesAggregatedListRequest(_messages.Message):
  """A ComputeTargetInstancesAggregatedListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeTargetInstancesDeleteRequest(_messages.Message):
  """A ComputeTargetInstancesDeleteRequest object.

  Fields:
    project: Project ID for this request.
    targetInstance: Name of the TargetInstance resource to delete.
    zone: Name of the zone scoping this request.
  """

  project = _messages.StringField(1, required=True)
  targetInstance = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeTargetInstancesGetRequest(_messages.Message):
  """A ComputeTargetInstancesGetRequest object.

  Fields:
    project: Project ID for this request.
    targetInstance: Name of the TargetInstance resource to return.
    zone: Name of the zone scoping this request.
  """

  project = _messages.StringField(1, required=True)
  targetInstance = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeTargetInstancesInsertRequest(_messages.Message):
  """A ComputeTargetInstancesInsertRequest object.

  Fields:
    project: Project ID for this request.
    targetInstance: A TargetInstance resource to be passed as the request
      body.
    zone: Name of the zone scoping this request.
  """

  project = _messages.StringField(1, required=True)
  targetInstance = _messages.MessageField('TargetInstance', 2)
  zone = _messages.StringField(3, required=True)


class ComputeTargetInstancesListRequest(_messages.Message):
  """A ComputeTargetInstancesListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    zone: Name of the zone scoping this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  zone = _messages.StringField(6, required=True)


class ComputeTargetInstancesTestIamPermissionsRequest(_messages.Message):
  """A ComputeTargetInstancesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
    zone: The name of the zone for this request.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)
  zone = _messages.StringField(4, required=True)


class ComputeTargetPoolsAddHealthCheckRequest(_messages.Message):
  """A ComputeTargetPoolsAddHealthCheckRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region scoping this request.
    targetPool: Name of the target pool to add a health check to.
    targetPoolsAddHealthCheckRequest: A TargetPoolsAddHealthCheckRequest
      resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  targetPool = _messages.StringField(3, required=True)
  targetPoolsAddHealthCheckRequest = _messages.MessageField('TargetPoolsAddHealthCheckRequest', 4)


class ComputeTargetPoolsAddInstanceRequest(_messages.Message):
  """A ComputeTargetPoolsAddInstanceRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region scoping this request.
    targetPool: Name of the TargetPool resource to add instances to.
    targetPoolsAddInstanceRequest: A TargetPoolsAddInstanceRequest resource to
      be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  targetPool = _messages.StringField(3, required=True)
  targetPoolsAddInstanceRequest = _messages.MessageField('TargetPoolsAddInstanceRequest', 4)


class ComputeTargetPoolsAggregatedListRequest(_messages.Message):
  """A ComputeTargetPoolsAggregatedListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeTargetPoolsDeleteRequest(_messages.Message):
  """A ComputeTargetPoolsDeleteRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region scoping this request.
    targetPool: Name of the TargetPool resource to delete.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  targetPool = _messages.StringField(3, required=True)


class ComputeTargetPoolsGetHealthRequest(_messages.Message):
  """A ComputeTargetPoolsGetHealthRequest object.

  Fields:
    instanceReference: A InstanceReference resource to be passed as the
      request body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    targetPool: Name of the TargetPool resource to which the queried instance
      belongs.
  """

  instanceReference = _messages.MessageField('InstanceReference', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  targetPool = _messages.StringField(4, required=True)


class ComputeTargetPoolsGetRequest(_messages.Message):
  """A ComputeTargetPoolsGetRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region scoping this request.
    targetPool: Name of the TargetPool resource to return.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  targetPool = _messages.StringField(3, required=True)


class ComputeTargetPoolsInsertRequest(_messages.Message):
  """A ComputeTargetPoolsInsertRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region scoping this request.
    targetPool: A TargetPool resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  targetPool = _messages.MessageField('TargetPool', 3)


class ComputeTargetPoolsListRequest(_messages.Message):
  """A ComputeTargetPoolsListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeTargetPoolsRemoveHealthCheckRequest(_messages.Message):
  """A ComputeTargetPoolsRemoveHealthCheckRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    targetPool: Name of the target pool to remove health checks from.
    targetPoolsRemoveHealthCheckRequest: A TargetPoolsRemoveHealthCheckRequest
      resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  targetPool = _messages.StringField(3, required=True)
  targetPoolsRemoveHealthCheckRequest = _messages.MessageField('TargetPoolsRemoveHealthCheckRequest', 4)


class ComputeTargetPoolsRemoveInstanceRequest(_messages.Message):
  """A ComputeTargetPoolsRemoveInstanceRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region scoping this request.
    targetPool: Name of the TargetPool resource to remove instances from.
    targetPoolsRemoveInstanceRequest: A TargetPoolsRemoveInstanceRequest
      resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  targetPool = _messages.StringField(3, required=True)
  targetPoolsRemoveInstanceRequest = _messages.MessageField('TargetPoolsRemoveInstanceRequest', 4)


class ComputeTargetPoolsSetBackupRequest(_messages.Message):
  """A ComputeTargetPoolsSetBackupRequest object.

  Fields:
    failoverRatio: New failoverRatio value for the target pool.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    targetPool: Name of the TargetPool resource to set a backup pool for.
    targetReference: A TargetReference resource to be passed as the request
      body.
  """

  failoverRatio = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  targetPool = _messages.StringField(4, required=True)
  targetReference = _messages.MessageField('TargetReference', 5)


class ComputeTargetPoolsTestIamPermissionsRequest(_messages.Message):
  """A ComputeTargetPoolsTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeTargetSslProxiesDeleteRequest(_messages.Message):
  """A ComputeTargetSslProxiesDeleteRequest object.

  Fields:
    project: Project ID for this request.
    targetSslProxy: Name of the TargetSslProxy resource to delete.
  """

  project = _messages.StringField(1, required=True)
  targetSslProxy = _messages.StringField(2, required=True)


class ComputeTargetSslProxiesGetRequest(_messages.Message):
  """A ComputeTargetSslProxiesGetRequest object.

  Fields:
    project: Project ID for this request.
    targetSslProxy: Name of the TargetSslProxy resource to return.
  """

  project = _messages.StringField(1, required=True)
  targetSslProxy = _messages.StringField(2, required=True)


class ComputeTargetSslProxiesInsertRequest(_messages.Message):
  """A ComputeTargetSslProxiesInsertRequest object.

  Fields:
    project: Project ID for this request.
    targetSslProxy: A TargetSslProxy resource to be passed as the request
      body.
  """

  project = _messages.StringField(1, required=True)
  targetSslProxy = _messages.MessageField('TargetSslProxy', 2)


class ComputeTargetSslProxiesListRequest(_messages.Message):
  """A ComputeTargetSslProxiesListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeTargetSslProxiesSetBackendServiceRequest(_messages.Message):
  """A ComputeTargetSslProxiesSetBackendServiceRequest object.

  Fields:
    project: Project ID for this request.
    targetSslProxiesSetBackendServiceRequest: A
      TargetSslProxiesSetBackendServiceRequest resource to be passed as the
      request body.
    targetSslProxy: Name of the TargetSslProxy resource whose BackendService
      resource is to be set.
  """

  project = _messages.StringField(1, required=True)
  targetSslProxiesSetBackendServiceRequest = _messages.MessageField('TargetSslProxiesSetBackendServiceRequest', 2)
  targetSslProxy = _messages.StringField(3, required=True)


class ComputeTargetSslProxiesSetProxyHeaderRequest(_messages.Message):
  """A ComputeTargetSslProxiesSetProxyHeaderRequest object.

  Fields:
    project: Project ID for this request.
    targetSslProxiesSetProxyHeaderRequest: A
      TargetSslProxiesSetProxyHeaderRequest resource to be passed as the
      request body.
    targetSslProxy: Name of the TargetSslProxy resource whose ProxyHeader is
      to be set.
  """

  project = _messages.StringField(1, required=True)
  targetSslProxiesSetProxyHeaderRequest = _messages.MessageField('TargetSslProxiesSetProxyHeaderRequest', 2)
  targetSslProxy = _messages.StringField(3, required=True)


class ComputeTargetSslProxiesSetSslCertificatesRequest(_messages.Message):
  """A ComputeTargetSslProxiesSetSslCertificatesRequest object.

  Fields:
    project: Project ID for this request.
    targetSslProxiesSetSslCertificatesRequest: A
      TargetSslProxiesSetSslCertificatesRequest resource to be passed as the
      request body.
    targetSslProxy: Name of the TargetSslProxy resource whose SslCertificate
      resource is to be set.
  """

  project = _messages.StringField(1, required=True)
  targetSslProxiesSetSslCertificatesRequest = _messages.MessageField('TargetSslProxiesSetSslCertificatesRequest', 2)
  targetSslProxy = _messages.StringField(3, required=True)


class ComputeTargetSslProxiesTestIamPermissionsRequest(_messages.Message):
  """A ComputeTargetSslProxiesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeTargetVpnGatewaysAggregatedListRequest(_messages.Message):
  """A ComputeTargetVpnGatewaysAggregatedListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeTargetVpnGatewaysDeleteRequest(_messages.Message):
  """A ComputeTargetVpnGatewaysDeleteRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    targetVpnGateway: Name of the target VPN gateway to delete.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  targetVpnGateway = _messages.StringField(3, required=True)


class ComputeTargetVpnGatewaysGetRequest(_messages.Message):
  """A ComputeTargetVpnGatewaysGetRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    targetVpnGateway: Name of the target VPN gateway to return.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  targetVpnGateway = _messages.StringField(3, required=True)


class ComputeTargetVpnGatewaysInsertRequest(_messages.Message):
  """A ComputeTargetVpnGatewaysInsertRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    targetVpnGateway: A TargetVpnGateway resource to be passed as the request
      body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  targetVpnGateway = _messages.MessageField('TargetVpnGateway', 3)


class ComputeTargetVpnGatewaysListRequest(_messages.Message):
  """A ComputeTargetVpnGatewaysListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeTargetVpnGatewaysTestIamPermissionsRequest(_messages.Message):
  """A ComputeTargetVpnGatewaysTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeUrlMapsDeleteRequest(_messages.Message):
  """A ComputeUrlMapsDeleteRequest object.

  Fields:
    project: Project ID for this request.
    urlMap: Name of the UrlMap resource to delete.
  """

  project = _messages.StringField(1, required=True)
  urlMap = _messages.StringField(2, required=True)


class ComputeUrlMapsGetRequest(_messages.Message):
  """A ComputeUrlMapsGetRequest object.

  Fields:
    project: Project ID for this request.
    urlMap: Name of the UrlMap resource to return.
  """

  project = _messages.StringField(1, required=True)
  urlMap = _messages.StringField(2, required=True)


class ComputeUrlMapsInsertRequest(_messages.Message):
  """A ComputeUrlMapsInsertRequest object.

  Fields:
    project: Project ID for this request.
    urlMap: A UrlMap resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  urlMap = _messages.MessageField('UrlMap', 2)


class ComputeUrlMapsInvalidateCacheRequest(_messages.Message):
  """A ComputeUrlMapsInvalidateCacheRequest object.

  Fields:
    cacheInvalidationRule: A CacheInvalidationRule resource to be passed as
      the request body.
    project: Project ID for this request.
    urlMap: Name of the UrlMap scoping this request.
  """

  cacheInvalidationRule = _messages.MessageField('CacheInvalidationRule', 1)
  project = _messages.StringField(2, required=True)
  urlMap = _messages.StringField(3, required=True)


class ComputeUrlMapsListRequest(_messages.Message):
  """A ComputeUrlMapsListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeUrlMapsPatchRequest(_messages.Message):
  """A ComputeUrlMapsPatchRequest object.

  Fields:
    project: Project ID for this request.
    urlMap: Name of the UrlMap resource to update.
    urlMapResource: A UrlMap resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  urlMap = _messages.StringField(2, required=True)
  urlMapResource = _messages.MessageField('UrlMap', 3)


class ComputeUrlMapsTestIamPermissionsRequest(_messages.Message):
  """A ComputeUrlMapsTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeUrlMapsUpdateRequest(_messages.Message):
  """A ComputeUrlMapsUpdateRequest object.

  Fields:
    project: Project ID for this request.
    urlMap: Name of the UrlMap resource to update.
    urlMapResource: A UrlMap resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  urlMap = _messages.StringField(2, required=True)
  urlMapResource = _messages.MessageField('UrlMap', 3)


class ComputeUrlMapsValidateRequest(_messages.Message):
  """A ComputeUrlMapsValidateRequest object.

  Fields:
    project: Project ID for this request.
    urlMap: Name of the UrlMap resource to be validated as.
    urlMapsValidateRequest: A UrlMapsValidateRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  urlMap = _messages.StringField(2, required=True)
  urlMapsValidateRequest = _messages.MessageField('UrlMapsValidateRequest', 3)


class ComputeVpnTunnelsAggregatedListRequest(_messages.Message):
  """A ComputeVpnTunnelsAggregatedListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeVpnTunnelsDeleteRequest(_messages.Message):
  """A ComputeVpnTunnelsDeleteRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    vpnTunnel: Name of the VpnTunnel resource to delete.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  vpnTunnel = _messages.StringField(3, required=True)


class ComputeVpnTunnelsGetRequest(_messages.Message):
  """A ComputeVpnTunnelsGetRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    vpnTunnel: Name of the VpnTunnel resource to return.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  vpnTunnel = _messages.StringField(3, required=True)


class ComputeVpnTunnelsInsertRequest(_messages.Message):
  """A ComputeVpnTunnelsInsertRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    vpnTunnel: A VpnTunnel resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  vpnTunnel = _messages.MessageField('VpnTunnel', 3)


class ComputeVpnTunnelsListRequest(_messages.Message):
  """A ComputeVpnTunnelsListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeVpnTunnelsTestIamPermissionsRequest(_messages.Message):
  """A ComputeVpnTunnelsTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeZoneOperationsDeleteRequest(_messages.Message):
  """A ComputeZoneOperationsDeleteRequest object.

  Fields:
    operation: Name of the Operations resource to delete.
    project: Project ID for this request.
    zone: Name of the zone for this request.
  """

  operation = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeZoneOperationsDeleteResponse(_messages.Message):
  """An empty ComputeZoneOperationsDelete response."""


class ComputeZoneOperationsGetRequest(_messages.Message):
  """A ComputeZoneOperationsGetRequest object.

  Fields:
    operation: Name of the Operations resource to return.
    project: Project ID for this request.
    zone: Name of the zone for this request.
  """

  operation = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeZoneOperationsListRequest(_messages.Message):
  """A ComputeZoneOperationsListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    zone: Name of the zone for request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  zone = _messages.StringField(6, required=True)


class ComputeZonesGetRequest(_messages.Message):
  """A ComputeZonesGetRequest object.

  Fields:
    project: Project ID for this request.
    zone: Name of the zone resource to return.
  """

  project = _messages.StringField(1, required=True)
  zone = _messages.StringField(2, required=True)


class ComputeZonesListRequest(_messages.Message):
  """A ComputeZonesListRequest object.

  Fields:
    filter: Sets a filter expression for filtering listed resources, in the
      form filter={expression}. Your {expression} must be in the format:
      field_name comparison_string literal_string.  The field_name is the name
      of the field you want to compare. Only atomic field types are supported
      (string, number, boolean). The comparison_string must be either eq
      (equals) or ne (not equals). The literal_string is the string value to
      filter to. The literal value must be valid for the type of field you are
      filtering by (string, number, boolean). For string fields, the literal
      value is interpreted as a regular expression using RE2 syntax. The
      literal value must match the entire field.  For example, to filter for
      instances that do not have a name of example-instance, you would use
      filter=name ne example-instance.  You can filter on nested fields. For
      example, you could filter on instances that have set the
      scheduling.automaticRestart field to true. Use filtering on nested
      fields to take advantage of labels to organize and search for results
      based on label values.  To filter on multiple expressions, provide each
      separate expression within parentheses. For example,
      (scheduling.automaticRestart eq true) (zone eq us-central1-f). Multiple
      expressions are treated as AND expressions, meaning that resources must
      match all expressions to pass the filters.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class Condition(_messages.Message):
  """A condition to be met.

  Enums:
    IamValueValuesEnum: Trusted attributes supplied by the IAM system.
    OpValueValuesEnum: An operator to apply the subject with.
    SysValueValuesEnum: Trusted attributes supplied by any service that owns
      resources and uses the IAM system for access control.

  Fields:
    iam: Trusted attributes supplied by the IAM system.
    op: An operator to apply the subject with.
    svc: Trusted attributes discharged by the service.
    sys: Trusted attributes supplied by any service that owns resources and
      uses the IAM system for access control.
    value: DEPRECATED. Use 'values' instead.
    values: The objects of the condition. This is mutually exclusive with
      'value'.
  """

  class IamValueValuesEnum(_messages.Enum):
    """Trusted attributes supplied by the IAM system.

    Values:
      ATTRIBUTION: <no description>
      AUTHORITY: <no description>
      NO_ATTR: <no description>
    """
    ATTRIBUTION = 0
    AUTHORITY = 1
    NO_ATTR = 2

  class OpValueValuesEnum(_messages.Enum):
    """An operator to apply the subject with.

    Values:
      DISCHARGED: <no description>
      EQUALS: <no description>
      IN: <no description>
      NOT_EQUALS: <no description>
      NOT_IN: <no description>
      NO_OP: <no description>
    """
    DISCHARGED = 0
    EQUALS = 1
    IN = 2
    NOT_EQUALS = 3
    NOT_IN = 4
    NO_OP = 5

  class SysValueValuesEnum(_messages.Enum):
    """Trusted attributes supplied by any service that owns resources and uses
    the IAM system for access control.

    Values:
      IP: <no description>
      NAME: <no description>
      NO_ATTR: <no description>
      REGION: <no description>
      SERVICE: <no description>
    """
    IP = 0
    NAME = 1
    NO_ATTR = 2
    REGION = 3
    SERVICE = 4

  iam = _messages.EnumField('IamValueValuesEnum', 1)
  op = _messages.EnumField('OpValueValuesEnum', 2)
  svc = _messages.StringField(3)
  sys = _messages.EnumField('SysValueValuesEnum', 4)
  value = _messages.StringField(5)
  values = _messages.StringField(6, repeated=True)


class ConnectionDraining(_messages.Message):
  """Message containing connection draining configuration.

  Fields:
    drainingTimeoutSec: Time for which instance will be drained (not accept
      new connections, but still work to finish started).
  """

  drainingTimeoutSec = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class CustomerEncryptionKey(_messages.Message):
  """Represents a customer-supplied encryption key

  Fields:
    rawKey: Specifies a 256-bit customer-supplied encryption key, encoded in
      RFC 4648 base64 to either encrypt or decrypt this resource.
    rsaEncryptedKey: Specifies an RFC 4648 base64 encoded, RSA-wrapped
      2048-bit customer-supplied encryption key to either encrypt or decrypt
      this resource.  The key must meet the following requirements before you
      can provide it to Compute Engine:   - The key is wrapped using a RSA
      public key certificate provided by Google.  - After being wrapped, the
      key must be encoded in RFC 4648 base64 encoding.  Get the RSA public key
      certificate provided by Google at: https://cloud-
      certs.storage.googleapis.com/google-cloud-csek-ingress.pem
    sha256: [Output only] The RFC 4648 base64 encoded SHA-256 hash of the
      customer-supplied encryption key that protects this resource.
  """

  rawKey = _messages.StringField(1)
  rsaEncryptedKey = _messages.StringField(2)
  sha256 = _messages.StringField(3)


class CustomerEncryptionKeyProtectedDisk(_messages.Message):
  """A CustomerEncryptionKeyProtectedDisk object.

  Fields:
    diskEncryptionKey: Decrypts data associated with the disk with a customer-
      supplied encryption key.
    source: Specifies a valid partial or full URL to an existing Persistent
      Disk resource. This field is only applicable for persistent disks.
  """

  diskEncryptionKey = _messages.MessageField('CustomerEncryptionKey', 1)
  source = _messages.StringField(2)


class DeprecationStatus(_messages.Message):
  """Deprecation status for a public resource.

  Enums:
    StateValueValuesEnum: The deprecation state of this resource. This can be
      DEPRECATED, OBSOLETE, or DELETED. Operations which create a new resource
      using a DEPRECATED resource will return successfully, but with a warning
      indicating the deprecated resource and recommending its replacement.
      Operations which use OBSOLETE or DELETED resources will be rejected and
      result in an error.

  Fields:
    deleted: An optional RFC3339 timestamp on or after which the deprecation
      state of this resource will be changed to DELETED.
    deprecated: An optional RFC3339 timestamp on or after which the
      deprecation state of this resource will be changed to DEPRECATED.
    obsolete: An optional RFC3339 timestamp on or after which the deprecation
      state of this resource will be changed to OBSOLETE.
    replacement: The URL of the suggested replacement for a deprecated
      resource. The suggested replacement resource must be the same kind of
      resource as the deprecated resource.
    state: The deprecation state of this resource. This can be DEPRECATED,
      OBSOLETE, or DELETED. Operations which create a new resource using a
      DEPRECATED resource will return successfully, but with a warning
      indicating the deprecated resource and recommending its replacement.
      Operations which use OBSOLETE or DELETED resources will be rejected and
      result in an error.
  """

  class StateValueValuesEnum(_messages.Enum):
    """The deprecation state of this resource. This can be DEPRECATED,
    OBSOLETE, or DELETED. Operations which create a new resource using a
    DEPRECATED resource will return successfully, but with a warning
    indicating the deprecated resource and recommending its replacement.
    Operations which use OBSOLETE or DELETED resources will be rejected and
    result in an error.

    Values:
      DELETED: <no description>
      DEPRECATED: <no description>
      OBSOLETE: <no description>
    """
    DELETED = 0
    DEPRECATED = 1
    OBSOLETE = 2

  deleted = _messages.StringField(1)
  deprecated = _messages.StringField(2)
  obsolete = _messages.StringField(3)
  replacement = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)


class Disk(_messages.Message):
  """A Disk resource.

  Enums:
    StatusValueValuesEnum: [Output Only] The status of disk creation.
      Applicable statuses includes: CREATING, FAILED, READY, RESTORING.
    StorageTypeValueValuesEnum: [Deprecated] Storage type of the persistent
      disk.

  Messages:
    LabelsValue: Labels to apply to this disk. These can be later modified by
      the setLabels method. Each label key/value pair must comply with
      RFC1035. Label values may be empty.

  Fields:
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    diskEncryptionKey: Encrypts the disk using a customer-supplied encryption
      key.  After you encrypt a disk with a customer-supplied key, you must
      provide the same key if you use the disk later (e.g. to create a disk
      snapshot or an image, or to attach the disk to a virtual machine).
      Customer-supplied encryption keys do not protect access to metadata of
      the disk.  If you do not provide an encryption key when creating the
      disk, then the disk will be encrypted using an automatically generated
      key and you do not need to provide a key to use the disk later.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] Type of the resource. Always compute#disk for disks.
    labelFingerprint: A fingerprint for the labels being applied to this disk,
      which is essentially a hash of the labels set used for optimistic
      locking. The fingerprint is initially generated by Compute Engine and
      changes after every request to modify or update labels. You must always
      provide an up-to-date fingerprint hash in order to update or change
      labels.  To see the latest fingerprint, make a get() request to retrieve
      a disk.
    labels: Labels to apply to this disk. These can be later modified by the
      setLabels method. Each label key/value pair must comply with RFC1035.
      Label values may be empty.
    lastAttachTimestamp: [Output Only] Last attach timestamp in RFC3339 text
      format.
    lastDetachTimestamp: [Output Only] Last detach timestamp in RFC3339 text
      format.
    licenses: Any applicable publicly visible licenses.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    options: Internal use only.
    region: [Output Only] URL of the region where the disk resides. Only
      applicable for regional resources.
    replicaZones: URLs of the zones where the disk should be replicated to.
      Only applicable for regional resources.
    selfLink: [Output Only] Server-defined fully-qualified URL for this
      resource.
    sizeGb: Size of the persistent disk, specified in GB. You can specify this
      field when creating a persistent disk using the sourceImage or
      sourceSnapshot parameter, or specify it alone to create an empty
      persistent disk.  If you specify this field along with sourceImage or
      sourceSnapshot, the value of sizeGb must not be less than the size of
      the sourceImage or the size of the snapshot.
    sourceImage: The source image used to create this disk. If the source
      image is deleted, this field will not be set.  To create a disk with one
      of the public operating system images, specify the image by its family
      name. For example, specify family/debian-8 to use the latest Debian 8
      image:  projects/debian-cloud/global/images/family/debian-8
      Alternatively, use a specific version of a public operating system
      image:  projects/debian-cloud/global/images/debian-8-jessie-vYYYYMMDD
      To create a disk with a private image that you created, specify the
      image name in the following format:  global/images/my-private-image
      You can also specify a private image by its image family, which returns
      the latest version of the image in that family. Replace the image name
      with family/family-name:  global/images/family/my-private-family
    sourceImageEncryptionKey: The customer-supplied encryption key of the
      source image. Required if the source image is protected by a customer-
      supplied encryption key.
    sourceImageId: [Output Only] The ID value of the image used to create this
      disk. This value identifies the exact image that was used to create this
      persistent disk. For example, if you created the persistent disk from an
      image that was later deleted and recreated under the same name, the
      source image ID would identify the exact version of the image that was
      used.
    sourceSnapshot: The source snapshot used to create this disk. You can
      provide this as a partial or full URL to the resource. For example, the
      following are valid values:   - https://www.googleapis.com/compute/v1/pr
      ojects/project/global/snapshots/snapshot  -
      projects/project/global/snapshots/snapshot  - global/snapshots/snapshot
    sourceSnapshotEncryptionKey: The customer-supplied encryption key of the
      source snapshot. Required if the source snapshot is protected by a
      customer-supplied encryption key.
    sourceSnapshotId: [Output Only] The unique ID of the snapshot used to
      create this disk. This value identifies the exact snapshot that was used
      to create this persistent disk. For example, if you created the
      persistent disk from a snapshot that was later deleted and recreated
      under the same name, the source snapshot ID would identify the exact
      version of the snapshot that was used.
    status: [Output Only] The status of disk creation. Applicable statuses
      includes: CREATING, FAILED, READY, RESTORING.
    storageType: [Deprecated] Storage type of the persistent disk.
    type: URL of the disk type resource describing which disk type to use to
      create the disk. Provide this when creating the disk.
    users: [Output Only] Links to the users of the disk (attached instances)
      in form: project/zones/zone/instances/instance
    zone: [Output Only] URL of the zone where the disk resides.
  """

  class StatusValueValuesEnum(_messages.Enum):
    """[Output Only] The status of disk creation. Applicable statuses
    includes: CREATING, FAILED, READY, RESTORING.

    Values:
      CREATING: <no description>
      FAILED: <no description>
      READY: <no description>
      RESTORING: <no description>
    """
    CREATING = 0
    FAILED = 1
    READY = 2
    RESTORING = 3

  class StorageTypeValueValuesEnum(_messages.Enum):
    """[Deprecated] Storage type of the persistent disk.

    Values:
      HDD: <no description>
      SSD: <no description>
    """
    HDD = 0
    SSD = 1

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    """Labels to apply to this disk. These can be later modified by the
    setLabels method. Each label key/value pair must comply with RFC1035.
    Label values may be empty.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  creationTimestamp = _messages.StringField(1)
  description = _messages.StringField(2)
  diskEncryptionKey = _messages.MessageField('CustomerEncryptionKey', 3)
  id = _messages.IntegerField(4, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(5, default=u'compute#disk')
  labelFingerprint = _messages.BytesField(6)
  labels = _messages.MessageField('LabelsValue', 7)
  lastAttachTimestamp = _messages.StringField(8)
  lastDetachTimestamp = _messages.StringField(9)
  licenses = _messages.StringField(10, repeated=True)
  name = _messages.StringField(11)
  options = _messages.StringField(12)
  region = _messages.StringField(13)
  replicaZones = _messages.StringField(14, repeated=True)
  selfLink = _messages.StringField(15)
  sizeGb = _messages.IntegerField(16)
  sourceImage = _messages.StringField(17)
  sourceImageEncryptionKey = _messages.MessageField('CustomerEncryptionKey', 18)
  sourceImageId = _messages.StringField(19)
  sourceSnapshot = _messages.StringField(20)
  sourceSnapshotEncryptionKey = _messages.MessageField('CustomerEncryptionKey', 21)
  sourceSnapshotId = _messages.StringField(22)
  status = _messages.EnumField('StatusValueValuesEnum', 23)
  storageType = _messages.EnumField('StorageTypeValueValuesEnum', 24)
  type = _messages.StringField(25)
  users = _messages.StringField(26, repeated=True)
  zone = _messages.StringField(27)


class DiskAggregatedList(_messages.Message):
  """A DiskAggregatedList object.

  Messages:
    ItemsValue: [Output Only] A map of scoped disk lists.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: [Output Only] A map of scoped disk lists.
    kind: [Output Only] Type of resource. Always compute#diskAggregatedList
      for aggregated lists of persistent disks.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    """[Output Only] A map of scoped disk lists.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: [Output Only] Name of the scope containing this
        set of disks.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A DisksScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('DisksScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default=u'compute#diskAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class DiskList(_messages.Message):
  """A list of Disk resources.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: [Output Only] A list of persistent disks.
    kind: [Output Only] Type of resource. Always compute#diskList for lists of
      disks.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('Disk', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#diskList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class DiskMoveRequest(_messages.Message):
  """A DiskMoveRequest object.

  Fields:
    destinationZone: The URL of the destination zone to move the disk. This
      can be a full or partial URL. For example, the following are all valid
      URLs to a zone:   -
      https://www.googleapis.com/compute/v1/projects/project/zones/zone  -
      projects/project/zones/zone  - zones/zone
    targetDisk: The URL of the target disk to move. This can be a full or
      partial URL. For example, the following are all valid URLs to a disk:
      - https://www.googleapis.com/compute/v1/projects/project/zones/zone/disk
      s/disk  - projects/project/zones/zone/disks/disk  -
      zones/zone/disks/disk
  """

  destinationZone = _messages.StringField(1)
  targetDisk = _messages.StringField(2)


class DiskType(_messages.Message):
  """A DiskType resource.

  Fields:
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    defaultDiskSizeGb: [Output Only] Server-defined default disk size in GB.
    deprecated: [Output Only] The deprecation status associated with this disk
      type.
    description: [Output Only] An optional description of this resource.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] Type of the resource. Always compute#diskType for disk
      types.
    name: [Output Only] Name of the resource.
    selfLink: [Output Only] Server-defined URL for the resource.
    validDiskSize: [Output Only] An optional textual description of the valid
      disk size, such as "10GB-10TB".
    zone: [Output Only] URL of the zone where the disk type resides.
  """

  creationTimestamp = _messages.StringField(1)
  defaultDiskSizeGb = _messages.IntegerField(2)
  deprecated = _messages.MessageField('DeprecationStatus', 3)
  description = _messages.StringField(4)
  id = _messages.IntegerField(5, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(6, default=u'compute#diskType')
  name = _messages.StringField(7)
  selfLink = _messages.StringField(8)
  validDiskSize = _messages.StringField(9)
  zone = _messages.StringField(10)


class DiskTypeAggregatedList(_messages.Message):
  """A DiskTypeAggregatedList object.

  Messages:
    ItemsValue: [Output Only] A map of scoped disk type lists.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: [Output Only] A map of scoped disk type lists.
    kind: [Output Only] Type of resource. Always
      compute#diskTypeAggregatedList.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    """[Output Only] A map of scoped disk type lists.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: [Output Only] Name of the scope containing this
        set of disk types.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A DiskTypesScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('DiskTypesScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default=u'compute#diskTypeAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class DiskTypeList(_messages.Message):
  """Contains a list of disk types.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: [Output Only] A list of Disk Type resources.
    kind: [Output Only] Type of resource. Always compute#diskTypeList for disk
      types.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('DiskType', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#diskTypeList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class DiskTypesScopedList(_messages.Message):
  """A DiskTypesScopedList object.

  Messages:
    WarningValue: [Output Only] Informational warning which replaces the list
      of disk types when the list is empty.

  Fields:
    diskTypes: [Output Only] List of disk types contained in this scope.
    warning: [Output Only] Informational warning which replaces the list of
      disk types when the list is empty.
  """

  class WarningValue(_messages.Message):
    """[Output Only] Informational warning which replaces the list of disk
    types when the list is empty.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      """[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 2
      INJECTED_KERNELS_DEPRECATED = 3
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 4
      NEXT_HOP_CANNOT_IP_FORWARD = 5
      NEXT_HOP_INSTANCE_NOT_FOUND = 6
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 7
      NEXT_HOP_NOT_RUNNING = 8
      NOT_CRITICAL_ERROR = 9
      NO_RESULTS_ON_PAGE = 10
      REQUIRED_TOS_AGREEMENT = 11
      RESOURCE_NOT_DELETED = 12
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 13
      UNREACHABLE = 14

    class DataValueListEntry(_messages.Message):
      """A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  diskTypes = _messages.MessageField('DiskType', 1, repeated=True)
  warning = _messages.MessageField('WarningValue', 2)


class DisksResizeRequest(_messages.Message):
  """A DisksResizeRequest object.

  Fields:
    sizeGb: The new size of the persistent disk, which is specified in GB.
  """

  sizeGb = _messages.IntegerField(1)


class DisksScopedList(_messages.Message):
  """A DisksScopedList object.

  Messages:
    WarningValue: [Output Only] Informational warning which replaces the list
      of disks when the list is empty.

  Fields:
    disks: [Output Only] List of disks contained in this scope.
    warning: [Output Only] Informational warning which replaces the list of
      disks when the list is empty.
  """

  class WarningValue(_messages.Message):
    """[Output Only] Informational warning which replaces the list of disks
    when the list is empty.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      """[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 2
      INJECTED_KERNELS_DEPRECATED = 3
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 4
      NEXT_HOP_CANNOT_IP_FORWARD = 5
      NEXT_HOP_INSTANCE_NOT_FOUND = 6
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 7
      NEXT_HOP_NOT_RUNNING = 8
      NOT_CRITICAL_ERROR = 9
      NO_RESULTS_ON_PAGE = 10
      REQUIRED_TOS_AGREEMENT = 11
      RESOURCE_NOT_DELETED = 12
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 13
      UNREACHABLE = 14

    class DataValueListEntry(_messages.Message):
      """A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  disks = _messages.MessageField('Disk', 1, repeated=True)
  warning = _messages.MessageField('WarningValue', 2)


class Firewall(_messages.Message):
  """Represents a Firewall resource.

  Messages:
    AllowedValueListEntry: A AllowedValueListEntry object.

  Fields:
    allowed: The list of rules specified by this firewall. Each rule specifies
      a protocol and port-range tuple that describes a permitted connection.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Ony] Type of the resource. Always compute#firewall for
      firewall rules.
    name: Name of the resource; provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    network: URL of the network resource for this firewall rule. If not
      specified when creating a firewall rule, the default network is used:
      global/networks/default If you choose to specify this property, you can
      specify the network as a full or partial URL. For example, the following
      are all valid URLs:   -
      https://www.googleapis.com/compute/v1/projects/myproject/global/networks
      /my-network  - projects/myproject/global/networks/my-network  -
      global/networks/default
    selfLink: [Output Only] Server-defined URL for the resource.
    sourceRanges: If source ranges are specified, the firewall will apply only
      to traffic that has source IP address in these ranges. These ranges must
      be expressed in CIDR format. One or both of sourceRanges and sourceTags
      may be set. If both properties are set, the firewall will apply to
      traffic that has source IP address within sourceRanges OR the source IP
      that belongs to a tag listed in the sourceTags property. The connection
      does not need to match both properties for the firewall to apply.
    sourceTags: If source tags are specified, the firewall will apply only to
      traffic with source IP that belongs to a tag listed in source tags.
      Source tags cannot be used to control traffic to an instance's external
      IP address. Because tags are associated with an instance, not an IP
      address. One or both of sourceRanges and sourceTags may be set. If both
      properties are set, the firewall will apply to traffic that has source
      IP address within sourceRanges OR the source IP that belongs to a tag
      listed in the sourceTags property. The connection does not need to match
      both properties for the firewall to apply.
    targetTags: A list of instance tags indicating sets of instances located
      in the network that may make network connections as specified in
      allowed[]. If no targetTags are specified, the firewall rule applies to
      all instances on the specified network.
  """

  class AllowedValueListEntry(_messages.Message):
    """A AllowedValueListEntry object.

    Fields:
      IPProtocol: The IP protocol that is allowed for this rule. The protocol
        type is required when creating a firewall rule. This value can either
        be one of the following well known protocol strings (tcp, udp, icmp,
        esp, ah, sctp), or the IP protocol number.
      ports: An optional list of ports which are allowed. This field is only
        applicable for UDP or TCP protocol. Each entry must be either an
        integer or a range. If not specified, connections through any port are
        allowed  Example inputs include: ["22"], ["80","443"], and
        ["12345-12349"].
    """

    IPProtocol = _messages.StringField(1)
    ports = _messages.StringField(2, repeated=True)

  allowed = _messages.MessageField('AllowedValueListEntry', 1, repeated=True)
  creationTimestamp = _messages.StringField(2)
  description = _messages.StringField(3)
  id = _messages.IntegerField(4, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(5, default=u'compute#firewall')
  name = _messages.StringField(6)
  network = _messages.StringField(7)
  selfLink = _messages.StringField(8)
  sourceRanges = _messages.StringField(9, repeated=True)
  sourceTags = _messages.StringField(10, repeated=True)
  targetTags = _messages.StringField(11, repeated=True)


class FirewallList(_messages.Message):
  """Contains a list of firewalls.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: [Output Only] A list of Firewall resources.
    kind: [Output Only] Type of resource. Always compute#firewallList for
      lists of firewalls.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('Firewall', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#firewallList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class FixedOrPercent(_messages.Message):
  """Encapsulates numeric value that can be either absolute or relative.

  Fields:
    calculated: [Output Only] Absolute value calculated based on mode: mode =
      fixed -> calculated = fixed = percent -> calculated =
      ceiling(percent/100 * base_value)
    fixed: fixed must be non-negative.
    percent: percent must belong to [0, 100].
  """

  calculated = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  fixed = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  percent = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class ForwardingRule(_messages.Message):
  """A ForwardingRule resource. A ForwardingRule resource specifies which pool
  of target virtual machines to forward a packet to if it matches the given
  [IPAddress, IPProtocol, portRange] tuple.

  Enums:
    IPProtocolValueValuesEnum: The IP protocol to which this rule applies.
      Valid options are TCP, UDP, ESP, AH, SCTP or ICMP.  When the load
      balancing scheme is INTERNAL</code, only TCP and UDP are valid.
    LoadBalancingSchemeValueValuesEnum: This signifies what the ForwardingRule
      will be used for and can only take the following values: INTERNAL
      EXTERNAL The value of INTERNAL means that this will be used for Internal
      Network Load Balancing (TCP, UDP). The value of EXTERNAL means that this
      will be used for External Load Balancing (HTTP(S) LB, External TCP/UDP
      LB, SSL Proxy)

  Fields:
    IPAddress: The IP address that this forwarding rule is serving on behalf
      of.  For global forwarding rules, the address must be a global IP; for
      regional forwarding rules, the address must live in the same region as
      the forwarding rule. By default, this field is empty and an ephemeral IP
      from the same scope (global or regional) will be assigned.  When the
      load balancing scheme is INTERNAL, this can only be an RFC 1918 IP
      address belonging to the network/subnetwork configured for the
      forwarding rule. A reserved address cannot be used. If the field is
      empty, the IP address will be automatically allocated from the internal
      IP range of the subnetwork or network configured for this forwarding
      rule.
    IPProtocol: The IP protocol to which this rule applies. Valid options are
      TCP, UDP, ESP, AH, SCTP or ICMP.  When the load balancing scheme is
      INTERNAL</code, only TCP and UDP are valid.
    backendService: This field is not used for external load balancing.  For
      internal load balancing, this field identifies the BackendService
      resource to receive the matched traffic.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] Type of the resource. Always compute#forwardingRule
      for Forwarding Rule resources.
    loadBalancingScheme: This signifies what the ForwardingRule will be used
      for and can only take the following values: INTERNAL EXTERNAL The value
      of INTERNAL means that this will be used for Internal Network Load
      Balancing (TCP, UDP). The value of EXTERNAL means that this will be used
      for External Load Balancing (HTTP(S) LB, External TCP/UDP LB, SSL Proxy)
    name: Name of the resource; provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    network: This field is not used for external load balancing.  For internal
      load balancing, this field identifies the network that the load balanced
      IP should belong to for this Forwarding Rule. If this field is not
      specified, the default network will be used.
    portRange: Applicable only when IPProtocol is TCP, UDP, or SCTP, only
      packets addressed to ports in the specified range will be forwarded to
      target. Forwarding rules with the same [IPAddress, IPProtocol] pair must
      have disjoint port ranges.  This field is not used for internal load
      balancing.
    ports: This field is not used for external load balancing.  When the load
      balancing scheme is INTERNAL, a single port or a comma separated list of
      ports can be configured. Only packets addressed to these ports will be
      forwarded to the backends configured with this forwarding rule. If the
      port list is not provided then all ports are allowed to pass through.
      You may specify a maximum of up to 5 ports.
    region: [Output Only] URL of the region where the regional forwarding rule
      resides. This field is not applicable to global forwarding rules.
    selfLink: [Output Only] Server-defined URL for the resource.
    subnetwork: This field is not used for external load balancing.  For
      internal load balancing, this field identifies the subnetwork that the
      load balanced IP should belong to for this Forwarding Rule.  If the
      network specified is in auto subnet mode, this field is optional.
      However, if the network is in custom subnet mode, a subnetwork must be
      specified.
    target: The URL of the target resource to receive the matched traffic. For
      regional forwarding rules, this target must live in the same region as
      the forwarding rule. For global forwarding rules, this target must be a
      global TargetHttpProxy or TargetHttpsProxy resource. The forwarded
      traffic must be of a type appropriate to the target object. For example,
      TargetHttpProxy requires HTTP traffic, and TargetHttpsProxy requires
      HTTPS traffic.  This field is not used for internal load balancing.
  """

  class IPProtocolValueValuesEnum(_messages.Enum):
    """The IP protocol to which this rule applies. Valid options are TCP, UDP,
    ESP, AH, SCTP or ICMP.  When the load balancing scheme is INTERNAL</code,
    only TCP and UDP are valid.

    Values:
      AH: <no description>
      ESP: <no description>
      ICMP: <no description>
      SCTP: <no description>
      TCP: <no description>
      UDP: <no description>
    """
    AH = 0
    ESP = 1
    ICMP = 2
    SCTP = 3
    TCP = 4
    UDP = 5

  class LoadBalancingSchemeValueValuesEnum(_messages.Enum):
    """This signifies what the ForwardingRule will be used for and can only
    take the following values: INTERNAL EXTERNAL The value of INTERNAL means
    that this will be used for Internal Network Load Balancing (TCP, UDP). The
    value of EXTERNAL means that this will be used for External Load Balancing
    (HTTP(S) LB, External TCP/UDP LB, SSL Proxy)

    Values:
      EXTERNAL: <no description>
      INTERNAL: <no description>
      INVALID: <no description>
    """
    EXTERNAL = 0
    INTERNAL = 1
    INVALID = 2

  IPAddress = _messages.StringField(1)
  IPProtocol = _messages.EnumField('IPProtocolValueValuesEnum', 2)
  backendService = _messages.StringField(3)
  creationTimestamp = _messages.StringField(4)
  description = _messages.StringField(5)
  id = _messages.IntegerField(6, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(7, default=u'compute#forwardingRule')
  loadBalancingScheme = _messages.EnumField('LoadBalancingSchemeValueValuesEnum', 8)
  name = _messages.StringField(9)
  network = _messages.StringField(10)
  portRange = _messages.StringField(11)
  ports = _messages.StringField(12, repeated=True)
  region = _messages.StringField(13)
  selfLink = _messages.StringField(14)
  subnetwork = _messages.StringField(15)
  target = _messages.StringField(16)


class ForwardingRuleAggregatedList(_messages.Message):
  """A ForwardingRuleAggregatedList object.

  Messages:
    ItemsValue: A map of scoped forwarding rule lists.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: A map of scoped forwarding rule lists.
    kind: [Output Only] Type of resource. Always
      compute#forwardingRuleAggregatedList for lists of forwarding rules.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    """A map of scoped forwarding rule lists.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: Name of the scope containing this set of
        addresses.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A ForwardingRulesScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('ForwardingRulesScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default=u'compute#forwardingRuleAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class ForwardingRuleList(_messages.Message):
  """Contains a list of ForwardingRule resources.

  Fields:
    id: [Output Only] Unique identifier for the resource. Set by the server.
    items: A list of ForwardingRule resources.
    kind: Type of resource.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('ForwardingRule', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#forwardingRuleList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class ForwardingRulesScopedList(_messages.Message):
  """A ForwardingRulesScopedList object.

  Messages:
    WarningValue: Informational warning which replaces the list of forwarding
      rules when the list is empty.

  Fields:
    forwardingRules: List of forwarding rules contained in this scope.
    warning: Informational warning which replaces the list of forwarding rules
      when the list is empty.
  """

  class WarningValue(_messages.Message):
    """Informational warning which replaces the list of forwarding rules when
    the list is empty.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      """[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 2
      INJECTED_KERNELS_DEPRECATED = 3
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 4
      NEXT_HOP_CANNOT_IP_FORWARD = 5
      NEXT_HOP_INSTANCE_NOT_FOUND = 6
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 7
      NEXT_HOP_NOT_RUNNING = 8
      NOT_CRITICAL_ERROR = 9
      NO_RESULTS_ON_PAGE = 10
      REQUIRED_TOS_AGREEMENT = 11
      RESOURCE_NOT_DELETED = 12
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 13
      UNREACHABLE = 14

    class DataValueListEntry(_messages.Message):
      """A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  forwardingRules = _messages.MessageField('ForwardingRule', 1, repeated=True)
  warning = _messages.MessageField('WarningValue', 2)


class GlobalSetLabelsRequest(_messages.Message):
  """A GlobalSetLabelsRequest object.

  Messages:
    LabelsValue: A list of labels to apply for this resource. Each label key &
      value must comply with RFC1035. Specifically, the name must be 1-63
      characters long and match the regular expression
      [a-z]([-a-z0-9]*[a-z0-9])? which means the first character must be a
      lowercase letter, and all following characters must be a dash, lowercase
      letter, or digit, except the last character, which cannot be a dash. For
      example, "webserver-frontend": "images". A label value can also be empty
      (e.g. "my-label": "").

  Fields:
    labelFingerprint: The fingerprint of the previous set of labels for this
      resource, used to detect conflicts. The fingerprint is initially
      generated by Compute Engine and changes after every request to modify or
      update labels. You must always provide an up-to-date fingerprint hash
      when updating or changing labels. Make a get() request to the resource
      to get the latest fingerprint.
    labels: A list of labels to apply for this resource. Each label key &
      value must comply with RFC1035. Specifically, the name must be 1-63
      characters long and match the regular expression
      [a-z]([-a-z0-9]*[a-z0-9])? which means the first character must be a
      lowercase letter, and all following characters must be a dash, lowercase
      letter, or digit, except the last character, which cannot be a dash. For
      example, "webserver-frontend": "images". A label value can also be empty
      (e.g. "my-label": "").
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    """A list of labels to apply for this resource. Each label key & value
    must comply with RFC1035. Specifically, the name must be 1-63 characters
    long and match the regular expression [a-z]([-a-z0-9]*[a-z0-9])? which
    means the first character must be a lowercase letter, and all following
    characters must be a dash, lowercase letter, or digit, except the last
    character, which cannot be a dash. For example, "webserver-frontend":
    "images". A label value can also be empty (e.g. "my-label": "").

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  labelFingerprint = _messages.BytesField(1)
  labels = _messages.MessageField('LabelsValue', 2)


class GuestOsFeature(_messages.Message):
  """Features supported by the guest os.

  Enums:
    TypeValueValuesEnum: The type of supported feature..

  Fields:
    type: The type of supported feature..
  """

  class TypeValueValuesEnum(_messages.Enum):
    """The type of supported feature..

    Values:
      FEATURE_TYPE_UNSPECIFIED: <no description>
      VIRTIO_SCSI_MULTIQUEUE: <no description>
    """
    FEATURE_TYPE_UNSPECIFIED = 0
    VIRTIO_SCSI_MULTIQUEUE = 1

  type = _messages.EnumField('TypeValueValuesEnum', 1)


class HTTP2HealthCheck(_messages.Message):
  """A HTTP2HealthCheck object.

  Enums:
    ProxyHeaderValueValuesEnum: Specifies the type of proxy header to append
      before sending data to the backend, either NONE or PROXY_V1. The default
      is NONE.

  Fields:
    host: The value of the host header in the HTTP/2 health check request. If
      left empty (default value), the IP on behalf of which this health check
      is performed will be used.
    port: The TCP port number for the health check request. The default value
      is 443.
    portName: Port name as defined in InstanceGroup#NamedPort#name. If both
      port and port_name are defined, port takes precedence.
    proxyHeader: Specifies the type of proxy header to append before sending
      data to the backend, either NONE or PROXY_V1. The default is NONE.
    requestPath: The request path of the HTTP/2 health check request. The
      default value is /.
  """

  class ProxyHeaderValueValuesEnum(_messages.Enum):
    """Specifies the type of proxy header to append before sending data to the
    backend, either NONE or PROXY_V1. The default is NONE.

    Values:
      NONE: <no description>
      PROXY_V1: <no description>
    """
    NONE = 0
    PROXY_V1 = 1

  host = _messages.StringField(1)
  port = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  portName = _messages.StringField(3)
  proxyHeader = _messages.EnumField('ProxyHeaderValueValuesEnum', 4)
  requestPath = _messages.StringField(5)


class HTTPHealthCheck(_messages.Message):
  """A HTTPHealthCheck object.

  Enums:
    ProxyHeaderValueValuesEnum: Specifies the type of proxy header to append
      before sending data to the backend, either NONE or PROXY_V1. The default
      is NONE.

  Fields:
    host: The value of the host header in the HTTP health check request. If
      left empty (default value), the IP on behalf of which this health check
      is performed will be used.
    port: The TCP port number for the health check request. The default value
      is 80.
    portName: Port name as defined in InstanceGroup#NamedPort#name. If both
      port and port_name are defined, port takes precedence.
    proxyHeader: Specifies the type of proxy header to append before sending
      data to the backend, either NONE or PROXY_V1. The default is NONE.
    requestPath: The request path of the HTTP health check request. The
      default value is /.
  """

  class ProxyHeaderValueValuesEnum(_messages.Enum):
    """Specifies the type of proxy header to append before sending data to the
    backend, either NONE or PROXY_V1. The default is NONE.

    Values:
      NONE: <no description>
      PROXY_V1: <no description>
    """
    NONE = 0
    PROXY_V1 = 1

  host = _messages.StringField(1)
  port = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  portName = _messages.StringField(3)
  proxyHeader = _messages.EnumField('ProxyHeaderValueValuesEnum', 4)
  requestPath = _messages.StringField(5)


class HTTPSHealthCheck(_messages.Message):
  """A HTTPSHealthCheck object.

  Enums:
    ProxyHeaderValueValuesEnum: Specifies the type of proxy header to append
      before sending data to the backend, either NONE or PROXY_V1. The default
      is NONE.

  Fields:
    host: The value of the host header in the HTTPS health check request. If
      left empty (default value), the IP on behalf of which this health check
      is performed will be used.
    port: The TCP port number for the health check request. The default value
      is 443.
    portName: Port name as defined in InstanceGroup#NamedPort#name. If both
      port and port_name are defined, port takes precedence.
    proxyHeader: Specifies the type of proxy header to append before sending
      data to the backend, either NONE or PROXY_V1. The default is NONE.
    requestPath: The request path of the HTTPS health check request. The
      default value is /.
  """

  class ProxyHeaderValueValuesEnum(_messages.Enum):
    """Specifies the type of proxy header to append before sending data to the
    backend, either NONE or PROXY_V1. The default is NONE.

    Values:
      NONE: <no description>
      PROXY_V1: <no description>
    """
    NONE = 0
    PROXY_V1 = 1

  host = _messages.StringField(1)
  port = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  portName = _messages.StringField(3)
  proxyHeader = _messages.EnumField('ProxyHeaderValueValuesEnum', 4)
  requestPath = _messages.StringField(5)


class HealthCheck(_messages.Message):
  """An HealthCheck resource. This resource defines a template for how
  individual virtual machines should be checked for health, via one of the
  supported protocols.

  Enums:
    TypeValueValuesEnum: Specifies the type of the healthCheck, either TCP,
      SSL, HTTP, HTTPS or HTTP2. If not specified, the default is TCP. Exactly
      one of the protocol-specific health check field must be specified, which
      must match type field.

  Fields:
    checkIntervalSec: How often (in seconds) to send a health check. The
      default value is 5 seconds.
    creationTimestamp: [Output Only] Creation timestamp in 3339 text format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    healthyThreshold: A so-far unhealthy instance will be marked healthy after
      this many consecutive successes. The default value is 2.
    http2HealthCheck: A HTTP2HealthCheck attribute.
    httpHealthCheck: A HTTPHealthCheck attribute.
    httpsHealthCheck: A HTTPSHealthCheck attribute.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: Type of the resource.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    selfLink: [Output Only] Server-defined URL for the resource.
    sslHealthCheck: A SSLHealthCheck attribute.
    tcpHealthCheck: A TCPHealthCheck attribute.
    timeoutSec: How long (in seconds) to wait before claiming failure. The
      default value is 5 seconds. It is invalid for timeoutSec to have greater
      value than checkIntervalSec.
    type: Specifies the type of the healthCheck, either TCP, SSL, HTTP, HTTPS
      or HTTP2. If not specified, the default is TCP. Exactly one of the
      protocol-specific health check field must be specified, which must match
      type field.
    unhealthyThreshold: A so-far healthy instance will be marked unhealthy
      after this many consecutive failures. The default value is 2.
  """

  class TypeValueValuesEnum(_messages.Enum):
    """Specifies the type of the healthCheck, either TCP, SSL, HTTP, HTTPS or
    HTTP2. If not specified, the default is TCP. Exactly one of the protocol-
    specific health check field must be specified, which must match type
    field.

    Values:
      HTTP: <no description>
      HTTP2: <no description>
      HTTPS: <no description>
      INVALID: <no description>
      SSL: <no description>
      TCP: <no description>
    """
    HTTP = 0
    HTTP2 = 1
    HTTPS = 2
    INVALID = 3
    SSL = 4
    TCP = 5

  checkIntervalSec = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  creationTimestamp = _messages.StringField(2)
  description = _messages.StringField(3)
  healthyThreshold = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  http2HealthCheck = _messages.MessageField('HTTP2HealthCheck', 5)
  httpHealthCheck = _messages.MessageField('HTTPHealthCheck', 6)
  httpsHealthCheck = _messages.MessageField('HTTPSHealthCheck', 7)
  id = _messages.IntegerField(8, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(9, default=u'compute#healthCheck')
  name = _messages.StringField(10)
  selfLink = _messages.StringField(11)
  sslHealthCheck = _messages.MessageField('SSLHealthCheck', 12)
  tcpHealthCheck = _messages.MessageField('TCPHealthCheck', 13)
  timeoutSec = _messages.IntegerField(14, variant=_messages.Variant.INT32)
  type = _messages.EnumField('TypeValueValuesEnum', 15)
  unhealthyThreshold = _messages.IntegerField(16, variant=_messages.Variant.INT32)


class HealthCheckList(_messages.Message):
  """Contains a list of HealthCheck resources.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: A list of HealthCheck resources.
    kind: Type of resource.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('HealthCheck', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#healthCheckList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class HealthCheckReference(_messages.Message):
  """A full or valid partial URL to a health check. For example, the following
  are valid URLs:   - https://www.googleapis.com/compute/beta/projects
  /project-id/global/httpHealthChecks/health-check  - projects/project-
  id/global/httpHealthChecks/health-check  - global/httpHealthChecks/health-
  check

  Fields:
    healthCheck: A string attribute.
  """

  healthCheck = _messages.StringField(1)


class HealthStatus(_messages.Message):
  """A HealthStatus object.

  Enums:
    HealthStateValueValuesEnum: Health state of the instance.

  Fields:
    healthState: Health state of the instance.
    instance: URL of the instance resource.
    ipAddress: The IP address represented by this resource.
    port: The port on the instance.
  """

  class HealthStateValueValuesEnum(_messages.Enum):
    """Health state of the instance.

    Values:
      HEALTHY: <no description>
      UNHEALTHY: <no description>
    """
    HEALTHY = 0
    UNHEALTHY = 1

  healthState = _messages.EnumField('HealthStateValueValuesEnum', 1)
  instance = _messages.StringField(2)
  ipAddress = _messages.StringField(3)
  port = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class HostRule(_messages.Message):
  """UrlMaps A host-matching rule for a URL. If matched, will use the named
  PathMatcher to select the BackendService.

  Fields:
    description: An optional description of this resource. Provide this
      property when you create the resource.
    hosts: The list of host patterns to match. They must be valid hostnames,
      except * will match any string of ([a-z0-9-.]*). In that case, * must be
      the first character and must be followed in the pattern by either - or
      ..
    pathMatcher: The name of the PathMatcher to use to match the path portion
      of the URL if the hostRule matches the URL's host portion.
  """

  description = _messages.StringField(1)
  hosts = _messages.StringField(2, repeated=True)
  pathMatcher = _messages.StringField(3)


class HttpHealthCheck(_messages.Message):
  """An HttpHealthCheck resource. This resource defines a template for how
  individual instances should be checked for health, via HTTP.

  Fields:
    checkIntervalSec: How often (in seconds) to send a health check. The
      default value is 5 seconds.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    healthyThreshold: A so-far unhealthy instance will be marked healthy after
      this many consecutive successes. The default value is 2.
    host: The value of the host header in the HTTP health check request. If
      left empty (default value), the public IP on behalf of which this health
      check is performed will be used.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] Type of the resource. Always compute#httpHealthCheck
      for HTTP health checks.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    port: The TCP port number for the HTTP health check request. The default
      value is 80.
    requestPath: The request path of the HTTP health check request. The
      default value is /.
    selfLink: [Output Only] Server-defined URL for the resource.
    timeoutSec: How long (in seconds) to wait before claiming failure. The
      default value is 5 seconds. It is invalid for timeoutSec to have greater
      value than checkIntervalSec.
    unhealthyThreshold: A so-far healthy instance will be marked unhealthy
      after this many consecutive failures. The default value is 2.
  """

  checkIntervalSec = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  creationTimestamp = _messages.StringField(2)
  description = _messages.StringField(3)
  healthyThreshold = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  host = _messages.StringField(5)
  id = _messages.IntegerField(6, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(7, default=u'compute#httpHealthCheck')
  name = _messages.StringField(8)
  port = _messages.IntegerField(9, variant=_messages.Variant.INT32)
  requestPath = _messages.StringField(10)
  selfLink = _messages.StringField(11)
  timeoutSec = _messages.IntegerField(12, variant=_messages.Variant.INT32)
  unhealthyThreshold = _messages.IntegerField(13, variant=_messages.Variant.INT32)


class HttpHealthCheckList(_messages.Message):
  """Contains a list of HttpHealthCheck resources.

  Fields:
    id: [Output Only] Unique identifier for the resource. Defined by the
      server.
    items: A list of HttpHealthCheck resources.
    kind: Type of resource.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('HttpHealthCheck', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#httpHealthCheckList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class HttpsHealthCheck(_messages.Message):
  """An HttpsHealthCheck resource. This resource defines a template for how
  individual instances should be checked for health, via HTTPS.

  Fields:
    checkIntervalSec: How often (in seconds) to send a health check. The
      default value is 5 seconds.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    healthyThreshold: A so-far unhealthy instance will be marked healthy after
      this many consecutive successes. The default value is 2.
    host: The value of the host header in the HTTPS health check request. If
      left empty (default value), the public IP on behalf of which this health
      check is performed will be used.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: Type of the resource.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    port: The TCP port number for the HTTPS health check request. The default
      value is 443.
    requestPath: The request path of the HTTPS health check request. The
      default value is "/".
    selfLink: [Output Only] Server-defined URL for the resource.
    timeoutSec: How long (in seconds) to wait before claiming failure. The
      default value is 5 seconds. It is invalid for timeoutSec to have a
      greater value than checkIntervalSec.
    unhealthyThreshold: A so-far healthy instance will be marked unhealthy
      after this many consecutive failures. The default value is 2.
  """

  checkIntervalSec = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  creationTimestamp = _messages.StringField(2)
  description = _messages.StringField(3)
  healthyThreshold = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  host = _messages.StringField(5)
  id = _messages.IntegerField(6, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(7, default=u'compute#httpsHealthCheck')
  name = _messages.StringField(8)
  port = _messages.IntegerField(9, variant=_messages.Variant.INT32)
  requestPath = _messages.StringField(10)
  selfLink = _messages.StringField(11)
  timeoutSec = _messages.IntegerField(12, variant=_messages.Variant.INT32)
  unhealthyThreshold = _messages.IntegerField(13, variant=_messages.Variant.INT32)


class HttpsHealthCheckList(_messages.Message):
  """Contains a list of HttpsHealthCheck resources.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of HttpsHealthCheck resources.
    kind: Type of resource.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('HttpsHealthCheck', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#httpsHealthCheckList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class Image(_messages.Message):
  """An Image resource.

  Enums:
    SourceTypeValueValuesEnum: The type of the image used to create this disk.
      The default and only value is RAW
    StatusValueValuesEnum: [Output Only] The status of the image. An image can
      be used to create other resources, such as instances, only after the
      image has been successfully created and the status is set to READY.
      Possible values are FAILED, PENDING, or READY.

  Messages:
    LabelsValue: Labels to apply to this image. These can be later modified by
      the setLabels method. Each label key/value pair must comply with
      RFC1035. Label values may be empty.
    RawDiskValue: The parameters of the raw disk image.

  Fields:
    archiveSizeBytes: Size of the image tar.gz archive stored in Google Cloud
      Storage (in bytes).
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    deprecated: The deprecation status associated with this image.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    diskSizeGb: Size of the image when restored onto a persistent disk (in
      GB).
    family: The name of the image family to which this image belongs. You can
      create disks by specifying an image family instead of a specific image
      name. The image family always returns its latest image that is not
      deprecated. The name of the image family must comply with RFC1035.
    guestOsFeatures: Features of the guest os, valid for bootable images only.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    imageEncryptionKey: Encrypts the image using a customer-supplied
      encryption key.  After you encrypt an image with a customer-supplied
      key, you must provide the same key if you use the image later (e.g. to
      create a disk from the image).  Customer-supplied encryption keys do not
      protect access to metadata of the disk.  If you do not provide an
      encryption key when creating the image, then the disk will be encrypted
      using an automatically generated key and you do not need to provide a
      key to use the image later.
    kind: [Output Only] Type of the resource. Always compute#image for images.
    labelFingerprint: A fingerprint for the labels being applied to this
      image, which is essentially a hash of the labels used for optimistic
      locking. The fingerprint is initially generated by Compute Engine and
      changes after every request to modify or update labels. You must always
      provide an up-to-date fingerprint hash in order to update or change
      labels.  To see the latest fingerprint, make a get() request to retrieve
      an image.
    labels: Labels to apply to this image. These can be later modified by the
      setLabels method. Each label key/value pair must comply with RFC1035.
      Label values may be empty.
    licenses: Any applicable license URI.
    name: Name of the resource; provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    rawDisk: The parameters of the raw disk image.
    selfLink: [Output Only] Server-defined URL for the resource.
    sourceDisk: URL of the The source disk used to create this image. This can
      be a full or valid partial URL. You must provide either this property or
      the rawDisk.source property but not both to create an image. For
      example, the following are valid values:   - https://www.googleapis.com/
      compute/v1/projects/project/zones/zone/disk/disk  -
      projects/project/zones/zone/disk/disk  - zones/zone/disks/disk
    sourceDiskEncryptionKey: The customer-supplied encryption key of the
      source disk. Required if the source disk is protected by a customer-
      supplied encryption key.
    sourceDiskId: The ID value of the disk used to create this image. This
      value may be used to determine whether the image was taken from the
      current or a previous instance of a given disk name.
    sourceType: The type of the image used to create this disk. The default
      and only value is RAW
    status: [Output Only] The status of the image. An image can be used to
      create other resources, such as instances, only after the image has been
      successfully created and the status is set to READY. Possible values are
      FAILED, PENDING, or READY.
  """

  class SourceTypeValueValuesEnum(_messages.Enum):
    """The type of the image used to create this disk. The default and only
    value is RAW

    Values:
      RAW: <no description>
    """
    RAW = 0

  class StatusValueValuesEnum(_messages.Enum):
    """[Output Only] The status of the image. An image can be used to create
    other resources, such as instances, only after the image has been
    successfully created and the status is set to READY. Possible values are
    FAILED, PENDING, or READY.

    Values:
      FAILED: <no description>
      PENDING: <no description>
      READY: <no description>
    """
    FAILED = 0
    PENDING = 1
    READY = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    """Labels to apply to this image. These can be later modified by the
    setLabels method. Each label key/value pair must comply with RFC1035.
    Label values may be empty.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  class RawDiskValue(_messages.Message):
    """The parameters of the raw disk image.

    Enums:
      ContainerTypeValueValuesEnum: The format used to encode and transmit the
        block device, which should be TAR. This is just a container and
        transmission format and not a runtime format. Provided by the client
        when the disk image is created.

    Fields:
      containerType: The format used to encode and transmit the block device,
        which should be TAR. This is just a container and transmission format
        and not a runtime format. Provided by the client when the disk image
        is created.
      sha1Checksum: An optional SHA1 checksum of the disk image before
        unpackaging; provided by the client when the disk image is created.
      source: The full Google Cloud Storage URL where the disk image is
        stored. You must provide either this property or the sourceDisk
        property but not both.
    """

    class ContainerTypeValueValuesEnum(_messages.Enum):
      """The format used to encode and transmit the block device, which should
      be TAR. This is just a container and transmission format and not a
      runtime format. Provided by the client when the disk image is created.

      Values:
        TAR: <no description>
      """
      TAR = 0

    containerType = _messages.EnumField('ContainerTypeValueValuesEnum', 1)
    sha1Checksum = _messages.StringField(2)
    source = _messages.StringField(3)

  archiveSizeBytes = _messages.IntegerField(1)
  creationTimestamp = _messages.StringField(2)
  deprecated = _messages.MessageField('DeprecationStatus', 3)
  description = _messages.StringField(4)
  diskSizeGb = _messages.IntegerField(5)
  family = _messages.StringField(6)
  guestOsFeatures = _messages.MessageField('GuestOsFeature', 7, repeated=True)
  id = _messages.IntegerField(8, variant=_messages.Variant.UINT64)
  imageEncryptionKey = _messages.MessageField('CustomerEncryptionKey', 9)
  kind = _messages.StringField(10, default=u'compute#image')
  labelFingerprint = _messages.BytesField(11)
  labels = _messages.MessageField('LabelsValue', 12)
  licenses = _messages.StringField(13, repeated=True)
  name = _messages.StringField(14)
  rawDisk = _messages.MessageField('RawDiskValue', 15)
  selfLink = _messages.StringField(16)
  sourceDisk = _messages.StringField(17)
  sourceDiskEncryptionKey = _messages.MessageField('CustomerEncryptionKey', 18)
  sourceDiskId = _messages.StringField(19)
  sourceType = _messages.EnumField('SourceTypeValueValuesEnum', 20, default=u'RAW')
  status = _messages.EnumField('StatusValueValuesEnum', 21)


class ImageList(_messages.Message):
  """Contains a list of images.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: [Output Only] A list of Image resources.
    kind: Type of resource.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('Image', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#imageList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class Instance(_messages.Message):
  """An Instance resource.

  Enums:
    StatusValueValuesEnum: [Output Only] The status of the instance. One of
      the following values: PROVISIONING, STAGING, RUNNING, STOPPING,
      SUSPENDED, SUSPENDING, and TERMINATED.

  Messages:
    LabelsValue: Labels to apply to this instance. These can be later modified
      by the setLabels method. Each label key/value pair must comply with
      RFC1035. Label values may be empty.

  Fields:
    canIpForward: Allows this instance to send and receive packets with non-
      matching destination or source IPs. This is required if you plan to use
      this instance to forward routes. For more information, see Enabling IP
      Forwarding.
    cpuPlatform: [Output Only] The CPU platform used by this instance.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    disks: Array of disks associated with this instance. Persistent disks must
      be created before you can assign them.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    instanceEncryptionKey: Encrypts or decrypts data for an instance with a
      customer-supplied encryption key.  If you are creating a new instance,
      this field encrypts the local SSD and in-memory contents of the instance
      using a key that you provide.  If you are restarting an instance
      protected with a customer-supplied encryption key, you must provide the
      correct key in order to successfully restart the instance.  If you do
      not provide an encryption key when creating the instance, then the local
      SSD and in-memory contents will be encrypted using an automatically
      generated key and you do not need to provide a key to start the instance
      later.  Instance templates do not store customer-supplied encryption
      keys, so you cannot use your own keys to encrypt local SSDs and in-
      memory content in a managed instance group.
    kind: [Output Only] Type of the resource. Always compute#instance for
      instances.
    labelFingerprint: A fingerprint for this request, which is essentially a
      hash of the metadata's contents and used for optimistic locking. The
      fingerprint is initially generated by Compute Engine and changes after
      every request to modify or update metadata. You must always provide an
      up-to-date fingerprint hash in order to update or change metadata.  To
      see the latest fingerprint, make get() request to the instance.
    labels: Labels to apply to this instance. These can be later modified by
      the setLabels method. Each label key/value pair must comply with
      RFC1035. Label values may be empty.
    machineType: Full or partial URL of the machine type resource to use for
      this instance, in the format: zones/zone/machineTypes/machine-type. This
      is provided by the client when the instance is created. For example, the
      following is a valid partial url to a predefined machine type:  zones
      /us-central1-f/machineTypes/n1-standard-1   To create a custom machine
      type, provide a URL to a machine type in the following format, where
      CPUS is 1 or an even number up to 32 (2, 4, 6, ... 24, etc), and MEMORY
      is the total memory for this instance. Memory must be a multiple of 256
      MB and must be supplied in MB (e.g. 5 GB of memory is 5120 MB):
      zones/zone/machineTypes/custom-CPUS-MEMORY   For example: zones/us-
      central1-f/machineTypes/custom-4-5120   For a full list of restrictions,
      read the Specifications for custom machine types.
    metadata: The metadata key/value pairs assigned to this instance. This
      includes custom metadata and predefined keys.
    name: The name of the resource, provided by the client when initially
      creating the resource. The resource name must be 1-63 characters long,
      and comply with RFC1035. Specifically, the name must be 1-63 characters
      long and match the regular expression [a-z]([-a-z0-9]*[a-z0-9])? which
      means the first character must be a lowercase letter, and all following
      characters must be a dash, lowercase letter, or digit, except the last
      character, which cannot be a dash.
    networkInterfaces: An array of configurations for this interface. This
      specifies how this interface is configured to interact with other
      network services, such as connecting to the internet. Only one interface
      is supported per instance.
    scheduling: Scheduling options for this instance.
    selfLink: [Output Only] Server-defined URL for this resource.
    serviceAccounts: A list of service accounts, with their specified scopes,
      authorized for this instance. Service accounts generate access tokens
      that can be accessed through the metadata server and used to
      authenticate applications on the instance. See Service Accounts for more
      information.
    status: [Output Only] The status of the instance. One of the following
      values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDED, SUSPENDING,
      and TERMINATED.
    statusMessage: [Output Only] An optional, human-readable explanation of
      the status.
    tags: A list of tags to apply to this instance. Tags are used to identify
      valid sources or targets for network firewalls and are specified by the
      client during instance creation. The tags can be later modified by the
      setTags method. Each tag within the list must comply with RFC1035.
    zone: [Output Only] URL of the zone where the instance resides.
  """

  class StatusValueValuesEnum(_messages.Enum):
    """[Output Only] The status of the instance. One of the following values:
    PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDED, SUSPENDING, and
    TERMINATED.

    Values:
      PROVISIONING: <no description>
      RUNNING: <no description>
      STAGING: <no description>
      STOPPED: <no description>
      STOPPING: <no description>
      SUSPENDED: <no description>
      SUSPENDING: <no description>
      TERMINATED: <no description>
    """
    PROVISIONING = 0
    RUNNING = 1
    STAGING = 2
    STOPPED = 3
    STOPPING = 4
    SUSPENDED = 5
    SUSPENDING = 6
    TERMINATED = 7

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    """Labels to apply to this instance. These can be later modified by the
    setLabels method. Each label key/value pair must comply with RFC1035.
    Label values may be empty.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  canIpForward = _messages.BooleanField(1)
  cpuPlatform = _messages.StringField(2)
  creationTimestamp = _messages.StringField(3)
  description = _messages.StringField(4)
  disks = _messages.MessageField('AttachedDisk', 5, repeated=True)
  id = _messages.IntegerField(6, variant=_messages.Variant.UINT64)
  instanceEncryptionKey = _messages.MessageField('CustomerEncryptionKey', 7)
  kind = _messages.StringField(8, default=u'compute#instance')
  labelFingerprint = _messages.BytesField(9)
  labels = _messages.MessageField('LabelsValue', 10)
  machineType = _messages.StringField(11)
  metadata = _messages.MessageField('Metadata', 12)
  name = _messages.StringField(13)
  networkInterfaces = _messages.MessageField('NetworkInterface', 14, repeated=True)
  scheduling = _messages.MessageField('Scheduling', 15)
  selfLink = _messages.StringField(16)
  serviceAccounts = _messages.MessageField('ServiceAccount', 17, repeated=True)
  status = _messages.EnumField('StatusValueValuesEnum', 18)
  statusMessage = _messages.StringField(19)
  tags = _messages.MessageField('Tags', 20)
  zone = _messages.StringField(21)


class InstanceAggregatedList(_messages.Message):
  """A InstanceAggregatedList object.

  Messages:
    ItemsValue: [Output Only] A map of scoped instance lists.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: [Output Only] A map of scoped instance lists.
    kind: [Output Only] Type of resource. Always
      compute#instanceAggregatedList for aggregated lists of Instance
      resources.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    """[Output Only] A map of scoped instance lists.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: [Output Only] Name of the scope containing this
        set of instances.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A InstancesScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('InstancesScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default=u'compute#instanceAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class InstanceGroup(_messages.Message):
  """A InstanceGroup object.

  Fields:
    creationTimestamp: [Output Only] The creation timestamp for this instance
      group in RFC3339 text format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    fingerprint: [Output Only] The fingerprint of the named ports. The system
      uses this fingerprint to detect conflicts when multiple users change the
      named ports concurrently.
    id: [Output Only] A unique identifier for this resource type. The server
      generates this identifier.
    kind: [Output Only] The resource type, which is always
      compute#instanceGroup for instance groups.
    name: The name of the instance group. The name must be 1-63 characters
      long, and comply with RFC1035.
    namedPorts: Assigns a name to a port number. For example: {name: "http",
      port: 80}  This allows the system to reference ports by the assigned
      name instead of a port number. Named ports can also contain multiple
      ports. For example: [{name: "http", port: 80},{name: "http", port:
      8080}]   Named ports apply to all instances in this instance group.
    network: The URL of the network to which all instances in the instance
      group belong.
    region: The URL of the region where the instance group is located.
    selfLink: [Output Only] The URL for this instance group. The server
      generates this URL.
    size: [Output Only] The total number of instances in the instance group.
    subnetwork: The URL of the subnetwork to which all instances in the
      instance group belong.
    zone: [Output Only] The URL of the zone where the instance group is
      located.
  """

  creationTimestamp = _messages.StringField(1)
  description = _messages.StringField(2)
  fingerprint = _messages.BytesField(3)
  id = _messages.IntegerField(4, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(5, default=u'compute#instanceGroup')
  name = _messages.StringField(6)
  namedPorts = _messages.MessageField('NamedPort', 7, repeated=True)
  network = _messages.StringField(8)
  region = _messages.StringField(9)
  selfLink = _messages.StringField(10)
  size = _messages.IntegerField(11, variant=_messages.Variant.INT32)
  subnetwork = _messages.StringField(12)
  zone = _messages.StringField(13)


class InstanceGroupAggregatedList(_messages.Message):
  """A InstanceGroupAggregatedList object.

  Messages:
    ItemsValue: A map of scoped instance group lists.

  Fields:
    id: [Output Only] A unique identifier for this aggregated list of instance
      groups. The server generates this identifier.
    items: A map of scoped instance group lists.
    kind: [Output Only] The resource type, which is always
      compute#instanceGroupAggregatedList for aggregated lists of instance
      groups.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] The URL for this resource type. The server
      generates this URL.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    """A map of scoped instance group lists.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: The name of the scope that contains this set of
        instance groups.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A InstanceGroupsScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('InstanceGroupsScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default=u'compute#instanceGroupAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class InstanceGroupList(_messages.Message):
  """A list of InstanceGroup resources.

  Fields:
    id: [Output Only] A unique identifier for this list of instance groups.
      The server generates this identifier.
    items: A list of instance groups.
    kind: [Output Only] The resource type, which is always
      compute#instanceGroupList for instance group lists.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] The URL for this resource type. The server
      generates this URL.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('InstanceGroup', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#instanceGroupList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class InstanceGroupManager(_messages.Message):
  """An Instance Group Manager resource.

  Enums:
    FailoverActionValueValuesEnum: The action to perform in case of zone
      failure (set only for Regional instance group managers).

  Fields:
    autoHealingPolicies: The autohealing policy for this managed instance
      group. You can specify only one value.
    baseInstanceName: The base instance name to use for instances in this
      group. The value must be 1-58 characters long. Instances are named by
      appending a hyphen and a random four-character string to the base
      instance name. The base instance name must comply with RFC1035.
    creationTimestamp: [Output Only] The creation timestamp for this managed
      instance group in RFC3339 text format.
    currentActions: [Output Only] The list of instance actions and the number
      of instances in this managed instance group that are scheduled for each
      of those actions.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    failoverAction: The action to perform in case of zone failure (set only
      for Regional instance group managers).
    fingerprint: [Output Only] The fingerprint of the resource data. You can
      use this optional field for optimistic locking when you update the
      resource.
    id: [Output Only] A unique identifier for this resource type. The server
      generates this identifier.
    instanceGroup: [Output Only] The URL of the Instance Group resource.
    instanceTemplate: The URL of the instance template that is specified for
      this managed instance group. The group uses this template to create all
      new instances in the managed instance group.
    kind: [Output Only] The resource type, which is always
      compute#instanceGroupManager for managed instance groups.
    name: The name of the managed instance group. The name must be 1-63
      characters long, and comply with RFC1035.
    namedPorts: Named ports configured for the Instance Groups complementary
      to this Instance Group Manager.
    pendingActions: [Output Only] The list of instance actions and the number
      of instances in this managed instance group that are pending for each of
      those actions.
    region: [Output Only] URL of the region where the managed instance group
      resides.
    selfLink: [Output Only] The URL for this managed instance group. The
      server defines this URL.
    targetPools: The URLs for all TargetPool resources to which instances in
      the instanceGroup field are added. The target pools automatically apply
      to all of the instances in the managed instance group.
    targetSize: The target number of running instances for this managed
      instance group. Deleting or abandoning instances reduces this number.
      Resizing the group changes this number.
    updatePolicy: The update policy for this managed instance group.
    versions: Versions supported by this IGM. User should set this field if
      they need fine-grained control over how many instances in each version
      are run by this IGM. Versions are keyed by instanceTemplate. Every
      instanceTemplate can appear at most once. This field overrides
      instanceTemplate field. If both instanceTemplate and versions are set,
      the user receives a warning. "instanceTemplate: X" is semantically
      equivalent to "versions [ { instanceTemplate: X } ]". Exactly one
      version must have targetSize field left unset. Size of such a version
      will be calculated automatically.
    zone: The name of the zone where the managed instance group is located.
  """

  class FailoverActionValueValuesEnum(_messages.Enum):
    """The action to perform in case of zone failure (set only for Regional
    instance group managers).

    Values:
      NO_FAILOVER: <no description>
      UNKNOWN: <no description>
    """
    NO_FAILOVER = 0
    UNKNOWN = 1

  autoHealingPolicies = _messages.MessageField('InstanceGroupManagerAutoHealingPolicy', 1, repeated=True)
  baseInstanceName = _messages.StringField(2)
  creationTimestamp = _messages.StringField(3)
  currentActions = _messages.MessageField('InstanceGroupManagerActionsSummary', 4)
  description = _messages.StringField(5)
  failoverAction = _messages.EnumField('FailoverActionValueValuesEnum', 6)
  fingerprint = _messages.BytesField(7)
  id = _messages.IntegerField(8, variant=_messages.Variant.UINT64)
  instanceGroup = _messages.StringField(9)
  instanceTemplate = _messages.StringField(10)
  kind = _messages.StringField(11, default=u'compute#instanceGroupManager')
  name = _messages.StringField(12)
  namedPorts = _messages.MessageField('NamedPort', 13, repeated=True)
  pendingActions = _messages.MessageField('InstanceGroupManagerPendingActionsSummary', 14)
  region = _messages.StringField(15)
  selfLink = _messages.StringField(16)
  targetPools = _messages.StringField(17, repeated=True)
  targetSize = _messages.IntegerField(18, variant=_messages.Variant.INT32)
  updatePolicy = _messages.MessageField('InstanceGroupManagerUpdatePolicy', 19)
  versions = _messages.MessageField('InstanceGroupManagerVersion', 20, repeated=True)
  zone = _messages.StringField(21)


class InstanceGroupManagerActionsSummary(_messages.Message):
  """A InstanceGroupManagerActionsSummary object.

  Fields:
    abandoning: [Output Only] The total number of instances in the managed
      instance group that are scheduled to be abandoned. Abandoning an
      instance removes it from the managed instance group without deleting it.
    creating: [Output Only] The number of instances in the managed instance
      group that are scheduled to be created or are currently being created.
      If the group fails to create any of these instances, it tries again
      until it creates the instance successfully.  If you have disabled
      creation retries, this field will not be populated; instead, the
      creatingWithoutRetries field will be populated.
    creatingWithoutRetries: [Output Only] The number of instances that the
      managed instance group will attempt to create. The group attempts to
      create each instance only once. If the group fails to create any of
      these instances, it decreases the group's target_size value accordingly.
    deleting: [Output Only] The number of instances in the managed instance
      group that are scheduled to be deleted or are currently being deleted.
    none: [Output Only] The number of instances in the managed instance group
      that are running and have no scheduled actions.
    recreating: [Output Only] The number of instances in the managed instance
      group that are scheduled to be recreated or are currently being being
      recreated. Recreating an instance deletes the existing root persistent
      disk and creates a new disk from the image that is defined in the
      instance template.
    refreshing: [Output Only] The number of instances in the managed instance
      group that are being reconfigured with properties that do not require a
      restart or a recreate action. For example, setting or removing target
      pools for the instance.
    restarting: [Output Only] The number of instances in the managed instance
      group that are scheduled to be restarted or are currently being
      restarted.
  """

  abandoning = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  creating = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  creatingWithoutRetries = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  deleting = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  none = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  recreating = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  refreshing = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  restarting = _messages.IntegerField(8, variant=_messages.Variant.INT32)


class InstanceGroupManagerAggregatedList(_messages.Message):
  """A InstanceGroupManagerAggregatedList object.

  Messages:
    ItemsValue: [Output Only] A map of filtered managed instance group lists.

  Fields:
    id: [Output Only] A unique identifier for this aggregated list of managed
      instance groups. The server generates this identifier.
    items: [Output Only] A map of filtered managed instance group lists.
    kind: [Output Only] The resource type, which is always
      compute#instanceGroupManagerAggregatedList for an aggregated list of
      managed instance groups.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] The URL for this resource type. The server
      generates this URL.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    """[Output Only] A map of filtered managed instance group lists.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: [Output Only] The name of the scope that contains
        this set of managed instance groups.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A InstanceGroupManagersScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('InstanceGroupManagersScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default=u'compute#instanceGroupManagerAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class InstanceGroupManagerAutoHealingPolicy(_messages.Message):
  """A InstanceGroupManagerAutoHealingPolicy object.

  Fields:
    healthCheck: The URL for the HealthCheck that signals autohealing.
    initialDelaySec: The number of seconds that the managed instance group
      waits before it applies autohealing policies to new instances or
      recently recreated instances. This initial delay allows instances to
      initialize and run their startup scripts before the instance group
      determines that they are UNHEALTHY. This prevents the managed instance
      group from recreating its instances prematurely.
  """

  healthCheck = _messages.StringField(1)
  initialDelaySec = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class InstanceGroupManagerList(_messages.Message):
  """[Output Only] A list of managed instance groups.

  Fields:
    id: [Output Only] A unique identifier for this resource type. The server
      generates this identifier.
    items: [Output Only] A list of managed instance groups.
    kind: [Output Only] The resource type, which is always
      compute#instanceGroupManagerList for a list of managed instance groups.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] The URL for this resource type. The server
      generates this URL.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('InstanceGroupManager', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#instanceGroupManagerList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class InstanceGroupManagerPendingActionsSummary(_messages.Message):
  """A InstanceGroupManagerPendingActionsSummary object.

  Fields:
    creating: [Output Only] The number of instances in the managed instance
      group that are pending to be created.
    deleting: [Output Only] The number of instances in the managed instance
      group that are pending to be deleted.
    recreating: [Output Only] The number of instances in the managed instance
      group that are pending to be recreated.
    restarting: [Output Only] The number of instances in the managed instance
      group that are pending to be restarted.
  """

  creating = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  deleting = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  recreating = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  restarting = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class InstanceGroupManagerUpdatePolicy(_messages.Message):
  """A InstanceGroupManagerUpdatePolicy object.

  Enums:
    MinimalActionValueValuesEnum: Minimal action to be taken on an instance.
      The order of action types is: RESTART < REPLACE.
    TypeValueValuesEnum:

  Fields:
    maxSurge: Maximum number of instances that can be created above the
      InstanceGroupManager.targetSize during the update process. By default, a
      fixed value of 1 is used. Using maxSurge > 0 will cause instance names
      to change during the update process. At least one of { maxSurge,
      maxUnavailable } must be greater than 0.
    maxUnavailable: Maximum number of instances that can be unavailable during
      the update process. The instance is considered available if all of the
      following conditions are satisfied: 1. instance's status is RUNNING 2.
      instance's liveness health check result was observed to be HEALTHY at
      least once By default, a fixed value of 1 is used. At least one of {
      maxSurge, maxUnavailable } must be greater than 0.
    minReadySec: Minimum number of seconds to wait for after a newly created
      instance becomes available.
    minimalAction: Minimal action to be taken on an instance. The order of
      action types is: RESTART < REPLACE.
    type: A TypeValueValuesEnum attribute.
  """

  class MinimalActionValueValuesEnum(_messages.Enum):
    """Minimal action to be taken on an instance. The order of action types
    is: RESTART < REPLACE.

    Values:
      REPLACE: <no description>
      RESTART: <no description>
    """
    REPLACE = 0
    RESTART = 1

  class TypeValueValuesEnum(_messages.Enum):
    """TypeValueValuesEnum enum type.

    Values:
      OPPORTUNISTIC: <no description>
      PROACTIVE: <no description>
    """
    OPPORTUNISTIC = 0
    PROACTIVE = 1

  maxSurge = _messages.MessageField('FixedOrPercent', 1)
  maxUnavailable = _messages.MessageField('FixedOrPercent', 2)
  minReadySec = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  minimalAction = _messages.EnumField('MinimalActionValueValuesEnum', 4)
  type = _messages.EnumField('TypeValueValuesEnum', 5)


class InstanceGroupManagerVersion(_messages.Message):
  """A InstanceGroupManagerVersion object.

  Fields:
    instanceTemplate: A string attribute.
    tag: Tag describing the version. Used to trigger rollout of a target
      version even if instance_template remains unchanged.
    targetSize: Intended number of instances that are created from
      instanceTemplate. The final number of instances created from
      instanceTemplate will be equal to: * if expressed as fixed number:
      min(targetSize.fixed, instanceGroupManager.targetSize), * if expressed
      as percent: ceiling(targetSize.percent *
      InstanceGroupManager.targetSize). If unset, this version will handle all
      the remaining instances.
  """

  instanceTemplate = _messages.StringField(1)
  tag = _messages.StringField(2)
  targetSize = _messages.MessageField('FixedOrPercent', 3)


class InstanceGroupManagersAbandonInstancesRequest(_messages.Message):
  """A InstanceGroupManagersAbandonInstancesRequest object.

  Fields:
    instances: The URL for one or more instances to abandon from the managed
      instance group.
  """

  instances = _messages.StringField(1, repeated=True)


class InstanceGroupManagersDeleteInstancesRequest(_messages.Message):
  """A InstanceGroupManagersDeleteInstancesRequest object.

  Fields:
    instances: The list of instances to delete from this managed instance
      group. Specify one or more instance URLs.
  """

  instances = _messages.StringField(1, repeated=True)


class InstanceGroupManagersListManagedInstancesResponse(_messages.Message):
  """A InstanceGroupManagersListManagedInstancesResponse object.

  Fields:
    managedInstances: [Output Only] The list of instances in the managed
      instance group.
  """

  managedInstances = _messages.MessageField('ManagedInstance', 1, repeated=True)


class InstanceGroupManagersRecreateInstancesRequest(_messages.Message):
  """A InstanceGroupManagersRecreateInstancesRequest object.

  Fields:
    instances: The URL for one or more instances to recreate.
  """

  instances = _messages.StringField(1, repeated=True)


class InstanceGroupManagersResizeAdvancedRequest(_messages.Message):
  """A InstanceGroupManagersResizeAdvancedRequest object.

  Fields:
    noCreationRetries: If this flag is true, the managed instance group
      attempts to create all instances initiated by this resize request only
      once. If there is an error during creation, the managed instance group
      does not retry create this instance, and we will decrease the targetSize
      of the request instead. If the flag is false, the group attemps to
      recreate each instance continuously until it succeeds.  This flag
      matters only in the first attempt of creation of an instance. After an
      instance is successfully created while this flag is enabled, the
      instance behaves the same way as all the other instances created with a
      regular resize request. In particular, if a running instance dies
      unexpectedly at a later time and needs to be recreated, this mode does
      not affect the recreation behavior in that scenario.  This flag is
      applicable only to the current resize request. It does not influence
      other resize requests in any way.  You can see which instances is being
      creating in which mode by calling the get or listManagedInstances API.
    targetSize: The number of running instances that the managed instance
      group should maintain at any given time. The group automatically adds or
      removes instances to maintain the number of instances specified by this
      parameter.
  """

  noCreationRetries = _messages.BooleanField(1)
  targetSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class InstanceGroupManagersScopedList(_messages.Message):
  """A InstanceGroupManagersScopedList object.

  Messages:
    WarningValue: [Output Only] The warning that replaces the list of managed
      instance groups when the list is empty.

  Fields:
    instanceGroupManagers: [Output Only] The list of managed instance groups
      that are contained in the specified project and zone.
    warning: [Output Only] The warning that replaces the list of managed
      instance groups when the list is empty.
  """

  class WarningValue(_messages.Message):
    """[Output Only] The warning that replaces the list of managed instance
    groups when the list is empty.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      """[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 2
      INJECTED_KERNELS_DEPRECATED = 3
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 4
      NEXT_HOP_CANNOT_IP_FORWARD = 5
      NEXT_HOP_INSTANCE_NOT_FOUND = 6
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 7
      NEXT_HOP_NOT_RUNNING = 8
      NOT_CRITICAL_ERROR = 9
      NO_RESULTS_ON_PAGE = 10
      REQUIRED_TOS_AGREEMENT = 11
      RESOURCE_NOT_DELETED = 12
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 13
      UNREACHABLE = 14

    class DataValueListEntry(_messages.Message):
      """A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  instanceGroupManagers = _messages.MessageField('InstanceGroupManager', 1, repeated=True)
  warning = _messages.MessageField('WarningValue', 2)


class InstanceGroupManagersSetAutoHealingRequest(_messages.Message):
  """A InstanceGroupManagersSetAutoHealingRequest object.

  Fields:
    autoHealingPolicies: A InstanceGroupManagerAutoHealingPolicy attribute.
  """

  autoHealingPolicies = _messages.MessageField('InstanceGroupManagerAutoHealingPolicy', 1, repeated=True)


class InstanceGroupManagersSetInstanceTemplateRequest(_messages.Message):
  """A InstanceGroupManagersSetInstanceTemplateRequest object.

  Fields:
    instanceTemplate: The URL of the instance template that is specified for
      this managed instance group. The group uses this template to create all
      new instances in the managed instance group.
  """

  instanceTemplate = _messages.StringField(1)


class InstanceGroupManagersSetTargetPoolsRequest(_messages.Message):
  """A InstanceGroupManagersSetTargetPoolsRequest object.

  Fields:
    fingerprint: The fingerprint of the target pools information. Use this
      optional property to prevent conflicts when multiple users change the
      target pools settings concurrently. Obtain the fingerprint with the
      instanceGroupManagers.get method. Then, include the fingerprint in your
      request to ensure that you do not overwrite changes that were applied
      from another concurrent request.
    targetPools: The list of target pool URLs that instances in this managed
      instance group belong to. The managed instance group applies these
      target pools to all of the instances in the group. Existing instances
      and new instances in the group all receive these target pool settings.
  """

  fingerprint = _messages.BytesField(1)
  targetPools = _messages.StringField(2, repeated=True)


class InstanceGroupsAddInstancesRequest(_messages.Message):
  """A InstanceGroupsAddInstancesRequest object.

  Fields:
    instances: The list of instances to add to the instance group.
  """

  instances = _messages.MessageField('InstanceReference', 1, repeated=True)


class InstanceGroupsListInstances(_messages.Message):
  """A InstanceGroupsListInstances object.

  Fields:
    id: [Output Only] A unique identifier for this list of instances in the
      specified instance group. The server generates this identifier.
    items: [Output Only] A list of instances and any named ports that are
      assigned to those instances.
    kind: [Output Only] The resource type, which is always
      compute#instanceGroupsListInstances for the list of instances in the
      specified instance group.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] The URL for this list of instances in the
      specified instance groups. The server generates this URL.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('InstanceWithNamedPorts', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#instanceGroupsListInstances')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class InstanceGroupsListInstancesRequest(_messages.Message):
  """A InstanceGroupsListInstancesRequest object.

  Enums:
    InstanceStateValueValuesEnum: A filter for the state of the instances in
      the instance group. Valid options are ALL or RUNNING. If you do not
      specify this parameter the list includes all instances regardless of
      their state.

  Fields:
    instanceState: A filter for the state of the instances in the instance
      group. Valid options are ALL or RUNNING. If you do not specify this
      parameter the list includes all instances regardless of their state.
  """

  class InstanceStateValueValuesEnum(_messages.Enum):
    """A filter for the state of the instances in the instance group. Valid
    options are ALL or RUNNING. If you do not specify this parameter the list
    includes all instances regardless of their state.

    Values:
      ALL: <no description>
      RUNNING: <no description>
    """
    ALL = 0
    RUNNING = 1

  instanceState = _messages.EnumField('InstanceStateValueValuesEnum', 1)


class InstanceGroupsRemoveInstancesRequest(_messages.Message):
  """A InstanceGroupsRemoveInstancesRequest object.

  Fields:
    instances: The list of instances to remove from the instance group.
  """

  instances = _messages.MessageField('InstanceReference', 1, repeated=True)


class InstanceGroupsScopedList(_messages.Message):
  """A InstanceGroupsScopedList object.

  Messages:
    WarningValue: [Output Only] An informational warning that replaces the
      list of instance groups when the list is empty.

  Fields:
    instanceGroups: [Output Only] The list of instance groups that are
      contained in this scope.
    warning: [Output Only] An informational warning that replaces the list of
      instance groups when the list is empty.
  """

  class WarningValue(_messages.Message):
    """[Output Only] An informational warning that replaces the list of
    instance groups when the list is empty.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      """[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 2
      INJECTED_KERNELS_DEPRECATED = 3
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 4
      NEXT_HOP_CANNOT_IP_FORWARD = 5
      NEXT_HOP_INSTANCE_NOT_FOUND = 6
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 7
      NEXT_HOP_NOT_RUNNING = 8
      NOT_CRITICAL_ERROR = 9
      NO_RESULTS_ON_PAGE = 10
      REQUIRED_TOS_AGREEMENT = 11
      RESOURCE_NOT_DELETED = 12
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 13
      UNREACHABLE = 14

    class DataValueListEntry(_messages.Message):
      """A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  instanceGroups = _messages.MessageField('InstanceGroup', 1, repeated=True)
  warning = _messages.MessageField('WarningValue', 2)


class InstanceGroupsSetNamedPortsRequest(_messages.Message):
  """A InstanceGroupsSetNamedPortsRequest object.

  Fields:
    fingerprint: The fingerprint of the named ports information for this
      instance group. Use this optional property to prevent conflicts when
      multiple users change the named ports settings concurrently. Obtain the
      fingerprint with the instanceGroups.get method. Then, include the
      fingerprint in your request to ensure that you do not overwrite changes
      that were applied from another concurrent request.
    namedPorts: The list of named ports to set for this instance group.
  """

  fingerprint = _messages.BytesField(1)
  namedPorts = _messages.MessageField('NamedPort', 2, repeated=True)


class InstanceList(_messages.Message):
  """Contains a list of instances.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: [Output Only] A list of instances.
    kind: [Output Only] Type of resource. Always compute#instanceList for
      lists of Instance resources.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('Instance', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#instanceList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class InstanceMoveRequest(_messages.Message):
  """A InstanceMoveRequest object.

  Fields:
    destinationZone: The URL of the destination zone to move the instance.
      This can be a full or partial URL. For example, the following are all
      valid URLs to a zone:   -
      https://www.googleapis.com/compute/v1/projects/project/zones/zone  -
      projects/project/zones/zone  - zones/zone
    targetInstance: The URL of the target instance to move. This can be a full
      or partial URL. For example, the following are all valid URLs to an
      instance:   - https://www.googleapis.com/compute/v1/projects/project/zon
      es/zone/instances/instance  -
      projects/project/zones/zone/instances/instance  -
      zones/zone/instances/instance
  """

  destinationZone = _messages.StringField(1)
  targetInstance = _messages.StringField(2)


class InstanceProperties(_messages.Message):
  """InstanceProperties message type.

  Messages:
    LabelsValue: Labels to apply to instances that are created from this
      template. Each label key/value pair must comply with RFC1035. Label
      values may be empty.

  Fields:
    canIpForward: Enables instances created based on this template to send
      packets with source IP addresses other than their own and receive
      packets with destination IP addresses other than their own. If these
      instances will be used as an IP gateway or it will be set as the next-
      hop in a Route resource, specify true. If unsure, leave this set to
      false. See the Enable IP forwarding for instances documentation for more
      information.
    description: An optional text description for the instances that are
      created from this instance template.
    disks: An array of disks that are associated with the instances that are
      created from this template.
    labels: Labels to apply to instances that are created from this template.
      Each label key/value pair must comply with RFC1035. Label values may be
      empty.
    machineType: The machine type to use for instances that are created from
      this template.
    metadata: The metadata key/value pairs to assign to instances that are
      created from this template. These pairs can consist of custom metadata
      or predefined keys. See Project and instance metadata for more
      information.
    networkInterfaces: An array of network access configurations for this
      interface.
    scheduling: Specifies the scheduling options for the instances that are
      created from this template.
    serviceAccounts: A list of service accounts with specified scopes. Access
      tokens for these service accounts are available to the instances that
      are created from this template. Use metadata queries to obtain the
      access tokens for these instances.
    tags: A list of tags to apply to the instances that are created from this
      template. The tags identify valid sources or targets for network
      firewalls. The setTags method can modify this list of tags. Each tag
      within the list must comply with RFC1035.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    """Labels to apply to instances that are created from this template. Each
    label key/value pair must comply with RFC1035. Label values may be empty.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  canIpForward = _messages.BooleanField(1)
  description = _messages.StringField(2)
  disks = _messages.MessageField('AttachedDisk', 3, repeated=True)
  labels = _messages.MessageField('LabelsValue', 4)
  machineType = _messages.StringField(5)
  metadata = _messages.MessageField('Metadata', 6)
  networkInterfaces = _messages.MessageField('NetworkInterface', 7, repeated=True)
  scheduling = _messages.MessageField('Scheduling', 8)
  serviceAccounts = _messages.MessageField('ServiceAccount', 9, repeated=True)
  tags = _messages.MessageField('Tags', 10)


class InstanceReference(_messages.Message):
  """A InstanceReference object.

  Fields:
    instance: The URL for a specific instance.
  """

  instance = _messages.StringField(1)


class InstanceTemplate(_messages.Message):
  """An Instance Template resource.

  Fields:
    creationTimestamp: [Output Only] The creation timestamp for this instance
      template in RFC3339 text format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    id: [Output Only] A unique identifier for this instance template. The
      server defines this identifier.
    kind: [Output Only] The resource type, which is always
      compute#instanceTemplate for instance templates.
    name: Name of the resource; provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    properties: The instance properties for this instance template.
    selfLink: [Output Only] The URL for this instance template. The server
      defines this URL.
    sourceInstance: The source instance used to create the template. You can
      provide this as a partial or full URL to the resource. For example, the
      following are valid values:   - https://www.googleapis.com/compute/v1/pr
      ojects/project/zones/zone/instances/instance  -
      projects/project/zones/zone/instances/instance
  """

  creationTimestamp = _messages.StringField(1)
  description = _messages.StringField(2)
  id = _messages.IntegerField(3, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(4, default=u'compute#instanceTemplate')
  name = _messages.StringField(5)
  properties = _messages.MessageField('InstanceProperties', 6)
  selfLink = _messages.StringField(7)
  sourceInstance = _messages.StringField(8)


class InstanceTemplateList(_messages.Message):
  """A list of instance templates.

  Fields:
    id: [Output Only] A unique identifier for this instance template. The
      server defines this identifier.
    items: [Output Only] list of InstanceTemplate resources.
    kind: [Output Only] The resource type, which is always
      compute#instanceTemplatesListResponse for instance template lists.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] The URL for this instance template list. The
      server defines this URL.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('InstanceTemplate', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#instanceTemplateList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class InstanceWithNamedPorts(_messages.Message):
  """A InstanceWithNamedPorts object.

  Enums:
    StatusValueValuesEnum: [Output Only] The status of the instance.

  Fields:
    instance: [Output Only] The URL of the instance.
    namedPorts: [Output Only] The named ports that belong to this instance
      group.
    status: [Output Only] The status of the instance.
  """

  class StatusValueValuesEnum(_messages.Enum):
    """[Output Only] The status of the instance.

    Values:
      PROVISIONING: <no description>
      RUNNING: <no description>
      STAGING: <no description>
      STOPPED: <no description>
      STOPPING: <no description>
      SUSPENDED: <no description>
      SUSPENDING: <no description>
      TERMINATED: <no description>
    """
    PROVISIONING = 0
    RUNNING = 1
    STAGING = 2
    STOPPED = 3
    STOPPING = 4
    SUSPENDED = 5
    SUSPENDING = 6
    TERMINATED = 7

  instance = _messages.StringField(1)
  namedPorts = _messages.MessageField('NamedPort', 2, repeated=True)
  status = _messages.EnumField('StatusValueValuesEnum', 3)


class InstancesScopedList(_messages.Message):
  """A InstancesScopedList object.

  Messages:
    WarningValue: [Output Only] Informational warning which replaces the list
      of instances when the list is empty.

  Fields:
    instances: [Output Only] List of instances contained in this scope.
    warning: [Output Only] Informational warning which replaces the list of
      instances when the list is empty.
  """

  class WarningValue(_messages.Message):
    """[Output Only] Informational warning which replaces the list of
    instances when the list is empty.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      """[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 2
      INJECTED_KERNELS_DEPRECATED = 3
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 4
      NEXT_HOP_CANNOT_IP_FORWARD = 5
      NEXT_HOP_INSTANCE_NOT_FOUND = 6
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 7
      NEXT_HOP_NOT_RUNNING = 8
      NOT_CRITICAL_ERROR = 9
      NO_RESULTS_ON_PAGE = 10
      REQUIRED_TOS_AGREEMENT = 11
      RESOURCE_NOT_DELETED = 12
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 13
      UNREACHABLE = 14

    class DataValueListEntry(_messages.Message):
      """A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  instances = _messages.MessageField('Instance', 1, repeated=True)
  warning = _messages.MessageField('WarningValue', 2)


class InstancesSetLabelsRequest(_messages.Message):
  """A InstancesSetLabelsRequest object.

  Messages:
    LabelsValue: A list of labels to apply for this instance. Changing
      instance labels will also change the instance tags.  Each label key &
      value must comply with RFC1035. Specifically, the name must be 1-63
      characters long and match the regular expression
      [a-z]([-a-z0-9]*[a-z0-9])? which means the first character must be a
      lowercase letter, and all following characters must be a dash, lowercase
      letter, or digit, except the last character, which cannot be a dash. For
      example, "webserver-frontend": "images". A label value can also be empty
      (e.g. "my-label": "").

  Fields:
    labelFingerprint: Fingerprint of the previous set of labels for this
      resource, used to prevent conflicts. Provide the latest fingerprint
      value when making a request to add or change labels.
    labels: A list of labels to apply for this instance. Changing instance
      labels will also change the instance tags.  Each label key & value must
      comply with RFC1035. Specifically, the name must be 1-63 characters long
      and match the regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means
      the first character must be a lowercase letter, and all following
      characters must be a dash, lowercase letter, or digit, except the last
      character, which cannot be a dash. For example, "webserver-frontend":
      "images". A label value can also be empty (e.g. "my-label": "").
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    """A list of labels to apply for this instance. Changing instance labels
    will also change the instance tags.  Each label key & value must comply
    with RFC1035. Specifically, the name must be 1-63 characters long and
    match the regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the
    first character must be a lowercase letter, and all following characters
    must be a dash, lowercase letter, or digit, except the last character,
    which cannot be a dash. For example, "webserver-frontend": "images". A
    label value can also be empty (e.g. "my-label": "").

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  labelFingerprint = _messages.BytesField(1)
  labels = _messages.MessageField('LabelsValue', 2)


class InstancesSetMachineTypeRequest(_messages.Message):
  """A InstancesSetMachineTypeRequest object.

  Fields:
    machineType: Full or partial URL of the machine type resource. See Machine
      Types for a full list of machine types. For example: zones/us-
      central1-f/machineTypes/n1-standard-1
  """

  machineType = _messages.StringField(1)


class InstancesSetServiceAccountRequest(_messages.Message):
  """A InstancesSetServiceAccountRequest object.

  Fields:
    email: Email address of the service account.
    scopes: The list of scopes to be made available for this service account.
  """

  email = _messages.StringField(1)
  scopes = _messages.StringField(2, repeated=True)


class InstancesStartWithEncryptionKeyRequest(_messages.Message):
  """A InstancesStartWithEncryptionKeyRequest object.

  Fields:
    disks: Array of disks associated with this instance that are protected
      with a customer-supplied encryption key.  In order to start the
      instance, the disk url and its corresponding key must be provided.  If
      the disk is not protected with a customer-supplied encryption key it
      should not be specified.
    instanceEncryptionKey: Decrypts data associated with an instance that is
      protected with a customer-supplied encryption key.  If the instance you
      are starting is protected with a customer-supplied encryption key, the
      correct key must be provided otherwise the instance start will not
      succeed.
  """

  disks = _messages.MessageField('CustomerEncryptionKeyProtectedDisk', 1, repeated=True)
  instanceEncryptionKey = _messages.MessageField('CustomerEncryptionKey', 2)


class License(_messages.Message):
  """A license resource.

  Fields:
    chargesUseFee: [Output Only] If true, the customer will be charged license
      fee for running software that contains this license on an instance.
    kind: [Output Only] Type of resource. Always compute#license for licenses.
    name: [Output Only] Name of the resource. The name is 1-63 characters long
      and complies with RFC1035.
    selfLink: [Output Only] Server-defined URL for the resource.
  """

  chargesUseFee = _messages.BooleanField(1)
  kind = _messages.StringField(2, default=u'compute#license')
  name = _messages.StringField(3)
  selfLink = _messages.StringField(4)


class LogConfig(_messages.Message):
  """Specifies what kind of log the caller must write

  Fields:
    counter: Counter options.
  """

  counter = _messages.MessageField('LogConfigCounterOptions', 1)


class LogConfigCounterOptions(_messages.Message):
  """Options for counters

  Fields:
    field: The field value to attribute.
    metric: The metric to update.
  """

  field = _messages.StringField(1)
  metric = _messages.StringField(2)


class MachineType(_messages.Message):
  """A Machine Type resource.

  Fields:
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    deprecated: [Output Only] The deprecation status associated with this
      machine type.
    description: [Output Only] An optional textual description of the
      resource.
    guestCpus: [Output Only] The number of virtual CPUs that are available to
      the instance.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    isSharedCpu: [Output Only] Whether this machine type has a shared CPU. See
      Shared-core machine types for more information.
    kind: [Output Only] The type of the resource. Always compute#machineType
      for machine types.
    maximumPersistentDisks: [Output Only] Maximum persistent disks allowed.
    maximumPersistentDisksSizeGb: [Output Only] Maximum total persistent disks
      size (GB) allowed.
    memoryMb: [Output Only] The amount of physical memory available to the
      instance, defined in MB.
    name: [Output Only] Name of the resource.
    selfLink: [Output Only] Server-defined URL for the resource.
    zone: [Output Only] The name of the zone where the machine type resides,
      such as us-central1-a.
  """

  creationTimestamp = _messages.StringField(1)
  deprecated = _messages.MessageField('DeprecationStatus', 2)
  description = _messages.StringField(3)
  guestCpus = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  id = _messages.IntegerField(5, variant=_messages.Variant.UINT64)
  isSharedCpu = _messages.BooleanField(6)
  kind = _messages.StringField(7, default=u'compute#machineType')
  maximumPersistentDisks = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  maximumPersistentDisksSizeGb = _messages.IntegerField(9)
  memoryMb = _messages.IntegerField(10, variant=_messages.Variant.INT32)
  name = _messages.StringField(11)
  selfLink = _messages.StringField(12)
  zone = _messages.StringField(13)


class MachineTypeAggregatedList(_messages.Message):
  """A MachineTypeAggregatedList object.

  Messages:
    ItemsValue: [Output Only] A map of scoped machine type lists.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: [Output Only] A map of scoped machine type lists.
    kind: [Output Only] Type of resource. Always
      compute#machineTypeAggregatedList for aggregated lists of machine types.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    """[Output Only] A map of scoped machine type lists.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: [Output Only] Name of the scope containing this
        set of machine types.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A MachineTypesScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('MachineTypesScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default=u'compute#machineTypeAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class MachineTypeList(_messages.Message):
  """Contains a list of machine types.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: [Output Only] A list of Machine Type resources.
    kind: [Output Only] Type of resource. Always compute#machineTypeList for
      lists of machine types.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('MachineType', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#machineTypeList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class MachineTypesScopedList(_messages.Message):
  """A MachineTypesScopedList object.

  Messages:
    WarningValue: [Output Only] An informational warning that appears when the
      machine types list is empty.

  Fields:
    machineTypes: [Output Only] List of machine types contained in this scope.
    warning: [Output Only] An informational warning that appears when the
      machine types list is empty.
  """

  class WarningValue(_messages.Message):
    """[Output Only] An informational warning that appears when the machine
    types list is empty.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      """[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 2
      INJECTED_KERNELS_DEPRECATED = 3
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 4
      NEXT_HOP_CANNOT_IP_FORWARD = 5
      NEXT_HOP_INSTANCE_NOT_FOUND = 6
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 7
      NEXT_HOP_NOT_RUNNING = 8
      NOT_CRITICAL_ERROR = 9
      NO_RESULTS_ON_PAGE = 10
      REQUIRED_TOS_AGREEMENT = 11
      RESOURCE_NOT_DELETED = 12
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 13
      UNREACHABLE = 14

    class DataValueListEntry(_messages.Message):
      """A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  machineTypes = _messages.MessageField('MachineType', 1, repeated=True)
  warning = _messages.MessageField('WarningValue', 2)


class ManagedInstance(_messages.Message):
  """A ManagedInstance object.

  Enums:
    CurrentActionValueValuesEnum: [Output Only] The current action that the
      managed instance group has scheduled for the instance. Possible values:
      - NONE The instance is running, and the managed instance group does not
      have any scheduled actions for this instance.  - CREATING The managed
      instance group is creating this instance. If the group fails to create
      this instance, it will try again until it is successful.  -
      CREATING_WITHOUT_RETRIES The managed instance group is attempting to
      create this instance only once. If the group fails to create this
      instance, it does not try again and the group's targetSize value is
      decreased instead.  - RECREATING The managed instance group is
      recreating this instance.  - DELETING The managed instance group is
      permanently deleting this instance.  - ABANDONING The managed instance
      group is abandoning this instance. The instance will be removed from the
      instance group and from any target pools that are associated with this
      group.  - RESTARTING The managed instance group is restarting the
      instance.  - REFRESHING The managed instance group is applying
      configuration changes to the instance without stopping it. For example,
      the group can update the target pool list for an instance without
      stopping that instance.
    InstanceStatusValueValuesEnum: [Output Only] The status of the instance.
      This field is empty when the instance does not exist.
    StandbyModeValueValuesEnum: [Output Only] Standby mode of the instance.
      This field is non-empty iff the instance is a standby.

  Fields:
    currentAction: [Output Only] The current action that the managed instance
      group has scheduled for the instance. Possible values:  - NONE The
      instance is running, and the managed instance group does not have any
      scheduled actions for this instance.  - CREATING The managed instance
      group is creating this instance. If the group fails to create this
      instance, it will try again until it is successful.  -
      CREATING_WITHOUT_RETRIES The managed instance group is attempting to
      create this instance only once. If the group fails to create this
      instance, it does not try again and the group's targetSize value is
      decreased instead.  - RECREATING The managed instance group is
      recreating this instance.  - DELETING The managed instance group is
      permanently deleting this instance.  - ABANDONING The managed instance
      group is abandoning this instance. The instance will be removed from the
      instance group and from any target pools that are associated with this
      group.  - RESTARTING The managed instance group is restarting the
      instance.  - REFRESHING The managed instance group is applying
      configuration changes to the instance without stopping it. For example,
      the group can update the target pool list for an instance without
      stopping that instance.
    id: [Output only] The unique identifier for this resource. This field is
      empty when instance does not exist.
    instance: [Output Only] The URL of the instance. The URL can exist even if
      the instance has not yet been created.
    instanceStatus: [Output Only] The status of the instance. This field is
      empty when the instance does not exist.
    instanceTemplate: [Output Only] The intended template of the instance.
      This field is empty when current_action is one of { DELETING, ABANDONING
      }.
    lastAttempt: [Output Only] Information about the last attempt to create or
      delete the instance.
    standbyMode: [Output Only] Standby mode of the instance. This field is
      non-empty iff the instance is a standby.
    tag: [Output Only] Tag describing the version.
  """

  class CurrentActionValueValuesEnum(_messages.Enum):
    """[Output Only] The current action that the managed instance group has
    scheduled for the instance. Possible values:  - NONE The instance is
    running, and the managed instance group does not have any scheduled
    actions for this instance.  - CREATING The managed instance group is
    creating this instance. If the group fails to create this instance, it
    will try again until it is successful.  - CREATING_WITHOUT_RETRIES The
    managed instance group is attempting to create this instance only once. If
    the group fails to create this instance, it does not try again and the
    group's targetSize value is decreased instead.  - RECREATING The managed
    instance group is recreating this instance.  - DELETING The managed
    instance group is permanently deleting this instance.  - ABANDONING The
    managed instance group is abandoning this instance. The instance will be
    removed from the instance group and from any target pools that are
    associated with this group.  - RESTARTING The managed instance group is
    restarting the instance.  - REFRESHING The managed instance group is
    applying configuration changes to the instance without stopping it. For
    example, the group can update the target pool list for an instance without
    stopping that instance.

    Values:
      ABANDONING: <no description>
      CREATING: <no description>
      CREATING_WITHOUT_RETRIES: <no description>
      DELETING: <no description>
      NONE: <no description>
      RECREATING: <no description>
      REFRESHING: <no description>
      RESTARTING: <no description>
    """
    ABANDONING = 0
    CREATING = 1
    CREATING_WITHOUT_RETRIES = 2
    DELETING = 3
    NONE = 4
    RECREATING = 5
    REFRESHING = 6
    RESTARTING = 7

  class InstanceStatusValueValuesEnum(_messages.Enum):
    """[Output Only] The status of the instance. This field is empty when the
    instance does not exist.

    Values:
      PROVISIONING: <no description>
      RUNNING: <no description>
      STAGING: <no description>
      STOPPED: <no description>
      STOPPING: <no description>
      SUSPENDED: <no description>
      SUSPENDING: <no description>
      TERMINATED: <no description>
    """
    PROVISIONING = 0
    RUNNING = 1
    STAGING = 2
    STOPPED = 3
    STOPPING = 4
    SUSPENDED = 5
    SUSPENDING = 6
    TERMINATED = 7

  class StandbyModeValueValuesEnum(_messages.Enum):
    """[Output Only] Standby mode of the instance. This field is non-empty iff
    the instance is a standby.

    Values:
      DRAINED: <no description>
    """
    DRAINED = 0

  currentAction = _messages.EnumField('CurrentActionValueValuesEnum', 1)
  id = _messages.IntegerField(2, variant=_messages.Variant.UINT64)
  instance = _messages.StringField(3)
  instanceStatus = _messages.EnumField('InstanceStatusValueValuesEnum', 4)
  instanceTemplate = _messages.StringField(5)
  lastAttempt = _messages.MessageField('ManagedInstanceLastAttempt', 6)
  standbyMode = _messages.EnumField('StandbyModeValueValuesEnum', 7)
  tag = _messages.StringField(8)


class ManagedInstanceLastAttempt(_messages.Message):
  """A ManagedInstanceLastAttempt object.

  Messages:
    ErrorsValue: [Output Only] Encountered errors during the last attempt to
      create or delete the instance.

  Fields:
    errors: [Output Only] Encountered errors during the last attempt to create
      or delete the instance.
  """

  class ErrorsValue(_messages.Message):
    """[Output Only] Encountered errors during the last attempt to create or
    delete the instance.

    Messages:
      ErrorsValueListEntry: A ErrorsValueListEntry object.

    Fields:
      errors: [Output Only] The array of errors encountered while processing
        this operation.
    """

    class ErrorsValueListEntry(_messages.Message):
      """A ErrorsValueListEntry object.

      Fields:
        code: [Output Only] The error type identifier for this error.
        location: [Output Only] Indicates the field in the request that caused
          the error. This property is optional.
        message: [Output Only] An optional, human-readable error message.
      """

      code = _messages.StringField(1)
      location = _messages.StringField(2)
      message = _messages.StringField(3)

    errors = _messages.MessageField('ErrorsValueListEntry', 1, repeated=True)

  errors = _messages.MessageField('ErrorsValue', 1)


class Metadata(_messages.Message):
  """A metadata key/value entry.

  Messages:
    ItemsValueListEntry: A ItemsValueListEntry object.

  Fields:
    fingerprint: Specifies a fingerprint for this request, which is
      essentially a hash of the metadata's contents and used for optimistic
      locking. The fingerprint is initially generated by Compute Engine and
      changes after every request to modify or update metadata. You must
      always provide an up-to-date fingerprint hash in order to update or
      change metadata.
    items: Array of key/value pairs. The total size of all keys and values
      must be less than 512 KB.
    kind: [Output Only] Type of the resource. Always compute#metadata for
      metadata.
  """

  class ItemsValueListEntry(_messages.Message):
    """A ItemsValueListEntry object.

    Fields:
      key: Key for the metadata entry. Keys must conform to the following
        regexp: [a-zA-Z0-9-_]+, and be less than 128 bytes in length. This is
        reflected as part of a URL in the metadata server. Additionally, to
        avoid ambiguity, keys must not conflict with any other metadata keys
        for the project.
      value: Value for the metadata entry. These are free-form strings, and
        only have meaning as interpreted by the image running in the instance.
        The only restriction placed on values is that their size must be less
        than or equal to 32768 bytes.
    """

    key = _messages.StringField(1)
    value = _messages.StringField(2)

  fingerprint = _messages.BytesField(1)
  items = _messages.MessageField('ItemsValueListEntry', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#metadata')


class NamedPort(_messages.Message):
  """The named port. For example: .

  Fields:
    name: The name for this named port. The name must be 1-63 characters long,
      and comply with RFC1035.
    port: The port number, which can be a value between 1 and 65535.
  """

  name = _messages.StringField(1)
  port = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class Network(_messages.Message):
  """Represents a Network resource. Read Networks and Firewalls for more
  information.

  Fields:
    IPv4Range: The range of internal addresses that are legal on this network.
      This range is a CIDR specification, for example: 192.168.0.0/16.
      Provided by the client when the network is created.
    autoCreateSubnetworks: When set to true, the network is created in "auto
      subnet mode". When set to false, the network is in "custom subnet mode".
      In "auto subnet mode", a newly created network is assigned the default
      CIDR of 10.128.0.0/9 and it automatically creates one subnetwork per
      region.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    gatewayIPv4: A gateway address for default routing to other networks. This
      value is read only and is selected by the Google Compute Engine,
      typically as the first usable address in the IPv4Range.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] Type of the resource. Always compute#network for
      networks.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    selfLink: [Output Only] Server-defined URL for the resource.
    subnetworks: [Output Only] Server-defined fully-qualified URLs for all
      subnetworks in this network.
  """

  IPv4Range = _messages.StringField(1)
  autoCreateSubnetworks = _messages.BooleanField(2)
  creationTimestamp = _messages.StringField(3)
  description = _messages.StringField(4)
  gatewayIPv4 = _messages.StringField(5)
  id = _messages.IntegerField(6, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(7, default=u'compute#network')
  name = _messages.StringField(8)
  selfLink = _messages.StringField(9)
  subnetworks = _messages.StringField(10, repeated=True)


class NetworkInterface(_messages.Message):
  """A network interface resource attached to an instance.

  Fields:
    accessConfigs: An array of configurations for this interface. Currently,
      only one access config, ONE_TO_ONE_NAT, is supported. If there are no
      accessConfigs specified, then this instance will have no external
      internet access.
    name: [Output Only] The name of the network interface, generated by the
      server. For network devices, these are eth0, eth1, etc.
    network: URL of the network resource for this instance. This is required
      for creating an instance but optional when creating a firewall rule. If
      not specified when creating a firewall rule, the default network is
      used:  global/networks/default   If you specify this property, you can
      specify the network as a full or partial URL. For example, the following
      are all valid URLs:   - https://www.googleapis.com/compute/v1/projects/p
      roject/global/networks/network  -
      projects/project/global/networks/network  - global/networks/default
    networkIP: An IPv4 internal network address to assign to the instance for
      this network interface. If not specified by the user, an unused internal
      IP is assigned by the system.
    subnetwork: The URL of the Subnetwork resource for this instance. If the
      network resource is in legacy mode, do not provide this property. If the
      network is in auto subnet mode, providing the subnetwork is optional. If
      the network is in custom subnet mode, then this field should be
      specified. If you specify this property, you can specify the subnetwork
      as a full or partial URL. For example, the following are all valid URLs:
      - https://www.googleapis.com/compute/v1/projects/project/regions/region/
      subnetworks/subnetwork  - regions/region/subnetworks/subnetwork
  """

  accessConfigs = _messages.MessageField('AccessConfig', 1, repeated=True)
  name = _messages.StringField(2)
  network = _messages.StringField(3)
  networkIP = _messages.StringField(4)
  subnetwork = _messages.StringField(5)


class NetworkList(_messages.Message):
  """Contains a list of networks.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: [Output Only] A list of Network resources.
    kind: [Output Only] Type of resource. Always compute#networkList for lists
      of networks.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource .
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('Network', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#networkList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class Operation(_messages.Message):
  """An Operation resource, used to manage asynchronous API requests.

  Enums:
    StatusValueValuesEnum: [Output Only] The status of the operation, which
      can be one of the following: PENDING, RUNNING, or DONE.

  Messages:
    ErrorValue: [Output Only] If errors are generated during processing of the
      operation, this field will be populated.
    WarningsValueListEntry: A WarningsValueListEntry object.

  Fields:
    clientOperationId: [Output Only] Reserved for future use.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: [Output Only] A textual description of the operation, which
      is set when the operation is created.
    endTime: [Output Only] The time that this operation was completed. This
      value is in RFC3339 text format.
    error: [Output Only] If errors are generated during processing of the
      operation, this field will be populated.
    httpErrorMessage: [Output Only] If the operation fails, this field
      contains the HTTP error message that was returned, such as NOT FOUND.
    httpErrorStatusCode: [Output Only] If the operation fails, this field
      contains the HTTP error status code that was returned. For example, a
      404 means the resource was not found.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    insertTime: [Output Only] The time that this operation was requested. This
      value is in RFC3339 text format.
    kind: [Output Only] Type of the resource. Always compute#operation for
      Operation resources.
    name: [Output Only] Name of the resource.
    operationType: [Output Only] The type of operation, such as insert,
      update, or delete, and so on.
    progress: [Output Only] An optional progress indicator that ranges from 0
      to 100. There is no requirement that this be linear or support any
      granularity of operations. This should not be used to guess when the
      operation will be complete. This number should monotonically increase as
      the operation progresses.
    region: [Output Only] The URL of the region where the operation resides.
      Only available when performing regional operations.
    selfLink: [Output Only] Server-defined URL for the resource.
    startTime: [Output Only] The time that this operation was started by the
      server. This value is in RFC3339 text format.
    status: [Output Only] The status of the operation, which can be one of the
      following: PENDING, RUNNING, or DONE.
    statusMessage: [Output Only] An optional textual description of the
      current status of the operation.
    targetId: [Output Only] The unique target ID, which identifies a specific
      incarnation of the target resource.
    targetLink: [Output Only] The URL of the resource that the operation
      modifies.
    user: [Output Only] User who requested the operation, for example:
      user@example.com.
    warnings: [Output Only] If warning messages are generated during
      processing of the operation, this field will be populated.
    zone: [Output Only] The URL of the zone where the operation resides. Only
      available when performing per-zone operations.
  """

  class StatusValueValuesEnum(_messages.Enum):
    """[Output Only] The status of the operation, which can be one of the
    following: PENDING, RUNNING, or DONE.

    Values:
      DONE: <no description>
      PENDING: <no description>
      RUNNING: <no description>
    """
    DONE = 0
    PENDING = 1
    RUNNING = 2

  class ErrorValue(_messages.Message):
    """[Output Only] If errors are generated during processing of the
    operation, this field will be populated.

    Messages:
      ErrorsValueListEntry: A ErrorsValueListEntry object.

    Fields:
      errors: [Output Only] The array of errors encountered while processing
        this operation.
    """

    class ErrorsValueListEntry(_messages.Message):
      """A ErrorsValueListEntry object.

      Fields:
        code: [Output Only] The error type identifier for this error.
        location: [Output Only] Indicates the field in the request that caused
          the error. This property is optional.
        message: [Output Only] An optional, human-readable error message.
      """

      code = _messages.StringField(1)
      location = _messages.StringField(2)
      message = _messages.StringField(3)

    errors = _messages.MessageField('ErrorsValueListEntry', 1, repeated=True)

  class WarningsValueListEntry(_messages.Message):
    """A WarningsValueListEntry object.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      """[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 2
      INJECTED_KERNELS_DEPRECATED = 3
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 4
      NEXT_HOP_CANNOT_IP_FORWARD = 5
      NEXT_HOP_INSTANCE_NOT_FOUND = 6
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 7
      NEXT_HOP_NOT_RUNNING = 8
      NOT_CRITICAL_ERROR = 9
      NO_RESULTS_ON_PAGE = 10
      REQUIRED_TOS_AGREEMENT = 11
      RESOURCE_NOT_DELETED = 12
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 13
      UNREACHABLE = 14

    class DataValueListEntry(_messages.Message):
      """A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  clientOperationId = _messages.StringField(1)
  creationTimestamp = _messages.StringField(2)
  description = _messages.StringField(3)
  endTime = _messages.StringField(4)
  error = _messages.MessageField('ErrorValue', 5)
  httpErrorMessage = _messages.StringField(6)
  httpErrorStatusCode = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  id = _messages.IntegerField(8, variant=_messages.Variant.UINT64)
  insertTime = _messages.StringField(9)
  kind = _messages.StringField(10, default=u'compute#operation')
  name = _messages.StringField(11)
  operationType = _messages.StringField(12)
  progress = _messages.IntegerField(13, variant=_messages.Variant.INT32)
  region = _messages.StringField(14)
  selfLink = _messages.StringField(15)
  startTime = _messages.StringField(16)
  status = _messages.EnumField('StatusValueValuesEnum', 17)
  statusMessage = _messages.StringField(18)
  targetId = _messages.IntegerField(19, variant=_messages.Variant.UINT64)
  targetLink = _messages.StringField(20)
  user = _messages.StringField(21)
  warnings = _messages.MessageField('WarningsValueListEntry', 22, repeated=True)
  zone = _messages.StringField(23)


class OperationAggregatedList(_messages.Message):
  """A OperationAggregatedList object.

  Messages:
    ItemsValue: [Output Only] A map of scoped operation lists.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: [Output Only] A map of scoped operation lists.
    kind: [Output Only] Type of resource. Always
      compute#operationAggregatedList for aggregated lists of operations.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    """[Output Only] A map of scoped operation lists.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: [Output Only] Name of the scope containing this
        set of operations.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A OperationsScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('OperationsScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default=u'compute#operationAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class OperationList(_messages.Message):
  """Contains a list of Operation resources.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: [Output Only] A list of Operation resources.
    kind: [Output Only] Type of resource. Always compute#operations for
      Operations resource.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('Operation', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#operationList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class OperationsScopedList(_messages.Message):
  """A OperationsScopedList object.

  Messages:
    WarningValue: [Output Only] Informational warning which replaces the list
      of operations when the list is empty.

  Fields:
    operations: [Output Only] List of operations contained in this scope.
    warning: [Output Only] Informational warning which replaces the list of
      operations when the list is empty.
  """

  class WarningValue(_messages.Message):
    """[Output Only] Informational warning which replaces the list of
    operations when the list is empty.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      """[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 2
      INJECTED_KERNELS_DEPRECATED = 3
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 4
      NEXT_HOP_CANNOT_IP_FORWARD = 5
      NEXT_HOP_INSTANCE_NOT_FOUND = 6
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 7
      NEXT_HOP_NOT_RUNNING = 8
      NOT_CRITICAL_ERROR = 9
      NO_RESULTS_ON_PAGE = 10
      REQUIRED_TOS_AGREEMENT = 11
      RESOURCE_NOT_DELETED = 12
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 13
      UNREACHABLE = 14

    class DataValueListEntry(_messages.Message):
      """A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  operations = _messages.MessageField('Operation', 1, repeated=True)
  warning = _messages.MessageField('WarningValue', 2)


class PathMatcher(_messages.Message):
  """A matcher for the path portion of the URL. The BackendService from the
  longest-matched rule will serve the URL. If no rule was matched, the default
  service will be used.

  Fields:
    defaultService: The full or partial URL to the BackendService resource.
      This will be used if none of the pathRules defined by this PathMatcher
      is matched by the URL's path portion. For example, the following are all
      valid URLs to a BackendService resource:   - https://www.googleapis.com/
      compute/v1/projects/project/global/backendServices/backendService  -
      compute/v1/projects/project/global/backendServices/backendService  -
      global/backendServices/backendService
    description: An optional description of this resource. Provide this
      property when you create the resource.
    name: The name to which this PathMatcher is referred by the HostRule.
    pathRules: The list of path rules.
  """

  defaultService = _messages.StringField(1)
  description = _messages.StringField(2)
  name = _messages.StringField(3)
  pathRules = _messages.MessageField('PathRule', 4, repeated=True)


class PathRule(_messages.Message):
  """A path-matching rule for a URL. If matched, will use the specified
  BackendService to handle the traffic arriving at this URL.

  Fields:
    paths: The list of path patterns to match. Each must start with / and the
      only place a * is allowed is at the end following a /. The string fed to
      the path matcher does not include any text after the first ? or #, and
      those chars are not allowed here.
    service: The URL of the BackendService resource if this rule is matched.
  """

  paths = _messages.StringField(1, repeated=True)
  service = _messages.StringField(2)


class Policy(_messages.Message):
  """Defines an Identity and Access Management (IAM) policy. It is used to
  specify access control policies for Cloud Platform resources.    A `Policy`
  consists of a list of `bindings`. A `Binding` binds a list of `members` to a
  `role`, where the members can be user accounts, Google groups, Google
  domains, and service accounts. A `role` is a named list of permissions
  defined by IAM.  **Example**  { "bindings": [ { "role": "roles/owner",
  "members": [ "user:mike@example.com", "group:admins@example.com",
  "domain:google.com", "serviceAccount:my-other-
  app@appspot.gserviceaccount.com", ] }, { "role": "roles/viewer", "members":
  ["user:sean@example.com"] } ] }  For a description of IAM and its features,
  see the [IAM developer's guide](https://cloud.google.com/iam).

  Fields:
    auditConfigs: Specifies audit logging configs for "data access". "data
      access": generally refers to data reads/writes and admin reads. "admin
      activity": generally refers to admin writes.  Note: `AuditConfig`
      doesn't apply to "admin activity", which always enables audit logging.
    bindings: Associates a list of `members` to a `role`. Multiple `bindings`
      must not be specified for the same `role`. `bindings` with no members
      will result in an error.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  If no `etag` is provided in the call to `setIamPolicy`, then
      the existing policy is overwritten blindly.
    iamOwned:
    rules: If more than one rule is specified, the rules are applied in the
      following manner: - All matching LOG rules are always applied. - If any
      DENY/DENY_WITH_LOG rule matches, permission is denied. Logging will be
      applied if one or more matching rule requires logging. - Otherwise, if
      any ALLOW/ALLOW_WITH_LOG rule matches, permission is granted. Logging
      will be applied if one or more matching rule requires logging. -
      Otherwise, if no rule applies, permission is denied.
    version: Version of the `Policy`. The default version is 0.
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  iamOwned = _messages.BooleanField(4)
  rules = _messages.MessageField('Rule', 5, repeated=True)
  version = _messages.IntegerField(6, variant=_messages.Variant.INT32)


class Project(_messages.Message):
  """A Project resource. Projects can only be created in the Google Cloud
  Platform Console. Unless marked otherwise, values can only be modified in
  the console.

  Enums:
    XpnProjectStatusValueValuesEnum: [Output Only] The role this project has
      in a Cross Project Network (XPN) configuration. Currently only HOST
      projects are differentiated.

  Fields:
    commonInstanceMetadata: Metadata key/value pairs available to all
      instances contained in this project. See Custom metadata for more
      information.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    defaultServiceAccount: [Output Only] Default service account used by VMs
      running in this project.
    description: An optional textual description of the resource.
    enabledFeatures: Restricted features enabled for use on this project.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server. This is not the project ID, and is just a
      unique ID used by Compute Engine to identify resources.
    kind: [Output Only] Type of the resource. Always compute#project for
      projects.
    name: The project ID. For example: my-example-project. Use the project ID
      to make requests to Compute Engine.
    quotas: [Output Only] Quotas assigned to this project.
    selfLink: [Output Only] Server-defined URL for the resource.
    usageExportLocation: The naming prefix for daily usage reports and the
      Google Cloud Storage bucket where they are stored.
    xpnProjectStatus: [Output Only] The role this project has in a Cross
      Project Network (XPN) configuration. Currently only HOST projects are
      differentiated.
  """

  class XpnProjectStatusValueValuesEnum(_messages.Enum):
    """[Output Only] The role this project has in a Cross Project Network
    (XPN) configuration. Currently only HOST projects are differentiated.

    Values:
      HOST: <no description>
      UNSPECIFIED_XPN_PROJECT_STATUS: <no description>
    """
    HOST = 0
    UNSPECIFIED_XPN_PROJECT_STATUS = 1

  commonInstanceMetadata = _messages.MessageField('Metadata', 1)
  creationTimestamp = _messages.StringField(2)
  defaultServiceAccount = _messages.StringField(3)
  description = _messages.StringField(4)
  enabledFeatures = _messages.StringField(5, repeated=True)
  id = _messages.IntegerField(6, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(7, default=u'compute#project')
  name = _messages.StringField(8)
  quotas = _messages.MessageField('Quota', 9, repeated=True)
  selfLink = _messages.StringField(10)
  usageExportLocation = _messages.MessageField('UsageExportLocation', 11)
  xpnProjectStatus = _messages.EnumField('XpnProjectStatusValueValuesEnum', 12)


class Quota(_messages.Message):
  """A quotas entry.

  Enums:
    MetricValueValuesEnum: [Output Only] Name of the quota metric.

  Fields:
    limit: [Output Only] Quota limit for this metric.
    metric: [Output Only] Name of the quota metric.
    usage: [Output Only] Current usage of this metric.
  """

  class MetricValueValuesEnum(_messages.Enum):
    """[Output Only] Name of the quota metric.

    Values:
      AUTOSCALERS: <no description>
      BACKEND_BUCKETS: <no description>
      BACKEND_SERVICES: <no description>
      CPUS: <no description>
      DISKS_TOTAL_GB: <no description>
      FIREWALLS: <no description>
      FORWARDING_RULES: <no description>
      HEALTH_CHECKS: <no description>
      IMAGES: <no description>
      INSTANCES: <no description>
      INSTANCE_GROUPS: <no description>
      INSTANCE_GROUP_MANAGERS: <no description>
      INSTANCE_TEMPLATES: <no description>
      IN_USE_ADDRESSES: <no description>
      LOCAL_SSD_TOTAL_GB: <no description>
      NETWORKS: <no description>
      PREEMPTIBLE_CPUS: <no description>
      REGIONAL_AUTOSCALERS: <no description>
      REGIONAL_INSTANCE_GROUP_MANAGERS: <no description>
      ROUTERS: <no description>
      ROUTES: <no description>
      SNAPSHOTS: <no description>
      SSD_TOTAL_GB: <no description>
      SSL_CERTIFICATES: <no description>
      STATIC_ADDRESSES: <no description>
      SUBNETWORKS: <no description>
      TARGET_HTTPS_PROXIES: <no description>
      TARGET_HTTP_PROXIES: <no description>
      TARGET_INSTANCES: <no description>
      TARGET_POOLS: <no description>
      TARGET_SSL_PROXIES: <no description>
      TARGET_VPN_GATEWAYS: <no description>
      URL_MAPS: <no description>
      VPN_TUNNELS: <no description>
    """
    AUTOSCALERS = 0
    BACKEND_BUCKETS = 1
    BACKEND_SERVICES = 2
    CPUS = 3
    DISKS_TOTAL_GB = 4
    FIREWALLS = 5
    FORWARDING_RULES = 6
    HEALTH_CHECKS = 7
    IMAGES = 8
    INSTANCES = 9
    INSTANCE_GROUPS = 10
    INSTANCE_GROUP_MANAGERS = 11
    INSTANCE_TEMPLATES = 12
    IN_USE_ADDRESSES = 13
    LOCAL_SSD_TOTAL_GB = 14
    NETWORKS = 15
    PREEMPTIBLE_CPUS = 16
    REGIONAL_AUTOSCALERS = 17
    REGIONAL_INSTANCE_GROUP_MANAGERS = 18
    ROUTERS = 19
    ROUTES = 20
    SNAPSHOTS = 21
    SSD_TOTAL_GB = 22
    SSL_CERTIFICATES = 23
    STATIC_ADDRESSES = 24
    SUBNETWORKS = 25
    TARGET_HTTPS_PROXIES = 26
    TARGET_HTTP_PROXIES = 27
    TARGET_INSTANCES = 28
    TARGET_POOLS = 29
    TARGET_SSL_PROXIES = 30
    TARGET_VPN_GATEWAYS = 31
    URL_MAPS = 32
    VPN_TUNNELS = 33

  limit = _messages.FloatField(1)
  metric = _messages.EnumField('MetricValueValuesEnum', 2)
  usage = _messages.FloatField(3)


class Region(_messages.Message):
  """Region resource.

  Enums:
    StatusValueValuesEnum: [Output Only] Status of the region, either UP or
      DOWN.

  Fields:
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    deprecated: [Output Only] The deprecation status associated with this
      region.
    description: [Output Only] Textual description of the resource.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] Type of the resource. Always compute#region for
      regions.
    name: [Output Only] Name of the resource.
    quotas: [Output Only] Quotas assigned to this region.
    selfLink: [Output Only] Server-defined URL for the resource.
    status: [Output Only] Status of the region, either UP or DOWN.
    zones: [Output Only] A list of zones available in this region, in the form
      of resource URLs.
  """

  class StatusValueValuesEnum(_messages.Enum):
    """[Output Only] Status of the region, either UP or DOWN.

    Values:
      DOWN: <no description>
      UP: <no description>
    """
    DOWN = 0
    UP = 1

  creationTimestamp = _messages.StringField(1)
  deprecated = _messages.MessageField('DeprecationStatus', 2)
  description = _messages.StringField(3)
  id = _messages.IntegerField(4, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(5, default=u'compute#region')
  name = _messages.StringField(6)
  quotas = _messages.MessageField('Quota', 7, repeated=True)
  selfLink = _messages.StringField(8)
  status = _messages.EnumField('StatusValueValuesEnum', 9)
  zones = _messages.StringField(10, repeated=True)


class RegionAutoscalerList(_messages.Message):
  """Contains a list of autoscalers.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: A list of autoscalers.
    kind: Type of resource.
    nextPageToken: [Output Only] A token used to continue a truncated list
      request.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('Autoscaler', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#regionAutoscalerList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class RegionDiskList(_messages.Message):
  """A RegionDiskList object.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: [Output Only] A list of persistent disks.
    kind: [Output Only] Type of resource. Always compute#regionDiskList for
      lists of region disks.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('Disk', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#regionDiskList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class RegionDiskTypeList(_messages.Message):
  """A RegionDiskTypeList object.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: [Output Only] A list of Disk Type resources.
    kind: [Output Only] Type of resource. Always compute#regionDiskTypeList
      for region disk types.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('DiskType', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#regionDiskTypeList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class RegionDisksResizeRequest(_messages.Message):
  """A RegionDisksResizeRequest object.

  Fields:
    sizeGb: The new size of the regional persistent disk, which is specified
      in GB.
  """

  sizeGb = _messages.IntegerField(1)


class RegionInstanceGroupList(_messages.Message):
  """Contains a list of InstanceGroup resources.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: A list of InstanceGroup resources.
    kind: The resource type.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] The URL for this resource type. The server
      generates this URL.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('InstanceGroup', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#regionInstanceGroupList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class RegionInstanceGroupManagerList(_messages.Message):
  """Contains a list of managed instance groups.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: A list of managed instance groups.
    kind: [Output Only] The resource type, which is always
      compute#instanceGroupManagerList for a list of managed instance groups
      that exist in th regional scope.
    nextPageToken: [Output only] A token used to continue a truncated list
      request.
    selfLink: [Output only] The URL for this resource type. The server
      generates this URL.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('InstanceGroupManager', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#regionInstanceGroupManagerList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class RegionInstanceGroupManagersAbandonInstancesRequest(_messages.Message):
  """A RegionInstanceGroupManagersAbandonInstancesRequest object.

  Fields:
    instances: The names of one or more instances to abandon.
  """

  instances = _messages.StringField(1, repeated=True)


class RegionInstanceGroupManagersDeleteInstancesRequest(_messages.Message):
  """A RegionInstanceGroupManagersDeleteInstancesRequest object.

  Fields:
    instances: The names of one or more instances to delete.
  """

  instances = _messages.StringField(1, repeated=True)


class RegionInstanceGroupManagersListInstancesResponse(_messages.Message):
  """A RegionInstanceGroupManagersListInstancesResponse object.

  Fields:
    managedInstances: List of managed instances.
  """

  managedInstances = _messages.MessageField('ManagedInstance', 1, repeated=True)


class RegionInstanceGroupManagersRecreateRequest(_messages.Message):
  """A RegionInstanceGroupManagersRecreateRequest object.

  Fields:
    instances: The URL for one or more instances to recreate.
  """

  instances = _messages.StringField(1, repeated=True)


class RegionInstanceGroupManagersSetAutoHealingRequest(_messages.Message):
  """A RegionInstanceGroupManagersSetAutoHealingRequest object.

  Fields:
    autoHealingPolicies: A InstanceGroupManagerAutoHealingPolicy attribute.
  """

  autoHealingPolicies = _messages.MessageField('InstanceGroupManagerAutoHealingPolicy', 1, repeated=True)


class RegionInstanceGroupManagersSetTargetPoolsRequest(_messages.Message):
  """A RegionInstanceGroupManagersSetTargetPoolsRequest object.

  Fields:
    fingerprint: Fingerprint of the target pools information, which is a hash
      of the contents. This field is used for optimistic locking when you
      update the target pool entries. This field is optional.
    targetPools: The URL of all TargetPool resources to which instances in the
      instanceGroup field are added. The target pools automatically apply to
      all of the instances in the managed instance group.
  """

  fingerprint = _messages.BytesField(1)
  targetPools = _messages.StringField(2, repeated=True)


class RegionInstanceGroupManagersSetTemplateRequest(_messages.Message):
  """A RegionInstanceGroupManagersSetTemplateRequest object.

  Fields:
    instanceTemplate: URL of the InstanceTemplate resource from which all new
      instances will be created.
  """

  instanceTemplate = _messages.StringField(1)


class RegionInstanceGroupsListInstances(_messages.Message):
  """A RegionInstanceGroupsListInstances object.

  Fields:
    id: [Output Only] Unique identifier for the resource. Defined by the
      server.
    items: A list of instances and any named ports that are assigned to those
      instances.
    kind: The resource type.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for the resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('InstanceWithNamedPorts', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#regionInstanceGroupsListInstances')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class RegionInstanceGroupsListInstancesRequest(_messages.Message):
  """A RegionInstanceGroupsListInstancesRequest object.

  Enums:
    InstanceStateValueValuesEnum: Instances in which state should be returned.
      Valid options are: 'ALL', 'RUNNING'. By default, it lists all instances.

  Fields:
    instanceState: Instances in which state should be returned. Valid options
      are: 'ALL', 'RUNNING'. By default, it lists all instances.
    portName: Name of port user is interested in. It is optional. If it is
      set, only information about this ports will be returned. If it is not
      set, all the named ports will be returned. Always lists all instances.
  """

  class InstanceStateValueValuesEnum(_messages.Enum):
    """Instances in which state should be returned. Valid options are: 'ALL',
    'RUNNING'. By default, it lists all instances.

    Values:
      ALL: <no description>
      RUNNING: <no description>
    """
    ALL = 0
    RUNNING = 1

  instanceState = _messages.EnumField('InstanceStateValueValuesEnum', 1)
  portName = _messages.StringField(2)


class RegionInstanceGroupsSetNamedPortsRequest(_messages.Message):
  """A RegionInstanceGroupsSetNamedPortsRequest object.

  Fields:
    fingerprint: The fingerprint of the named ports information for this
      instance group. Use this optional property to prevent conflicts when
      multiple users change the named ports settings concurrently. Obtain the
      fingerprint with the instanceGroups.get method. Then, include the
      fingerprint in your request to ensure that you do not overwrite changes
      that were applied from another concurrent request.
    namedPorts: The list of named ports to set for this instance group.
  """

  fingerprint = _messages.BytesField(1)
  namedPorts = _messages.MessageField('NamedPort', 2, repeated=True)


class RegionList(_messages.Message):
  """Contains a list of region resources.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: [Output Only] A list of Region resources.
    kind: [Output Only] Type of resource. Always compute#regionList for lists
      of regions.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('Region', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#regionList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class RegionSetLabelsRequest(_messages.Message):
  """A RegionSetLabelsRequest object.

  Messages:
    LabelsValue: The labels to set for this resource.

  Fields:
    labelFingerprint: The fingerprint of the previous set of labels for this
      resource, used to detect conflicts. The fingerprint is initially
      generated by Compute Engine and changes after every request to modify or
      update labels. You must always provide an up-to-date fingerprint hash in
      order to update or change labels. Make a get() request to the resource
      to get the latest fingerprint.
    labels: The labels to set for this resource.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    """The labels to set for this resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  labelFingerprint = _messages.BytesField(1)
  labels = _messages.MessageField('LabelsValue', 2)


class ResourceGroupReference(_messages.Message):
  """A ResourceGroupReference object.

  Fields:
    group: A URI referencing one of the resource views listed in the backend
      service.
  """

  group = _messages.StringField(1)


class Route(_messages.Message):
  """Represents a Route resource. A route specifies how certain packets should
  be handled by the network. Routes are associated with instances by tags and
  the set of routes for a particular instance is called its routing table.
  For each packet leaving a instance, the system searches that instance's
  routing table for a single best matching route. Routes match packets by
  destination IP address, preferring smaller or more specific ranges over
  larger ones. If there is a tie, the system selects the route with the
  smallest priority value. If there is still a tie, it uses the layer three
  and four packet headers to select just one of the remaining matching routes.
  The packet is then forwarded as specified by the nextHop field of the
  winning route - either to another instance destination, a instance gateway
  or a Google Compute Engine-operated gateway.  Packets that do not match any
  route in the sending instance's routing table are dropped.

  Messages:
    WarningsValueListEntry: A WarningsValueListEntry object.

  Fields:
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    destRange: The destination range of outgoing packets that this route
      applies to.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] Type of this resource. Always compute#routes for Route
      resources.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    network: Fully-qualified URL of the network that this route applies to.
    nextHopGateway: The URL to a gateway that should handle matching packets.
      You can only specify the internet gateway using a full or partial valid
      URL:  projects/<project-id>/global/gateways/default-internet-gateway
    nextHopInstance: The URL to an instance that should handle matching
      packets. You can specify this as a full or partial URL. For example: htt
      ps://www.googleapis.com/compute/v1/projects/project/zones/zone/instances
      /
    nextHopIp: The network IP address of an instance that should handle
      matching packets.
    nextHopNetwork: The URL of the local network if it should handle matching
      packets.
    nextHopVpnTunnel: The URL to a VpnTunnel that should handle matching
      packets.
    priority: The priority of this route. Priority is used to break ties in
      cases where there is more than one matching route of equal prefix
      length. In the case of two routes with equal prefix length, the one with
      the lowest-numbered priority value wins. Default value is 1000. Valid
      range is 0 through 65535.
    selfLink: [Output Only] Server-defined fully-qualified URL for this
      resource.
    tags: A list of instance tags to which this route applies.
    warnings: [Output Only] If potential misconfigurations are detected for
      this route, this field will be populated with warning messages.
  """

  class WarningsValueListEntry(_messages.Message):
    """A WarningsValueListEntry object.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      """[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 2
      INJECTED_KERNELS_DEPRECATED = 3
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 4
      NEXT_HOP_CANNOT_IP_FORWARD = 5
      NEXT_HOP_INSTANCE_NOT_FOUND = 6
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 7
      NEXT_HOP_NOT_RUNNING = 8
      NOT_CRITICAL_ERROR = 9
      NO_RESULTS_ON_PAGE = 10
      REQUIRED_TOS_AGREEMENT = 11
      RESOURCE_NOT_DELETED = 12
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 13
      UNREACHABLE = 14

    class DataValueListEntry(_messages.Message):
      """A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  creationTimestamp = _messages.StringField(1)
  description = _messages.StringField(2)
  destRange = _messages.StringField(3)
  id = _messages.IntegerField(4, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(5, default=u'compute#route')
  name = _messages.StringField(6)
  network = _messages.StringField(7)
  nextHopGateway = _messages.StringField(8)
  nextHopInstance = _messages.StringField(9)
  nextHopIp = _messages.StringField(10)
  nextHopNetwork = _messages.StringField(11)
  nextHopVpnTunnel = _messages.StringField(12)
  priority = _messages.IntegerField(13, variant=_messages.Variant.UINT32)
  selfLink = _messages.StringField(14)
  tags = _messages.StringField(15, repeated=True)
  warnings = _messages.MessageField('WarningsValueListEntry', 16, repeated=True)


class RouteList(_messages.Message):
  """Contains a list of Route resources.

  Fields:
    id: [Output Only] Unique identifier for the resource. Defined by the
      server.
    items: [Output Only] A list of Route resources.
    kind: Type of resource.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('Route', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#routeList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class Router(_messages.Message):
  """Router resource.

  Fields:
    bgp: A RouterBgp attribute.
    bgpPeers: A RouterBgpPeer attribute.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    interfaces: A RouterInterface attribute.
    kind: [Output Only] Type of resource. Always compute#router for routers.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    network: URI of the network to which this router belongs.
    region: [Output Only] URI of the region where the router resides.
    selfLink: [Output Only] Server-defined URL for the resource.
  """

  bgp = _messages.MessageField('RouterBgp', 1)
  bgpPeers = _messages.MessageField('RouterBgpPeer', 2, repeated=True)
  creationTimestamp = _messages.StringField(3)
  description = _messages.StringField(4)
  id = _messages.IntegerField(5, variant=_messages.Variant.UINT64)
  interfaces = _messages.MessageField('RouterInterface', 6, repeated=True)
  kind = _messages.StringField(7, default=u'compute#router')
  name = _messages.StringField(8)
  network = _messages.StringField(9)
  region = _messages.StringField(10)
  selfLink = _messages.StringField(11)


class RouterAggregatedList(_messages.Message):
  """Contains a list of routers.

  Messages:
    ItemsValue: A map of scoped router lists.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: A map of scoped router lists.
    kind: Type of resource.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    """A map of scoped router lists.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: Name of the scope containing this set of routers.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A RoutersScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('RoutersScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default=u'compute#routerAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class RouterBgp(_messages.Message):
  """A RouterBgp object.

  Fields:
    asn: Local BGP Autonomous System Number (ASN). Must be an RFC6996 private
      ASN, either 16-bit or 32-bit. The value will be fixed for this router
      resource. All VPN tunnels that link to this router will have the same
      local ASN.
  """

  asn = _messages.IntegerField(1, variant=_messages.Variant.UINT32)


class RouterBgpPeer(_messages.Message):
  """BGP information that needs to be configured into the routing stack to
  establish the BGP peering. It must specify peer ASN and either interface
  name, IP, or peer IP. Reference: https://tools.ietf.org/html/rfc4273

  Fields:
    advertisedRoutePriority: The priority of routes advertised to this BGP
      peer. In the case where there is more than one matching route of maximum
      length, the routes with lowest priority value win.
    interfaceName: Name of the interface the BGP peer is associated with.
    ipAddress: IP address of the interface inside Google Cloud Platform.
    name: Name of this BGP peer. The name must be 1-63 characters long and
      comply with RFC1035.
    peerAsn: Peer BGP Autonomous System Number (ASN). For VPN use case, this
      value can be different for every tunnel.
    peerIpAddress: IP address of the BGP interface outside Google cloud.
  """

  advertisedRoutePriority = _messages.IntegerField(1, variant=_messages.Variant.UINT32)
  interfaceName = _messages.StringField(2)
  ipAddress = _messages.StringField(3)
  name = _messages.StringField(4)
  peerAsn = _messages.IntegerField(5, variant=_messages.Variant.UINT32)
  peerIpAddress = _messages.StringField(6)


class RouterInterface(_messages.Message):
  """Router interfaces. Each interface requires either one linked resource
  (e.g. linked_vpn_tunnel) or IP address + range (specified in ip_range).

  Fields:
    ipRange: IP address and range of the interface. The IP range must be in
      the RFC3927 link-local IP space. The value must be a CIDR-formatted
      string, for example: 169.254.0.1/30. NOTE: Do not truncate the address
      as it represents the IP address of the interface.
    linkedVpnTunnel: URI of linked VPN tunnel. It must be in the same region
      as the router. Each interface can have at most one linked resource.
    name: Name of this interface entry. The name must be 1-63 characters long
      and comply with RFC1035.
  """

  ipRange = _messages.StringField(1)
  linkedVpnTunnel = _messages.StringField(2)
  name = _messages.StringField(3)


class RouterList(_messages.Message):
  """Contains a list of Router resources.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: A list of Router resources.
    kind: [Output Only] Type of resource. Always compute#router for routers.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for the resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('Router', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#routerList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class RouterStatus(_messages.Message):
  """A RouterStatus object.

  Fields:
    bestRoutes: Best routes for this router's network.
    bgpPeerStatus: A RouterStatusBgpPeerStatus attribute.
    network: URI of the network to which this router belongs.
  """

  bestRoutes = _messages.MessageField('Route', 1, repeated=True)
  bgpPeerStatus = _messages.MessageField('RouterStatusBgpPeerStatus', 2, repeated=True)
  network = _messages.StringField(3)


class RouterStatusBgpPeerStatus(_messages.Message):
  """A RouterStatusBgpPeerStatus object.

  Enums:
    StatusValueValuesEnum: Status of the BGP peer: {UP, DOWN}

  Fields:
    advertisedRoutes: Routes that were advertised to the remote BGP peer
    ipAddress: IP address of the local BGP interface.
    linkedVpnTunnel: URL of the VPN tunnel that this BGP peer controls.
    name: Name of this BGP peer. Unique within the Routers resource.
    numLearnedRoutes: Number of routes learned from the remote BGP Peer.
    peerIpAddress: IP address of the remote BGP interface.
    state: BGP state as specified in RFC1771.
    status: Status of the BGP peer: {UP, DOWN}
    uptime: Time this session has been up. Format: 14 years, 51 weeks, 6 days,
      23 hours, 59 minutes, 59 seconds
    uptimeSeconds: Time this session has been up, in seconds. Format: 145
  """

  class StatusValueValuesEnum(_messages.Enum):
    """Status of the BGP peer: {UP, DOWN}

    Values:
      DOWN: <no description>
      UNKNOWN: <no description>
      UP: <no description>
    """
    DOWN = 0
    UNKNOWN = 1
    UP = 2

  advertisedRoutes = _messages.MessageField('Route', 1, repeated=True)
  ipAddress = _messages.StringField(2)
  linkedVpnTunnel = _messages.StringField(3)
  name = _messages.StringField(4)
  numLearnedRoutes = _messages.IntegerField(5, variant=_messages.Variant.UINT32)
  peerIpAddress = _messages.StringField(6)
  state = _messages.StringField(7)
  status = _messages.EnumField('StatusValueValuesEnum', 8)
  uptime = _messages.StringField(9)
  uptimeSeconds = _messages.StringField(10)


class RouterStatusResponse(_messages.Message):
  """A RouterStatusResponse object.

  Fields:
    kind: Type of resource.
    result: A RouterStatus attribute.
  """

  kind = _messages.StringField(1, default=u'compute#routerStatusResponse')
  result = _messages.MessageField('RouterStatus', 2)


class RoutersPreviewResponse(_messages.Message):
  """A RoutersPreviewResponse object.

  Fields:
    resource: Preview of given router.
  """

  resource = _messages.MessageField('Router', 1)


class RoutersScopedList(_messages.Message):
  """A RoutersScopedList object.

  Messages:
    WarningValue: Informational warning which replaces the list of routers
      when the list is empty.

  Fields:
    routers: List of routers contained in this scope.
    warning: Informational warning which replaces the list of routers when the
      list is empty.
  """

  class WarningValue(_messages.Message):
    """Informational warning which replaces the list of routers when the list
    is empty.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      """[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 2
      INJECTED_KERNELS_DEPRECATED = 3
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 4
      NEXT_HOP_CANNOT_IP_FORWARD = 5
      NEXT_HOP_INSTANCE_NOT_FOUND = 6
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 7
      NEXT_HOP_NOT_RUNNING = 8
      NOT_CRITICAL_ERROR = 9
      NO_RESULTS_ON_PAGE = 10
      REQUIRED_TOS_AGREEMENT = 11
      RESOURCE_NOT_DELETED = 12
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 13
      UNREACHABLE = 14

    class DataValueListEntry(_messages.Message):
      """A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  routers = _messages.MessageField('Router', 1, repeated=True)
  warning = _messages.MessageField('WarningValue', 2)


class Rule(_messages.Message):
  """A rule to be applied in a Policy.

  Enums:
    ActionValueValuesEnum: Required

  Fields:
    action: Required
    conditions: Additional restrictions that must be met
    description: Human-readable description of the rule.
    ins: If one or more 'in' clauses are specified, the rule matches if the
      PRINCIPAL/AUTHORITY_SELECTOR is in at least one of these entries.
    logConfigs: The config returned to callers of tech.iam.IAM.CheckPolicy for
      any entries that match the LOG action.
    notIns: If one or more 'not_in' clauses are specified, the rule matches if
      the PRINCIPAL/AUTHORITY_SELECTOR is in none of the entries.
    permissions: A permission is a string of form '..' (e.g.,
      'storage.buckets.list'). A value of '*' matches all permissions, and a
      verb part of '*' (e.g., 'storage.buckets.*') matches all verbs.
  """

  class ActionValueValuesEnum(_messages.Enum):
    """Required

    Values:
      ALLOW: <no description>
      ALLOW_WITH_LOG: <no description>
      DENY: <no description>
      DENY_WITH_LOG: <no description>
      LOG: <no description>
      NO_ACTION: <no description>
    """
    ALLOW = 0
    ALLOW_WITH_LOG = 1
    DENY = 2
    DENY_WITH_LOG = 3
    LOG = 4
    NO_ACTION = 5

  action = _messages.EnumField('ActionValueValuesEnum', 1)
  conditions = _messages.MessageField('Condition', 2, repeated=True)
  description = _messages.StringField(3)
  ins = _messages.StringField(4, repeated=True)
  logConfigs = _messages.MessageField('LogConfig', 5, repeated=True)
  notIns = _messages.StringField(6, repeated=True)
  permissions = _messages.StringField(7, repeated=True)


class SSLHealthCheck(_messages.Message):
  """A SSLHealthCheck object.

  Enums:
    ProxyHeaderValueValuesEnum: Specifies the type of proxy header to append
      before sending data to the backend, either NONE or PROXY_V1. The default
      is NONE.

  Fields:
    port: The TCP port number for the health check request. The default value
      is 443.
    portName: Port name as defined in InstanceGroup#NamedPort#name. If both
      port and port_name are defined, port takes precedence.
    proxyHeader: Specifies the type of proxy header to append before sending
      data to the backend, either NONE or PROXY_V1. The default is NONE.
    request: The application data to send once the SSL connection has been
      established (default value is empty). If both request and response are
      empty, the connection establishment alone will indicate health. The
      request data can only be ASCII.
    response: The bytes to match against the beginning of the response data.
      If left empty (the default value), any response will indicate health.
      The response data can only be ASCII.
  """

  class ProxyHeaderValueValuesEnum(_messages.Enum):
    """Specifies the type of proxy header to append before sending data to the
    backend, either NONE or PROXY_V1. The default is NONE.

    Values:
      NONE: <no description>
      PROXY_V1: <no description>
    """
    NONE = 0
    PROXY_V1 = 1

  port = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  portName = _messages.StringField(2)
  proxyHeader = _messages.EnumField('ProxyHeaderValueValuesEnum', 3)
  request = _messages.StringField(4)
  response = _messages.StringField(5)


class Scheduling(_messages.Message):
  """Sets the scheduling options for an Instance.

  Enums:
    OnHostMaintenanceValueValuesEnum: Defines the maintenance behavior for
      this instance. For standard instances, the default behavior is MIGRATE.
      For preemptible instances, the default and only possible behavior is
      TERMINATE. For more information, see Setting Instance Scheduling
      Options.

  Fields:
    automaticRestart: Specifies whether the instance should be automatically
      restarted if it is terminated by Compute Engine (not terminated by a
      user). You can only set the automatic restart option for standard
      instances. Preemptible instances cannot be automatically restarted.
    onHostMaintenance: Defines the maintenance behavior for this instance. For
      standard instances, the default behavior is MIGRATE. For preemptible
      instances, the default and only possible behavior is TERMINATE. For more
      information, see Setting Instance Scheduling Options.
    preemptible: Whether the instance is preemptible.
  """

  class OnHostMaintenanceValueValuesEnum(_messages.Enum):
    """Defines the maintenance behavior for this instance. For standard
    instances, the default behavior is MIGRATE. For preemptible instances, the
    default and only possible behavior is TERMINATE. For more information, see
    Setting Instance Scheduling Options.

    Values:
      MIGRATE: <no description>
      TERMINATE: <no description>
    """
    MIGRATE = 0
    TERMINATE = 1

  automaticRestart = _messages.BooleanField(1)
  onHostMaintenance = _messages.EnumField('OnHostMaintenanceValueValuesEnum', 2)
  preemptible = _messages.BooleanField(3)


class SerialPortOutput(_messages.Message):
  """An instance's serial console output.

  Fields:
    contents: [Output Only] The contents of the console output.
    kind: [Output Only] Type of the resource. Always compute#serialPortOutput
      for serial port output.
    next: [Output Only] The position of the next byte of content from the
      serial console output. Use this value in the next request as the start
      parameter.
    selfLink: [Output Only] Server-defined URL for the resource.
    start: [Output Only] The starting byte position of the output that was
      returned. This should match the start parameter sent with the request.
      If the serial console output exceeds the size of the buffer, older
      output will be overwritten by newer content and the start values will be
      mismatched.
  """

  contents = _messages.StringField(1)
  kind = _messages.StringField(2, default=u'compute#serialPortOutput')
  next = _messages.IntegerField(3)
  selfLink = _messages.StringField(4)
  start = _messages.IntegerField(5)


class ServiceAccount(_messages.Message):
  """A service account.

  Fields:
    email: Email address of the service account.
    scopes: The list of scopes to be made available for this service account.
  """

  email = _messages.StringField(1)
  scopes = _messages.StringField(2, repeated=True)


class Snapshot(_messages.Message):
  """A persistent disk snapshot resource.

  Enums:
    StatusValueValuesEnum: [Output Only] The status of the snapshot. This can
      be CREATING, DELETING, FAILED, READY, or UPLOADING.
    StorageBytesStatusValueValuesEnum: [Output Only] An indicator whether
      storageBytes is in a stable state or it is being adjusted as a result of
      shared storage reallocation. This status can either be UPDATING, meaning
      the size of the snapshot is being updated, or UP_TO_DATE, meaning the
      size of the snapshot is up-to-date.

  Messages:
    LabelsValue: Labels to apply to this snapshot. These can be later modified
      by the setLabels method. Each label key/value pair must comply with
      RFC1035. Label values may be empty.

  Fields:
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    diskSizeGb: [Output Only] Size of the snapshot, specified in GB.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] Type of the resource. Always compute#snapshot for
      Snapshot resources.
    labelFingerprint: A fingerprint for the labels being applied to this
      snapshot, which is essentially a hash of the labels set used for
      optimistic locking. The fingerprint is initially generated by Compute
      Engine and changes after every request to modify or update labels. You
      must always provide an up-to-date fingerprint hash in order to update or
      change labels.  To see the latest fingerprint, make a get() request to
      retrieve a snapshot.
    labels: Labels to apply to this snapshot. These can be later modified by
      the setLabels method. Each label key/value pair must comply with
      RFC1035. Label values may be empty.
    licenses: [Output Only] A list of public visible licenses that apply to
      this snapshot. This can be because the original image had licenses
      attached (such as a Windows image).
    name: Name of the resource; provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    selfLink: [Output Only] Server-defined URL for the resource.
    snapshotEncryptionKey: Encrypts the snapshot using a customer-supplied
      encryption key.  After you encrypt a snapshot using a customer-supplied
      key, you must provide the same key if you use the image later For
      example, you must provide the encryption key when you create a disk from
      the encrypted snapshot in a future request.  Customer-supplied
      encryption keys do not protect access to metadata of the disk.  If you
      do not provide an encryption key when creating the snapshot, then the
      snapshot will be encrypted using an automatically generated key and you
      do not need to provide a key to use the snapshot later.
    sourceDisk: [Output Only] The source disk used to create this snapshot.
    sourceDiskEncryptionKey: The customer-supplied encryption key of the
      source disk. Required if the source disk is protected by a customer-
      supplied encryption key.
    sourceDiskId: [Output Only] The ID value of the disk used to create this
      snapshot. This value may be used to determine whether the snapshot was
      taken from the current or a previous instance of a given disk name.
    status: [Output Only] The status of the snapshot. This can be CREATING,
      DELETING, FAILED, READY, or UPLOADING.
    storageBytes: [Output Only] A size of the the storage used by the
      snapshot. As snapshots share storage, this number is expected to change
      with snapshot creation/deletion.
    storageBytesStatus: [Output Only] An indicator whether storageBytes is in
      a stable state or it is being adjusted as a result of shared storage
      reallocation. This status can either be UPDATING, meaning the size of
      the snapshot is being updated, or UP_TO_DATE, meaning the size of the
      snapshot is up-to-date.
  """

  class StatusValueValuesEnum(_messages.Enum):
    """[Output Only] The status of the snapshot. This can be CREATING,
    DELETING, FAILED, READY, or UPLOADING.

    Values:
      CREATING: <no description>
      DELETING: <no description>
      FAILED: <no description>
      READY: <no description>
      UPLOADING: <no description>
    """
    CREATING = 0
    DELETING = 1
    FAILED = 2
    READY = 3
    UPLOADING = 4

  class StorageBytesStatusValueValuesEnum(_messages.Enum):
    """[Output Only] An indicator whether storageBytes is in a stable state or
    it is being adjusted as a result of shared storage reallocation. This
    status can either be UPDATING, meaning the size of the snapshot is being
    updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.

    Values:
      UPDATING: <no description>
      UP_TO_DATE: <no description>
    """
    UPDATING = 0
    UP_TO_DATE = 1

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    """Labels to apply to this snapshot. These can be later modified by the
    setLabels method. Each label key/value pair must comply with RFC1035.
    Label values may be empty.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  creationTimestamp = _messages.StringField(1)
  description = _messages.StringField(2)
  diskSizeGb = _messages.IntegerField(3)
  id = _messages.IntegerField(4, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(5, default=u'compute#snapshot')
  labelFingerprint = _messages.BytesField(6)
  labels = _messages.MessageField('LabelsValue', 7)
  licenses = _messages.StringField(8, repeated=True)
  name = _messages.StringField(9)
  selfLink = _messages.StringField(10)
  snapshotEncryptionKey = _messages.MessageField('CustomerEncryptionKey', 11)
  sourceDisk = _messages.StringField(12)
  sourceDiskEncryptionKey = _messages.MessageField('CustomerEncryptionKey', 13)
  sourceDiskId = _messages.StringField(14)
  status = _messages.EnumField('StatusValueValuesEnum', 15)
  storageBytes = _messages.IntegerField(16)
  storageBytesStatus = _messages.EnumField('StorageBytesStatusValueValuesEnum', 17)


class SnapshotList(_messages.Message):
  """Contains a list of Snapshot resources.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: [Output Only] A list of Snapshot resources.
    kind: Type of resource.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('Snapshot', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#snapshotList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class SslCertificate(_messages.Message):
  """An SslCertificate resource. This resource provides a mechanism to upload
  an SSL key and certificate to the load balancer to serve secure connections
  from the user.

  Fields:
    certificate: A local certificate file. The certificate must be in PEM
      format. The certificate chain must be no greater than 5 certs long. The
      chain must include at least one intermediate cert.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] Type of the resource. Always compute#sslCertificate
      for SSL certificates.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    privateKey: A write-only private key in PEM format. Only insert RPCs will
      include this field.
    selfLink: [Output only] Server-defined URL for the resource.
  """

  certificate = _messages.StringField(1)
  creationTimestamp = _messages.StringField(2)
  description = _messages.StringField(3)
  id = _messages.IntegerField(4, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(5, default=u'compute#sslCertificate')
  name = _messages.StringField(6)
  privateKey = _messages.StringField(7)
  selfLink = _messages.StringField(8)


class SslCertificateList(_messages.Message):
  """Contains a list of SslCertificate resources.

  Fields:
    id: [Output Only] Unique identifier for the resource. Defined by the
      server.
    items: A list of SslCertificate resources.
    kind: Type of resource.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('SslCertificate', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#sslCertificateList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class StandardQueryParameters(_messages.Message):
  """Query parameters accepted by all methods.

  Enums:
    AltValueValuesEnum: Data format for the response.

  Fields:
    alt: Data format for the response.
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters. Overrides userIp if both are provided.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    userIp: IP address of the site where the request originates. Use this if
      you want to enforce per-user limits.
  """

  class AltValueValuesEnum(_messages.Enum):
    """Data format for the response.

    Values:
      json: Responses with Content-Type of application/json
    """
    json = 0

  alt = _messages.EnumField('AltValueValuesEnum', 1, default=u'json')
  fields = _messages.StringField(2)
  key = _messages.StringField(3)
  oauth_token = _messages.StringField(4)
  prettyPrint = _messages.BooleanField(5, default=True)
  quotaUser = _messages.StringField(6)
  trace = _messages.StringField(7)
  userIp = _messages.StringField(8)


class Subnetwork(_messages.Message):
  """A Subnetwork resource.

  Fields:
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    gatewayAddress: [Output Only] The gateway address for default routes to
      reach destination addresses outside this subnetwork.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    ipCidrRange: The range of internal addresses that are owned by this
      subnetwork. Provide this property when you create the subnetwork. For
      example, 10.0.0.0/8 or 192.168.0.0/16. Ranges must be unique and non-
      overlapping within a network.
    kind: [Output Only] Type of the resource. Always compute#subnetwork for
      Subnetwork resources.
    name: The name of the resource, provided by the client when initially
      creating the resource. The name must be 1-63 characters long, and comply
      with RFC1035. Specifically, the name must be 1-63 characters long and
      match the regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the
      first character must be a lowercase letter, and all following characters
      must be a dash, lowercase letter, or digit, except the last character,
      which cannot be a dash.
    network: The URL of the network to which this subnetwork belongs, provided
      by the client when initially creating the subnetwork. Only networks that
      are in the distributed mode can have subnetworks.
    privateIpGoogleAccess: Whether the VMs in this subnet can access Google
      services without assigned external IP addresses.
    region: URL of the region where the Subnetwork resides.
    selfLink: [Output Only] Server-defined URL for the resource.
  """

  creationTimestamp = _messages.StringField(1)
  description = _messages.StringField(2)
  gatewayAddress = _messages.StringField(3)
  id = _messages.IntegerField(4, variant=_messages.Variant.UINT64)
  ipCidrRange = _messages.StringField(5)
  kind = _messages.StringField(6, default=u'compute#subnetwork')
  name = _messages.StringField(7)
  network = _messages.StringField(8)
  privateIpGoogleAccess = _messages.BooleanField(9)
  region = _messages.StringField(10)
  selfLink = _messages.StringField(11)


class SubnetworkAggregatedList(_messages.Message):
  """A SubnetworkAggregatedList object.

  Messages:
    ItemsValue: [Output] A map of scoped Subnetwork lists.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: [Output] A map of scoped Subnetwork lists.
    kind: [Output Only] Type of resource. Always
      compute#subnetworkAggregatedList for aggregated lists of subnetworks.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    """[Output] A map of scoped Subnetwork lists.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: Name of the scope containing this set of
        Subnetworks.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A SubnetworksScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('SubnetworksScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default=u'compute#subnetworkAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class SubnetworkList(_messages.Message):
  """Contains a list of Subnetwork resources.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: The Subnetwork resources.
    kind: [Output Only] Type of resource. Always compute#subnetworkList for
      lists of subnetworks.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('Subnetwork', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#subnetworkList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class SubnetworksExpandIpCidrRangeRequest(_messages.Message):
  """A SubnetworksExpandIpCidrRangeRequest object.

  Fields:
    ipCidrRange: A string attribute.
  """

  ipCidrRange = _messages.StringField(1)


class SubnetworksScopedList(_messages.Message):
  """A SubnetworksScopedList object.

  Messages:
    WarningValue: An informational warning that appears when the list of
      addresses is empty.

  Fields:
    subnetworks: List of subnetworks contained in this scope.
    warning: An informational warning that appears when the list of addresses
      is empty.
  """

  class WarningValue(_messages.Message):
    """An informational warning that appears when the list of addresses is
    empty.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      """[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 2
      INJECTED_KERNELS_DEPRECATED = 3
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 4
      NEXT_HOP_CANNOT_IP_FORWARD = 5
      NEXT_HOP_INSTANCE_NOT_FOUND = 6
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 7
      NEXT_HOP_NOT_RUNNING = 8
      NOT_CRITICAL_ERROR = 9
      NO_RESULTS_ON_PAGE = 10
      REQUIRED_TOS_AGREEMENT = 11
      RESOURCE_NOT_DELETED = 12
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 13
      UNREACHABLE = 14

    class DataValueListEntry(_messages.Message):
      """A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  subnetworks = _messages.MessageField('Subnetwork', 1, repeated=True)
  warning = _messages.MessageField('WarningValue', 2)


class TCPHealthCheck(_messages.Message):
  """A TCPHealthCheck object.

  Enums:
    ProxyHeaderValueValuesEnum: Specifies the type of proxy header to append
      before sending data to the backend, either NONE or PROXY_V1. The default
      is NONE.

  Fields:
    port: The TCP port number for the health check request. The default value
      is 80.
    portName: Port name as defined in InstanceGroup#NamedPort#name. If both
      port and port_name are defined, port takes precedence.
    proxyHeader: Specifies the type of proxy header to append before sending
      data to the backend, either NONE or PROXY_V1. The default is NONE.
    request: The application data to send once the TCP connection has been
      established (default value is empty). If both request and response are
      empty, the connection establishment alone will indicate health. The
      request data can only be ASCII.
    response: The bytes to match against the beginning of the response data.
      If left empty (the default value), any response will indicate health.
      The response data can only be ASCII.
  """

  class ProxyHeaderValueValuesEnum(_messages.Enum):
    """Specifies the type of proxy header to append before sending data to the
    backend, either NONE or PROXY_V1. The default is NONE.

    Values:
      NONE: <no description>
      PROXY_V1: <no description>
    """
    NONE = 0
    PROXY_V1 = 1

  port = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  portName = _messages.StringField(2)
  proxyHeader = _messages.EnumField('ProxyHeaderValueValuesEnum', 3)
  request = _messages.StringField(4)
  response = _messages.StringField(5)


class Tags(_messages.Message):
  """A set of instance tags.

  Fields:
    fingerprint: Specifies a fingerprint for this request, which is
      essentially a hash of the metadata's contents and used for optimistic
      locking. The fingerprint is initially generated by Compute Engine and
      changes after every request to modify or update metadata. You must
      always provide an up-to-date fingerprint hash in order to update or
      change metadata.  To see the latest fingerprint, make get() request to
      the instance.
    items: An array of tags. Each tag must be 1-63 characters long, and comply
      with RFC1035.
  """

  fingerprint = _messages.BytesField(1)
  items = _messages.StringField(2, repeated=True)


class TargetHttpProxy(_messages.Message):
  """A TargetHttpProxy resource. This resource defines an HTTP proxy.

  Fields:
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] Type of resource. Always compute#targetHttpProxy for
      target HTTP proxies.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    selfLink: [Output Only] Server-defined URL for the resource.
    urlMap: URL to the UrlMap resource that defines the mapping from URL to
      the BackendService.
  """

  creationTimestamp = _messages.StringField(1)
  description = _messages.StringField(2)
  id = _messages.IntegerField(3, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(4, default=u'compute#targetHttpProxy')
  name = _messages.StringField(5)
  selfLink = _messages.StringField(6)
  urlMap = _messages.StringField(7)


class TargetHttpProxyList(_messages.Message):
  """A list of TargetHttpProxy resources.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: A list of TargetHttpProxy resources.
    kind: Type of resource. Always compute#targetHttpProxyList for lists of
      target HTTP proxies.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('TargetHttpProxy', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#targetHttpProxyList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class TargetHttpsProxiesSetSslCertificatesRequest(_messages.Message):
  """A TargetHttpsProxiesSetSslCertificatesRequest object.

  Fields:
    sslCertificates: New set of SslCertificate resources to associate with
      this TargetHttpsProxy resource. Currently exactly one SslCertificate
      resource must be specified.
  """

  sslCertificates = _messages.StringField(1, repeated=True)


class TargetHttpsProxy(_messages.Message):
  """A TargetHttpsProxy resource. This resource defines an HTTPS proxy.

  Fields:
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] Type of resource. Always compute#targetHttpsProxy for
      target HTTPS proxies.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    selfLink: [Output Only] Server-defined URL for the resource.
    sslCertificates: URLs to SslCertificate resources that are used to
      authenticate connections between users and the load balancer. Currently,
      exactly one SSL certificate must be specified.
    urlMap: A fully-qualified or valid partial URL to the UrlMap resource that
      defines the mapping from URL to the BackendService. For example, the
      following are all valid URLs for specifying a URL map:   -
      https://www.googleapis.compute/v1/projects/project/global/urlMaps/url-
      map  - projects/project/global/urlMaps/url-map  - global/urlMaps/url-map
  """

  creationTimestamp = _messages.StringField(1)
  description = _messages.StringField(2)
  id = _messages.IntegerField(3, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(4, default=u'compute#targetHttpsProxy')
  name = _messages.StringField(5)
  selfLink = _messages.StringField(6)
  sslCertificates = _messages.StringField(7, repeated=True)
  urlMap = _messages.StringField(8)


class TargetHttpsProxyList(_messages.Message):
  """Contains a list of TargetHttpsProxy resources.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: A list of TargetHttpsProxy resources.
    kind: Type of resource. Always compute#targetHttpsProxyList for lists of
      target HTTPS proxies.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('TargetHttpsProxy', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#targetHttpsProxyList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class TargetInstance(_messages.Message):
  """A TargetInstance resource. This resource defines an endpoint instance
  that terminates traffic of certain protocols.

  Enums:
    NatPolicyValueValuesEnum: NAT option controlling how IPs are NAT'ed to the
      instance. Currently only NO_NAT (default value) is supported.

  Fields:
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    instance: A URL to the virtual machine instance that handles traffic for
      this target instance. When creating a target instance, you can provide
      the fully-qualified URL or a valid partial URL to the desired virtual
      machine. For example, the following are all valid URLs:  - https://www.g
      oogleapis.com/compute/v1/projects/project/zones/zone/instances/instance
      - projects/project/zones/zone/instances/instance  -
      zones/zone/instances/instance
    kind: [Output Only] The type of the resource. Always
      compute#targetInstance for target instances.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    natPolicy: NAT option controlling how IPs are NAT'ed to the instance.
      Currently only NO_NAT (default value) is supported.
    selfLink: [Output Only] Server-defined URL for the resource.
    zone: [Output Only] URL of the zone where the target instance resides.
  """

  class NatPolicyValueValuesEnum(_messages.Enum):
    """NAT option controlling how IPs are NAT'ed to the instance. Currently
    only NO_NAT (default value) is supported.

    Values:
      NO_NAT: <no description>
    """
    NO_NAT = 0

  creationTimestamp = _messages.StringField(1)
  description = _messages.StringField(2)
  id = _messages.IntegerField(3, variant=_messages.Variant.UINT64)
  instance = _messages.StringField(4)
  kind = _messages.StringField(5, default=u'compute#targetInstance')
  name = _messages.StringField(6)
  natPolicy = _messages.EnumField('NatPolicyValueValuesEnum', 7)
  selfLink = _messages.StringField(8)
  zone = _messages.StringField(9)


class TargetInstanceAggregatedList(_messages.Message):
  """A TargetInstanceAggregatedList object.

  Messages:
    ItemsValue: A map of scoped target instance lists.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A map of scoped target instance lists.
    kind: Type of resource.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    """A map of scoped target instance lists.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: Name of the scope containing this set of target
        instances.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A TargetInstancesScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('TargetInstancesScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default=u'compute#targetInstanceAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class TargetInstanceList(_messages.Message):
  """Contains a list of TargetInstance resources.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: A list of TargetInstance resources.
    kind: Type of resource.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('TargetInstance', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#targetInstanceList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class TargetInstancesScopedList(_messages.Message):
  """A TargetInstancesScopedList object.

  Messages:
    WarningValue: Informational warning which replaces the list of addresses
      when the list is empty.

  Fields:
    targetInstances: List of target instances contained in this scope.
    warning: Informational warning which replaces the list of addresses when
      the list is empty.
  """

  class WarningValue(_messages.Message):
    """Informational warning which replaces the list of addresses when the
    list is empty.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      """[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 2
      INJECTED_KERNELS_DEPRECATED = 3
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 4
      NEXT_HOP_CANNOT_IP_FORWARD = 5
      NEXT_HOP_INSTANCE_NOT_FOUND = 6
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 7
      NEXT_HOP_NOT_RUNNING = 8
      NOT_CRITICAL_ERROR = 9
      NO_RESULTS_ON_PAGE = 10
      REQUIRED_TOS_AGREEMENT = 11
      RESOURCE_NOT_DELETED = 12
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 13
      UNREACHABLE = 14

    class DataValueListEntry(_messages.Message):
      """A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  targetInstances = _messages.MessageField('TargetInstance', 1, repeated=True)
  warning = _messages.MessageField('WarningValue', 2)


class TargetPool(_messages.Message):
  """A TargetPool resource. This resource defines a pool of instances,
  associated HttpHealthCheck resources, and the fallback target pool.

  Enums:
    SessionAffinityValueValuesEnum: Sesssion affinity option, must be one of
      the following values: NONE: Connections from the same client IP may go
      to any instance in the pool. CLIENT_IP: Connections from the same client
      IP will go to the same instance in the pool while that instance remains
      healthy. CLIENT_IP_PROTO: Connections from the same client IP with the
      same IP protocol will go to the same instance in the pool while that
      instance remains healthy.

  Fields:
    backupPool: This field is applicable only when the containing target pool
      is serving a forwarding rule as the primary pool, and its failoverRatio
      field is properly set to a value between [0, 1].  backupPool and
      failoverRatio together define the fallback behavior of the primary
      target pool: if the ratio of the healthy instances in the primary pool
      is at or below failoverRatio, traffic arriving at the load-balanced IP
      will be directed to the backup pool.  In case where failoverRatio and
      backupPool are not set, or all the instances in the backup pool are
      unhealthy, the traffic will be directed back to the primary pool in the
      "force" mode, where traffic will be spread to the healthy instances with
      the best effort, or to all instances when no instance is healthy.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    failoverRatio: This field is applicable only when the containing target
      pool is serving a forwarding rule as the primary pool (i.e., not as a
      backup pool to some other target pool). The value of the field must be
      in [0, 1].  If set, backupPool must also be set. They together define
      the fallback behavior of the primary target pool: if the ratio of the
      healthy instances in the primary pool is at or below this number,
      traffic arriving at the load-balanced IP will be directed to the backup
      pool.  In case where failoverRatio is not set or all the instances in
      the backup pool are unhealthy, the traffic will be directed back to the
      primary pool in the "force" mode, where traffic will be spread to the
      healthy instances with the best effort, or to all instances when no
      instance is healthy.
    healthChecks: A list of URLs to the HttpHealthCheck resource. A member
      instance in this pool is considered healthy if and only if all specified
      health checks pass. An empty list means all member instances will be
      considered healthy at all times.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    instances: A list of resource URLs to the virtual machine instances
      serving this pool. They must live in zones contained in the same region
      as this pool.
    kind: [Output Only] Type of the resource. Always compute#targetPool for
      target pools.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    region: [Output Only] URL of the region where the target pool resides.
    selfLink: [Output Only] Server-defined URL for the resource.
    sessionAffinity: Sesssion affinity option, must be one of the following
      values: NONE: Connections from the same client IP may go to any instance
      in the pool. CLIENT_IP: Connections from the same client IP will go to
      the same instance in the pool while that instance remains healthy.
      CLIENT_IP_PROTO: Connections from the same client IP with the same IP
      protocol will go to the same instance in the pool while that instance
      remains healthy.
  """

  class SessionAffinityValueValuesEnum(_messages.Enum):
    """Sesssion affinity option, must be one of the following values: NONE:
    Connections from the same client IP may go to any instance in the pool.
    CLIENT_IP: Connections from the same client IP will go to the same
    instance in the pool while that instance remains healthy. CLIENT_IP_PROTO:
    Connections from the same client IP with the same IP protocol will go to
    the same instance in the pool while that instance remains healthy.

    Values:
      CLIENT_IP: <no description>
      CLIENT_IP_PORT_PROTO: <no description>
      CLIENT_IP_PROTO: <no description>
      GENERATED_COOKIE: <no description>
      NONE: <no description>
    """
    CLIENT_IP = 0
    CLIENT_IP_PORT_PROTO = 1
    CLIENT_IP_PROTO = 2
    GENERATED_COOKIE = 3
    NONE = 4

  backupPool = _messages.StringField(1)
  creationTimestamp = _messages.StringField(2)
  description = _messages.StringField(3)
  failoverRatio = _messages.FloatField(4, variant=_messages.Variant.FLOAT)
  healthChecks = _messages.StringField(5, repeated=True)
  id = _messages.IntegerField(6, variant=_messages.Variant.UINT64)
  instances = _messages.StringField(7, repeated=True)
  kind = _messages.StringField(8, default=u'compute#targetPool')
  name = _messages.StringField(9)
  region = _messages.StringField(10)
  selfLink = _messages.StringField(11)
  sessionAffinity = _messages.EnumField('SessionAffinityValueValuesEnum', 12)


class TargetPoolAggregatedList(_messages.Message):
  """A TargetPoolAggregatedList object.

  Messages:
    ItemsValue: [Output Only] A map of scoped target pool lists.

  Fields:
    id: [Output Only] Unique identifier for the resource. Defined by the
      server.
    items: [Output Only] A map of scoped target pool lists.
    kind: [Output Only] Type of resource. Always
      compute#targetPoolAggregatedList for aggregated lists of target pools.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    """[Output Only] A map of scoped target pool lists.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: Name of the scope containing this set of target
        pools.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A TargetPoolsScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('TargetPoolsScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default=u'compute#targetPoolAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class TargetPoolInstanceHealth(_messages.Message):
  """A TargetPoolInstanceHealth object.

  Fields:
    healthStatus: A HealthStatus attribute.
    kind: [Output Only] Type of resource. Always
      compute#targetPoolInstanceHealth when checking the health of an
      instance.
  """

  healthStatus = _messages.MessageField('HealthStatus', 1, repeated=True)
  kind = _messages.StringField(2, default=u'compute#targetPoolInstanceHealth')


class TargetPoolList(_messages.Message):
  """Contains a list of TargetPool resources.

  Fields:
    id: [Output Only] Unique identifier for the resource. Defined by the
      server.
    items: A list of TargetPool resources.
    kind: [Output Only] Type of resource. Always compute#targetPoolList for
      lists of target pools.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('TargetPool', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#targetPoolList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class TargetPoolsAddHealthCheckRequest(_messages.Message):
  """A TargetPoolsAddHealthCheckRequest object.

  Fields:
    healthChecks: A list of HttpHealthCheck resources to add to the target
      pool.
  """

  healthChecks = _messages.MessageField('HealthCheckReference', 1, repeated=True)


class TargetPoolsAddInstanceRequest(_messages.Message):
  """A TargetPoolsAddInstanceRequest object.

  Fields:
    instances: A full or partial URL to an instance to add to this target
      pool. This can be a full or partial URL. For example, the following are
      valid URLs:   - https://www.googleapis.com/compute/v1/projects/project-
      id/zones/zone/instances/instance-name  - projects/project-
      id/zones/zone/instances/instance-name  - zones/zone/instances/instance-
      name
  """

  instances = _messages.MessageField('InstanceReference', 1, repeated=True)


class TargetPoolsRemoveHealthCheckRequest(_messages.Message):
  """A TargetPoolsRemoveHealthCheckRequest object.

  Fields:
    healthChecks: Health check URL to be removed. This can be a full or valid
      partial URL. For example, the following are valid URLs:   - https://www.
      googleapis.com/compute/beta/projects/project/global/httpHealthChecks
      /health-check  - projects/project/global/httpHealthChecks/health-check
      - global/httpHealthChecks/health-check
  """

  healthChecks = _messages.MessageField('HealthCheckReference', 1, repeated=True)


class TargetPoolsRemoveInstanceRequest(_messages.Message):
  """A TargetPoolsRemoveInstanceRequest object.

  Fields:
    instances: URLs of the instances to be removed from target pool.
  """

  instances = _messages.MessageField('InstanceReference', 1, repeated=True)


class TargetPoolsScopedList(_messages.Message):
  """A TargetPoolsScopedList object.

  Messages:
    WarningValue: Informational warning which replaces the list of addresses
      when the list is empty.

  Fields:
    targetPools: List of target pools contained in this scope.
    warning: Informational warning which replaces the list of addresses when
      the list is empty.
  """

  class WarningValue(_messages.Message):
    """Informational warning which replaces the list of addresses when the
    list is empty.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      """[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 2
      INJECTED_KERNELS_DEPRECATED = 3
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 4
      NEXT_HOP_CANNOT_IP_FORWARD = 5
      NEXT_HOP_INSTANCE_NOT_FOUND = 6
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 7
      NEXT_HOP_NOT_RUNNING = 8
      NOT_CRITICAL_ERROR = 9
      NO_RESULTS_ON_PAGE = 10
      REQUIRED_TOS_AGREEMENT = 11
      RESOURCE_NOT_DELETED = 12
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 13
      UNREACHABLE = 14

    class DataValueListEntry(_messages.Message):
      """A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  targetPools = _messages.MessageField('TargetPool', 1, repeated=True)
  warning = _messages.MessageField('WarningValue', 2)


class TargetReference(_messages.Message):
  """A TargetReference object.

  Fields:
    target: A string attribute.
  """

  target = _messages.StringField(1)


class TargetSslProxiesSetBackendServiceRequest(_messages.Message):
  """A TargetSslProxiesSetBackendServiceRequest object.

  Fields:
    service: The URL of the new BackendService resource for the
      targetSslProxy.
  """

  service = _messages.StringField(1)


class TargetSslProxiesSetProxyHeaderRequest(_messages.Message):
  """A TargetSslProxiesSetProxyHeaderRequest object.

  Enums:
    ProxyHeaderValueValuesEnum: The new type of proxy header to append before
      sending data to the backend. NONE or PROXY_V1 are allowed.

  Fields:
    proxyHeader: The new type of proxy header to append before sending data to
      the backend. NONE or PROXY_V1 are allowed.
  """

  class ProxyHeaderValueValuesEnum(_messages.Enum):
    """The new type of proxy header to append before sending data to the
    backend. NONE or PROXY_V1 are allowed.

    Values:
      NONE: <no description>
      PROXY_V1: <no description>
    """
    NONE = 0
    PROXY_V1 = 1

  proxyHeader = _messages.EnumField('ProxyHeaderValueValuesEnum', 1)


class TargetSslProxiesSetSslCertificatesRequest(_messages.Message):
  """A TargetSslProxiesSetSslCertificatesRequest object.

  Fields:
    sslCertificates: New set of URLs to SslCertificate resources to associate
      with this TargetSslProxy. Currently exactly one ssl certificate must be
      specified.
  """

  sslCertificates = _messages.StringField(1, repeated=True)


class TargetSslProxy(_messages.Message):
  """A TargetSslProxy resource. This resource defines an SSL proxy.

  Enums:
    ProxyHeaderValueValuesEnum: Specifies the type of proxy header to append
      before sending data to the backend, either NONE or PROXY_V1. The default
      is NONE.

  Fields:
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] Type of the resource. Always compute#targetSslProxy
      for target SSL proxies.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    proxyHeader: Specifies the type of proxy header to append before sending
      data to the backend, either NONE or PROXY_V1. The default is NONE.
    selfLink: [Output Only] Server-defined URL for the resource.
    service: URL to the BackendService resource.
    sslCertificates: URLs to SslCertificate resources that are used to
      authenticate connections to Backends. Currently exactly one SSL
      certificate must be specified.
  """

  class ProxyHeaderValueValuesEnum(_messages.Enum):
    """Specifies the type of proxy header to append before sending data to the
    backend, either NONE or PROXY_V1. The default is NONE.

    Values:
      NONE: <no description>
      PROXY_V1: <no description>
    """
    NONE = 0
    PROXY_V1 = 1

  creationTimestamp = _messages.StringField(1)
  description = _messages.StringField(2)
  id = _messages.IntegerField(3, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(4, default=u'compute#targetSslProxy')
  name = _messages.StringField(5)
  proxyHeader = _messages.EnumField('ProxyHeaderValueValuesEnum', 6)
  selfLink = _messages.StringField(7)
  service = _messages.StringField(8)
  sslCertificates = _messages.StringField(9, repeated=True)


class TargetSslProxyList(_messages.Message):
  """Contains a list of TargetSslProxy resources.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: A list of TargetSslProxy resources.
    kind: Type of resource.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('TargetSslProxy', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#targetSslProxyList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class TargetVpnGateway(_messages.Message):
  """Represents a Target VPN gateway resource.

  Enums:
    StatusValueValuesEnum: [Output Only] The status of the VPN gateway.

  Fields:
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    forwardingRules: [Output Only] A list of URLs to the ForwardingRule
      resources. ForwardingRules are created using
      compute.forwardingRules.insert and associated to a VPN gateway.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] Type of resource. Always compute#targetVpnGateway for
      target VPN gateways.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    network: URL of the network to which this VPN gateway is attached.
      Provided by the client when the VPN gateway is created.
    region: [Output Only] URL of the region where the target VPN gateway
      resides.
    selfLink: [Output Only] Server-defined URL for the resource.
    status: [Output Only] The status of the VPN gateway.
    tunnels: [Output Only] A list of URLs to VpnTunnel resources. VpnTunnels
      are created using compute.vpntunnels.insert method and associated to a
      VPN gateway.
  """

  class StatusValueValuesEnum(_messages.Enum):
    """[Output Only] The status of the VPN gateway.

    Values:
      CREATING: <no description>
      DELETING: <no description>
      FAILED: <no description>
      READY: <no description>
    """
    CREATING = 0
    DELETING = 1
    FAILED = 2
    READY = 3

  creationTimestamp = _messages.StringField(1)
  description = _messages.StringField(2)
  forwardingRules = _messages.StringField(3, repeated=True)
  id = _messages.IntegerField(4, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(5, default=u'compute#targetVpnGateway')
  name = _messages.StringField(6)
  network = _messages.StringField(7)
  region = _messages.StringField(8)
  selfLink = _messages.StringField(9)
  status = _messages.EnumField('StatusValueValuesEnum', 10)
  tunnels = _messages.StringField(11, repeated=True)


class TargetVpnGatewayAggregatedList(_messages.Message):
  """A TargetVpnGatewayAggregatedList object.

  Messages:
    ItemsValue: A map of scoped target vpn gateway lists.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: A map of scoped target vpn gateway lists.
    kind: [Output Only] Type of resource. Always compute#targetVpnGateway for
      target VPN gateways.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for the resource.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    """A map of scoped target vpn gateway lists.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: [Output Only] Name of the scope containing this
        set of target VPN gateways.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A TargetVpnGatewaysScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('TargetVpnGatewaysScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default=u'compute#targetVpnGatewayAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class TargetVpnGatewayList(_messages.Message):
  """Contains a list of TargetVpnGateway resources.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: [Output Only] A list of TargetVpnGateway resources.
    kind: [Output Only] Type of resource. Always compute#targetVpnGateway for
      target VPN gateways.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for the resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('TargetVpnGateway', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#targetVpnGatewayList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class TargetVpnGatewaysScopedList(_messages.Message):
  """A TargetVpnGatewaysScopedList object.

  Messages:
    WarningValue: [Output Only] Informational warning which replaces the list
      of addresses when the list is empty.

  Fields:
    targetVpnGateways: [Output Only] List of target vpn gateways contained in
      this scope.
    warning: [Output Only] Informational warning which replaces the list of
      addresses when the list is empty.
  """

  class WarningValue(_messages.Message):
    """[Output Only] Informational warning which replaces the list of
    addresses when the list is empty.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      """[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 2
      INJECTED_KERNELS_DEPRECATED = 3
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 4
      NEXT_HOP_CANNOT_IP_FORWARD = 5
      NEXT_HOP_INSTANCE_NOT_FOUND = 6
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 7
      NEXT_HOP_NOT_RUNNING = 8
      NOT_CRITICAL_ERROR = 9
      NO_RESULTS_ON_PAGE = 10
      REQUIRED_TOS_AGREEMENT = 11
      RESOURCE_NOT_DELETED = 12
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 13
      UNREACHABLE = 14

    class DataValueListEntry(_messages.Message):
      """A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  targetVpnGateways = _messages.MessageField('TargetVpnGateway', 1, repeated=True)
  warning = _messages.MessageField('WarningValue', 2)


class TestFailure(_messages.Message):
  """A TestFailure object.

  Fields:
    actualService: A string attribute.
    expectedService: A string attribute.
    host: A string attribute.
    path: A string attribute.
  """

  actualService = _messages.StringField(1)
  expectedService = _messages.StringField(2)
  host = _messages.StringField(3)
  path = _messages.StringField(4)


class TestPermissionsRequest(_messages.Message):
  """A TestPermissionsRequest object.

  Fields:
    permissions: The set of permissions to check for the 'resource'.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class TestPermissionsResponse(_messages.Message):
  """A TestPermissionsResponse object.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class UrlMap(_messages.Message):
  """A UrlMap resource. This resource defines the mapping from URL to the
  BackendService resource, based on the "longest-match" of the URL's host and
  path.

  Fields:
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    defaultService: The URL of the BackendService resource if none of the
      hostRules match.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    fingerprint: Fingerprint of this resource. A hash of the contents stored
      in this object. This field is used in optimistic locking. This field
      will be ignored when inserting a UrlMap. An up-to-date fingerprint must
      be provided in order to update the UrlMap.
    hostRules: The list of HostRules to use against the URL.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] Type of the resource. Always compute#urlMaps for url
      maps.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    pathMatchers: The list of named PathMatchers to use against the URL.
    selfLink: [Output Only] Server-defined URL for the resource.
    tests: The list of expected URL mappings. Request to update this UrlMap
      will succeed only if all of the test cases pass.
  """

  creationTimestamp = _messages.StringField(1)
  defaultService = _messages.StringField(2)
  description = _messages.StringField(3)
  fingerprint = _messages.BytesField(4)
  hostRules = _messages.MessageField('HostRule', 5, repeated=True)
  id = _messages.IntegerField(6, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(7, default=u'compute#urlMap')
  name = _messages.StringField(8)
  pathMatchers = _messages.MessageField('PathMatcher', 9, repeated=True)
  selfLink = _messages.StringField(10)
  tests = _messages.MessageField('UrlMapTest', 11, repeated=True)


class UrlMapList(_messages.Message):
  """Contains a list of UrlMap resources.

  Fields:
    id: [Output Only] Unique identifier for the resource. Set by the server.
    items: A list of UrlMap resources.
    kind: Type of resource.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('UrlMap', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#urlMapList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class UrlMapReference(_messages.Message):
  """A UrlMapReference object.

  Fields:
    urlMap: A string attribute.
  """

  urlMap = _messages.StringField(1)


class UrlMapTest(_messages.Message):
  """Message for the expected URL mappings.

  Fields:
    description: Description of this test case.
    host: Host portion of the URL.
    path: Path portion of the URL.
    service: Expected BackendService resource the given URL should be mapped
      to.
  """

  description = _messages.StringField(1)
  host = _messages.StringField(2)
  path = _messages.StringField(3)
  service = _messages.StringField(4)


class UrlMapValidationResult(_messages.Message):
  """Message representing the validation result for a UrlMap.

  Fields:
    loadErrors: A string attribute.
    loadSucceeded: Whether the given UrlMap can be successfully loaded. If
      false, 'loadErrors' indicates the reasons.
    testFailures: A TestFailure attribute.
    testPassed: If successfully loaded, this field indicates whether the test
      passed. If false, 'testFailures's indicate the reason of failure.
  """

  loadErrors = _messages.StringField(1, repeated=True)
  loadSucceeded = _messages.BooleanField(2)
  testFailures = _messages.MessageField('TestFailure', 3, repeated=True)
  testPassed = _messages.BooleanField(4)


class UrlMapsValidateRequest(_messages.Message):
  """A UrlMapsValidateRequest object.

  Fields:
    resource: Content of the UrlMap to be validated.
  """

  resource = _messages.MessageField('UrlMap', 1)


class UrlMapsValidateResponse(_messages.Message):
  """A UrlMapsValidateResponse object.

  Fields:
    result: A UrlMapValidationResult attribute.
  """

  result = _messages.MessageField('UrlMapValidationResult', 1)


class UsageExportLocation(_messages.Message):
  """The location in Cloud Storage and naming method of the daily usage
  report. Contains bucket_name and report_name prefix.

  Fields:
    bucketName: The name of an existing bucket in Cloud Storage where the
      usage report object is stored. The Google Service Account is granted
      write access to this bucket. This can either be the bucket name by
      itself, such as example-bucket, or the bucket name with gs:// or
      https://storage.googleapis.com/ in front of it, such as gs://example-
      bucket.
    reportNamePrefix: An optional prefix for the name of the usage report
      object stored in bucketName. If not supplied, defaults to usage. The
      report is stored as a CSV file named report_name_prefix_gce_YYYYMMDD.csv
      where YYYYMMDD is the day of the usage according to Pacific Time. If you
      supply a prefix, it should conform to Cloud Storage object naming
      conventions.
  """

  bucketName = _messages.StringField(1)
  reportNamePrefix = _messages.StringField(2)


class VpnTunnel(_messages.Message):
  """A VpnTunnel object.

  Enums:
    StatusValueValuesEnum: [Output Only] The status of the VPN tunnel.

  Fields:
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    detailedStatus: [Output Only] Detailed status message for the VPN tunnel.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    ikeVersion: IKE protocol version to use when establishing the VPN tunnel
      with peer VPN gateway. Acceptable IKE versions are 1 or 2. Default
      version is 2.
    kind: [Output Only] Type of resource. Always compute#vpnTunnel for VPN
      tunnels.
    localTrafficSelector: Local traffic selector to use when establishing the
      VPN tunnel with peer VPN gateway. The value should be a CIDR formatted
      string, for example: 192.168.0.0/16. The ranges should be disjoint.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    peerIp: IP address of the peer VPN gateway.
    region: [Output Only] URL of the region where the VPN tunnel resides.
    remoteTrafficSelector: Remote traffic selectors to use when establishing
      the VPN tunnel with peer VPN gateway. The value should be a CIDR
      formatted string, for example: 192.168.0.0/16. The ranges should be
      disjoint.
    router: URL of router resource to be used for dynamic routing.
    selfLink: [Output Only] Server-defined URL for the resource.
    sharedSecret: Shared secret used to set the secure session between the
      Cloud VPN gateway and the peer VPN gateway.
    sharedSecretHash: Hash of the shared secret.
    status: [Output Only] The status of the VPN tunnel.
    targetVpnGateway: URL of the VPN gateway with which this VPN tunnel is
      associated. Provided by the client when the VPN tunnel is created.
  """

  class StatusValueValuesEnum(_messages.Enum):
    """[Output Only] The status of the VPN tunnel.

    Values:
      ALLOCATING_RESOURCES: <no description>
      AUTHORIZATION_ERROR: <no description>
      DEPROVISIONING: <no description>
      ESTABLISHED: <no description>
      FAILED: <no description>
      FIRST_HANDSHAKE: <no description>
      NEGOTIATION_FAILURE: <no description>
      NETWORK_ERROR: <no description>
      NO_INCOMING_PACKETS: <no description>
      PROVISIONING: <no description>
      REJECTED: <no description>
      WAITING_FOR_FULL_CONFIG: <no description>
    """
    ALLOCATING_RESOURCES = 0
    AUTHORIZATION_ERROR = 1
    DEPROVISIONING = 2
    ESTABLISHED = 3
    FAILED = 4
    FIRST_HANDSHAKE = 5
    NEGOTIATION_FAILURE = 6
    NETWORK_ERROR = 7
    NO_INCOMING_PACKETS = 8
    PROVISIONING = 9
    REJECTED = 10
    WAITING_FOR_FULL_CONFIG = 11

  creationTimestamp = _messages.StringField(1)
  description = _messages.StringField(2)
  detailedStatus = _messages.StringField(3)
  id = _messages.IntegerField(4, variant=_messages.Variant.UINT64)
  ikeVersion = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  kind = _messages.StringField(6, default=u'compute#vpnTunnel')
  localTrafficSelector = _messages.StringField(7, repeated=True)
  name = _messages.StringField(8)
  peerIp = _messages.StringField(9)
  region = _messages.StringField(10)
  remoteTrafficSelector = _messages.StringField(11, repeated=True)
  router = _messages.StringField(12)
  selfLink = _messages.StringField(13)
  sharedSecret = _messages.StringField(14)
  sharedSecretHash = _messages.StringField(15)
  status = _messages.EnumField('StatusValueValuesEnum', 16)
  targetVpnGateway = _messages.StringField(17)


class VpnTunnelAggregatedList(_messages.Message):
  """A VpnTunnelAggregatedList object.

  Messages:
    ItemsValue: [Output Only] A map of scoped vpn tunnel lists.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: [Output Only] A map of scoped vpn tunnel lists.
    kind: [Output Only] Type of resource. Always compute#vpnTunnel for VPN
      tunnels.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    """[Output Only] A map of scoped vpn tunnel lists.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: Name of the scope containing this set of vpn
        tunnels.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A VpnTunnelsScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('VpnTunnelsScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default=u'compute#vpnTunnelAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class VpnTunnelList(_messages.Message):
  """Contains a list of VpnTunnel resources.

  Fields:
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    items: [Output Only] A list of VpnTunnel resources.
    kind: [Output Only] Type of resource. Always compute#vpnTunnel for VPN
      tunnels.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for the resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('VpnTunnel', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#vpnTunnelList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class VpnTunnelsScopedList(_messages.Message):
  """A VpnTunnelsScopedList object.

  Messages:
    WarningValue: Informational warning which replaces the list of addresses
      when the list is empty.

  Fields:
    vpnTunnels: List of vpn tunnels contained in this scope.
    warning: Informational warning which replaces the list of addresses when
      the list is empty.
  """

  class WarningValue(_messages.Message):
    """Informational warning which replaces the list of addresses when the
    list is empty.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      """[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 2
      INJECTED_KERNELS_DEPRECATED = 3
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 4
      NEXT_HOP_CANNOT_IP_FORWARD = 5
      NEXT_HOP_INSTANCE_NOT_FOUND = 6
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 7
      NEXT_HOP_NOT_RUNNING = 8
      NOT_CRITICAL_ERROR = 9
      NO_RESULTS_ON_PAGE = 10
      REQUIRED_TOS_AGREEMENT = 11
      RESOURCE_NOT_DELETED = 12
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 13
      UNREACHABLE = 14

    class DataValueListEntry(_messages.Message):
      """A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  vpnTunnels = _messages.MessageField('VpnTunnel', 1, repeated=True)
  warning = _messages.MessageField('WarningValue', 2)


class Zone(_messages.Message):
  """A Zone resource.

  Enums:
    StatusValueValuesEnum: [Output Only] Status of the zone, either UP or
      DOWN.

  Fields:
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    deprecated: [Output Only] The deprecation status associated with this
      zone.
    description: [Output Only] Textual description of the resource.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] Type of the resource. Always compute#zone for zones.
    name: [Output Only] Name of the resource.
    region: [Output Only] Full URL reference to the region which hosts the
      zone.
    selfLink: [Output Only] Server-defined URL for the resource.
    status: [Output Only] Status of the zone, either UP or DOWN.
  """

  class StatusValueValuesEnum(_messages.Enum):
    """[Output Only] Status of the zone, either UP or DOWN.

    Values:
      DOWN: <no description>
      UP: <no description>
    """
    DOWN = 0
    UP = 1

  creationTimestamp = _messages.StringField(1)
  deprecated = _messages.MessageField('DeprecationStatus', 2)
  description = _messages.StringField(3)
  id = _messages.IntegerField(4, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(5, default=u'compute#zone')
  name = _messages.StringField(6)
  region = _messages.StringField(7)
  selfLink = _messages.StringField(8)
  status = _messages.EnumField('StatusValueValuesEnum', 9)


class ZoneList(_messages.Message):
  """Contains a list of zone resources.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: [Output Only] A list of Zone resources.
    kind: Type of resource.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('Zone', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#zoneList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class ZoneSetLabelsRequest(_messages.Message):
  """A ZoneSetLabelsRequest object.

  Messages:
    LabelsValue: The labels to set for this resource.

  Fields:
    labelFingerprint: The fingerprint of the previous set of labels for this
      resource, used to detect conflicts. The fingerprint is initially
      generated by Compute Engine and changes after every request to modify or
      update labels. You must always provide an up-to-date fingerprint hash in
      order to update or change labels. Make a get() request to the resource
      to get the latest fingerprint.
    labels: The labels to set for this resource.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    """The labels to set for this resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  labelFingerprint = _messages.BytesField(1)
  labels = _messages.MessageField('LabelsValue', 2)


