# Facter: loginclass
#
# Purpose: Retrieve the login class of the current user.
#
# Resolution:
#  On OpenBSD parses the output of 'userinfo'
#
# Caveats:
#  Not all systems utilize the login class (such as Darwin)
#

Facter.add(:loginclass) do
  confine do
    Facter::Core::Execution.which('userinfo')
  end

  setcode do
    uid = Facter.value(:id)
    output = Facter::Core::Execution.exec("userinfo #{uid}")
    output.split("\n").select { |field| /^class/.match(field) }.first.split("\t").last
  end
end
