/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.messagelocation;

import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.view.AbstractMultipleOptionsBaseTableModel;
import org.zaproxy.zap.view.messagelocation.HighlightChangedEvent;
import org.zaproxy.zap.view.messagelocation.HighlightChangedListener;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlight;
import org.zaproxy.zap.view.messagelocation.MessageLocationTableEntry;

public class MessageLocationsTableModel<T extends MessageLocationTableEntry>
extends AbstractMultipleOptionsBaseTableModel<T> {
    private static final long serialVersionUID = 4506544561803715504L;
    private static final String[] COLUMNS = new String[]{"", Constant.messages.getString("messagelocations.table.header.location"), Constant.messages.getString("messagelocations.table.header.value")};
    protected static final int BASE_NUMBER_OF_COLUMNS = COLUMNS.length;
    private final List<T> messageLocations;

    public MessageLocationsTableModel() {
        this.messageLocations = new ArrayList<T>();
    }

    public MessageLocationsTableModel(List<T> list) {
        this.messageLocations = list;
    }

    @Override
    public int getRowCount() {
        return this.messageLocations.size();
    }

    @Override
    public int getColumnCount() {
        return BASE_NUMBER_OF_COLUMNS;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMNS[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        MessageLocationTableEntry messageLocationTableEntry = (MessageLocationTableEntry)this.getElement(n);
        if (n2 == 0) {
            return messageLocationTableEntry.getHighlight();
        }
        if (n2 == 1) {
            return messageLocationTableEntry.getLocationUI();
        }
        return messageLocationTableEntry.getLocation().getValue();
    }

    public Class<?> getColumnClass(int n, int n2) {
        MessageLocationHighlight messageLocationHighlight;
        if (n2 == 0 && this.getRowCount() != 0 && (messageLocationHighlight = ((MessageLocationTableEntry)this.getElement(n)).getHighlight()) != null) {
            return messageLocationHighlight.getClass();
        }
        return this.getColumnClass(n2);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 0) {
            return MessageLocationHighlight.class;
        }
        if (n == 1) {
            return MessageLocationTableEntry.LocationUI.class;
        }
        return String.class;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 != 0 || !(object instanceof MessageLocationHighlight)) {
            return;
        }
        MessageLocationTableEntry messageLocationTableEntry = (MessageLocationTableEntry)this.getElement(n);
        messageLocationTableEntry.setHighlight((MessageLocationHighlight)object);
        this.fireHighlightChanged(messageLocationTableEntry, messageLocationTableEntry.getHighlightReference());
        this.fireTableCellUpdated(n, n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0;
    }

    @Override
    public List<T> getElements() {
        return this.messageLocations;
    }

    public int getRow(MessageLocationTableEntry messageLocationTableEntry) {
        return this.messageLocations.indexOf(messageLocationTableEntry);
    }

    public void addMessageLocationHighlightChangedListener(HighlightChangedListener<T> highlightChangedListener) {
        this.listenerList.add(HighlightChangedListener.class, highlightChangedListener);
    }

    public void removeMessageLocationHighlightChangedListener(HighlightChangedListener<T> highlightChangedListener) {
        this.listenerList.remove(HighlightChangedListener.class, highlightChangedListener);
    }

    protected void fireHighlightChanged(T t, MessageLocationHighlight messageLocationHighlight) {
        HighlightChangedEvent<T> highlightChangedEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != HighlightChangedListener.class) continue;
            if (highlightChangedEvent == null) {
                highlightChangedEvent = new HighlightChangedEvent<T>(this, t, messageLocationHighlight);
            }
            HighlightChangedListener highlightChangedListener = (HighlightChangedListener)objectArray[i + 1];
            highlightChangedListener.highlightChanged(highlightChangedEvent);
        }
    }
}

