/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.messagelocation;

import org.zaproxy.zap.model.MessageLocation;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlight;

public class MessageLocationTableEntry {
    private final LocationUI locationUI;
    private MessageLocationHighlight highlight;
    private MessageLocationHighlight highlightReference;

    public MessageLocationTableEntry(MessageLocation messageLocation) {
        this(messageLocation, null, null);
    }

    public MessageLocationTableEntry(MessageLocation messageLocation, MessageLocationHighlight messageLocationHighlight, MessageLocationHighlight messageLocationHighlight2) {
        if (messageLocation == null) {
            throw new IllegalArgumentException("Parameter location must not be null.");
        }
        this.locationUI = new LocationUI(messageLocation);
        this.highlight = messageLocationHighlight;
        this.highlightReference = messageLocationHighlight2;
    }

    public MessageLocationHighlight getHighlight() {
        return this.highlight;
    }

    public void setHighlight(MessageLocationHighlight messageLocationHighlight) {
        this.highlight = messageLocationHighlight;
    }

    public MessageLocationHighlight getHighlightReference() {
        return this.highlightReference;
    }

    public void setHighlightReference(MessageLocationHighlight messageLocationHighlight) {
        this.highlightReference = messageLocationHighlight;
    }

    public LocationUI getLocationUI() {
        return this.locationUI;
    }

    public MessageLocation getLocation() {
        return this.locationUI.getLocation();
    }

    public static class LocationUI
    implements Comparable<LocationUI> {
        private final MessageLocation location;

        private LocationUI(MessageLocation messageLocation) {
            this.location = messageLocation;
        }

        public MessageLocation getLocation() {
            return this.location;
        }

        @Override
        public int compareTo(LocationUI locationUI) {
            return this.location.compareTo(locationUI.location);
        }

        public String toString() {
            return this.location.getDescription();
        }
    }
}

