/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import edu.umass.cs.benchlab.har.HarCache;
import edu.umass.cs.benchlab.har.HarContent;
import edu.umass.cs.benchlab.har.HarCookie;
import edu.umass.cs.benchlab.har.HarCookies;
import edu.umass.cs.benchlab.har.HarCreator;
import edu.umass.cs.benchlab.har.HarEntry;
import edu.umass.cs.benchlab.har.HarEntryTimings;
import edu.umass.cs.benchlab.har.HarHeader;
import edu.umass.cs.benchlab.har.HarHeaders;
import edu.umass.cs.benchlab.har.HarLog;
import edu.umass.cs.benchlab.har.HarPostData;
import edu.umass.cs.benchlab.har.HarPostDataParam;
import edu.umass.cs.benchlab.har.HarPostDataParams;
import edu.umass.cs.benchlab.har.HarQueryParam;
import edu.umass.cs.benchlab.har.HarQueryString;
import edu.umass.cs.benchlab.har.HarRequest;
import edu.umass.cs.benchlab.har.HarResponse;
import edu.umass.cs.benchlab.har.tools.HarFileWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpCookie;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.encoder.Base64;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpHeader;
import org.parosproxy.paros.network.HttpHeaderField;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.network.HttpResponseHeader;
import org.zaproxy.zap.network.HttpRequestBody;

public final class HarUtils {
    private static final Logger LOGGER = Logger.getLogger(HarUtils.class);

    private HarUtils() {
    }

    public static HarLog createZapHarLog() {
        return new HarLog(new HarCreator("OWASP ZAP", Constant.PROGRAM_VERSION));
    }

    public static byte[] harLogToByteArray(HarLog harLog) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        HarFileWriter harFileWriter = new HarFileWriter();
        harFileWriter.writeHarFile(harLog, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static HttpMessage createHttpMessage(String string) throws IOException {
        return HarUtils.createHttpMessage(HarUtils.createHarRequest(string));
    }

    public static HarRequest createHarRequest(String string) throws IOException {
        HarRequest harRequest;
        try (JsonParser jsonParser = new JsonFactory().createJsonParser(string);){
            jsonParser.nextToken();
            jsonParser.nextToken();
            harRequest = new HarRequest(jsonParser, null);
        }
        return harRequest;
    }

    public static HttpMessage createHttpMessage(HarRequest harRequest) throws HttpMalformedHeaderException {
        HarHeader harHeader2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(harRequest.getMethod()).append(' ').append(harRequest.getUrl()).append(' ').append(harRequest.getHttpVersion()).append("\r\n");
        for (HarHeader harHeader2 : harRequest.getHeaders().getHeaders()) {
            stringBuilder.append(harHeader2.getName()).append(": ").append(harHeader2.getValue()).append("\r\n");
        }
        stringBuilder.append("\r\n");
        StringBuilder stringBuilder2 = new StringBuilder();
        harHeader2 = harRequest.getPostData();
        if (harHeader2 != null) {
            String string = harHeader2.getText();
            if (string != null && !string.isEmpty()) {
                stringBuilder2.append(harRequest.getPostData().getText());
            } else if (harHeader2.getParams() != null && !harHeader2.getParams().getPostDataParams().isEmpty()) {
                for (HarPostDataParam harPostDataParam : harRequest.getPostData().getParams().getPostDataParams()) {
                    if (stringBuilder2.length() > 0) {
                        stringBuilder2.append('&');
                    }
                    stringBuilder2.append(harPostDataParam.getName()).append('=').append(harPostDataParam.getValue());
                }
            }
        }
        return new HttpMessage(new HttpRequestHeader(stringBuilder.toString()), new HttpRequestBody(stringBuilder2.toString()));
    }

    public static HarEntry createHarEntry(HttpMessage httpMessage) {
        HarEntryTimings harEntryTimings = new HarEntryTimings(0L, 0L, (long)httpMessage.getTimeElapsedMillis());
        return new HarEntry(new Date(httpMessage.getTimeSentMillis()), (long)httpMessage.getTimeElapsedMillis(), HarUtils.createHarRequest(httpMessage), HarUtils.createHarResponse(httpMessage), new HarCache(), harEntryTimings);
    }

    /*
     * WARNING - void declaration
     */
    public static HarRequest createHarRequest(HttpMessage httpMessage) {
        void var4_9;
        HttpRequestHeader httpRequestHeader = httpMessage.getRequestHeader();
        HarCookies harCookies = new HarCookies();
        try {
            for (HttpCookie object22 : httpRequestHeader.getHttpCookies()) {
                harCookies.addCookie(new HarCookie(object22.getName(), object22.getValue()));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.warn((Object)("Ignoring cookies for HAR (\"request\") \"cookies\" list. Request contains invalid cookie: " + illegalArgumentException.getMessage()));
        }
        HarQueryString harQueryString = new HarQueryString();
        for (HtmlParameter htmlParameter : httpMessage.getUrlParams()) {
            harQueryString.addQueryParam(new HarQueryParam(htmlParameter.getName(), htmlParameter.getValue()));
        }
        Object var4_7 = null;
        HttpRequestBody httpRequestBody = httpMessage.getRequestBody();
        if (httpRequestBody.length() >= 0) {
            HarPostDataParams harPostDataParams = new HarPostDataParams();
            String string = "";
            String string2 = httpRequestHeader.getHeader("Content-Type");
            if (string2 == null) {
                string2 = "";
                string = httpRequestBody.toString();
            } else if (StringUtils.startsWithIgnoreCase(string2.trim(), "application/x-www-form-urlencoded")) {
                for (HtmlParameter htmlParameter : httpMessage.getFormParams()) {
                    harPostDataParams.addPostDataParam(new HarPostDataParam(htmlParameter.getName(), htmlParameter.getValue()));
                }
            } else {
                string = httpRequestBody.toString();
            }
            HarPostData harPostData = new HarPostData(string2, harPostDataParams, string, null);
        }
        return new HarRequest(httpRequestHeader.getMethod(), httpRequestHeader.getURI().toString(), httpRequestHeader.getVersion(), harCookies, HarUtils.createHarHeaders(httpRequestHeader), harQueryString, (HarPostData)var4_9, (long)httpRequestHeader.toString().length(), (long)httpMessage.getRequestBody().length(), null);
    }

    /*
     * WARNING - void declaration
     */
    public static HarResponse createHarResponse(HttpMessage httpMessage) {
        void var6_8;
        String string;
        Object object;
        HttpResponseHeader httpResponseHeader = httpMessage.getResponseHeader();
        HarCookies harCookies = new HarCookies();
        long l = System.currentTimeMillis();
        for (HttpCookie object22 : httpResponseHeader.getHttpCookies(httpMessage.getRequestHeader().getHostName())) {
            object = object22.getVersion() == 0 ? new Date(l + object22.getMaxAge() * 1000L) : new Date(httpMessage.getTimeSentMillis() + (long)httpMessage.getTimeElapsedMillis() + object22.getMaxAge() * 1000L);
            harCookies.addCookie(new HarCookie(object22.getName(), object22.getValue(), object22.getPath(), object22.getDomain(), (Date)object, object22.isHttpOnly(), object22.getSecure(), null));
        }
        Object object3 = null;
        Object var6_6 = null;
        object = httpResponseHeader.getHeader("Content-Type");
        if (object == null) {
            object = "";
        } else if (!((String)object).isEmpty()) {
            string = ((String)object).toLowerCase(Locale.ROOT);
            int n = string.indexOf(59);
            if (n != -1) {
                string = string.substring(0, n).trim();
            }
            if (!string.startsWith("text")) {
                String string2 = "base64";
                object3 = Base64.encodeBytes(httpMessage.getResponseBody().getBytes());
            } else {
                object3 = httpMessage.getResponseBody().toString();
            }
        }
        string = new HarContent((long)httpMessage.getResponseBody().length(), 0L, (String)object, object3, (String)var6_8, null);
        String string3 = httpResponseHeader.getHeader("Location");
        return new HarResponse(httpResponseHeader.getStatusCode(), httpResponseHeader.getReasonPhrase(), httpResponseHeader.getVersion(), harCookies, HarUtils.createHarHeaders(httpResponseHeader), (HarContent)string, string3 == null ? "" : string3, (long)httpResponseHeader.toString().length(), (long)httpMessage.getResponseBody().length(), null);
    }

    public static HarHeaders createHarHeaders(HttpHeader httpHeader) {
        HarHeaders harHeaders = new HarHeaders();
        List<HttpHeaderField> list = httpHeader.getHeaders();
        for (HttpHeaderField httpHeaderField : list) {
            harHeaders.addHeader(new HarHeader(httpHeaderField.getName(), httpHeaderField.getValue()));
        }
        return harHeaders;
    }
}

