/*
 * Decompiled with CFR 0.152.
 */
package ch.csnc.extension.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Observable;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class DriverConfiguration
extends Observable {
    private File file = null;
    private Vector<String> names;
    private Vector<String> paths;
    private Vector<Integer> slots;
    private Vector<Integer> slotListIndexes;
    private final Logger logger = Logger.getLogger(this.getClass());

    public DriverConfiguration(File file) {
        this.file = file;
        this.names = new Vector();
        this.paths = new Vector();
        this.slots = new Vector();
        this.slotListIndexes = new Vector();
        try {
            Document document = new SAXBuilder().build(file);
            Element element = document.getRootElement();
            for (Object e : element.getChildren("driver")) {
                Element element2 = ((Element)e).getChild("name");
                this.names.add(element2.getValue());
                Element element3 = ((Element)e).getChild("path");
                this.paths.add(element3.getValue());
                Element element4 = ((Element)e).getChild("slot");
                try {
                    this.slots.add(Integer.parseInt(element4.getValue()));
                }
                catch (Exception exception) {
                    this.slots.add(0);
                }
                Element element5 = ((Element)e).getChild("slotListIndex");
                try {
                    this.slotListIndexes.add(Integer.parseInt(element5.getValue()));
                }
                catch (Exception exception) {
                    this.slotListIndexes.add(0);
                }
            }
        }
        catch (JDOMException jDOMException) {
            JOptionPane.showMessageDialog(null, new String[]{"Error accessing key store: ", jDOMException.toString()}, "Error", 0);
            this.logger.error((Object)jDOMException.getMessage(), (Throwable)jDOMException);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, new String[]{"Error accessing key store: ", iOException.toString()}, "Error", 0);
            this.logger.error((Object)iOException.getMessage(), (Throwable)iOException);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, new String[]{"Error slot or slot list index is not a number: ", numberFormatException.toString()}, "Error", 0);
            this.logger.error((Object)numberFormatException.getMessage(), (Throwable)numberFormatException);
        }
    }

    public void write() {
        Element element;
        Document document = new Document();
        Element element2 = new Element("driverConfiguration");
        document.addContent((Content)element2);
        for (int i = 0; i < this.names.size(); ++i) {
            element = new Element("driver");
            element2.addContent((Content)element);
            Element element3 = new Element("name");
            element.addContent((Content)element3);
            element3.addContent(this.names.get(i));
            Element element4 = new Element("path");
            element.addContent((Content)element4);
            element4.addContent(this.paths.get(i));
            Element element5 = new Element("slot");
            element.addContent((Content)element5);
            element5.addContent(this.slots.get(i).toString());
            Element element6 = new Element("slotListIndex");
            element.addContent((Content)element6);
            element6.addContent(this.slotListIndexes.get(i).toString());
        }
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.file));
            element = new XMLOutputter();
            element.output(document, (OutputStream)bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(null, new String[]{"Error accessing key store: ", fileNotFoundException.toString()}, "Error", 0);
            this.logger.error((Object)fileNotFoundException.getMessage(), (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, new String[]{"Error accessing key store: ", iOException.toString()}, "Error", 0);
            this.logger.error((Object)iOException.getMessage(), (Throwable)iOException);
        }
        this.setChanged();
        this.notifyObservers();
    }

    public Vector<String> getNames() {
        return this.names;
    }

    public void setNames(Vector<String> vector) {
        this.names = vector;
    }

    public Vector<String> getPaths() {
        return this.paths;
    }

    public void setPaths(Vector<String> vector) {
        this.paths = vector;
    }

    public Vector<Integer> getSlots() {
        return this.slots;
    }

    public void setSlots(Vector<Integer> vector) {
        this.slots = vector;
    }

    public Vector<Integer> getSlotIndexes() {
        return this.slotListIndexes;
    }

    public void setSlotListIndexes(Vector<Integer> vector) {
        this.slotListIndexes = vector;
    }
}

