/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.ui.menu;

import com.Ostermiller.util.Browser;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.owasp.jbrofuzz.help.Faq;
import org.owasp.jbrofuzz.help.Shortcuts;
import org.owasp.jbrofuzz.help.Topics;
import org.owasp.jbrofuzz.system.Logger;
import org.owasp.jbrofuzz.ui.JBroFuzzWindow;
import org.owasp.jbrofuzz.ui.menu.AboutBox;
import org.owasp.jbrofuzz.ui.menu.JBroFuzzMenuBar;
import org.owasp.jbrofuzz.version.ImageCreator;

class JMenuHelp
extends JMenu {
    private static final long serialVersionUID = 5161865891267439105L;

    protected JMenuHelp(JBroFuzzMenuBar mainMenuBar) {
        super("Help");
        final JBroFuzzWindow mainFrame = mainMenuBar.getFrame();
        JMenuItem topics = new JMenuItem("Topics", ImageCreator.IMG_TOPICS);
        JMenuItem faq = new JMenuItem("FAQ", ImageCreator.IMG_FAQ);
        JMenuItem shortcuts = new JMenuItem("Keyboard Shortcuts");
        JMenuItem website = new JMenuItem("JBroFuzz Website...", ImageCreator.IMG_OWASP_SML);
        JMenuItem disclaimer = new JMenuItem("Disclaimer", ImageCreator.IMG_DISCLAIMER);
        JMenuItem about = new JMenuItem("About", ImageCreator.IMG_ABOUT);
        about.setAccelerator(KeyStroke.getKeyStroke(48, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.add(topics);
        this.add(shortcuts);
        this.add(faq);
        this.addSeparator();
        this.addSeparator();
        this.add(website);
        this.addSeparator();
        this.add(disclaimer);
        this.add(about);
        faq.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        new Faq(mainFrame);
                    }
                });
            }
        });
        topics.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        new Topics(mainFrame);
                    }
                });
            }
        });
        shortcuts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        new Shortcuts(mainFrame);
                    }
                });
            }
        });
        website.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Browser.init();
                        try {
                            Browser.displayURL((String)"http://www.owasp.org/index.php/JBroFuzz");
                        }
                        catch (IOException ex) {
                            Logger.log("Could not launch link in external browser", 3);
                        }
                    }
                });
            }
        });
        disclaimer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        new AboutBox(mainFrame, AboutBox.Tab.DISCLAIMER);
                    }
                });
            }
        });
        about.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        new AboutBox(mainFrame, AboutBox.Tab.ABOUT);
                    }
                });
            }
        });
    }
}

