/*
 * Decompiled with CFR 0.152.
 */
package railo.cli;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.ConnectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RemoteServer;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import javax.servlet.ServletException;
import railo.cli.CLIInvoker;
import railo.cli.CLIInvokerImpl;
import railo.cli.Closer;

public class CLIFactory
extends Thread {
    private static final int PORT = 8893;
    private File root;
    private String servletName;
    private Map<String, String> config;
    private long idleTime;

    public CLIFactory(File root, String servletName, Map<String, String> config) {
        this.root = root;
        this.servletName = servletName;
        this.config = config;
        this.idleTime = 60000L;
        String strIdle = config.get("idle");
        if (strIdle != null) {
            try {
                this.idleTime = Long.parseLong(strIdle);
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void run() {
        String name = this.root.getAbsolutePath();
        InetAddress current = null;
        try {
            current = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e1) {
            e1.printStackTrace();
            return;
        }
        try {
            try {
                this.invoke(current, name);
            }
            catch (ConnectException connectException) {
                this.startInvoker(name);
                this.invoke(current, name);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void invoke(InetAddress current, String name) throws RemoteException, NotBoundException {
        Registry registry = LocateRegistry.getRegistry(current.getHostAddress(), 8893);
        CLIInvoker invoker = (CLIInvoker)registry.lookup(name);
        invoker.invoke(this.config);
    }

    private void startInvoker(String name) throws ServletException, RemoteException {
        Registry myReg = CLIFactory.getRegistry(8893);
        CLIInvokerImpl invoker = new CLIInvokerImpl(this.root, this.servletName);
        CLIInvoker stub = (CLIInvoker)UnicastRemoteObject.exportObject((Remote)invoker, 0);
        myReg.rebind(name, stub);
        if (this.idleTime > 0L) {
            Closer closer = new Closer(myReg, invoker, name, this.idleTime);
            closer.setDaemon(false);
            closer.start();
        }
    }

    public static Registry getRegistry(int port) {
        Registry registry = null;
        try {
            registry = LocateRegistry.createRegistry(port);
        }
        catch (RemoteException remoteException) {}
        try {
            if (registry == null) {
                registry = LocateRegistry.getRegistry(port);
            }
        }
        catch (RemoteException remoteException) {}
        RemoteServer.setLog(System.out);
        return registry;
    }
}

