/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.util;

import java.util.ArrayList;
import java.util.List;

public class ThreadPool {
    private final ThreadGroup threadGroup;
    private final int maxSize;
    private final List waitingThreads = new ArrayList();
    private final List runningThreads = new ArrayList();
    private final List waitingTasks = new ArrayList();
    private int num;

    public ThreadPool(int pMaxSize, String pName) {
        this.maxSize = pMaxSize;
        this.threadGroup = new ThreadGroup(pName);
    }

    synchronized void discard(Poolable pPoolable) {
        pPoolable.shutdown();
        this.runningThreads.remove(pPoolable);
        this.waitingThreads.remove(pPoolable);
    }

    synchronized void repool(Poolable pPoolable) {
        if (this.runningThreads.remove(pPoolable)) {
            if (this.maxSize != 0 && this.runningThreads.size() + this.waitingThreads.size() >= this.maxSize) {
                this.discard(pPoolable);
            } else {
                this.waitingThreads.add(pPoolable);
                if (this.waitingTasks.size() > 0) {
                    Task task = (Task)this.waitingTasks.remove(this.waitingTasks.size() - 1);
                    this.startTask(task);
                }
            }
        } else {
            this.discard(pPoolable);
        }
    }

    public synchronized boolean startTask(Task pTask) {
        if (this.maxSize != 0 && this.runningThreads.size() > this.maxSize) {
            return false;
        }
        Poolable poolable = this.waitingThreads.size() > 0 ? (Poolable)this.waitingThreads.remove(this.waitingThreads.size() - 1) : new Poolable(this.threadGroup, this.num++);
        this.runningThreads.add(poolable);
        poolable.start(pTask);
        return true;
    }

    public synchronized boolean addTask(Task pTask) {
        if (this.startTask(pTask)) {
            return true;
        }
        this.waitingTasks.add(pTask);
        return false;
    }

    public synchronized void shutdown() {
        Poolable poolable;
        while (!this.waitingThreads.isEmpty()) {
            poolable = (Poolable)this.waitingThreads.remove(this.waitingThreads.size() - 1);
            poolable.shutdown();
        }
        while (!this.runningThreads.isEmpty()) {
            poolable = (Poolable)this.runningThreads.remove(this.runningThreads.size() - 1);
            poolable.shutdown();
        }
    }

    public int getMaxThreads() {
        return this.maxSize;
    }

    public synchronized int getNumThreads() {
        return this.num;
    }

    private class Poolable {
        private boolean shuttingDown;
        private Task task;
        private Thread thread;

        Poolable(ThreadGroup pGroup, int pNum) {
            this.thread = new Thread(pGroup, pGroup.getName() + "-" + pNum){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (!Poolable.this.isShuttingDown()) {
                        Task t = Poolable.this.getTask();
                        if (t == null) {
                            try {
                                1 var2_2 = this;
                                synchronized (var2_2) {
                                    this.wait();
                                    continue;
                                }
                            }
                            catch (InterruptedException e) {
                                continue;
                            }
                        }
                        try {
                            t.run();
                            Poolable.this.resetTask();
                            ThreadPool.this.repool(Poolable.this);
                        }
                        catch (Throwable e) {
                            ThreadPool.this.discard(Poolable.this);
                            Poolable.this.resetTask();
                        }
                    }
                }
            };
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void shutdown() {
            this.shuttingDown = true;
            Task t = this.getTask();
            if (t != null && t instanceof InterruptableTask) {
                try {
                    ((InterruptableTask)t).shutdown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.task = null;
            Thread thread = this.thread;
            synchronized (thread) {
                this.thread.notify();
            }
        }

        private synchronized boolean isShuttingDown() {
            return this.shuttingDown;
        }

        String getName() {
            return this.thread.getName();
        }

        private synchronized Task getTask() {
            return this.task;
        }

        private synchronized void resetTask() {
            this.task = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void start(Task pTask) {
            this.task = pTask;
            Thread thread = this.thread;
            synchronized (thread) {
                this.thread.notify();
            }
        }
    }

    public static interface InterruptableTask
    extends Task {
        public void shutdown() throws Throwable;
    }

    public static interface Task {
        public void run() throws Throwable;
    }
}

