/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.writer;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.mpxj.json.JsonWriter;
import net.sf.mpxj.mpx.MPXWriter;
import net.sf.mpxj.mspdi.MSPDIWriter;
import net.sf.mpxj.planner.PlannerWriter;
import net.sf.mpxj.writer.ProjectWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectWriterUtility {
    private static final Map<String, Class<? extends ProjectWriter>> WRITER_MAP = new HashMap<String, Class<? extends ProjectWriter>>();

    private ProjectWriterUtility() {
    }

    public static ProjectWriter getProjectWriter(String string) throws InstantiationException, IllegalAccessException {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            throw new IllegalArgumentException("Filename has no extension: " + string);
        }
        String string2 = string.substring(n + 1).toUpperCase();
        Class<? extends ProjectWriter> clazz = WRITER_MAP.get(string2);
        if (clazz == null) {
            throw new IllegalArgumentException("Cannot write files of type: " + string);
        }
        ProjectWriter projectWriter = clazz.newInstance();
        return projectWriter;
    }

    public static Set<String> getSupportedFileExtensions() {
        return WRITER_MAP.keySet();
    }

    static {
        WRITER_MAP.put("MPX", MPXWriter.class);
        WRITER_MAP.put("XML", MSPDIWriter.class);
        WRITER_MAP.put("PLANNER", PlannerWriter.class);
        WRITER_MAP.put("JSON", JsonWriter.class);
    }
}

