/*
 * Decompiled with CFR 0.152.
 */
package com.projity.toolbar;

import com.projity.grouping.core.transform.CommonTransformFactory;
import com.projity.grouping.core.transform.ViewConfiguration;
import com.projity.menu.HyperLinkToolTip;
import com.projity.menu.MenuManager;
import com.projity.toolbar.TransformComboBoxModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComboBox;
import javax.swing.JToolTip;
import javax.swing.UIManager;

public class TransformComboBox
extends JComboBox {
    protected int type;

    public TransformComboBox(MenuManager menuManager, String string, int n) {
        super(new TransformComboBoxModel(n));
        String string2;
        this.setActionCommand(string);
        this.type = n;
        this.setMaximumSize(new Dimension(150, Integer.MAX_VALUE));
        if (menuManager != null) {
            String string3 = menuManager.getString(string + ".tooltip");
            String string4 = menuManager.getStringOrNull(string + ".help");
            String string5 = menuManager.getStringOrNull(string + ".demo");
            String string6 = menuManager.getStringOrNull(string + ".doc");
            string2 = HyperLinkToolTip.helpTipText(string3, string4, string5, string6);
        } else {
            string2 = ((TransformComboBoxModel)this.getModel()).getTipText();
        }
        this.setToolTipText(string2);
    }

    public void setView(ViewConfiguration viewConfiguration) {
        ((TransformComboBoxModel)this.getModel()).setView(viewConfiguration);
        this.setSelectedItem(this.getModel().getSelectedItem());
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        if (this.getToolTipText().startsWith("<html>")) {
            return new Point(0, this.getHeight() - 2);
        }
        return super.getToolTipLocation(mouseEvent);
    }

    public JToolTip createToolTip() {
        if (this.getToolTipText().startsWith("<html>")) {
            HyperLinkToolTip hyperLinkToolTip = new HyperLinkToolTip();
            hyperLinkToolTip.setComponent(this);
            return hyperLinkToolTip;
        }
        return super.createToolTip();
    }

    public void paintComponent(Graphics graphics) {
        boolean bl = this.getSelectedIndex() <= 0;
        this.setForeground(bl ? UIManager.getColor("ComboBox.foreground") : Color.RED);
        super.paintComponent(graphics);
    }

    public void transformBasedOnValue() {
        CommonTransformFactory commonTransformFactory = (CommonTransformFactory)this.getSelectedItem();
        ((TransformComboBoxModel)this.getModel()).changeTransform(commonTransformFactory);
    }
}

