/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.filters;

import java.io.File;
import java.util.ResourceBundle;
import javax.swing.filechooser.FileFilter;
import org.openide.util.NbBundle;

public class MakefileFileFilter
extends FileFilter {
    private static MakefileFileFilter instance = null;
    private ResourceBundle bundle;

    public static MakefileFileFilter getInstance() {
        if (instance == null) {
            instance = new MakefileFileFilter();
        }
        return instance;
    }

    @Override
    public String getDescription() {
        return this.getString("FILECHOOSER_MAKEFILE_FILEFILTER");
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            return this.checkMakefile(f);
        }
        return false;
    }

    private boolean checkMakefile(File f) {
        String name = f.getName();
        return name.indexOf("Makefile") >= 0 || name.indexOf("makefile") >= 0 || name.endsWith(".mk");
    }

    private String getString(String s) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(MakefileFileFilter.class);
        }
        return this.bundle.getString(s);
    }
}

