/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.awt.EventQueue;
import java.io.File;
import java.util.HashSet;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public final class WorkingCopyAttributesCache {
    private static WorkingCopyAttributesCache instance;
    private HashSet<String> unsupportedWorkingCopies = new HashSet(5);

    public static WorkingCopyAttributesCache getInstance() {
        if (instance == null) {
            instance = new WorkingCopyAttributesCache();
            instance.init();
        }
        return instance;
    }

    private WorkingCopyAttributesCache() {
    }

    private void init() {
    }

    public void logUnsupportedWC(final SVNClientException ex, File file) throws SVNClientException {
        String fileName = file.getAbsolutePath();
        if (!this.isInUnsupportedWorkingCopies(fileName)) {
            File topManaged = Subversion.getInstance().getTopmostManagedAncestor(file);
            this.unsupportedWorkingCopies.add(topManaged.getAbsolutePath());
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                }
            });
        }
        throw ex;
    }

    public boolean isInUnsupportedWorkingCopies(String fileName) {
        for (String unsupported : this.unsupportedWorkingCopies) {
            if (!fileName.startsWith(unsupported)) continue;
            return true;
        }
        return false;
    }
}

