/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws.nodes;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.swing.Action;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.maven.jaxws.MavenModelUtils;
import org.netbeans.modules.maven.jaxws.ServerType;
import org.netbeans.modules.maven.jaxws.WSStackUtils;
import org.netbeans.modules.maven.jaxws.WSUtils;
import org.netbeans.modules.maven.jaxws._RetoucheUtil;
import org.netbeans.modules.maven.jaxws.actions.AddOperationAction;
import org.netbeans.modules.maven.jaxws.actions.WSEditAttributesAction;
import org.netbeans.modules.maven.jaxws.actions.WsTesterPageAction;
import org.netbeans.modules.maven.jaxws.nodes.HandlerButtonListener;
import org.netbeans.modules.maven.jaxws.nodes.JaxWsChildren;
import org.netbeans.modules.maven.jaxws.nodes.JaxWsClientNode;
import org.netbeans.modules.maven.jaxws.wseditor.EditWSAttributesCookieImpl;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Handler;
import org.netbeans.modules.websvc.api.jaxws.project.config.HandlerChain;
import org.netbeans.modules.websvc.api.jaxws.project.config.HandlerChains;
import org.netbeans.modules.websvc.api.jaxws.project.config.HandlerChainsProvider;
import org.netbeans.modules.websvc.api.support.ConfigureHandlerCookie;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.websvc.spi.support.ConfigureHandlerAction;
import org.netbeans.modules.websvc.spi.support.MessageHandlerPanel;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWs;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.DeleteAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PropertiesAction;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

public class JaxWsNode
extends AbstractNode
implements ConfigureHandlerCookie {
    JaxWsService service;
    FileObject srcRoot;
    private FileObject implBeanClass;
    InstanceContent content;
    Project project;
    private static final String WAITING_BADGE = "org/netbeans/modules/maven/jaxws/resources/waiting.png";
    private static final String ERROR_BADGE = "org/netbeans/modules/maven/jaxws/resources/error-badge.gif";
    private static final String SERVICE_BADGE = "org/netbeans/modules/maven/jaxws/resources/XMLServiceDataIcon.png";
    private Image cachedWaitingBadge;
    private Image cachedErrorBadge;
    private Image cachedServiceBadge;

    public JaxWsNode(JaxWsService jaxWsService, FileObject fileObject, FileObject fileObject2) {
        this(jaxWsService, fileObject, fileObject2, new InstanceContent());
    }

    private JaxWsNode(JaxWsService jaxWsService, FileObject fileObject, FileObject fileObject2, InstanceContent instanceContent) {
        super((Children)new JaxWsChildren(jaxWsService, fileObject, fileObject2), (Lookup)new AbstractLookup((AbstractLookup.Content)instanceContent));
        this.service = jaxWsService;
        this.srcRoot = fileObject;
        this.content = instanceContent;
        this.implBeanClass = fileObject2;
        this.project = FileOwnerQuery.getOwner((FileObject)fileObject);
        String string = jaxWsService.getServiceName();
        this.setName(string);
        instanceContent.add((Object)this);
        instanceContent.add((Object)jaxWsService);
        instanceContent.add((Object)fileObject2);
        OpenCookie openCookie = new OpenCookie(){

            public void open() {
                OpenCookie openCookie = JaxWsNode.this.getOpenCookie();
                if (openCookie != null) {
                    openCookie.open();
                }
            }
        };
        instanceContent.add((Object)openCookie);
        this.setServiceUrl();
        instanceContent.add((Object)new EditWSAttributesCookieImpl((Node)this));
        this.attachFileChangeListener();
    }

    private boolean isWebProject() {
        J2eeModule.Type type;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        return j2eeModuleProvider != null && J2eeModule.Type.WAR.equals(type = j2eeModuleProvider.getJ2eeModule().getType());
    }

    public String getDisplayName() {
        return this.service.getServiceName();
    }

    public String getShortDescription() {
        return this.getWsdlURL();
    }

    public Image getIcon(int n) {
        return this.getServiceImage();
    }

    private Image getServiceImage() {
        if (this.cachedServiceBadge == null) {
            this.cachedServiceBadge = ImageUtilities.loadImage((String)SERVICE_BADGE);
        }
        return this.cachedServiceBadge;
    }

    private Image getErrorBadge() {
        if (this.cachedErrorBadge == null) {
            this.cachedErrorBadge = ImageUtilities.loadImage((String)ERROR_BADGE);
        }
        return this.cachedErrorBadge;
    }

    private Image getWaitingBadge() {
        if (this.cachedWaitingBadge == null) {
            this.cachedWaitingBadge = ImageUtilities.loadImage((String)WAITING_BADGE);
        }
        return this.cachedWaitingBadge;
    }

    void changeIcon() {
        this.fireIconChange();
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    private DataObject getDataObject() {
        FileObject fileObject = this.getImplBean();
        if (fileObject != null) {
            try {
                return DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().log(1, dataObjectNotFoundException.toString());
            }
        }
        return null;
    }

    private OpenCookie getOpenCookie() {
        OpenCookie openCookie = null;
        FileObject fileObject = this.getImplBean();
        if (fileObject != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().log(1, dataObjectNotFoundException.toString());
            }
        }
        return openCookie;
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }

    public Action[] getActions(boolean bl) {
        DataObject dataObject = (DataObject)this.getCookie(DataObject.class);
        ArrayList<CallableSystemAction> arrayList = new ArrayList<CallableSystemAction>(Arrays.asList((CallableSystemAction)SystemAction.get(OpenAction.class), (CallableSystemAction)SystemAction.get(AddOperationAction.class), null, (CallableSystemAction)SystemAction.get(WsTesterPageAction.class), (CallableSystemAction)SystemAction.get(WSEditAttributesAction.class), (CallableSystemAction)SystemAction.get(ConfigureHandlerAction.class), null, (CallableSystemAction)SystemAction.get(DeleteAction.class), null, (CallableSystemAction)SystemAction.get(PropertiesAction.class)));
        this.addFromLayers(arrayList, "WebServices/Services/Actions");
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private void addFromLayers(List<Action> list, String string) {
        Lookup lookup = Lookups.forPath((String)string);
        for (Object e : lookup.lookupAll(Object.class)) {
            if (e instanceof Action) {
                list.add((Action)e);
                continue;
            }
            if (!(e instanceof JSeparator)) continue;
            list.add(null);
        }
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean canDestroy() {
        return true;
    }

    private String getWebServiceURL() {
        ServerContextInfo serverContextInfo = this.getServerContextInfo();
        String string = serverContextInfo.getContextRoot();
        return "http://" + serverContextInfo.getHost() + ":" + serverContextInfo.getPort() + "/" + this.getServiceUri(string);
    }

    private String getNameFromPackageName(String string) {
        int n = string.lastIndexOf(".");
        return n >= 0 ? string.substring(n + 1) : string;
    }

    public String getWsdlURL() {
        String string = this.getWebServiceURL();
        return string.length() == 0 ? "" : string + "?wsdl";
    }

    public String getTesterPageURL() {
        JaxWs.UriDescriptor uriDescriptor;
        ServerContextInfo serverContextInfo = this.getServerContextInfo();
        ServiceInfo serviceInfo = this.getServiceInfo();
        WSStackUtils wSStackUtils = new WSStackUtils(this.project);
        boolean bl = wSStackUtils.isJsr109Supported();
        WSStack<JaxWs> wSStack = wSStackUtils.getWsStack(JaxWs.class);
        if (wSStack != null && (uriDescriptor = ((JaxWs)wSStack.get()).getWsUriDescriptor()) != null) {
            return uriDescriptor.getTesterPageUri(serverContextInfo.getHost(), serverContextInfo.getPort(), serverContextInfo.getContextRoot(), serviceInfo.getServiceName(), serviceInfo.getPortName(), serviceInfo.isEjb());
        }
        return this.getWebServiceURL();
    }

    public void destroy() throws IOException {
        if (this.service.getLocalWsdl() != null) {
            final String string = this.service.getId();
            ModelOperation<POMModel> modelOperation = new ModelOperation<POMModel>(){

                public void performOperation(POMModel pOMModel) {
                    MavenModelUtils.removeWsimportExecution(pOMModel, string);
                }
            };
            FileObject fileObject = this.project.getProjectDirectory().getFileObject("pom.xml");
            Utilities.performPOMModelOperations((FileObject)fileObject, Collections.singletonList(modelOperation));
            try {
                this.removeStaleFile(string);
            }
            catch (IOException iOException) {
                Logger.getLogger(JaxWsClientNode.class.getName()).log(Level.FINE, "Cannot remove stale file", iOException);
            }
            FileObject fileObject2 = this.getLocalWsdl();
            JAXWSLightSupport jAXWSLightSupport = JAXWSLightSupport.getJAXWSLightSupport((FileObject)this.implBeanClass);
            if (fileObject2 != null && jAXWSLightSupport != null) {
                boolean bl = false;
                List list = jAXWSLightSupport.getServices();
                for (JaxWsService jaxWsService : list) {
                    if (string == null || string.equals(jaxWsService.getId()) || !this.service.getLocalWsdl().equals(jaxWsService.getLocalWsdl())) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    fileObject2.delete();
                }
            }
        }
        WSUtils.removeImplClass(this.project, this.service.getImplementationClass());
    }

    private FileObject getImplBean() {
        String string = this.service.getImplementationClass();
        if (string != null) {
            return this.srcRoot.getFileObject(string.replace('.', '/') + ".java");
        }
        return null;
    }

    private FileObject getLocalWsdl() {
        String string;
        FileObject fileObject;
        JAXWSLightSupport jAXWSLightSupport = JAXWSLightSupport.getJAXWSLightSupport((FileObject)this.implBeanClass);
        if (jAXWSLightSupport != null && (fileObject = jAXWSLightSupport.getWsdlFolder(false)) != null && (string = this.service.getLocalWsdl()) != null) {
            return fileObject.getFileObject(string);
        }
        return null;
    }

    private JavaSource getImplBeanJavaSource() {
        FileObject fileObject = this.getImplBean();
        if (fileObject != null) {
            return JavaSource.forFileObject((FileObject)fileObject);
        }
        return null;
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return true;
    }

    private String getPortNumber(InstanceProperties instanceProperties) {
        String string = instanceProperties.getProperty("httpportnumber");
        if (string == null || string.equals("")) {
            return "8080";
        }
        return string;
    }

    private String getHostName(InstanceProperties instanceProperties) {
        String string = instanceProperties.getProperty("url");
        String string2 = "localhost";
        if (string != null && string.indexOf("::") > 0) {
            int n = string.indexOf("::");
            int n2 = string.lastIndexOf(":");
            if (n2 > n + 2) {
                string2 = string.substring(n + 2, n2);
            }
        }
        return string2;
    }

    void setServiceUrl() {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                JaxWsNode.this.setValue("wsdl-url", JaxWsNode.this.getWsdlURL());
            }
        });
    }

    protected void fireShortDescriptionChange() {
        this.setShortDescription(this.getWsdlURL());
    }

    private void attachFileChangeListener() {
        this.implBeanClass.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

            public void fileChanged(final FileEvent fileEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String string = JaxWsNode.this.service.getServiceName();
                        final String[] stringArray = new String[1];
                        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileEvent.getFile());
                        if (javaSource != null) {
                            CancellableTask<CompilationController> cancellableTask = new CancellableTask<CompilationController>(){

                                public void run(CompilationController compilationController) throws IOException {
                                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                    TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)compilationController);
                                    if (typeElement != null) {
                                        stringArray[0] = JaxWsNode.this.getServiceName(compilationController, typeElement);
                                    }
                                }

                                public void cancel() {
                                }
                            };
                            try {
                                javaSource.runUserActionTask((Task)cancellableTask, true);
                            }
                            catch (IOException iOException) {
                                ErrorManager.getDefault().notify((Throwable)iOException);
                            }
                            if (stringArray[0] == null) {
                                stringArray[0] = fileEvent.getFile().getName() + "Service";
                            }
                            if (!stringArray[0].equals(string)) {
                                FileObject fileObject = JaxWsNode.this.getImplBean();
                                if (JaxWsNode.this.getImplBean() != null) {
                                    JaxWsNode.this.service.setServiceName(stringArray[0]);
                                    JaxWsNode.this.fireDisplayNameChange(string, stringArray[0]);
                                    JaxWsNode.this.fireNameChange(string, stringArray[0]);
                                    JaxWsNode.this.fireShortDescriptionChange();
                                    if (!WSUtils.isJsr109Supported(JaxWsNode.this.project)) {
                                        JAXWSLightSupport jAXWSLightSupport = JAXWSLightSupport.getJAXWSLightSupport((FileObject)fileObject);
                                        FileObject fileObject2 = jAXWSLightSupport.getDeploymentDescriptorFolder();
                                        if (fileObject2 != null) {
                                            try {
                                                WSUtils.replaceSunJaxWsEntries(fileObject2, string, stringArray[0]);
                                            }
                                            catch (IOException iOException) {
                                                Logger.getLogger(JaxWsNode.class.getName()).log(Level.WARNING, "Cannot modify endpoint in sun-jaxws.xml file", iOException);
                                            }
                                        }
                                        try {
                                            WSUtils.replaceServiceEntriesFromDD(JaxWsNode.this.project, string, stringArray[0]);
                                        }
                                        catch (IOException iOException) {
                                            Logger.getLogger(JaxWsNode.class.getName()).log(Level.WARNING, "Cannot modify web.xml file", iOException);
                                        }
                                    }
                                }
                            }
                        }
                    }
                });
            }
        });
    }

    private String getServiceName(CompilationController compilationController, TypeElement typeElement) {
        TypeElement typeElement2 = compilationController.getElements().getTypeElement("javax.jws.WebService");
        if (typeElement2 != null) {
            List<? extends AnnotationMirror> list = typeElement.getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : list) {
                if (!compilationController.getTypes().isSameType(typeElement2.asType(), annotationMirror.getAnnotationType())) continue;
                Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : map.entrySet()) {
                    if (!entry.getKey().getSimpleName().contentEquals("serviceName")) continue;
                    return (String)map.get(entry.getKey()).getValue();
                }
            }
        }
        return null;
    }

    public void configureHandler() {
        File file;
        Object object;
        FileObject fileObject;
        boolean[] blArray;
        HandlerChains handlerChains;
        FileObject fileObject2;
        ArrayList<String> arrayList;
        FileObject fileObject3;
        block10: {
            fileObject3 = this.getImplBean();
            arrayList = new ArrayList<String>();
            fileObject2 = null;
            handlerChains = null;
            Object[] objectArray = new String[1];
            blArray = new boolean[]{true};
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject3);
            CancellableTask<CompilationController> cancellableTask = new CancellableTask<CompilationController>((String[])objectArray){
                final /* synthetic */ String[] val$handlerFileName;
                {
                    this.val$handlerFileName = stringArray;
                }

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)compilationController);
                    AnnotationMirror annotationMirror = _RetoucheUtil.getAnnotation(compilationController, typeElement, "javax.jws.HandlerChain");
                    if (annotationMirror != null) {
                        blArray[0] = false;
                        Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
                        for (ExecutableElement executableElement : map.keySet()) {
                            if (!executableElement.getSimpleName().contentEquals("file")) continue;
                            this.val$handlerFileName[0] = (String)map.get(executableElement).getValue();
                            break;
                        }
                    }
                }

                public void cancel() {
                }
            };
            try {
                javaSource.runUserActionTask((Task)cancellableTask, true);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            if (!blArray[0] && objectArray[0] != null) {
                try {
                    fileObject = fileObject3.getParent();
                    object = FileUtil.toFile((FileObject)fileObject);
                    file = new File((File)object, objectArray[0]);
                    if (file.exists()) {
                        file = file.getCanonicalFile();
                        fileObject2 = FileUtil.toFileObject((File)file);
                    }
                    if (fileObject2 != null) {
                        try {
                            handlerChains = HandlerChainsProvider.getDefault().getHandlerChains(fileObject2);
                        }
                        catch (Exception exception) {
                            ErrorManager.getDefault().notify((Throwable)exception);
                            return;
                        }
                        HandlerChain[] handlerChainArray = handlerChains.getHandlerChains();
                        HandlerChain handlerChain = handlerChainArray[0];
                        Handler[] handlerArray = handlerChain.getHandlers();
                        for (int i = 0; i < handlerArray.length; ++i) {
                            arrayList.add(handlerArray[i].getHandlerClass());
                        }
                        break block10;
                    }
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsNode.class, (String)"MSG_HANDLER_FILE_NOT_FOUND", (Object[])objectArray), 1);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }
        fileObject = new MessageHandlerPanel(this.project, arrayList, true, this.service.getServiceName());
        object = NbBundle.getMessage(JaxWsNode.class, (String)"TTL_MessageHandlerPanel");
        file = new DialogDescriptor((Object)fileObject, (String)object);
        file.setButtonListener(new HandlerButtonListener((MessageHandlerPanel)fileObject, handlerChains, fileObject2, fileObject3, this.service, blArray[0]));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)file);
    }

    private void removeStaleFile(String string) throws IOException {
        FileObject fileObject = this.project.getProjectDirectory().getFileObject("target/jaxws/stale/" + string + ".stale");
        if (fileObject != null) {
            fileObject.delete();
        }
    }

    private String getServiceUri(String string) {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        J2eeModule.Type type = j2eeModuleProvider.getJ2eeModule().getType();
        String string2 = null;
        WSStackUtils wSStackUtils = new WSStackUtils(this.project);
        try {
            Object object;
            ServiceInfo serviceInfo = new ServiceInfo();
            serviceInfo.setEjb(J2eeModule.Type.EJB.equals(type));
            this.resolveServiceInfo(serviceInfo);
            boolean bl = false;
            WSStack<JaxWs> wSStack = wSStackUtils.getWsStack(JaxWs.class);
            if (wSStack != null && (object = ((JaxWs)wSStack.get()).getWsUriDescriptor()) != null) {
                bl = true;
                ServerContextInfo serverContextInfo = this.getServerContextInfo();
                string2 = object.getServiceUri(string, serviceInfo.getServiceName(), serviceInfo.getPortName(), serviceInfo.isEjb());
            }
            if (!bl) {
                object = serviceInfo.getPortName();
                string2 = (string == null ? "" : string + "/") + serviceInfo.getServiceName() + (object == null ? "" : "/" + (String)object);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string2;
    }

    private ServerContextInfo getServerContextInfo() {
        Object object;
        Object object2;
        String string = "8080";
        String string2 = "localhost";
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        String string3 = j2eeModuleProvider.getServerInstanceID();
        if (string3 == null) {
            Logger.getLogger(JaxWsNode.class.getName()).log(Level.INFO, "Can not detect target J2EE server");
        }
        ServerInstance serverInstance = Deployment.getDefault().getServerInstance(string3);
        try {
            object2 = serverInstance.getDescriptor();
            if (object2 != null) {
                int n = object2.getHttpPort();
                string = n == 0 ? "8080" : String.valueOf(n);
                object = object2.getHostname();
                if (object != null) {
                    string2 = object;
                }
            } else {
                InstanceProperties instanceProperties = j2eeModuleProvider.getInstanceProperties();
                if (instanceProperties == null) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsNode.class, (String)"MSG_MissingServer"), 0));
                } else {
                    string = this.getPortNumber(instanceProperties);
                    string2 = this.getHostName(instanceProperties);
                }
            }
        }
        catch (InstanceRemovedException instanceRemovedException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, "Removed ServerInstance", instanceRemovedException);
        }
        object2 = "";
        J2eeModule.Type type = j2eeModuleProvider.getJ2eeModule().getType();
        object = new WSStackUtils(this.project);
        if (J2eeModule.Type.WAR.equals(type)) {
            J2eeModuleProvider.ConfigSupport configSupport = j2eeModuleProvider.getConfigSupport();
            try {
                object2 = configSupport.getWebContextRoot();
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
            if (object2 != null && ((String)object2).startsWith("/")) {
                object2 = ((String)object2).substring(1);
            }
        } else if (J2eeModule.Type.EJB.equals(type) && ServerType.JBOSS == ((WSStackUtils)object).getServerType()) {
            object2 = this.project.getProjectDirectory().getName();
        }
        return new ServerContextInfo(string2, string, (String)object2);
    }

    private ServiceInfo getServiceInfo() {
        ServiceInfo serviceInfo = new ServiceInfo();
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        boolean bl = J2eeModule.Type.EJB.equals(j2eeModuleProvider.getJ2eeModule().getType());
        serviceInfo.setEjb(bl);
        try {
            this.resolveServiceInfo(serviceInfo);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return serviceInfo;
    }

    private void resolveServiceInfo(ServiceInfo serviceInfo) throws UnsupportedEncodingException {
        Object object;
        final String[] stringArray = new String[1];
        final String[] stringArray2 = new String[1];
        final boolean[] blArray = new boolean[]{false};
        JavaSource javaSource = this.getImplBeanJavaSource();
        if (javaSource != null) {
            object = new CancellableTask<CompilationController>(){

                public void run(CompilationController compilationController) throws IOException {
                    boolean bl;
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)compilationController);
                    TypeElement typeElement2 = compilationController.getElements().getTypeElement("javax.jws.WebService");
                    if (typeElement != null && typeElement2 != null && !(bl = JaxWsNode.this.resolveServiceUrl(compilationController, typeElement, typeElement2, stringArray, stringArray2))) {
                        TypeElement typeElement3 = compilationController.getElements().getTypeElement("javax.xml.ws.WebServiceProvider");
                        List<? extends AnnotationMirror> list = typeElement.getAnnotationMirrors();
                        for (AnnotationMirror annotationMirror : list) {
                            if (!compilationController.getTypes().isSameType(typeElement3.asType(), annotationMirror.getAnnotationType())) continue;
                            blArray[0] = true;
                        }
                    }
                }

                public void cancel() {
                }
            };
            try {
                javaSource.runUserActionTask((Task)object, true);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
        object = this.service.getImplementationClass();
        String string = this.getNameFromPackageName((String)object);
        if (stringArray[0] == null) {
            stringArray[0] = URLEncoder.encode(string + "Service", "UTF-8");
        }
        serviceInfo.setServiceName(stringArray[0]);
        if (stringArray2[0] == null) {
            stringArray2[0] = blArray[0] ? object : string;
            stringArray2[0] = URLEncoder.encode(stringArray2[0], "UTF-8");
        }
        serviceInfo.setPortName(stringArray2[0]);
    }

    private boolean resolveServiceUrl(CompilationController compilationController, TypeElement typeElement, TypeElement typeElement2, String[] stringArray, String[] stringArray2) throws IOException {
        boolean bl = false;
        List<? extends AnnotationMirror> list = typeElement.getAnnotationMirrors();
        block0: for (AnnotationMirror annotationMirror : list) {
            if (!compilationController.getTypes().isSameType(typeElement2.asType(), annotationMirror.getAnnotationType())) continue;
            bl = true;
            Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : map.entrySet()) {
                if (entry.getKey().getSimpleName().contentEquals("serviceName")) {
                    stringArray[0] = (String)map.get(entry.getKey()).getValue();
                    if (stringArray[0] != null) {
                        stringArray[0] = URLEncoder.encode(stringArray[0], "UTF-8");
                    }
                } else if (entry.getKey().getSimpleName().contentEquals("name")) {
                    stringArray2[0] = (String)map.get(entry.getKey()).getValue();
                    if (stringArray2[0] != null) {
                        stringArray2[0] = URLEncoder.encode(stringArray2[0], "UTF-8");
                    }
                }
                if (stringArray[0] == null || stringArray2[0] == null) continue;
                break block0;
            }
        }
        return bl;
    }

    private class ServiceInfo {
        private String serviceName;
        private String portName;
        private boolean ejb;

        private ServiceInfo() {
        }

        public void setEjb(boolean bl) {
            this.ejb = bl;
        }

        public void setPortName(String string) {
            this.portName = string;
        }

        public void setServiceName(String string) {
            this.serviceName = string;
        }

        public boolean isEjb() {
            return this.ejb;
        }

        public String getPortName() {
            return this.portName;
        }

        public String getServiceName() {
            return this.serviceName;
        }
    }

    private class ServerContextInfo {
        private String host;
        private String port;
        private String contextRoot;

        public ServerContextInfo(String string, String string2, String string3) {
            this.host = string;
            this.port = string2;
            this.contextRoot = string3;
        }

        public String getHost() {
            return this.host;
        }

        public String getPort() {
            return this.port;
        }

        public String getContextRoot() {
            return this.contextRoot;
        }
    }
}

