/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.config;

import java.io.File;
import java.util.HashMap;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;

public abstract class AbstractFilesListener {
    protected J2eeModuleProvider provider;
    private HashMap fileListeners = new HashMap();
    private FileChangeListener listener = new FileListener();

    public AbstractFilesListener(J2eeModuleProvider j2eeModuleProvider) {
        this.provider = j2eeModuleProvider;
        this.startListening();
    }

    protected abstract File[] getTargetFiles();

    protected abstract boolean isTarget(FileObject var1);

    protected abstract boolean isTarget(String var1);

    protected abstract void targetCreated(FileObject var1);

    protected abstract void targetDeleted(FileObject var1);

    protected abstract void targetChanged(FileObject var1);

    private synchronized void startListening() {
        File[] fileArray = this.getTargetFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            this.startListening(fileArray[i]);
        }
    }

    public synchronized void stopListening() {
        for (FileObject fileObject : this.fileListeners.keySet()) {
            this.removeFileListenerFrom(fileObject);
        }
    }

    private void startListening(File file) {
        if (!file.isAbsolute()) {
            return;
        }
        FileObject fileObject = FileUtil.toFileObject((File)file);
        while (fileObject == null) {
            if ((file = file.getParentFile()) == null) {
                return;
            }
            fileObject = FileUtil.toFileObject((File)file);
        }
        if (!this.fileListeners.containsKey(fileObject)) {
            this.addFileListenerTo(fileObject);
        }
    }

    private void addFileListenerTo(FileObject fileObject) {
        FileChangeListener fileChangeListener = FileUtil.weakFileChangeListener((FileChangeListener)this.listener, (Object)fileObject);
        this.fileListeners.put(fileObject, fileChangeListener);
        fileObject.addFileChangeListener(fileChangeListener);
    }

    private void removeFileListenerFrom(FileObject fileObject) {
        FileChangeListener fileChangeListener = (FileChangeListener)this.fileListeners.remove(fileObject);
        if (fileChangeListener != null) {
            fileObject.removeFileChangeListener(fileChangeListener);
        }
    }

    private final class FileListener
    implements FileChangeListener {
        private FileListener() {
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            AbstractFilesListener.this.startListening();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileDeleted(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            if (AbstractFilesListener.this.isTarget(fileObject)) {
                HashMap hashMap = AbstractFilesListener.this.fileListeners;
                synchronized (hashMap) {
                    AbstractFilesListener.this.removeFileListenerFrom(fileObject);
                }
                AbstractFilesListener.this.targetDeleted(fileObject);
            }
            AbstractFilesListener.this.startListening();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileDataCreated(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            if (AbstractFilesListener.this.isTarget(fileObject)) {
                HashMap hashMap = AbstractFilesListener.this.fileListeners;
                synchronized (hashMap) {
                    AbstractFilesListener.this.addFileListenerTo(fileObject);
                }
                AbstractFilesListener.this.targetCreated(fileObject);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            FileObject fileObject = fileRenameEvent.getFile();
            if (AbstractFilesListener.this.isTarget(fileObject)) {
                HashMap hashMap = AbstractFilesListener.this.fileListeners;
                synchronized (hashMap) {
                    if (!AbstractFilesListener.this.fileListeners.containsKey(fileObject)) {
                        AbstractFilesListener.this.addFileListenerTo(fileObject);
                    }
                }
                AbstractFilesListener.this.targetCreated(fileObject);
            } else if (AbstractFilesListener.this.isTarget(fileRenameEvent.getName() + "." + fileRenameEvent.getExt())) {
                HashMap hashMap = AbstractFilesListener.this.fileListeners;
                synchronized (hashMap) {
                    AbstractFilesListener.this.removeFileListenerFrom(fileObject);
                }
                AbstractFilesListener.this.targetDeleted(fileObject);
            }
            AbstractFilesListener.this.startListening();
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            if (AbstractFilesListener.this.isTarget(fileObject)) {
                fileObject.refresh(true);
                AbstractFilesListener.this.targetChanged(fileObject);
            }
        }
    }
}

