/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.glassfish.common.wizards.AddServerLocationPanel;
import org.netbeans.modules.glassfish.common.wizards.Retriever;
import org.netbeans.modules.glassfish.common.wizards.ServerWizardIterator;
import org.netbeans.modules.glassfish.spi.Utils;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class AddServerLocationVisualPanel
extends JPanel
implements Retriever.Updater {
    private String nameOfBits;
    public static final String V3_DOWNLOAD_PREFIX = "http://java.net/download/";
    private final List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
    private Retriever retriever;
    private volatile DownloadState downloadState;
    private volatile String statusText;
    private ServerWizardIterator wizardIterator;
    private JCheckBox agreeCheckBox;
    private JButton browseButton;
    private JButton downloadButton;
    private JLabel downloadStatusLabel;
    private JLabel hk2HomeLabel;
    private JTextField hk2HomeTextField;
    private JButton readlicenseButton;

    public AddServerLocationVisualPanel(ServerWizardIterator swi) {
        this.wizardIterator = swi;
        this.initComponents();
        this.initUserComponents();
    }

    private void initUserComponents() {
        this.downloadButton.setEnabled(false);
        this.setName(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"TITLE_ServerLocation"));
        this.hk2HomeTextField.setText(this.getPreviousValue());
        this.hk2HomeTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddServerLocationVisualPanel.this.homeFolderChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddServerLocationVisualPanel.this.homeFolderChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddServerLocationVisualPanel.this.homeFolderChanged();
            }
        });
        this.setDownloadState(DownloadState.AVAILABLE);
        this.updateMessageText("");
    }

    private String getPreviousValue() {
        Preferences prefs = NbPreferences.forModule(this.wizardIterator.getClass());
        String prevValue = null;
        if (null != prefs) {
            prevValue = prefs.get(this.wizardIterator.getInstallRootKey(), null);
        }
        if (null == prevValue) {
            String installDir = System.getProperty(this.wizardIterator.getInstallRootProperty());
            if (null != installDir && installDir.trim().length() != 0) {
                return installDir;
            }
            return System.getProperty("user.home") + File.separatorChar + this.wizardIterator.getDefaultInstallDirectoryName();
        }
        return prevValue;
    }

    public DownloadState getDownloadState() {
        return this.downloadState;
    }

    public String getHk2HomeLocation() {
        return this.hk2HomeTextField.getText();
    }

    public String getStatusText() {
        return this.statusText;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChangeEvent() {
        ChangeEvent ev = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(ev);
        }
    }

    private String browseHomeLocation(String nameOfBits) {
        String hk2Location = null;
        JFileChooser chooser = this.getJFileChooser(nameOfBits);
        int returnValue = chooser.showDialog(this, NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_ChooseButton"));
        if (returnValue == 0) {
            hk2Location = chooser.getSelectedFile().getAbsolutePath();
        }
        return hk2Location;
    }

    private JFileChooser getJFileChooser(String nameOfBits) {
        JFileChooser chooser = new JFileChooser();
        String t = NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_ChooserName", (Object)nameOfBits);
        chooser.setDialogTitle(t);
        chooser.setDialogType(2);
        chooser.setFileSelectionMode(1);
        chooser.setApproveButtonMnemonic("Choose_Button_Mnemonic".charAt(0));
        chooser.setMultiSelectionEnabled(false);
        chooser.addChoosableFileFilter(new DirFilter(nameOfBits));
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setApproveButtonToolTipText(t);
        chooser.getAccessibleContext().setAccessibleName(t);
        chooser.getAccessibleContext().setAccessibleDescription(t);
        File currentLocation = new File(this.hk2HomeTextField.getText());
        File currentLocationParent = currentLocation.getParentFile();
        if (currentLocationParent != null && currentLocationParent.exists()) {
            chooser.setCurrentDirectory(currentLocationParent);
        }
        if (currentLocation.exists() && currentLocation.isDirectory()) {
            chooser.setSelectedFile(currentLocation);
        }
        return chooser;
    }

    @Override
    public void removeNotify() {
        if (this.retriever != null) {
            this.retriever.stopRetrieval();
        }
        super.removeNotify();
    }

    @Override
    public void updateMessageText(final String msg) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                if (msg.trim().startsWith("<html>")) {
                    AddServerLocationVisualPanel.this.downloadStatusLabel.setText(msg);
                } else {
                    AddServerLocationVisualPanel.this.downloadStatusLabel.setText("<html>" + msg + "</html>");
                }
                AddServerLocationVisualPanel.this.fireChangeEvent();
            }
        });
    }

    @Override
    public void updateStatusText(String status) {
        this.statusText = status;
        this.fireChangeEvent();
    }

    @Override
    public void clearCancelState() {
        this.setDownloadState(this.retriever.getDownloadState() == 3 ? DownloadState.COMPLETED : DownloadState.AVAILABLE);
        this.retriever = null;
    }

    private void updateButton() {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                boolean writableLoc;
                DownloadState state = AddServerLocationVisualPanel.this.downloadState;
                boolean licenseAccepted = AddServerLocationVisualPanel.this.agreeCheckBox.isSelected();
                File val = new File(AddServerLocationVisualPanel.this.hk2HomeTextField.getText().trim());
                boolean bl = writableLoc = AddServerLocationPanel.canCreate(val) || Utils.canWrite(val);
                String buttonTextKey = state == DownloadState.DOWNLOADING ? "LBL_CancelDownload" : (state == DownloadState.COMPLETED ? "LBL_DownloadComplete" : "LBL_DownloadNow");
                String buttonText = NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)buttonTextKey);
                AddServerLocationVisualPanel.this.downloadButton.setText(buttonText);
                AddServerLocationVisualPanel.this.downloadButton.setEnabled(state != DownloadState.COMPLETED && licenseAccepted && writableLoc);
            }
        });
    }

    private synchronized void setDownloadState(DownloadState state) {
        this.downloadState = state;
        this.updateButton();
    }

    private void homeFolderChanged() {
        this.updateMessageText("");
        if (this.downloadState == DownloadState.COMPLETED) {
            this.setDownloadState(DownloadState.AVAILABLE);
        } else {
            this.updateButton();
        }
    }

    private void initComponents() {
        this.hk2HomeLabel = new JLabel();
        this.hk2HomeTextField = new JTextField();
        this.browseButton = new JButton();
        this.downloadButton = new JButton();
        this.agreeCheckBox = new JCheckBox();
        this.readlicenseButton = new JButton();
        this.downloadStatusLabel = new JLabel();
        this.hk2HomeLabel.setLabelFor(this.hk2HomeTextField);
        Mnemonics.setLocalizedText((JLabel)this.hk2HomeLabel, (String)NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_InstallLocation"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_BrowseButton"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddServerLocationVisualPanel.this.browseButtonActionPerformed(evt);
            }
        });
        this.downloadButton.setText("[download/cancel]");
        this.downloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddServerLocationVisualPanel.this.downloadButtonActionPerformed(evt);
            }
        });
        this.agreeCheckBox.setMargin(new Insets(4, 4, 4, 4));
        this.agreeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddServerLocationVisualPanel.this.agreeCheckBoxActionPerformed(evt);
            }
        });
        this.readlicenseButton.setText(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_ReadLicenseText"));
        this.readlicenseButton.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.readlicenseButton.setBorderPainted(false);
        this.readlicenseButton.setContentAreaFilled(false);
        this.readlicenseButton.setHorizontalAlignment(10);
        this.readlicenseButton.setVerticalAlignment(1);
        this.readlicenseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddServerLocationVisualPanel.this.readlicenseButtonActionPerformed(evt);
            }
        });
        this.downloadStatusLabel.setText("[download status]");
        this.downloadStatusLabel.setVerticalAlignment(1);
        this.downloadStatusLabel.setHorizontalTextPosition(10);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.hk2HomeLabel).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.downloadButton).addPreferredGap(1).add((Component)this.agreeCheckBox).add(2, 2, 2).add((Component)this.readlicenseButton, -1, -1, Short.MAX_VALUE)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.hk2HomeTextField, -1, 387, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.browseButton)).add((Component)this.downloadStatusLabel, -1, 480, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.hk2HomeLabel).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.hk2HomeTextField, -2, -1, -2).add((Component)this.browseButton)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.downloadButton).add((Component)this.agreeCheckBox).add((Component)this.readlicenseButton)).addPreferredGap(0).add((Component)this.downloadStatusLabel).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void readlicenseButtonActionPerformed(ActionEvent evt) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("https://glassfish.dev.java.net/public/CDDL+GPL.html"));
        }
        catch (Exception ex) {
            Logger.getLogger("glassfish").log(Level.INFO, ex.getLocalizedMessage(), ex);
        }
    }

    private void downloadButtonActionPerformed(ActionEvent evt) {
        if (this.retriever == null) {
            this.updateStatusText("");
            this.retriever = new Retriever(new File(this.hk2HomeTextField.getText()), this.wizardIterator.getIndirect(), V3_DOWNLOAD_PREFIX, this.wizardIterator.getDirect(), this, "glassfish");
            new Thread(this.retriever).start();
            this.setDownloadState(DownloadState.DOWNLOADING);
        } else {
            this.retriever.stopRetrieval();
            this.setDownloadState(DownloadState.AVAILABLE);
        }
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        String newLoc = this.browseHomeLocation(this.wizardIterator.getNameOfBits());
        if (newLoc != null && newLoc.length() > 0) {
            this.hk2HomeTextField.setText(newLoc);
        }
    }

    private void agreeCheckBoxActionPerformed(ActionEvent evt) {
        DownloadState state = this.downloadState;
        if (state == DownloadState.COMPLETED) {
            this.setDownloadState(DownloadState.AVAILABLE);
        } else {
            File val = new File(this.hk2HomeTextField.getText().trim());
            boolean writableLoc = AddServerLocationPanel.canCreate(val) || Utils.canWrite(val);
            this.downloadButton.setEnabled(this.agreeCheckBox.isSelected() && writableLoc);
        }
    }

    private static class DirFilter
    extends FileFilter {
        private String nameOfBits;

        DirFilter(String nameOfBits) {
            this.nameOfBits = nameOfBits;
        }

        @Override
        public boolean accept(File f) {
            return f.exists() && f.canRead() && f.isDirectory();
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_DirType", (Object)this.nameOfBits);
        }
    }

    public static enum DownloadState {
        AVAILABLE,
        DOWNLOADING,
        COMPLETED;

    }
}

