/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class NotNode
extends Node {
    private final Node conditionNode;

    public NotNode(ISourcePosition position, Node conditionNode) {
        super(position, NodeType.NOTNODE);
        assert (conditionNode != null) : "conditionNode is not null";
        this.conditionNode = conditionNode;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitNotNode(this);
    }

    public Node getConditionNode() {
        return this.conditionNode;
    }

    @Override
    public List<Node> childNodes() {
        return NotNode.createList(this.conditionNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject result = this.conditionNode.interpret(runtime, context, self, aBlock);
        return result.isTrue() ? runtime.getFalse() : runtime.getTrue();
    }
}

