/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui.customizer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.modules.ruby.platform.gems.GemInfo;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.rubyproject.GemRequirement;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class GemRequirementDetailsPanel
extends JPanel {
    private final GemManager gemManager;
    private final String gemName;
    private final String indexedVersion;
    private final GemRequirement gemRequirement;
    private JComboBox operatorCombo;
    private JLabel requirementLabel;
    private JComboBox versionCombo;

    public GemRequirementDetailsPanel(GemManager gemManager, String gemName, String requiredVersion, String indexedVersion) {
        this.gemManager = gemManager;
        this.gemName = gemName;
        this.indexedVersion = indexedVersion;
        this.gemRequirement = GemRequirement.fromString(gemName + " " + requiredVersion);
        this.initComponents();
        this.initRequiredVersion();
        this.initGemVersions();
    }

    private void initRequiredVersion() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (String operator : GemRequirement.getOperators()) {
            model.addElement(operator);
        }
        this.operatorCombo.setModel(model);
        if (!this.isEmpty(this.gemRequirement.getOperator())) {
            this.operatorCombo.setSelectedItem(this.gemRequirement.getOperator());
        }
    }

    private boolean isEmpty(String str) {
        return str == null || "".equals(str.trim());
    }

    private void initGemVersions() {
        boolean versionSpecified;
        List gemInfos = this.gemManager.getVersions(this.gemName);
        ArrayList<String> versions = new ArrayList<String>();
        for (GemInfo each : gemInfos) {
            versions.add(each.getVersion());
        }
        boolean bl = versionSpecified = !this.isEmpty(this.gemRequirement.getVersion());
        if (versionSpecified && !versions.contains(this.gemRequirement.getVersion())) {
            versions.add(this.gemRequirement.getVersion());
        }
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        Collections.sort(versions);
        for (String each : versions) {
            model.addElement(each);
        }
        this.versionCombo.setModel(model);
        this.versionCombo.setSelectedItem(versionSpecified ? this.gemRequirement.getVersion() : this.indexedVersion);
    }

    GemRequirement getGemRequirement() {
        return GemRequirement.fromString(this.gemName + " " + this.operatorCombo.getSelectedItem() + " " + this.versionCombo.getSelectedItem());
    }

    private void initComponents() {
        this.operatorCombo = new JComboBox();
        this.versionCombo = new JComboBox();
        this.requirementLabel = new JLabel();
        this.operatorCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.versionCombo.setEditable(true);
        this.versionCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        Mnemonics.setLocalizedText((JLabel)this.requirementLabel, (String)NbBundle.getMessage(GemRequirementDetailsPanel.class, (String)"GemRequirementDetailsPanel.requirementLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.requirementLabel).addGroup(layout.createSequentialGroup().addComponent(this.operatorCombo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.versionCombo, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.requirementLabel).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.operatorCombo, -2, -1, -2).addComponent(this.versionCombo, -2, -1, -2)).addContainerGap(23, Short.MAX_VALUE)));
    }
}

