/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.web.beans.impl.model.AnnotationObjectProvider;
import org.netbeans.modules.web.beans.impl.model.Filter;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;

class MemberCheckerFilter<T extends Element>
extends Filter<T> {
    private WebBeansModelImplementation myImpl;
    private Map<? extends ExecutableElement, ? extends AnnotationValue> myValues;
    private Set<ExecutableElement> myMembers;
    private Class<T> myClass;

    private MemberCheckerFilter(Class<T> clazz) {
        this.myClass = clazz;
    }

    public static <T extends Element> MemberCheckerFilter<T> get(Class<T> clazz) {
        MemberCheckerFilter.assertElement(clazz);
        if (clazz.equals(Element.class)) {
            return new MemberCheckerFilter<Element>(Element.class);
        }
        if (clazz.equals(TypeElement.class)) {
            return new MemberCheckerFilter<TypeElement>(TypeElement.class);
        }
        return null;
    }

    void init(Map<? extends ExecutableElement, ? extends AnnotationValue> map, Set<ExecutableElement> set, WebBeansModelImplementation webBeansModelImplementation) {
        this.myImpl = webBeansModelImplementation;
        this.myValues = map;
        this.myMembers = set;
    }

    @Override
    void filter(Set<T> set) {
        super.filter(set);
        for (Map.Entry<ExecutableElement, AnnotationValue> entry : this.getValues().entrySet()) {
            ExecutableElement executableElement = entry.getKey();
            AnnotationValue annotationValue = entry.getValue();
            if (!this.getMemebers().contains(executableElement)) continue;
            this.checkMember(executableElement, annotationValue, set);
        }
    }

    Class<T> getElementClass() {
        return this.myClass;
    }

    static Element getSpecialized(Element element, WebBeansModelImplementation webBeansModelImplementation, String string) {
        return MemberCheckerFilter.getSpecialized(element, webBeansModelImplementation.getHelper(), string);
    }

    static Element getSpecialized(Element element, AnnotationModelHelper annotationModelHelper, String string) {
        ExecutableElement executableElement;
        if (!(element instanceof ExecutableElement)) {
            return null;
        }
        ExecutableElement executableElement2 = (ExecutableElement)element;
        while ((executableElement = annotationModelHelper.getCompilationController().getElementUtilities().getOverriddenMethod(executableElement2)) != null && AnnotationObjectProvider.hasSpecializes(executableElement2, annotationModelHelper)) {
            if ("javax.enterprise.inject.Default".equals(string) ? AnnotationObjectProvider.checkSpecializedDefault(executableElement, annotationModelHelper) : AnnotationObjectProvider.hasAnnotation(executableElement, string, annotationModelHelper)) {
                return executableElement;
            }
            executableElement2 = executableElement;
        }
        return null;
    }

    private void checkMember(ExecutableElement executableElement, AnnotationValue annotationValue, Set<T> set) {
        Element element = executableElement.getEnclosingElement();
        if (!(element instanceof TypeElement)) {
            return;
        }
        String string = ((TypeElement)element).getQualifiedName().toString();
        Iterator<T> iterator = set.iterator();
        while (iterator.hasNext()) {
            Element element2;
            Element element3 = (Element)iterator.next();
            if (this.checkMember(executableElement, annotationValue, element3, iterator, string)) continue;
            if (element3 instanceof TypeElement) {
                element2 = AnnotationObjectProvider.checkSuper((TypeElement)element3, string, this.getImplementation().getHelper());
                if (element2 == null) continue;
                this.checkMember(executableElement, annotationValue, element2, iterator, string);
                continue;
            }
            if (!(element3 instanceof ExecutableElement) || (element2 = MemberCheckerFilter.getSpecialized(element3, this.getImplementation(), string)) == null) continue;
            this.checkMember(executableElement, annotationValue, element2, iterator, string);
        }
    }

    private boolean checkMember(ExecutableElement executableElement, AnnotationValue annotationValue, Element element, Iterator<? extends Element> iterator, String string) {
        List<? extends AnnotationMirror> list = this.getImplementation().getHelper().getCompilationController().getElements().getAllAnnotationMirrors(element);
        AnnotationMirror annotationMirror = (AnnotationMirror)this.getImplementation().getHelper().getAnnotationsByType(list).get(string);
        if (annotationMirror == null) {
            return false;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
        AnnotationValue annotationValue2 = map.get(executableElement);
        if (!this.equals(annotationValue, annotationValue2)) {
            iterator.remove();
        }
        return true;
    }

    private boolean equals(AnnotationValue annotationValue, AnnotationValue annotationValue2) {
        if (annotationValue == null) {
            return annotationValue2 == null;
        }
        if (annotationValue.getValue() == null) {
            return annotationValue2 != null && annotationValue2.getValue() == null;
        }
        return annotationValue.getValue().equals(annotationValue2 == null ? null : annotationValue2.getValue());
    }

    private WebBeansModelImplementation getImplementation() {
        return this.myImpl;
    }

    private Map<? extends ExecutableElement, ? extends AnnotationValue> getValues() {
        return this.myValues;
    }

    private Set<ExecutableElement> getMemebers() {
        return this.myMembers;
    }
}

