/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.dtrace.collector;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.types.Time;
import org.netbeans.modules.dlight.util.DLightLogger;

public class DtraceParser {
    private static final Logger log = DLightLogger.getLogger(DtraceParser.class);
    private static final Pattern regex = Pattern.compile("[^\\s\"']+|\"[^\"]*\"|'[^']*'");
    private static final char DQUOTE = '\"';
    private static final char SQUOTE = '\'';
    private final DataTableMetadata metadata;

    public DtraceParser(DataTableMetadata metadata) {
        this.metadata = metadata;
    }

    private List<Object> parse(String line) {
        assert (this.metadata != null);
        return this.parse(line, this.metadata.getColumnsCount());
    }

    protected List<Object> parse(String line, int colCount) {
        ArrayList<String> matchList = new ArrayList<String>();
        Matcher regexMatcher = regex.matcher(line);
        while (regexMatcher.find()) {
            matchList.add(regexMatcher.group());
        }
        if (matchList.size() < colCount && log.isLoggable(Level.INFO)) {
            log.info("^^^^^Line:" + line + " lines array size is " + "less than medatadat.getCoulmnsCount() columnsCount=" + this.metadata.getColumnsCount() + " lines splited=" + matchList.size());
            return null;
        }
        try {
            List columns = this.metadata.getColumns();
            ArrayList<Object> data = new ArrayList<Object>(columns.size());
            for (int i = 0; i < colCount; ++i) {
                Class columnClass;
                String stringValue = (String)matchList.get(i);
                int stringLength = stringValue.length();
                if (stringValue != null && 2 <= stringLength && (stringValue.charAt(0) == '\'' && stringValue.charAt(stringLength - 1) == '\'' || stringValue.charAt(0) == '\"' && stringValue.charAt(stringLength - 1) == '\"')) {
                    stringValue = stringValue.substring(1, stringLength - 1);
                }
                Object value = (columnClass = ((DataTableMetadata.Column)columns.get(i)).getColumnClass()) == Long.class || columnClass == Time.class ? Long.valueOf(stringValue) : (columnClass == Integer.class ? Integer.valueOf(stringValue) : (columnClass == Short.class ? Short.valueOf(stringValue) : (columnClass == Byte.class ? Byte.valueOf(stringValue) : (columnClass == Double.class ? Double.valueOf(stringValue) : (columnClass == Float.class ? Float.valueOf(stringValue) : stringValue)))));
                data.add(value);
            }
            return data;
        }
        catch (NumberFormatException ex) {
            log.log(Level.WARNING, "Failed to parse number in line: " + line, ex);
            return null;
        }
    }

    public DataRow process(String line) {
        List<Object> data = this.parse(line);
        if (data == null) {
            return null;
        }
        return new DataRow(this.metadata.getColumnNames(), data);
    }

    public DataRow processClose() {
        return null;
    }
}

