/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.dev.wizard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;
import org.netbeans.modules.websvc.core.dev.wizard.NodeDisplayPanel;
import org.openide.awt.Mnemonics;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.NbBundle;

public class EjbChooser
extends JPanel {
    public static final String IS_VALID = "ejbChooser_isValid";
    private NodeAcceptor nodeAcceptor;
    private NodeDisplayPanel nodeDisplayPanel;
    private JLabel jLabelDesc;
    private JLabel jLabelError;
    private JPanel jPanelBeanTree;

    public EjbChooser(Node node, boolean bl) {
        this.initComponents();
        this.nodeAcceptor = new NodeAcceptorImpl(bl);
        this.nodeDisplayPanel = new NodeDisplayPanel(node);
        this.nodeDisplayPanel.setBorder(new EtchedBorder());
        this.jPanelBeanTree.add(this.nodeDisplayPanel);
        this.nodeDisplayPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                EjbChooser.this.validateNodes();
            }
        });
        BeanTreeView beanTreeView = (BeanTreeView)this.nodeDisplayPanel.getComponent(0);
        this.jLabelDesc.setLabelFor(beanTreeView.getViewport().getView());
        this.validateNodes();
    }

    private void validateNodes() {
        boolean bl = this.nodeAcceptor.acceptNodes(this.nodeDisplayPanel.getSelectedNodes());
        if (!bl) {
            this.firePropertyChange(IS_VALID, true, false);
        } else {
            this.firePropertyChange(IS_VALID, false, true);
        }
    }

    private void setErrorMessage(String string) {
        if (string == null) {
            string = " ";
        }
        this.jLabelError.setText(string);
    }

    public Node[] getSelectedNodes() {
        return this.nodeDisplayPanel.getSelectedNodes();
    }

    public String getSelectedEJBProjectName() {
        return this.nodeDisplayPanel.getSelectedNodes()[0].getParentNode().getDisplayName();
    }

    private void initComponents() {
        this.jLabelDesc = new JLabel();
        this.jPanelBeanTree = new JPanel();
        this.jLabelError = new JLabel();
        this.setToolTipText(NbBundle.getMessage(EjbChooser.class, (String)"LBL_BrowseBean_Title"));
        this.setLayout(new GridBagLayout());
        this.jLabelDesc.setLabelFor(this.jPanelBeanTree);
        Mnemonics.setLocalizedText((JLabel)this.jLabelDesc, (String)NbBundle.getMessage(EjbChooser.class, (String)"LBL_SelectBeanDescription"));
        this.jLabelDesc.setToolTipText(NbBundle.getMessage(EjbChooser.class, (String)"HINT_EnterpriseBean"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add((Component)this.jLabelDesc, gridBagConstraints);
        this.jPanelBeanTree.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 11, 11);
        this.add((Component)this.jPanelBeanTree, gridBagConstraints);
        this.jLabelError.setForeground(new Color(255, 0, 0));
        this.jLabelError.setLabelFor(this.jPanelBeanTree);
        this.jLabelError.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 11, 0, 11);
        this.add((Component)this.jLabelError, gridBagConstraints);
    }

    private class NodeAcceptorImpl
    implements NodeAcceptor {
        private boolean localInterfaceOptional;

        public NodeAcceptorImpl(boolean bl) {
            this.localInterfaceOptional = bl;
        }

        public boolean acceptNodes(Node[] nodeArray) {
            EjbChooser.this.setErrorMessage(" ");
            if (nodeArray.length == 0) {
                EjbChooser.this.setErrorMessage(NbBundle.getMessage(EjbChooser.class, (String)"LBL_SelectOneEJB"));
                return false;
            }
            EjbReference ejbReference = (EjbReference)nodeArray[0].getLookup().lookup(EjbReference.class);
            if (ejbReference == null) {
                EjbChooser.this.setErrorMessage(NbBundle.getMessage(EjbChooser.class, (String)"LBL_NodeIsNotEJB"));
                return false;
            }
            if (ejbReference.getLocal() == null && ejbReference.getRemote() == null && !this.localInterfaceOptional) {
                EjbChooser.this.setErrorMessage(NbBundle.getMessage(EjbChooser.class, (String)"MSG_MISSING_INTERFACE"));
                return false;
            }
            return true;
        }
    }
}

