/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.refactoring;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.openide.util.Exceptions;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WebXMLRefactoringSupport {
    protected Document doc;
    private XPathFactory xpFactory = XPathFactory.newInstance();
    private XPath xPath = this.xpFactory.newXPath();
    private XPathExpression servletClassXPression;
    private XPathExpression filterClassXPression;
    private XPathExpression listenerClassXPression;
    private XPathExpression servletNameXPression;

    private WebXMLRefactoringSupport(Document doc) {
        try {
            this.servletClassXPression = this.xPath.compile("/web-app/servlet/servlet-class/text()");
            this.filterClassXPression = this.xPath.compile("/web-app/filter/filter-class/text()");
            this.listenerClassXPression = this.xPath.compile("/web-app/listener/listener-class/text()");
            this.servletNameXPression = this.xPath.compile("/web-app/servlet/servlet-name/text()");
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException("Internal initialization failure", e);
        }
        this.doc = doc;
    }

    public static WebXMLRefactoringSupport fromFile(File file) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            return new WebXMLRefactoringSupport(docBuilder.parse(file));
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException(ex);
        }
        catch (SAXException ex) {
            throw new IllegalStateException(ex);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public NodeList getServletClassElements() {
        try {
            return (NodeList)this.servletClassXPression.evaluate(this.doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException ex) {
            Logger.getLogger(WebXMLRefactoringSupport.class.getName()).log(Level.WARNING, null, ex);
            return null;
        }
    }

    public NodeList getListenerClassElements() {
        try {
            return (NodeList)this.listenerClassXPression.evaluate(this.doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException ex) {
            Logger.getLogger(WebXMLRefactoringSupport.class.getName()).log(Level.WARNING, null, ex);
            return null;
        }
    }

    public NodeList getFilterClassElements() {
        try {
            return (NodeList)this.filterClassXPression.evaluate(this.doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException ex) {
            Logger.getLogger(WebXMLRefactoringSupport.class.getName()).log(Level.WARNING, null, ex);
            return null;
        }
    }

    public Document getDocument() {
        return this.doc;
    }

    public boolean isServletDefined(String servletName) {
        try {
            XPathExpression xPression = this.xPath.compile("/web-app/servlet/servlet-name[text()='" + servletName + "']");
            return (Boolean)xPression.evaluate(this.doc, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException ex) {
            return false;
        }
    }

    public void addServletInfo(String servletName, String className, String urlPattern) {
        if (this.isServletDefined(servletName)) {
            throw new IllegalArgumentException("Servlet with name '" + servletName + "' is already defined.");
        }
        this.addServletElement(servletName, className);
        if (urlPattern != null) {
            this.addServletMappingElement(servletName, urlPattern);
        }
    }

    public void addServletElement(String servletName, String className) {
        Element servlet = this.doc.createElement("servlet");
        Element sName = this.doc.createElement("servlet-name");
        sName.setTextContent(servletName);
        Element sClass = this.doc.createElement("servlet-class");
        sClass.setTextContent(className);
        servlet.appendChild(sName);
        servlet.appendChild(sClass);
        this.getWebAppNode().appendChild(servlet);
    }

    public void addServletMappingElement(String servletName, String urlPattern) {
        Element mapping = this.doc.createElement("servlet-mapping");
        Element sName = this.doc.createElement("servlet-name");
        sName.setTextContent(servletName);
        Element url = this.doc.createElement("url-pattern");
        url.setTextContent(urlPattern);
        mapping.appendChild(sName);
        mapping.appendChild(url);
        this.getWebAppNode().appendChild(mapping);
    }

    public Node getWebAppNode() {
        Element node = this.doc.getDocumentElement();
        if (node == null) {
            Element root = this.doc.createElement("web-app");
            Attr attr = this.doc.createAttribute("version");
            attr.setNodeValue("2.0");
            this.doc.appendChild(root);
            return root;
        }
        if (node.getNodeName().equals("web-app")) {
            return node;
        }
        return null;
    }

    public Collection<String> getAllServletNames() {
        HashSet<String> names = new HashSet<String>();
        try {
            NodeList nodes = (NodeList)this.servletNameXPression.evaluate(this.doc, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                names.add(nodes.item(i).getNodeValue());
            }
        }
        catch (XPathExpressionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return names;
    }

    public String[] getURLPatterns(String servletName) {
        try {
            XPathExpression xPression = this.xPath.compile("/web-app/servlet-mapping[servlet-name/text()=\"" + servletName + "\"]/url-pattern/text()");
            NodeList nodes = (NodeList)xPression.evaluate(this.doc, XPathConstants.NODESET);
            String[] patterns = new String[nodes.getLength()];
            for (int i = 0; i < nodes.getLength(); ++i) {
                patterns[i] = nodes.item(i).getNodeValue();
            }
            return patterns;
        }
        catch (XPathExpressionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return new String[0];
        }
    }
}

