/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.cnd.api.model.services.CsmMacroExpansion;
import org.netbeans.modules.cnd.debugger.gdb.GdbCallStackFrame;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.models.AbstractVariable;

public class GdbWatchVariable
extends AbstractVariable
implements PropertyChangeListener {
    protected static final boolean disableMacros = Boolean.getBoolean("gdb.macros.disable");
    private final Watch watch;
    private static final Logger log = Logger.getLogger("gdb.logger.watches");
    private boolean requestType = true;
    private boolean requestValue = true;
    private boolean requestResolved = true;
    private String type = null;
    private String resolvedType = null;
    private String expandedWatch = null;

    public GdbWatchVariable(GdbDebugger debugger, Watch watch) {
        super(debugger, null);
        this.watch = watch;
        debugger.addPropertyChangeListener(this);
        watch.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public Watch getWatch() {
        return this.watch;
    }

    @Override
    protected void selfDestroy() {
        this.getDebugger().removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        log.fine("GWV.propertyChange: Property change for " + ev.getPropertyName());
        String pname = ev.getPropertyName();
        if (pname.equals("currentThread") || pname.equals("currentCallStackFrame") || pname.equals("expression")) {
            if (pname.equals("expression")) {
                this.tinfo = null;
            }
            this.emptyFields();
            this.requestType = true;
            this.requestValue = true;
            this.requestResolved = true;
            this.expandedWatch = null;
            this.notifyValueChanged(this.value, null);
        } else if ("valueChanged".equals(pname)) {
            this.onValueChange(ev);
        }
    }

    @Override
    public String getName() {
        return this.watch.getExpression();
    }

    @Override
    public String getType() {
        if (this.requestType) {
            String t = this.getDebugger().requestWhatis(this.getExpanded());
            this.type = t == null ? "" : t;
            this.requestType = false;
        }
        return this.type;
    }

    @Override
    protected String getResolvedType() {
        if (this.requestResolved) {
            this.resolvedType = this.getType().length() > 0 ? super.getResolvedType() : "";
            this.requestResolved = false;
        }
        return this.resolvedType;
    }

    @Override
    public String getValue() {
        if (this.requestValue) {
            this.value = this.getDebugger().evaluate(this.getExpanded());
            this.requestValue = false;
        }
        return super.getValue();
    }

    private String getExpanded() {
        if (this.expandedWatch == null) {
            String expr = this.watch.getExpression();
            if (!disableMacros) {
                expr = GdbWatchVariable.expandMacro(this.getDebugger(), expr);
            }
            this.expandedWatch = expr;
        }
        return this.expandedWatch;
    }

    public static String expandMacro(GdbDebugger debugger, String expr) {
        int offset;
        StyledDocument doc;
        GdbCallStackFrame csf = debugger.getCurrentCallStackFrame();
        if (csf != null && (doc = csf.getDocument()) != null && (offset = csf.getOffset()) >= 0) {
            return CsmMacroExpansion.expand((Document)doc, (int)offset, (String)expr);
        }
        return expr;
    }
}

