/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy.classparser.attributes;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;

public class InnerClassesTable
implements Serializable {
    private static final int ACC_PUBLIC = 1;
    private static final int ACC_PRIVATE = 2;
    private static final int ACC_PROTECTED = 4;
    private static final int ACC_STATIC = 8;
    private static final int ACC_FINAL = 16;
    private static final int ACC_INTERFACE = 512;
    private static final int ACC_ABSTRACT = 1024;
    private int innerClassInfoIndex;
    private int outerClassInfoIndex;
    private int innerNameIndex;
    private int innerClassAccessFlags;

    public InnerClassesTable(DataInputStream dataInputStream) throws IOException {
        this.innerClassInfoIndex = dataInputStream.readUnsignedShort();
        this.outerClassInfoIndex = dataInputStream.readUnsignedShort();
        this.innerNameIndex = dataInputStream.readUnsignedShort();
        this.innerClassAccessFlags = dataInputStream.readUnsignedShort();
    }

    public String toString() {
        String string = new String("");
        string = string + "\n\tinnerClassInfoIndex=" + this.innerClassInfoIndex;
        string = string + "\n\touterClassInfoIndex=" + this.outerClassInfoIndex;
        string = string + "\n\tinnerNameIndex=" + this.innerNameIndex;
        string = string + "\n\tinnerClassAccessFlags=";
        if ((this.innerClassAccessFlags & 1) > 0) {
            string = string + "public ";
        }
        if ((this.innerClassAccessFlags & 2) > 0) {
            string = string + "private ";
        }
        if ((this.innerClassAccessFlags & 4) > 0) {
            string = string + "protected ";
        }
        if ((this.innerClassAccessFlags & 8) > 0) {
            string = string + "static ";
        }
        if ((this.innerClassAccessFlags & 0x10) > 0) {
            string = string + "final ";
        }
        if ((this.innerClassAccessFlags & 0x200) > 0) {
            string = string + "interface ";
        }
        if ((this.innerClassAccessFlags & 0x400) > 0) {
            string = string + "abstract";
        }
        return string;
    }
}

