/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile;

import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.classfile.attributes.JAttribute;
import com.sun.javacard.classfile.attributes.JCodeAttr;
import com.sun.javacard.classfile.attributes.JExceptionsAttr;
import com.sun.javacard.classfile.constants.JConstantPool;
import com.sun.javacard.classfile.instructions.JInstruction;
import java.io.DataInputStream;
import java.io.IOException;

public class JMethod
extends MethodDefinition {
    private JConstantPool constant_pool;
    private int name_index;
    private int descriptor_index;
    private JAttribute[] attributes = null;
    private JCodeAttr code_attr = null;
    private JExceptionsAttr exc_attr = null;

    public JCodeAttr getCodeAttr() {
        return this.code_attr;
    }

    public JInstruction getCode() {
        if (this.code_attr == null) {
            return null;
        }
        return this.code_attr.getCode();
    }

    public JAttribute[] getAttributes() {
        return this.attributes;
    }

    public JMethod(JConstantPool jConstantPool) {
        this.constant_pool = jConstantPool;
    }

    public JMethod(MethodDefinition methodDefinition) {
        this.access_flags = 1025;
        this.method_name = methodDefinition.getMethodName();
        this.descriptor = methodDefinition.getMethodDescriptor();
        this.token = 255;
    }

    public void parse(DataInputStream dataInputStream) throws IOException {
        this.access_flags = dataInputStream.readUnsignedShort();
        this.name_index = dataInputStream.readUnsignedShort();
        this.descriptor_index = dataInputStream.readUnsignedShort();
        int n = dataInputStream.readUnsignedShort();
        this.attributes = new JAttribute[n];
        for (int i = 0; i < n; ++i) {
            int n2 = dataInputStream.readUnsignedShort();
            this.attributes[i] = JAttribute.create(this.constant_pool, n2);
            this.attributes[i].parse(dataInputStream);
        }
    }

    public void resolve() {
        this.method_name = this.constant_pool.getConstantUtf8(this.name_index).getString();
        this.descriptor = this.constant_pool.getConstantUtf8(this.descriptor_index).getString();
        for (JAttribute jAttribute : this.attributes) {
            jAttribute.resolve();
            if (jAttribute instanceof JCodeAttr) {
                this.code_attr = (JCodeAttr)jAttribute;
                continue;
            }
            if (!(jAttribute instanceof JExceptionsAttr)) continue;
            this.exc_attr = (JExceptionsAttr)jAttribute;
        }
    }

    public boolean throwsRemoteExceptionOrSuper() {
        String[] stringArray;
        if (this.exc_attr == null) {
            return false;
        }
        for (String string : stringArray = this.exc_attr.getExcNames()) {
            if (!string.equals("java/lang/Throwable") && !string.equals("java/lang/Exception") && !string.equals("java/io/IOException") && !string.equals("java/rmi/RemoteException")) continue;
            return true;
        }
        return false;
    }
}

