/*
 * Decompiled with CFR 0.152.
 */
package org.h2.schema;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import org.h2.constant.SysProperties;
import org.h2.constraint.Constraint;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.index.Index;
import org.h2.message.Message;
import org.h2.schema.Constant;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.table.Table;
import org.h2.table.TableData;
import org.h2.table.TableLink;
import org.h2.util.ObjectArray;

public class Schema
extends DbObjectBase {
    private User owner;
    private boolean system;
    private HashMap tablesAndViews = new HashMap();
    private HashMap indexes = new HashMap();
    private HashMap sequences = new HashMap();
    private HashMap triggers = new HashMap();
    private HashMap constraints = new HashMap();
    private HashMap constants = new HashMap();
    private HashSet temporaryUniqueNames = new HashSet();

    public Schema(Database database, int n, String string, User user, boolean bl) {
        this.initDbObjectBase(database, n, string, "schema");
        this.owner = user;
        this.system = bl;
    }

    public boolean canDrop() {
        return !this.system;
    }

    public String getCreateSQLForCopy(Table table, String string) {
        throw Message.getInternalError();
    }

    public String getDropSQL() {
        return null;
    }

    public String getCreateSQL() {
        if (this.system) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE SCHEMA ");
        stringBuffer.append(this.getSQL());
        stringBuffer.append(" AUTHORIZATION ");
        stringBuffer.append(this.owner.getSQL());
        return stringBuffer.toString();
    }

    public int getType() {
        return 10;
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        SchemaObject schemaObject;
        while (this.triggers != null && this.triggers.size() > 0) {
            schemaObject = (TriggerObject)this.triggers.values().toArray()[0];
            this.database.removeSchemaObject(session, schemaObject);
        }
        while (this.constraints != null && this.constraints.size() > 0) {
            schemaObject = (Constraint)this.constraints.values().toArray()[0];
            this.database.removeSchemaObject(session, schemaObject);
        }
        while (this.tablesAndViews != null && this.tablesAndViews.size() > 0) {
            schemaObject = (Table)this.tablesAndViews.values().toArray()[0];
            this.database.removeSchemaObject(session, schemaObject);
        }
        while (this.indexes != null && this.indexes.size() > 0) {
            schemaObject = (Index)this.indexes.values().toArray()[0];
            this.database.removeSchemaObject(session, schemaObject);
        }
        while (this.sequences != null && this.sequences.size() > 0) {
            schemaObject = (Sequence)this.sequences.values().toArray()[0];
            this.database.removeSchemaObject(session, schemaObject);
        }
        while (this.constants != null && this.constants.size() > 0) {
            schemaObject = (Constant)this.constants.values().toArray()[0];
            this.database.removeSchemaObject(session, schemaObject);
        }
        this.database.removeMeta(session, this.getId());
        this.owner = null;
        this.invalidate();
    }

    public void checkRename() {
    }

    public User getOwner() {
        return this.owner;
    }

    private HashMap getMap(int n) {
        switch (n) {
            case 0: {
                return this.tablesAndViews;
            }
            case 3: {
                return this.sequences;
            }
            case 1: {
                return this.indexes;
            }
            case 4: {
                return this.triggers;
            }
            case 5: {
                return this.constraints;
            }
            case 11: {
                return this.constants;
            }
        }
        throw Message.getInternalError("type=" + n);
    }

    public void add(SchemaObject schemaObject) {
        if (SysProperties.CHECK && schemaObject.getSchema() != this) {
            throw Message.getInternalError("wrong schema");
        }
        String string = schemaObject.getName();
        HashMap hashMap = this.getMap(schemaObject.getType());
        if (SysProperties.CHECK && hashMap.get(string) != null) {
            throw Message.getInternalError("object already exists");
        }
        hashMap.put(string, schemaObject);
        this.freeUniqueName(string);
    }

    public void rename(SchemaObject schemaObject, String string) throws SQLException {
        int n = schemaObject.getType();
        HashMap hashMap = this.getMap(n);
        if (SysProperties.CHECK) {
            if (!hashMap.containsKey(schemaObject.getName())) {
                throw Message.getInternalError("not found: " + schemaObject.getName());
            }
            if (schemaObject.getName().equals(string) || hashMap.containsKey(string)) {
                throw Message.getInternalError("object already exists: " + string);
            }
        }
        schemaObject.checkRename();
        hashMap.remove(schemaObject.getName());
        this.freeUniqueName(schemaObject.getName());
        schemaObject.rename(string);
        hashMap.put(string, schemaObject);
        this.freeUniqueName(string);
    }

    public Table findTableOrView(Session session, String string) {
        Table table = (Table)this.tablesAndViews.get(string);
        if (table == null && session != null) {
            table = session.findLocalTempTable(string);
        }
        return table;
    }

    public Index findIndex(String string) {
        return (Index)this.indexes.get(string);
    }

    public TriggerObject findTrigger(String string) {
        return (TriggerObject)this.triggers.get(string);
    }

    public Sequence findSequence(String string) {
        return (Sequence)this.sequences.get(string);
    }

    public Constraint findConstraint(String string) {
        return (Constraint)this.constraints.get(string);
    }

    public Constant findConstant(String string) {
        return (Constant)this.constants.get(string);
    }

    public void freeUniqueName(String string) {
        if (string != null) {
            this.temporaryUniqueNames.remove(string);
        }
    }

    private String getUniqueName(DbObject dbObject, HashMap hashMap, String string) {
        int n;
        String string2 = Integer.toHexString(dbObject.getName().hashCode()).toUpperCase();
        String string3 = null;
        for (n = 1; n < string2.length() && (hashMap.containsKey(string3 = string + string2.substring(0, n)) || this.temporaryUniqueNames.contains(string3)); ++n) {
            string3 = null;
        }
        if (string3 == null) {
            string = string + string2 + "_";
            n = 0;
            while (hashMap.containsKey(string3 = string + n) || this.temporaryUniqueNames.contains(string3)) {
                ++n;
            }
        }
        this.temporaryUniqueNames.add(string3);
        return string3;
    }

    public String getUniqueConstraintName(Table table) {
        return this.getUniqueName(table, this.constraints, "CONSTRAINT_");
    }

    public String getUniqueIndexName(Table table, String string) {
        return this.getUniqueName(table, this.indexes, string);
    }

    public Table getTableOrView(Session session, String string) throws SQLException {
        Table table = (Table)this.tablesAndViews.get(string);
        if (table == null && session != null) {
            table = session.findLocalTempTable(string);
        }
        if (table == null) {
            throw Message.getSQLException(42102, string);
        }
        return table;
    }

    public Index getIndex(String string) throws SQLException {
        Index index = (Index)this.indexes.get(string);
        if (index == null) {
            throw Message.getSQLException(42112, string);
        }
        return index;
    }

    public Constraint getConstraint(String string) throws SQLException {
        Constraint constraint = (Constraint)this.constraints.get(string);
        if (constraint == null) {
            throw Message.getSQLException(90057, string);
        }
        return constraint;
    }

    public Constant getConstant(String string) throws SQLException {
        Constant constant = (Constant)this.constants.get(string);
        if (constant == null) {
            throw Message.getSQLException(90115, string);
        }
        return constant;
    }

    public Sequence getSequence(String string) throws SQLException {
        Sequence sequence = (Sequence)this.sequences.get(string);
        if (sequence == null) {
            throw Message.getSQLException(90036, string);
        }
        return sequence;
    }

    public ObjectArray getAll(int n) {
        HashMap hashMap = this.getMap(n);
        return new ObjectArray(hashMap.values());
    }

    public void remove(SchemaObject schemaObject) {
        String string = schemaObject.getName();
        HashMap hashMap = this.getMap(schemaObject.getType());
        if (SysProperties.CHECK && !hashMap.containsKey(string)) {
            throw Message.getInternalError("not found: " + string);
        }
        hashMap.remove(string);
        this.freeUniqueName(string);
    }

    public TableData createTable(String string, int n, ObjectArray objectArray, boolean bl, boolean bl2) throws SQLException {
        return new TableData(this, string, n, objectArray, bl, bl2);
    }

    public TableLink createTableLink(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, boolean bl2) throws SQLException {
        return new TableLink(this, n, string, string2, string3, string4, string5, string6, string7, bl, bl2);
    }
}

