/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rhtml.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.modules.ruby.rhtml.lexer.api.RhtmlTokenId;

public class HtmlEmbeddingProvider
extends EmbeddingProvider {
    public static final String GENERATED_CODE = "@@@";

    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        TokenHierarchy th = TokenHierarchy.create((CharSequence)snapshot.getText(), RhtmlTokenId.language());
        TokenSequence sequence = th.tokenSequence(RhtmlTokenId.language());
        sequence.moveStart();
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
        boolean lastEmbeddingIsVirtual = false;
        while (sequence.moveNext()) {
            Token t = sequence.token();
            if (t.id() == RhtmlTokenId.HTML) {
                embeddings.add(snapshot.create(sequence.offset(), t.length(), "text/html"));
                lastEmbeddingIsVirtual = false;
                continue;
            }
            if (lastEmbeddingIsVirtual) continue;
            embeddings.add(snapshot.create((CharSequence)GENERATED_CODE, "text/html"));
            lastEmbeddingIsVirtual = true;
        }
        if (embeddings.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(Embedding.create(embeddings));
    }

    public int getPriority() {
        return 150;
    }

    public void cancel() {
    }

    public static final class Factory
    extends TaskFactory {
        public Collection<SchedulerTask> create(Snapshot snapshot) {
            return Collections.singletonList(new HtmlEmbeddingProvider());
        }
    }
}

