/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.database;

import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.database.JdbcInfo;
import org.netbeans.modules.ruby.railsprojects.database.RailsAdapters;
import org.netbeans.modules.ruby.railsprojects.database.RailsDatabaseConfiguration;
import org.netbeans.modules.ruby.railsprojects.database.RailsJdbcConnection;
import org.openide.LifecycleManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public class ConfigurableRailsAdapter
extends RailsDatabaseConfiguration {
    private static final Logger LOGGER = Logger.getLogger(ConfigurableRailsAdapter.class.getName());
    private final RailsDatabaseConfiguration delegate;
    private final String userName;
    private final String password;
    private final String database;
    private final boolean jdbc;

    public ConfigurableRailsAdapter(RailsDatabaseConfiguration delegate, String userName, String password, String database, boolean jdbc) {
        this.delegate = delegate;
        this.userName = userName;
        this.password = password;
        this.database = database;
        this.jdbc = jdbc;
    }

    @Override
    public String railsGenerationParam() {
        return this.delegate.railsGenerationParam();
    }

    @Override
    public void editConfig(RailsProject project) {
        this.delegate.editConfig(project);
        this.edit(project.getProjectDirectory());
        JdbcInfo jdbcInfo = this.getJdbcInfo();
        if (this.jdbc && jdbcInfo != null) {
            RailsJdbcConnection.bundleDrivers(project, jdbcInfo.getDriverClass());
        }
    }

    @Override
    public String getDisplayName() {
        return this.delegate.getDisplayName();
    }

    private void edit(FileObject dir) {
        FileObject fo = dir.getFileObject("config/database.yml");
        if (fo != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
                if (ec != null) {
                    StyledDocument doc = ec.openDocument();
                    this.setDatabase(doc);
                    RailsAdapters.changeAttribute(doc, "username:", this.userName, "url:");
                    RailsAdapters.changeAttribute(doc, "password:", this.password, "username:");
                    this.handleTestAndProduction(doc);
                    SaveCookie sc = (SaveCookie)dobj.getCookie(SaveCookie.class);
                    if (sc != null) {
                        sc.save();
                    } else {
                        LifecycleManager.getDefault().saveAll();
                    }
                }
            }
            catch (BadLocationException ble) {
                Exceptions.printStackTrace((Throwable)ble);
            }
            catch (DataObjectNotFoundException dnfe) {
                Exceptions.printStackTrace((Throwable)dnfe);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
    }

    private void handleTestAndProduction(Document databaseYml) throws BadLocationException {
        String text = this.getText(databaseYml);
        int start = text.indexOf("development:\n");
        int end = text.indexOf("test:\n");
        if (end == -1) {
            LOGGER.warning("Could not find 'test:' in database.yml. Its content is: " + text);
            return;
        }
        databaseYml.remove(end, databaseYml.getLength() - end);
        String developmentConfig = databaseYml.getText(start, end - start);
        String developmentDbName = !this.isEmpty(this.database) ? this.database : RailsAdapters.getPropertyValue(databaseYml, "database:");
        PlainDocument test = new PlainDocument();
        String testConfig = developmentConfig.replace("development:\n", "test:\n");
        int warningIndex = testConfig.lastIndexOf("# Warning: The database defined as \"test\" will be erased");
        if (warningIndex != -1) {
            testConfig = testConfig.substring(0, warningIndex);
        }
        test.insertString(0, testConfig, null);
        this.changeDatabase(test, this.getTestDatabaseName(developmentDbName));
        PlainDocument production = new PlainDocument();
        String productionConfig = testConfig.replace("test:\n", "production:\n");
        production.insertString(0, productionConfig, null);
        this.changeDatabase(production, this.getProductionDatabaseName(developmentDbName));
        databaseYml.insertString(databaseYml.getLength(), this.getText(test) + this.getText(production), null);
    }

    private void changeDatabase(Document doc, String databaseName) throws BadLocationException {
        JdbcInfo jdbcInfo = this.getJdbcInfo();
        if (!this.jdbc || jdbcInfo == null) {
            RailsAdapters.changeAttribute(doc, "database:", databaseName, null);
        } else {
            RailsAdapters.changeAttribute(doc, "url:", jdbcInfo.getURL("localhost", databaseName), "adapter:");
        }
    }

    private String getText(Document doc) throws BadLocationException {
        return doc.getText(0, doc.getLength());
    }

    private void setDatabase(Document databaseYml) throws BadLocationException {
        JdbcInfo jdbcInfo = this.getJdbcInfo();
        if (!this.jdbc || jdbcInfo == null) {
            RailsAdapters.changeAttribute(databaseYml, "database:", this.database, null);
            return;
        }
        String dbName = !this.isEmpty(this.database) ? this.database : RailsAdapters.getPropertyValue(databaseYml, "database:");
        RailsAdapters.changeAttribute(databaseYml, "adapter:", "jdbc", null);
        RailsAdapters.addProperty(databaseYml, "url:", jdbcInfo.getURL("localhost", dbName), "adapter:");
        RailsAdapters.addProperty(databaseYml, "driver:", jdbcInfo.getDriverClass(), "adapter:");
        RailsAdapters.removeProperty(databaseYml, "database:");
    }

    private boolean isEmpty(String str) {
        return str == null || "".equals(str.trim());
    }

    @Override
    public JdbcInfo getJdbcInfo() {
        return this.delegate.getJdbcInfo();
    }

    @Override
    public String getDatabaseName(String projectName) {
        return this.delegate.getDatabaseName(projectName);
    }

    @Override
    public String getTestDatabaseName(String developmentDbName) {
        return this.delegate.getTestDatabaseName(developmentDbName);
    }

    @Override
    public String getProductionDatabaseName(String developmentDbName) {
        return this.delegate.getProductionDatabaseName(developmentDbName);
    }
}

