/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.lib.profiler.common.filters.FilterUtils;
import org.netbeans.lib.profiler.common.filters.SimpleFilter;
import org.netbeans.modules.profiler.spi.ProjectProfilingSupport;
import org.netbeans.modules.profiler.spi.ProjectTypeProfiler;
import org.netbeans.modules.profiler.ui.stp.DefaultSettingsConfigurator;
import org.netbeans.modules.profiler.ui.stp.SelectProfilingTask;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.netbeans.modules.profiler.utils.ProjectUtilities;
import org.openide.filesystems.FileObject;

public abstract class AbstractProjectTypeProfiler
implements ProjectTypeProfiler {
    protected static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.profiler.spi.ProjectTypeProfiler");

    @Override
    public abstract String getProfilerTargetName(Project var1, FileObject var2, int var3, FileObject var4);

    @Override
    public abstract boolean isProfilingSupported(Project var1);

    @Override
    public JComponent getAdditionalConfigurationComponent(Project project) {
        return null;
    }

    @Override
    public boolean isAttachSupported(Project project) {
        return true;
    }

    @Override
    public ClientUtils.SourceCodeSelection[] getDefaultRootMethods(Project project, FileObject fileObject, boolean bl, String[][] stringArray) {
        if (bl) {
            return new ClientUtils.SourceCodeSelection[0];
        }
        Collection collection = project.getLookup().lookupAll(ProjectProfilingSupport.class);
        HashSet<ClientUtils.SourceCodeSelection> hashSet = new HashSet<ClientUtils.SourceCodeSelection>();
        for (ProjectProfilingSupport projectProfilingSupport : collection) {
            ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray = projectProfilingSupport.getRootMethods(fileObject);
            hashSet.addAll(Arrays.asList(sourceCodeSelectionArray));
        }
        return hashSet.toArray(new ClientUtils.SourceCodeSelection[hashSet.size()]);
    }

    @Override
    public boolean isFileObjectSupported(Project project, FileObject fileObject) {
        Collection collection = project.getLookup().lookupAll(ProjectProfilingSupport.class);
        for (ProjectProfilingSupport projectProfilingSupport : collection) {
            if (!projectProfilingSupport.canProfileFile(fileObject)) continue;
            return true;
        }
        return false;
    }

    @Override
    public abstract boolean checkProjectCanBeProfiled(Project var1, FileObject var2);

    @Override
    public abstract boolean checkProjectIsModifiedForProfiler(Project var1);

    @Override
    public List<SimpleFilter> getPredefinedInstrumentationFilters(Project project) {
        return org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.getProjectDefaultInstrFilters((Project)project);
    }

    @Override
    public float getProfilingOverhead(ProfilingSettings profilingSettings) {
        float f = 0.0f;
        if (!Utils.isMonitorSettings(profilingSettings)) {
            if (Utils.isCPUSettings(profilingSettings)) {
                if (profilingSettings.getProfilingType() == 8) {
                    f += 0.5f;
                } else if (profilingSettings.getProfilingType() == 16) {
                    f += 0.2f;
                }
                if (FilterUtils.NONE_FILTER.equals(profilingSettings.getSelectedInstrumentationFilter())) {
                    f += 0.5f;
                }
            } else if (Utils.isMemorySettings(profilingSettings)) {
                if (profilingSettings.getProfilingType() == 2) {
                    f += 0.5f;
                } else if (profilingSettings.getProfilingType() == 4) {
                    f += 0.7f;
                }
                if (profilingSettings.getAllocStackTraceLimit() != 0) {
                    f += 0.3f;
                }
            }
        }
        return f;
    }

    @Override
    public FileObject getProjectBuildScript(Project project) {
        return ProjectUtilities.findBuildFile(project);
    }

    @Override
    public JavaPlatform getProjectJavaPlatform(Project project) {
        return null;
    }

    @Override
    public SelectProfilingTask.SettingsConfigurator getSettingsConfigurator() {
        return DefaultSettingsConfigurator.SHARED_INSTANCE;
    }

    @Override
    public SimpleFilter computePredefinedInstrumentationFilter(Project project, SimpleFilter simpleFilter, String[][] stringArray) {
        Collection collection = project.getLookup().lookupAll(ProjectProfilingSupport.class);
        StringBuilder stringBuilder = new StringBuilder();
        for (ProjectProfilingSupport projectProfilingSupport : collection) {
            String string = projectProfilingSupport.getFilter(org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.isIncludeSubprojects((SimpleFilter)simpleFilter));
            stringBuilder.append(" ").append(string);
        }
        return new SimpleFilter(simpleFilter.getFilterName(), simpleFilter.getFilterType(), stringBuilder.toString().trim());
    }

    @Override
    public void computeProjectPackages(Project project, boolean bl, String[][] stringArray) {
        org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.computeProjectPackages((Project)project, (boolean)bl, (String[][])stringArray);
    }

    @Override
    public void configurePropertiesForProfiling(Properties properties, Project project, FileObject fileObject) {
    }

    @Override
    public void setupProjectSessionSettings(Project project, SessionSettings sessionSettings) {
    }

    @Override
    public boolean supportsSettingsOverride() {
        return false;
    }

    @Override
    public boolean supportsUnintegrate(Project project) {
        return false;
    }

    @Override
    public void unintegrateProfiler(Project project) {
    }

    @Override
    public boolean startProfilingSession(Project project, FileObject fileObject, boolean bl, Properties properties) {
        return false;
    }
}

