/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.TextElement;

public class PlaceholderTextElement
extends TextElement {
    private String hint;
    private String placeHolderText;
    private XMultiServiceFactory xmsf;

    public PlaceholderTextElement(XTextRange xTextRange, String string, String string2, XMultiServiceFactory xMultiServiceFactory) {
        super(xTextRange);
        this.placeHolderText = string;
        this.hint = string2;
        this.xmsf = xMultiServiceFactory;
    }

    public void write(Object object) {
        super.write(object);
        if (this.text.equals(PropertyNames.EMPTY_STRING)) {
            XTextRange xTextRange = (XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)object);
            try {
                XTextContent xTextContent = PlaceholderTextElement.createPlaceHolder(this.xmsf, this.placeHolderText, this.hint);
                xTextRange.getText().insertTextContent(xTextRange.getStart(), xTextContent, true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
        }
    }

    private static XTextContent createPlaceHolder(XMultiServiceFactory xMultiServiceFactory, String string, String string2) {
        Object object;
        try {
            object = xMultiServiceFactory.createInstance("com.sun.star.text.TextField.JumpEdit");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        Helper.setUnoPropertyValue(object, "PlaceHolder", string);
        Helper.setUnoPropertyValue(object, "Hint", string2);
        Helper.setUnoPropertyValue(object, "PlaceHolderType", (short)0);
        return (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)object);
    }
}

