/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class LoadDataHandler
extends RequestHandler {
    private static final String OSM_MIME_TYPE = "application/x-osm+xml";
    public static final String command = "load_data";
    private String data;
    private DataSet dataSet;

    @Override
    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException {
        Main.worker.submit(new LoadDataTask(this.isLoadInNewLayer(), this.dataSet, (String)this.args.get("layer_name")));
    }

    @Override
    public String[] getMandatoryParams() {
        return new String[]{"data"};
    }

    @Override
    public String[] getOptionalParams() {
        return new String[]{"new_layer", "mime_type", "layer_name"};
    }

    @Override
    public String getUsage() {
        return "Reads data encoded directly in the URL and adds it to the current data set";
    }

    @Override
    public String[] getUsageExamples() {
        return new String[]{"/load_data?layer_name=extra_layer&new_layer=true&data=" + Utils.encodeUrl("<osm version='0.6'><node id='-1' lat='1' lon='2' /></osm>")};
    }

    @Override
    public String getPermissionMessage() {
        return I18n.tr("Remote Control has been asked to load the following data:", new Object[0]) + "<br>" + this.data;
    }

    @Override
    public PermissionPrefWithDefault getPermissionPref() {
        return PermissionPrefWithDefault.IMPORT_DATA;
    }

    @Override
    protected void validateRequest() throws RequestHandler.RequestHandlerBadRequestException {
        this.data = (String)this.args.get("data");
        String string = Utils.firstNonNull((String)this.args.get("mime_type"), OSM_MIME_TYPE);
        try {
            if (OSM_MIME_TYPE.equals(string)) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.data.getBytes(StandardCharsets.UTF_8));
                this.dataSet = OsmReader.parseDataSet(byteArrayInputStream, null);
            } else {
                this.dataSet = new DataSet();
            }
        }
        catch (IllegalDataException illegalDataException) {
            throw new RequestHandler.RequestHandlerBadRequestException("Failed to parse " + this.data + ": " + illegalDataException.getMessage(), illegalDataException);
        }
    }

    protected static class LoadDataTask
    extends DownloadOsmTask.AbstractInternalTask {
        protected final String layerName;

        public LoadDataTask(boolean bl, DataSet dataSet, String string) {
            super(bl, I18n.tr("Loading data", new Object[0]), false, true);
            this.dataSet = dataSet;
            this.layerName = string;
        }

        @Override
        public void realRun() {
        }

        @Override
        protected void cancel() {
        }

        @Override
        protected void finish() {
            this.loadData(this.layerName, null);
        }
    }
}

