/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmChangeReader;
import org.openstreetmap.josm.tools.I18n;

public class OsmChangeImporter
extends FileImporter {
    public static final ExtensionFileFilter FILE_FILTER = ExtensionFileFilter.newFilterWithArchiveExtensions("osc", "osc", I18n.tr("OsmChange File", new Object[0]), true);

    public OsmChangeImporter() {
        super(FILE_FILTER);
    }

    public OsmChangeImporter(ExtensionFileFilter extensionFileFilter) {
        super(extensionFileFilter);
    }

    @Override
    public void importData(File file, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        try {
            this.importData(Compression.getUncompressedFileInputStream(file), file, progressMonitor);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Main.error(fileNotFoundException);
            throw new IOException(I18n.tr("File ''{0}'' does not exist.", file.getName()), fileNotFoundException);
        }
    }

    protected void importData(InputStream inputStream, File file, ProgressMonitor progressMonitor) throws IllegalDataException {
        DataSet dataSet = OsmChangeReader.parseDataSet(inputStream, progressMonitor);
        OsmDataLayer osmDataLayer = new OsmDataLayer(dataSet, file.getName(), file);
        this.addDataLayer(dataSet, osmDataLayer, file.getPath());
    }

    protected void addDataLayer(final DataSet dataSet, final OsmDataLayer osmDataLayer, final String string) {
        GuiHelper.runInEDT(new Runnable(){

            @Override
            public void run() {
                if (dataSet.allPrimitives().isEmpty()) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("No data found in file {0}.", string), I18n.tr("Open OsmChange file", new Object[0]), 1);
                }
                Main.getLayerManager().addLayer(osmDataLayer);
                osmDataLayer.onPostLoadFromFile();
            }
        });
    }
}

