/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.io.AllFormatsImporter;
import org.openstreetmap.josm.io.FileExporter;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.GeoJSONExporter;
import org.openstreetmap.josm.io.GpxExporter;
import org.openstreetmap.josm.io.GpxImporter;
import org.openstreetmap.josm.io.JpgImporter;
import org.openstreetmap.josm.io.NMEAImporter;
import org.openstreetmap.josm.io.NoteExporter;
import org.openstreetmap.josm.io.NoteImporter;
import org.openstreetmap.josm.io.OsmBzip2Exporter;
import org.openstreetmap.josm.io.OsmChangeImporter;
import org.openstreetmap.josm.io.OsmExporter;
import org.openstreetmap.josm.io.OsmGzipExporter;
import org.openstreetmap.josm.io.OsmImporter;
import org.openstreetmap.josm.io.WMSLayerExporter;
import org.openstreetmap.josm.io.WMSLayerImporter;
import org.openstreetmap.josm.io.session.SessionImporter;
import org.openstreetmap.josm.tools.Utils;

public class ExtensionFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    private static final ArrayList<FileImporter> importers;
    private static final ArrayList<FileExporter> exporters;
    private final String extensions;
    private final String description;
    private final String defaultExtension;

    protected static void sort(List<ExtensionFileFilter> list) {
        Collections.sort(list, new Comparator<ExtensionFileFilter>(){
            private AllFormatsImporter all = new AllFormatsImporter();

            @Override
            public int compare(ExtensionFileFilter extensionFileFilter, ExtensionFileFilter extensionFileFilter2) {
                if (extensionFileFilter.getDescription().equals(this.all.filter.getDescription())) {
                    return 1;
                }
                if (extensionFileFilter2.getDescription().equals(this.all.filter.getDescription())) {
                    return -1;
                }
                return extensionFileFilter.getDescription().compareTo(extensionFileFilter2.getDescription());
            }
        });
    }

    public static void addImporter(FileImporter fileImporter) {
        if (fileImporter != null) {
            importers.add(fileImporter);
        }
    }

    public static void addImporterFirst(FileImporter fileImporter) {
        if (fileImporter != null) {
            importers.add(0, fileImporter);
        }
    }

    public static void addExporter(FileExporter fileExporter) {
        if (fileExporter != null) {
            exporters.add(fileExporter);
        }
    }

    public static void addExporterFirst(FileExporter fileExporter) {
        if (fileExporter != null) {
            exporters.add(0, fileExporter);
        }
    }

    public static List<FileImporter> getImporters() {
        return Collections.unmodifiableList(importers);
    }

    public static List<FileExporter> getExporters() {
        return Collections.unmodifiableList(exporters);
    }

    public static void updateAllFormatsImporter() {
        for (int i = 0; i < importers.size(); ++i) {
            if (!(importers.get(i) instanceof AllFormatsImporter)) continue;
            importers.set(i, new AllFormatsImporter());
        }
    }

    public static List<ExtensionFileFilter> getImportExtensionFileFilters() {
        ExtensionFileFilter.updateAllFormatsImporter();
        LinkedList<ExtensionFileFilter> linkedList = new LinkedList<ExtensionFileFilter>();
        for (FileImporter fileImporter : importers) {
            linkedList.add(fileImporter.filter);
        }
        ExtensionFileFilter.sort(linkedList);
        return linkedList;
    }

    public static List<ExtensionFileFilter> getExportExtensionFileFilters() {
        LinkedList<ExtensionFileFilter> linkedList = new LinkedList<ExtensionFileFilter>();
        for (FileExporter fileExporter : exporters) {
            if (linkedList.contains(fileExporter.filter) || !fileExporter.isEnabled()) continue;
            linkedList.add(fileExporter.filter);
        }
        ExtensionFileFilter.sort(linkedList);
        return linkedList;
    }

    public static ExtensionFileFilter getDefaultImportExtensionFileFilter(String string) {
        if (string == null) {
            return new AllFormatsImporter().filter;
        }
        for (FileImporter fileImporter : importers) {
            if (!string.equals(fileImporter.filter.getDefaultExtension())) continue;
            return fileImporter.filter;
        }
        return new AllFormatsImporter().filter;
    }

    public static ExtensionFileFilter getDefaultExportExtensionFileFilter(String string) {
        if (string == null) {
            return new AllFormatsImporter().filter;
        }
        for (FileExporter object : exporters) {
            if (!string.equals(object.filter.getDefaultExtension())) continue;
            return object.filter;
        }
        File file = new File("file." + string);
        for (FileExporter fileExporter : exporters) {
            if (!fileExporter.filter.accept(file)) continue;
            return fileExporter.filter;
        }
        return new AllFormatsImporter().filter;
    }

    public static void applyChoosableImportFileFilters(AbstractFileChooser abstractFileChooser, String string, boolean bl) {
        for (ExtensionFileFilter extensionFileFilter : ExtensionFileFilter.getImportExtensionFileFilters()) {
            if (!bl && !extensionFileFilter.acceptName("file." + string)) continue;
            abstractFileChooser.addChoosableFileFilter(extensionFileFilter);
        }
        abstractFileChooser.setFileFilter(ExtensionFileFilter.getDefaultImportExtensionFileFilter(string));
    }

    public static void applyChoosableExportFileFilters(AbstractFileChooser abstractFileChooser, String string, boolean bl) {
        for (ExtensionFileFilter extensionFileFilter : ExtensionFileFilter.getExportExtensionFileFilters()) {
            if (!bl && !extensionFileFilter.acceptName("file." + string)) continue;
            abstractFileChooser.addChoosableFileFilter(extensionFileFilter);
        }
        abstractFileChooser.setFileFilter(ExtensionFileFilter.getDefaultExportExtensionFileFilter(string));
    }

    public ExtensionFileFilter(String string, String string2, String string3) {
        this.extensions = string;
        this.defaultExtension = string2;
        this.description = string3;
    }

    public static ExtensionFileFilter newFilterWithArchiveExtensions(String string, String string2, String string3, AddArchiveExtension addArchiveExtension, List<String> list) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>();
        for (String string4 : string.split(",")) {
            linkedHashSet.add(string4);
            if (addArchiveExtension != AddArchiveExtension.NONE) {
                linkedHashSet2.add("*." + string4);
            }
            for (String string5 : list) {
                linkedHashSet.add(string4 + '.' + string5);
                if (addArchiveExtension != AddArchiveExtension.ALL) continue;
                linkedHashSet2.add("*." + string4 + '.' + string5);
            }
        }
        return new ExtensionFileFilter(Utils.join(",", linkedHashSet), string2, string3 + (!linkedHashSet2.isEmpty() ? " (" + Utils.join(", ", linkedHashSet2) + ')' : ""));
    }

    public static ExtensionFileFilter newFilterWithArchiveExtensions(String string, String string2, String string3, boolean bl) {
        List<String> list = Arrays.asList("gz", "bz2");
        return ExtensionFileFilter.newFilterWithArchiveExtensions(string, string2, string3, bl ? AddArchiveExtension.ALL : AddArchiveExtension.BASE, list);
    }

    public boolean acceptName(String string) {
        return Utils.hasExtension(string, this.extensions.split(","));
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return this.acceptName(file.getName());
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getExtensions() {
        return this.extensions;
    }

    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    public int hashCode() {
        return Objects.hash(this.extensions, this.description, this.defaultExtension);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ExtensionFileFilter extensionFileFilter = (ExtensionFileFilter)object;
        return Objects.equals(this.extensions, extensionFileFilter.extensions) && Objects.equals(this.description, extensionFileFilter.description) && Objects.equals(this.defaultExtension, extensionFileFilter.defaultExtension);
    }

    static {
        Object reflectiveOperationException;
        importers = new ArrayList();
        List<Class> list = Arrays.asList(OsmImporter.class, OsmChangeImporter.class, GpxImporter.class, NMEAImporter.class, NoteImporter.class, JpgImporter.class, WMSLayerImporter.class, AllFormatsImporter.class, SessionImporter.class);
        for (Class object22 : list) {
            try {
                reflectiveOperationException = (FileImporter)object22.getConstructor(new Class[0]).newInstance(new Object[0]);
                importers.add((FileImporter)reflectiveOperationException);
            }
            catch (ReflectiveOperationException serviceConfigurationError) {
                if (!Main.isDebugEnabled()) continue;
                Main.debug(serviceConfigurationError.getMessage());
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                Main.error(serviceConfigurationError);
            }
        }
        exporters = new ArrayList();
        List<Class> list2 = Arrays.asList(GpxExporter.class, OsmExporter.class, OsmGzipExporter.class, OsmBzip2Exporter.class, GeoJSONExporter.CurrentProjection.class, GeoJSONExporter.class, WMSLayerExporter.class, NoteExporter.class);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            reflectiveOperationException = (Class)iterator.next();
            try {
                FileExporter reflectiveOperationException2 = (FileExporter)((Class)reflectiveOperationException).getConstructor(new Class[0]).newInstance(new Object[0]);
                exporters.add(reflectiveOperationException2);
                Main.getLayerManager().addAndFireActiveLayerChangeListener(reflectiveOperationException2);
            }
            catch (ReflectiveOperationException serviceConfigurationError) {
                if (!Main.isDebugEnabled()) continue;
                Main.debug(serviceConfigurationError.getMessage());
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                Main.error(serviceConfigurationError);
            }
        }
    }

    public static enum AddArchiveExtension {
        NONE,
        BASE,
        ALL;

    }
}

