/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.accessibility.AccessibleContext;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.ComboPopup;

public class BasicComboPopup
extends JPopupMenu
implements ComboPopup {
    static final ListModel EmptyListModel = new EmptyListModelClass();
    private static Border LIST_BORDER = new LineBorder(Color.BLACK, 1);
    protected JComboBox comboBox;
    protected JList list;
    protected JScrollPane scroller;
    protected boolean valueIsAdjusting = false;
    private Handler handler;
    protected MouseMotionListener mouseMotionListener;
    protected MouseListener mouseListener;
    protected KeyListener keyListener;
    protected ListSelectionListener listSelectionListener;
    protected MouseListener listMouseListener;
    protected MouseMotionListener listMouseMotionListener;
    protected PropertyChangeListener propertyChangeListener;
    protected ListDataListener listDataListener;
    protected ItemListener itemListener;
    private MouseWheelListener scrollerMouseWheelListener;
    protected Timer autoscrollTimer;
    protected boolean hasEntered = false;
    protected boolean isAutoScrolling = false;
    protected int scrollDirection = 0;
    protected static final int SCROLL_UP = 0;
    protected static final int SCROLL_DOWN = 1;

    @Override
    public void show() {
        this.comboBox.firePopupMenuWillBecomeVisible();
        this.setListSelection(this.comboBox.getSelectedIndex());
        Point point = this.getPopupLocation();
        this.show(this.comboBox, point.x, point.y);
    }

    @Override
    public void hide() {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        for (int i = 0; i < menuElementArray.length; ++i) {
            if (menuElementArray[i] != this) continue;
            menuSelectionManager.clearSelectedPath();
            break;
        }
        if (menuElementArray.length > 0) {
            this.comboBox.repaint();
        }
    }

    @Override
    public JList getList() {
        return this.list;
    }

    @Override
    public MouseListener getMouseListener() {
        if (this.mouseListener == null) {
            this.mouseListener = this.createMouseListener();
        }
        return this.mouseListener;
    }

    @Override
    public MouseMotionListener getMouseMotionListener() {
        if (this.mouseMotionListener == null) {
            this.mouseMotionListener = this.createMouseMotionListener();
        }
        return this.mouseMotionListener;
    }

    @Override
    public KeyListener getKeyListener() {
        if (this.keyListener == null) {
            this.keyListener = this.createKeyListener();
        }
        return this.keyListener;
    }

    @Override
    public void uninstallingUI() {
        if (this.propertyChangeListener != null) {
            this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.itemListener != null) {
            this.comboBox.removeItemListener(this.itemListener);
        }
        this.uninstallComboBoxModelListeners(this.comboBox.getModel());
        this.uninstallKeyboardActions();
        this.uninstallListListeners();
        this.uninstallScrollerListeners();
        this.list.setModel(EmptyListModel);
    }

    protected void uninstallComboBoxModelListeners(ComboBoxModel comboBoxModel) {
        if (comboBoxModel != null && this.listDataListener != null) {
            comboBoxModel.removeListDataListener(this.listDataListener);
        }
    }

    protected void uninstallKeyboardActions() {
    }

    public BasicComboPopup(JComboBox jComboBox) {
        this.setName("ComboPopup.popup");
        this.comboBox = jComboBox;
        this.setLightWeightPopupEnabled(this.comboBox.isLightWeightPopupEnabled());
        this.list = this.createList();
        this.list.setName("ComboBox.list");
        this.configureList();
        this.scroller = this.createScroller();
        this.scroller.setName("ComboBox.scrollPane");
        this.configureScroller();
        this.configurePopup();
        this.installComboBoxListeners();
        this.installKeyboardActions();
    }

    @Override
    protected void firePopupMenuWillBecomeVisible() {
        super.firePopupMenuWillBecomeVisible();
    }

    @Override
    protected void firePopupMenuWillBecomeInvisible() {
        super.firePopupMenuWillBecomeInvisible();
        this.comboBox.firePopupMenuWillBecomeInvisible();
    }

    @Override
    protected void firePopupMenuCanceled() {
        super.firePopupMenuCanceled();
        this.comboBox.firePopupMenuCanceled();
    }

    protected MouseListener createMouseListener() {
        return this.getHandler();
    }

    protected MouseMotionListener createMouseMotionListener() {
        return this.getHandler();
    }

    protected KeyListener createKeyListener() {
        return null;
    }

    protected ListSelectionListener createListSelectionListener() {
        return null;
    }

    protected ListDataListener createListDataListener() {
        return null;
    }

    protected MouseListener createListMouseListener() {
        return this.getHandler();
    }

    protected MouseMotionListener createListMouseMotionListener() {
        return this.getHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    protected ItemListener createItemListener() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected JList createList() {
        return new JList(this.comboBox.getModel()){

            @Override
            public void processMouseEvent(MouseEvent mouseEvent) {
                if (BasicGraphicsUtils.isMenuShortcutKeyDown(mouseEvent)) {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    mouseEvent = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers() ^ toolkit.getMenuShortcutKeyMask(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), 0);
                }
                super.processMouseEvent(mouseEvent);
            }
        };
    }

    protected void configureList() {
        this.list.setFont(this.comboBox.getFont());
        this.list.setForeground(this.comboBox.getForeground());
        this.list.setBackground(this.comboBox.getBackground());
        this.list.setSelectionForeground(UIManager.getColor("ComboBox.selectionForeground"));
        this.list.setSelectionBackground(UIManager.getColor("ComboBox.selectionBackground"));
        this.list.setBorder(null);
        this.list.setCellRenderer(this.comboBox.getRenderer());
        this.list.setFocusable(false);
        this.list.setSelectionMode(0);
        this.setListSelection(this.comboBox.getSelectedIndex());
        this.installListListeners();
    }

    protected void installListListeners() {
        this.listMouseListener = this.createListMouseListener();
        if (this.listMouseListener != null) {
            this.list.addMouseListener(this.listMouseListener);
        }
        if ((this.listMouseMotionListener = this.createListMouseMotionListener()) != null) {
            this.list.addMouseMotionListener(this.listMouseMotionListener);
        }
        if ((this.listSelectionListener = this.createListSelectionListener()) != null) {
            this.list.addListSelectionListener(this.listSelectionListener);
        }
    }

    void uninstallListListeners() {
        if (this.listMouseListener != null) {
            this.list.removeMouseListener(this.listMouseListener);
            this.listMouseListener = null;
        }
        if (this.listMouseMotionListener != null) {
            this.list.removeMouseMotionListener(this.listMouseMotionListener);
            this.listMouseMotionListener = null;
        }
        if (this.listSelectionListener != null) {
            this.list.removeListSelectionListener(this.listSelectionListener);
            this.listSelectionListener = null;
        }
        this.handler = null;
    }

    protected JScrollPane createScroller() {
        JScrollPane jScrollPane = new JScrollPane(this.list, 20, 31);
        jScrollPane.setHorizontalScrollBar(null);
        return jScrollPane;
    }

    protected void configureScroller() {
        this.scroller.setFocusable(false);
        this.scroller.getVerticalScrollBar().setFocusable(false);
        this.scroller.setBorder(null);
        this.installScrollerListeners();
    }

    protected void configurePopup() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorderPainted(true);
        this.setBorder(LIST_BORDER);
        this.setOpaque(false);
        this.add(this.scroller);
        this.setDoubleBuffered(true);
        this.setFocusable(false);
    }

    private void installScrollerListeners() {
        this.scrollerMouseWheelListener = this.getHandler();
        if (this.scrollerMouseWheelListener != null) {
            this.scroller.addMouseWheelListener(this.scrollerMouseWheelListener);
        }
    }

    private void uninstallScrollerListeners() {
        if (this.scrollerMouseWheelListener != null) {
            this.scroller.removeMouseWheelListener(this.scrollerMouseWheelListener);
            this.scrollerMouseWheelListener = null;
        }
    }

    protected void installComboBoxListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.itemListener = this.createItemListener()) != null) {
            this.comboBox.addItemListener(this.itemListener);
        }
        this.installComboBoxModelListeners(this.comboBox.getModel());
    }

    protected void installComboBoxModelListeners(ComboBoxModel comboBoxModel) {
        if (comboBoxModel != null && (this.listDataListener = this.createListDataListener()) != null) {
            comboBoxModel.addListDataListener(this.listDataListener);
        }
    }

    protected void installKeyboardActions() {
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    protected void startAutoScrolling(int n) {
        if (this.isAutoScrolling) {
            this.autoscrollTimer.stop();
        }
        this.isAutoScrolling = true;
        if (n == 0) {
            this.scrollDirection = 0;
            Point point = SwingUtilities.convertPoint(this.scroller, new Point(1, 1), this.list);
            int n2 = this.list.locationToIndex(point);
            this.list.setSelectedIndex(n2);
            this.autoscrollTimer = new Timer(100, new AutoScrollActionHandler(0));
        } else if (n == 1) {
            this.scrollDirection = 1;
            Dimension dimension = this.scroller.getSize();
            Point point = SwingUtilities.convertPoint(this.scroller, new Point(1, dimension.height - 1 - 2), this.list);
            int n3 = this.list.locationToIndex(point);
            this.list.setSelectedIndex(n3);
            this.autoscrollTimer = new Timer(100, new AutoScrollActionHandler(1));
        }
        this.autoscrollTimer.start();
    }

    protected void stopAutoScrolling() {
        this.isAutoScrolling = false;
        if (this.autoscrollTimer != null) {
            this.autoscrollTimer.stop();
            this.autoscrollTimer = null;
        }
    }

    protected void autoScrollUp() {
        int n = this.list.getSelectedIndex();
        if (n > 0) {
            this.list.setSelectedIndex(n - 1);
            this.list.ensureIndexIsVisible(n - 1);
        }
    }

    protected void autoScrollDown() {
        int n;
        int n2 = this.list.getSelectedIndex();
        if (n2 < (n = this.list.getModel().getSize() - 1)) {
            this.list.setSelectedIndex(n2 + 1);
            this.list.ensureIndexIsVisible(n2 + 1);
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        AccessibleContext accessibleContext = super.getAccessibleContext();
        accessibleContext.setAccessibleParent(this.comboBox);
        return accessibleContext;
    }

    protected void delegateFocus(MouseEvent mouseEvent) {
        if (this.comboBox.isEditable()) {
            Component component = this.comboBox.getEditor().getEditorComponent();
            if (!(component instanceof JComponent) || ((JComponent)component).isRequestFocusEnabled()) {
                component.requestFocus();
            }
        } else if (this.comboBox.isRequestFocusEnabled()) {
            this.comboBox.requestFocus();
        }
    }

    protected void togglePopup() {
        if (this.isVisible()) {
            this.hide();
        } else {
            this.show();
        }
    }

    private void setListSelection(int n) {
        if (n == -1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(n);
            this.list.ensureIndexIsVisible(n);
        }
    }

    protected MouseEvent convertMouseEvent(MouseEvent mouseEvent) {
        Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this.list);
        MouseEvent mouseEvent2 = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), 0);
        return mouseEvent2;
    }

    protected int getPopupHeightForRowCount(int n) {
        Border border;
        Serializable serializable;
        int n2 = Math.min(n, this.comboBox.getItemCount());
        int n3 = 0;
        ListCellRenderer<Object> listCellRenderer = this.list.getCellRenderer();
        Object e = null;
        for (int i = 0; i < n2; ++i) {
            e = this.list.getModel().getElementAt(i);
            serializable = listCellRenderer.getListCellRendererComponent(this.list, e, i, false, false);
            n3 += ((Component)serializable).getPreferredSize().height;
        }
        if (n3 == 0) {
            n3 = this.comboBox.getHeight();
        }
        if ((border = this.scroller.getViewportBorder()) != null) {
            serializable = border.getBorderInsets(null);
            n3 += ((Insets)serializable).top + ((Insets)serializable).bottom;
        }
        if ((border = this.scroller.getBorder()) != null) {
            serializable = border.getBorderInsets(null);
            n3 += ((Insets)serializable).top + ((Insets)serializable).bottom;
        }
        return n3;
    }

    protected Rectangle computePopupBounds(int n, int n2, int n3, int n4) {
        Rectangle rectangle;
        Cloneable cloneable;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration graphicsConfiguration = this.comboBox.getGraphicsConfiguration();
        Point point = new Point();
        SwingUtilities.convertPointFromScreen(point, this.comboBox);
        if (graphicsConfiguration != null) {
            cloneable = toolkit.getScreenInsets(graphicsConfiguration);
            rectangle = graphicsConfiguration.getBounds();
            rectangle.width -= cloneable.left + cloneable.right;
            rectangle.height -= cloneable.top + cloneable.bottom;
            rectangle.x += point.x + cloneable.left;
            rectangle.y += point.y + cloneable.top;
        } else {
            rectangle = new Rectangle(point, toolkit.getScreenSize());
        }
        cloneable = new Rectangle(n, n2, n3, n4);
        if (n2 + n4 > rectangle.y + rectangle.height && n4 < rectangle.height) {
            ((Rectangle)cloneable).y = -((Rectangle)cloneable).height;
        }
        return cloneable;
    }

    private Point getPopupLocation() {
        Dimension dimension = this.comboBox.getSize();
        Insets insets = this.getInsets();
        dimension.setSize(dimension.width - (insets.right + insets.left), this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
        Rectangle rectangle = this.computePopupBounds(0, this.comboBox.getBounds().height, dimension.width, dimension.height);
        Dimension dimension2 = rectangle.getSize();
        Point point = rectangle.getLocation();
        this.scroller.setMaximumSize(dimension2);
        this.scroller.setPreferredSize(dimension2);
        this.scroller.setMinimumSize(dimension2);
        this.list.revalidate();
        return point;
    }

    protected void updateListBoxSelectionForEvent(MouseEvent mouseEvent, boolean bl) {
        Point point = mouseEvent.getPoint();
        if (this.list == null) {
            return;
        }
        int n = this.list.locationToIndex(point);
        if (n == -1) {
            n = point.y < 0 ? 0 : this.comboBox.getModel().getSize() - 1;
        }
        if (this.list.getSelectedIndex() != n) {
            this.list.setSelectedIndex(n);
            if (bl) {
                this.list.ensureIndexIsVisible(n);
            }
        }
    }

    private class Handler
    implements ItemListener,
    MouseListener,
    MouseMotionListener,
    MouseWheelListener,
    PropertyChangeListener,
    Serializable {
        private Handler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == BasicComboPopup.this.list) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent) || !BasicComboPopup.this.comboBox.isEnabled()) {
                return;
            }
            if (BasicComboPopup.this.comboBox.isEditable()) {
                Component component = BasicComboPopup.this.comboBox.getEditor().getEditorComponent();
                if (!(component instanceof JComponent) || ((JComponent)component).isRequestFocusEnabled()) {
                    component.requestFocus();
                }
            } else if (BasicComboPopup.this.comboBox.isRequestFocusEnabled()) {
                BasicComboPopup.this.comboBox.requestFocus();
            }
            BasicComboPopup.this.togglePopup();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == BasicComboPopup.this.list) {
                if (BasicComboPopup.this.list.getModel().getSize() > 0) {
                    if (BasicComboPopup.this.comboBox.getSelectedIndex() == BasicComboPopup.this.list.getSelectedIndex()) {
                        BasicComboPopup.this.comboBox.getEditor().setItem(BasicComboPopup.this.list.getSelectedValue());
                    }
                    BasicComboPopup.this.comboBox.setSelectedIndex(BasicComboPopup.this.list.getSelectedIndex());
                }
                BasicComboPopup.this.comboBox.setPopupVisible(false);
                if (BasicComboPopup.this.comboBox.isEditable() && BasicComboPopup.this.comboBox.getEditor() != null) {
                    BasicComboPopup.this.comboBox.configureEditor(BasicComboPopup.this.comboBox.getEditor(), BasicComboPopup.this.comboBox.getSelectedItem());
                }
                return;
            }
            Component component = (Component)mouseEvent.getSource();
            Dimension dimension = component.getSize();
            Rectangle rectangle = new Rectangle(0, 0, dimension.width - 1, dimension.height - 1);
            if (!rectangle.contains(mouseEvent.getPoint())) {
                MouseEvent mouseEvent2 = BasicComboPopup.this.convertMouseEvent(mouseEvent);
                Point point = mouseEvent2.getPoint();
                Rectangle rectangle2 = new Rectangle();
                BasicComboPopup.this.list.computeVisibleRect(rectangle2);
                if (rectangle2.contains(point)) {
                    if (BasicComboPopup.this.comboBox.getSelectedIndex() == BasicComboPopup.this.list.getSelectedIndex()) {
                        BasicComboPopup.this.comboBox.getEditor().setItem(BasicComboPopup.this.list.getSelectedValue());
                    }
                    BasicComboPopup.this.comboBox.setSelectedIndex(BasicComboPopup.this.list.getSelectedIndex());
                }
                BasicComboPopup.this.comboBox.setPopupVisible(false);
            }
            BasicComboPopup.this.hasEntered = false;
            BasicComboPopup.this.stopAutoScrolling();
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == BasicComboPopup.this.list) {
                Point point = mouseEvent.getPoint();
                Rectangle rectangle = new Rectangle();
                BasicComboPopup.this.list.computeVisibleRect(rectangle);
                if (rectangle.contains(point)) {
                    BasicComboPopup.this.updateListBoxSelectionForEvent(mouseEvent, false);
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == BasicComboPopup.this.list) {
                return;
            }
            if (BasicComboPopup.this.isVisible()) {
                MouseEvent mouseEvent2 = BasicComboPopup.this.convertMouseEvent(mouseEvent);
                Rectangle rectangle = new Rectangle();
                BasicComboPopup.this.list.computeVisibleRect(rectangle);
                if (mouseEvent2.getPoint().y >= rectangle.y && mouseEvent2.getPoint().y <= rectangle.y + rectangle.height - 1) {
                    Point point;
                    BasicComboPopup.this.hasEntered = true;
                    if (BasicComboPopup.this.isAutoScrolling) {
                        BasicComboPopup.this.stopAutoScrolling();
                    }
                    if (rectangle.contains(point = mouseEvent2.getPoint())) {
                        BasicComboPopup.this.updateListBoxSelectionForEvent(mouseEvent2, false);
                    }
                } else if (BasicComboPopup.this.hasEntered) {
                    int n;
                    int n2 = n = mouseEvent2.getPoint().y < rectangle.y ? 0 : 1;
                    if (BasicComboPopup.this.isAutoScrolling && BasicComboPopup.this.scrollDirection != n) {
                        BasicComboPopup.this.stopAutoScrolling();
                        BasicComboPopup.this.startAutoScrolling(n);
                    } else if (!BasicComboPopup.this.isAutoScrolling) {
                        BasicComboPopup.this.startAutoScrolling(n);
                    }
                } else if (mouseEvent.getPoint().y < 0) {
                    BasicComboPopup.this.hasEntered = true;
                    BasicComboPopup.this.startAutoScrolling(0);
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JComboBox jComboBox = (JComboBox)propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if (string == "model") {
                ComboBoxModel comboBoxModel = (ComboBoxModel)propertyChangeEvent.getOldValue();
                ComboBoxModel comboBoxModel2 = (ComboBoxModel)propertyChangeEvent.getNewValue();
                BasicComboPopup.this.uninstallComboBoxModelListeners(comboBoxModel);
                BasicComboPopup.this.installComboBoxModelListeners(comboBoxModel2);
                BasicComboPopup.this.list.setModel(comboBoxModel2);
                if (BasicComboPopup.this.isVisible()) {
                    BasicComboPopup.this.hide();
                }
            } else if (string == "renderer") {
                BasicComboPopup.this.list.setCellRenderer(jComboBox.getRenderer());
                if (BasicComboPopup.this.isVisible()) {
                    BasicComboPopup.this.hide();
                }
            } else if (string == "componentOrientation") {
                ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
                JList jList = BasicComboPopup.this.getList();
                if (jList != null && jList.getComponentOrientation() != componentOrientation) {
                    jList.setComponentOrientation(componentOrientation);
                }
                if (BasicComboPopup.this.scroller != null && BasicComboPopup.this.scroller.getComponentOrientation() != componentOrientation) {
                    BasicComboPopup.this.scroller.setComponentOrientation(componentOrientation);
                }
                if (componentOrientation != BasicComboPopup.this.getComponentOrientation()) {
                    BasicComboPopup.this.setComponentOrientation(componentOrientation);
                }
            } else if (string == "lightWeightPopupEnabled") {
                BasicComboPopup.this.setLightWeightPopupEnabled(jComboBox.isLightWeightPopupEnabled());
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                BasicComboPopup.this.setListSelection(jComboBox.getSelectedIndex());
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            mouseWheelEvent.consume();
        }
    }

    private class AutoScrollActionHandler
    implements ActionListener {
        private int direction;

        AutoScrollActionHandler(int n) {
            this.direction = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.direction == 0) {
                BasicComboPopup.this.autoScrollUp();
            } else {
                BasicComboPopup.this.autoScrollDown();
            }
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        protected PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BasicComboPopup.this.getHandler().propertyChange(propertyChangeEvent);
        }
    }

    protected class ItemHandler
    implements ItemListener {
        protected ItemHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            BasicComboPopup.this.getHandler().itemStateChanged(itemEvent);
        }
    }

    protected class ListMouseMotionHandler
    extends MouseMotionAdapter {
        protected ListMouseMotionHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            BasicComboPopup.this.getHandler().mouseMoved(mouseEvent);
        }
    }

    protected class ListMouseHandler
    extends MouseAdapter {
        protected ListMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            BasicComboPopup.this.getHandler().mouseReleased(mouseEvent);
        }
    }

    public class ListDataHandler
    implements ListDataListener {
        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
        }
    }

    protected class ListSelectionHandler
    implements ListSelectionListener {
        protected ListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
        }
    }

    public class InvocationKeyHandler
    extends KeyAdapter {
        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    protected class InvocationMouseMotionHandler
    extends MouseMotionAdapter {
        protected InvocationMouseMotionHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            BasicComboPopup.this.getHandler().mouseDragged(mouseEvent);
        }
    }

    protected class InvocationMouseHandler
    extends MouseAdapter {
        protected InvocationMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            BasicComboPopup.this.getHandler().mousePressed(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            BasicComboPopup.this.getHandler().mouseReleased(mouseEvent);
        }
    }

    private static class EmptyListModelClass
    implements ListModel<Object>,
    Serializable {
        private EmptyListModelClass() {
        }

        @Override
        public int getSize() {
            return 0;
        }

        @Override
        public Object getElementAt(int n) {
            return null;
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
        }
    }
}

