/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.Collection;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RejectedExecutionException;
import sun.misc.Unsafe;

public class ForkJoinWorkerThread
extends Thread {
    private static final int SMASK = 65535;
    private static final int INITIAL_QUEUE_CAPACITY = 8192;
    private static final int MAXIMUM_QUEUE_CAPACITY = 0x1000000;
    ForkJoinTask<?>[] queue;
    final ForkJoinPool pool;
    int queueTop;
    volatile int queueBase;
    int stealHint;
    final int poolIndex;
    int nextWait;
    volatile int eventCount;
    int seed;
    int stealCount;
    volatile boolean terminate;
    volatile boolean parked;
    final boolean locallyFifo;
    ForkJoinTask<?> currentSteal;
    ForkJoinTask<?> currentJoin;
    private static final int MAX_HELP = 16;
    private static final Unsafe UNSAFE;
    private static final long ABASE;
    private static final int ASHIFT;

    protected ForkJoinWorkerThread(ForkJoinPool forkJoinPool) {
        super(forkJoinPool.nextWorkerName());
        int n;
        this.pool = forkJoinPool;
        this.poolIndex = n = forkJoinPool.registerWorker(this);
        this.eventCount = ~n & 0xFFFF;
        this.locallyFifo = forkJoinPool.locallyFifo;
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = forkJoinPool.ueh;
        if (uncaughtExceptionHandler != null) {
            this.setUncaughtExceptionHandler(uncaughtExceptionHandler);
        }
        this.setDaemon(true);
    }

    public ForkJoinPool getPool() {
        return this.pool;
    }

    public int getPoolIndex() {
        return this.poolIndex;
    }

    private int nextSeed() {
        int n = this.seed;
        n ^= n << 13;
        n ^= n >>> 17;
        n ^= n << 5;
        this.seed = n;
        return this.seed;
    }

    protected void onStart() {
        this.queue = new ForkJoinTask[8192];
        int n = ForkJoinPool.workerSeedGenerator.nextInt();
        this.seed = n == 0 ? 1 : n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onTermination(Throwable throwable) {
        try {
            this.terminate = true;
            this.cancelTasks();
            this.pool.deregisterWorker(this, throwable);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            }
        }
        finally {
            if (throwable != null) {
                UNSAFE.throwException(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Throwable throwable = null;
        try {
            this.onStart();
            this.pool.work(this);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        finally {
            this.onTermination(throwable);
        }
    }

    private static final boolean casSlotNull(ForkJoinTask<?>[] forkJoinTaskArray, int n, ForkJoinTask<?> forkJoinTask) {
        return UNSAFE.compareAndSwapObject(forkJoinTaskArray, (long)(n << ASHIFT) + ABASE, forkJoinTask, null);
    }

    private static final void writeSlot(ForkJoinTask<?>[] forkJoinTaskArray, int n, ForkJoinTask<?> forkJoinTask) {
        UNSAFE.putObjectVolatile(forkJoinTaskArray, (long)(n << ASHIFT) + ABASE, forkJoinTask);
    }

    final void pushTask(ForkJoinTask<?> forkJoinTask) {
        ForkJoinTask<?>[] forkJoinTaskArray = this.queue;
        if (this.queue != null) {
            int n = this.queueTop;
            int n2 = forkJoinTaskArray.length - 1;
            long l = (long)((n & n2) << ASHIFT) + ABASE;
            UNSAFE.putOrderedObject(forkJoinTaskArray, l, forkJoinTask);
            this.queueTop = n + 1;
            if ((n -= this.queueBase) <= 2) {
                this.pool.signalWork();
            } else if (n == n2) {
                this.growQueue();
            }
        }
    }

    private void growQueue() {
        int n;
        int n2;
        ForkJoinTask<?>[] forkJoinTaskArray = this.queue;
        int n3 = n2 = forkJoinTaskArray != null ? forkJoinTaskArray.length << 1 : 8192;
        if (n2 > 0x1000000) {
            throw new RejectedExecutionException("Queue capacity exceeded");
        }
        if (n2 < 8192) {
            n2 = 8192;
        }
        this.queue = new ForkJoinTask[n2];
        ForkJoinTask[] forkJoinTaskArray2 = this.queue;
        int n4 = n2 - 1;
        int n5 = this.queueTop;
        if (forkJoinTaskArray != null && (n = forkJoinTaskArray.length - 1) >= 0) {
            for (int i = this.queueBase; i != n5; ++i) {
                long l = (long)((i & n) << ASHIFT) + ABASE;
                Object object = UNSAFE.getObjectVolatile(forkJoinTaskArray, l);
                if (object == null || !UNSAFE.compareAndSwapObject(forkJoinTaskArray, l, object, null)) continue;
                UNSAFE.putObjectVolatile(forkJoinTaskArray2, (long)((i & n4) << ASHIFT) + ABASE, object);
            }
        }
    }

    final ForkJoinTask<?> deqTask() {
        int n = this.queueBase;
        if (this.queueTop != n) {
            ForkJoinTask<?> forkJoinTask;
            int n2;
            ForkJoinTask<?>[] forkJoinTaskArray = this.queue;
            if (this.queue != null && (n2 = forkJoinTaskArray.length - 1 & n) >= 0 && (forkJoinTask = forkJoinTaskArray[n2]) != null && this.queueBase == n && UNSAFE.compareAndSwapObject(forkJoinTaskArray, (long)(n2 << ASHIFT) + ABASE, forkJoinTask, null)) {
                this.queueBase = n + 1;
                return forkJoinTask;
            }
        }
        return null;
    }

    final ForkJoinTask<?> locallyDeqTask() {
        int n;
        ForkJoinTask<?>[] forkJoinTaskArray = this.queue;
        if (forkJoinTaskArray != null && (n = forkJoinTaskArray.length - 1) >= 0) {
            int n2;
            while (this.queueTop != (n2 = this.queueBase)) {
                int n3 = n & n2;
                ForkJoinTask<?> forkJoinTask = forkJoinTaskArray[n3];
                if (forkJoinTask == null || this.queueBase != n2 || !UNSAFE.compareAndSwapObject(forkJoinTaskArray, (long)(n3 << ASHIFT) + ABASE, forkJoinTask, null)) continue;
                this.queueBase = n2 + 1;
                return forkJoinTask;
            }
        }
        return null;
    }

    private ForkJoinTask<?> popTask() {
        int n;
        ForkJoinTask<?>[] forkJoinTaskArray = this.queue;
        if (forkJoinTaskArray != null && (n = forkJoinTaskArray.length - 1) >= 0) {
            int n2;
            while ((n2 = this.queueTop) != this.queueBase) {
                int n3 = n & --n2;
                long l = (long)(n3 << ASHIFT) + ABASE;
                ForkJoinTask<?> forkJoinTask = forkJoinTaskArray[n3];
                if (forkJoinTask == null) break;
                if (!UNSAFE.compareAndSwapObject(forkJoinTaskArray, l, forkJoinTask, null)) continue;
                this.queueTop = n2;
                return forkJoinTask;
            }
        }
        return null;
    }

    final boolean unpushTask(ForkJoinTask<?> forkJoinTask) {
        int n;
        ForkJoinTask<?>[] forkJoinTaskArray = this.queue;
        if (this.queue != null && (n = this.queueTop) != this.queueBase && UNSAFE.compareAndSwapObject(forkJoinTaskArray, (long)((forkJoinTaskArray.length - 1 & --n) << ASHIFT) + ABASE, forkJoinTask, null)) {
            this.queueTop = n;
            return true;
        }
        return false;
    }

    final ForkJoinTask<?> peekTask() {
        int n;
        ForkJoinTask<?>[] forkJoinTaskArray = this.queue;
        if (forkJoinTaskArray == null || (n = forkJoinTaskArray.length - 1) < 0) {
            return null;
        }
        int n2 = this.locallyFifo ? this.queueBase : this.queueTop - 1;
        return forkJoinTaskArray[n2 & n];
    }

    final void execTask(ForkJoinTask<?> forkJoinTask) {
        this.currentSteal = forkJoinTask;
        while (true) {
            if (forkJoinTask != null) {
                forkJoinTask.doExec();
            }
            if (this.queueTop == this.queueBase) break;
            forkJoinTask = this.locallyFifo ? this.locallyDeqTask() : this.popTask();
        }
        ++this.stealCount;
        this.currentSteal = null;
    }

    final void cancelTasks() {
        ForkJoinTask<?> forkJoinTask;
        ForkJoinTask<?> forkJoinTask2 = this.currentJoin;
        if (forkJoinTask2 != null && forkJoinTask2.status >= 0) {
            forkJoinTask2.cancelIgnoringExceptions();
        }
        if ((forkJoinTask = this.currentSteal) != null && forkJoinTask.status >= 0) {
            forkJoinTask.cancelIgnoringExceptions();
        }
        while (this.queueBase != this.queueTop) {
            ForkJoinTask<?> forkJoinTask3 = this.deqTask();
            if (forkJoinTask3 == null) continue;
            forkJoinTask3.cancelIgnoringExceptions();
        }
    }

    final int drainTasksTo(Collection<? super ForkJoinTask<?>> collection) {
        int n = 0;
        while (this.queueBase != this.queueTop) {
            ForkJoinTask<?> forkJoinTask = this.deqTask();
            if (forkJoinTask == null) continue;
            collection.add(forkJoinTask);
            ++n;
        }
        return n;
    }

    final int getQueueSize() {
        return this.queueTop - this.queueBase;
    }

    final ForkJoinTask<?> pollLocalTask() {
        return this.locallyFifo ? this.locallyDeqTask() : this.popTask();
    }

    final ForkJoinTask<?> pollTask() {
        ForkJoinWorkerThread[] forkJoinWorkerThreadArray;
        ForkJoinTask<?> forkJoinTask;
        block6: {
            block5: {
                forkJoinTask = this.pollLocalTask();
                if (forkJoinTask != null) break block5;
                forkJoinWorkerThreadArray = this.pool.workers;
                if (this.pool.workers != null) break block6;
            }
            return forkJoinTask;
        }
        int n = forkJoinWorkerThreadArray.length;
        int n2 = n << 1;
        int n3 = this.nextSeed();
        int n4 = 0;
        while (n4 < n2) {
            ForkJoinWorkerThread forkJoinWorkerThread;
            if ((forkJoinWorkerThread = forkJoinWorkerThreadArray[n4++ + n3 & n - 1]) == null || forkJoinWorkerThread.queueBase == forkJoinWorkerThread.queueTop || forkJoinWorkerThread.queue == null) continue;
            forkJoinTask = forkJoinWorkerThread.deqTask();
            if (forkJoinTask != null) {
                return forkJoinTask;
            }
            n4 = 0;
        }
        return null;
    }

    final int joinTask(ForkJoinTask<?> forkJoinTask) {
        ForkJoinTask<?> forkJoinTask2 = this.currentJoin;
        this.currentJoin = forkJoinTask;
        int n = 16;
        while (true) {
            int n2;
            if ((n2 = forkJoinTask.status) < 0) {
                this.currentJoin = forkJoinTask2;
                return n2;
            }
            if (n > 0) {
                if (this.queueTop != this.queueBase) {
                    if (this.localHelpJoinTask(forkJoinTask)) continue;
                    n = 0;
                    continue;
                }
                if (n == 8) {
                    --n;
                    if (this.tryDeqAndExec(forkJoinTask) < 0) continue;
                    Thread.yield();
                    continue;
                }
                n = this.helpJoinTask(forkJoinTask) ? 16 : n - 1;
                continue;
            }
            n = 16;
            this.pool.tryAwaitJoin(forkJoinTask);
        }
    }

    private boolean localHelpJoinTask(ForkJoinTask<?> forkJoinTask) {
        int n = this.queueTop;
        if (n != this.queueBase) {
            ForkJoinTask<?> forkJoinTask2;
            int n2;
            ForkJoinTask<?>[] forkJoinTaskArray = this.queue;
            if (this.queue != null && (n2 = forkJoinTaskArray.length - 1 & --n) >= 0 && (forkJoinTask2 = forkJoinTaskArray[n2]) != null) {
                if (forkJoinTask2 != forkJoinTask && forkJoinTask2.status >= 0) {
                    return false;
                }
                if (UNSAFE.compareAndSwapObject(forkJoinTaskArray, (long)(n2 << ASHIFT) + ABASE, forkJoinTask2, null)) {
                    this.queueTop = n;
                    forkJoinTask2.doExec();
                }
            }
        }
        return true;
    }

    private boolean helpJoinTask(ForkJoinTask<?> forkJoinTask) {
        boolean bl = false;
        int n = this.pool.scanGuard & 0xFFFF;
        ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.pool.workers;
        if (forkJoinWorkerThreadArray != null && forkJoinWorkerThreadArray.length > n && forkJoinTask.status >= 0) {
            int n2 = 16;
            ForkJoinTask<?> forkJoinTask2 = forkJoinTask;
            ForkJoinWorkerThread forkJoinWorkerThread = this;
            block0: while (true) {
                ForkJoinWorkerThread forkJoinWorkerThread2;
                block7: {
                    if ((forkJoinWorkerThread2 = forkJoinWorkerThreadArray[forkJoinWorkerThread.stealHint & n]) == null || forkJoinWorkerThread2.currentSteal != forkJoinTask2) {
                        int n3 = 0;
                        do {
                            if ((forkJoinWorkerThread2 = forkJoinWorkerThreadArray[n3]) == null || forkJoinWorkerThread2.currentSteal != forkJoinTask2) continue;
                            forkJoinWorkerThread.stealHint = n3;
                            break block7;
                        } while (++n3 <= n);
                        break;
                    }
                }
                while (forkJoinTask.status >= 0) {
                    int n4 = forkJoinWorkerThread2.queueBase;
                    if (n4 != forkJoinWorkerThread2.queueTop) {
                        int n5;
                        ForkJoinTask<?>[] forkJoinTaskArray = forkJoinWorkerThread2.queue;
                        if (forkJoinWorkerThread2.queue != null && (n5 = forkJoinTaskArray.length - 1 & n4) >= 0) {
                            long l = (long)(n5 << ASHIFT) + ABASE;
                            ForkJoinTask<?> forkJoinTask3 = forkJoinTaskArray[n5];
                            if (forkJoinTask2.status < 0) break block0;
                            if (forkJoinTask3 == null || forkJoinWorkerThread2.queueBase != n4 || !UNSAFE.compareAndSwapObject(forkJoinTaskArray, l, forkJoinTask3, null)) continue;
                            forkJoinWorkerThread2.queueBase = n4 + 1;
                            forkJoinWorkerThread2.stealHint = this.poolIndex;
                            ForkJoinTask<?> forkJoinTask4 = this.currentSteal;
                            this.currentSteal = forkJoinTask3;
                            forkJoinTask3.doExec();
                            this.currentSteal = forkJoinTask4;
                            bl = true;
                            continue;
                        }
                    }
                    ForkJoinTask<?> forkJoinTask5 = forkJoinWorkerThread2.currentJoin;
                    if (--n2 <= 0 || forkJoinTask2.status < 0 || forkJoinTask5 == null || forkJoinTask5 == forkJoinTask2) break block0;
                    forkJoinTask2 = forkJoinTask5;
                    forkJoinWorkerThread = forkJoinWorkerThread2;
                    continue block0;
                }
                break;
            }
        }
        return bl;
    }

    private int tryDeqAndExec(ForkJoinTask<?> forkJoinTask) {
        int n = this.pool.scanGuard & 0xFFFF;
        ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.pool.workers;
        if (forkJoinWorkerThreadArray != null && forkJoinWorkerThreadArray.length > n && forkJoinTask.status >= 0) {
            for (int i = 0; i <= n; ++i) {
                int n2;
                int n3;
                ForkJoinWorkerThread forkJoinWorkerThread = forkJoinWorkerThreadArray[i];
                if (forkJoinWorkerThread == null || (n3 = forkJoinWorkerThread.queueBase) == forkJoinWorkerThread.queueTop) continue;
                ForkJoinTask<?>[] forkJoinTaskArray = forkJoinWorkerThread.queue;
                if (forkJoinWorkerThread.queue == null || (n2 = forkJoinTaskArray.length - 1 & n3) < 0 || forkJoinTaskArray[n2] != forkJoinTask) continue;
                long l = (long)(n2 << ASHIFT) + ABASE;
                if (forkJoinWorkerThread.queueBase != n3 || !UNSAFE.compareAndSwapObject(forkJoinTaskArray, l, forkJoinTask, null)) break;
                forkJoinWorkerThread.queueBase = n3 + 1;
                forkJoinWorkerThread.stealHint = this.poolIndex;
                ForkJoinTask<?> forkJoinTask2 = this.currentSteal;
                this.currentSteal = forkJoinTask;
                forkJoinTask.doExec();
                this.currentSteal = forkJoinTask2;
                break;
            }
        }
        return forkJoinTask.status;
    }

    final int getEstimatedSurplusTaskCount() {
        return this.queueTop - this.queueBase - this.pool.idlePerActive();
    }

    final void helpQuiescePool() {
        boolean bl = true;
        ForkJoinTask<?> forkJoinTask = this.currentSteal;
        ForkJoinPool forkJoinPool = this.pool;
        forkJoinPool.addQuiescerCount(1);
        while (true) {
            Object object;
            int n;
            ForkJoinWorkerThread[] forkJoinWorkerThreadArray = forkJoinPool.workers;
            Object object2 = null;
            if (this.queueTop != this.queueBase) {
                object2 = this;
            } else if (forkJoinWorkerThreadArray != null && (n = forkJoinWorkerThreadArray.length) > 1) {
                int n2 = this.nextSeed();
                int n3 = n << 1;
                for (int i = 0; i < n3; ++i) {
                    object = forkJoinWorkerThreadArray[i + n2 & n - 1];
                    if (object == null || ((ForkJoinWorkerThread)object).queueBase == ((ForkJoinWorkerThread)object).queueTop) continue;
                    object2 = object;
                    break;
                }
            }
            if (object2 != null) {
                if (!bl) {
                    bl = true;
                    forkJoinPool.addActiveCount(1);
                }
                if ((object2 != this ? ((ForkJoinWorkerThread)object2).deqTask() : (object = this.locallyFifo ? this.locallyDeqTask() : this.popTask())) == null) continue;
                this.currentSteal = object;
                ((ForkJoinTask)object).doExec();
                this.currentSteal = forkJoinTask;
                continue;
            }
            if (bl) {
                bl = false;
                forkJoinPool.addActiveCount(-1);
            }
            if (forkJoinPool.isQuiescent()) break;
        }
        forkJoinPool.addActiveCount(1);
        forkJoinPool.addQuiescerCount(-1);
    }

    static {
        int n;
        try {
            UNSAFE = Unsafe.getUnsafe();
            Class<ForkJoinTask[]> clazz = ForkJoinTask[].class;
            ABASE = UNSAFE.arrayBaseOffset(clazz);
            n = UNSAFE.arrayIndexScale(clazz);
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
        if ((n & n - 1) != 0) {
            throw new Error("data type scale not a power of two");
        }
        ASHIFT = 31 - Integer.numberOfLeadingZeros(n);
    }
}

