/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.params;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.stubs.EmptyStub;
import com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;

public class GrParameterListImpl
extends GrStubElementBase<EmptyStub>
implements GrParameterList,
StubBasedPsiElement<EmptyStub> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.lang.psi.impl.statements.params.GrParameterListImpl");

    public GrParameterListImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterListImpl", "<init>"));
        }
        super(node);
    }

    public GrParameterListImpl(EmptyStub stub) {
        super(stub, (IStubElementType)GroovyElementTypes.PARAMETERS_LIST);
    }

    @Override
    public PsiElement getParent() {
        return this.getParentByStub();
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitParameterList(this);
    }

    public String toString() {
        return "Parameter list";
    }

    @Override
    @NotNull
    public GrParameter[] getParameters() {
        GrParameter[] grParameterArray = (GrParameter[])this.getStubOrPsiChildren(GroovyElementTypes.PARAMETER, GrParameter.ARRAY_FACTORY);
        if (grParameterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterListImpl", "getParameters"));
        }
        return grParameterArray;
    }

    public int getParameterIndex(PsiParameter parameter) {
        LOG.assertTrue(parameter.getParent() == this);
        return PsiImplUtil.getParameterIndex((PsiParameter)parameter, (PsiParameterList)this);
    }

    public int getParametersCount() {
        return this.getParameters().length;
    }

    @Override
    public int getParameterNumber(GrParameter parameter) {
        GrParameter[] parameters = this.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            GrParameter param = parameters[i];
            if (param != parameter) continue;
            return i;
        }
        return -1;
    }

    public ASTNode addInternal(ASTNode first, ASTNode last, ASTNode anchor, Boolean before) {
        GrParameter[] params = this.getParameters();
        ASTNode result = super.addInternal(first, last, anchor, before);
        if (first == last && first.getPsi() instanceof GrParameter && params.length > 0) {
            if (before.booleanValue() && anchor != null) {
                this.getNode().addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", anchor);
            } else if (before.booleanValue() && anchor == null) {
                this.getNode().addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", result);
            } else if (!before.booleanValue() && anchor != null) {
                this.getNode().addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", result);
            } else if (!before.booleanValue() && anchor == null) {
                this.getNode().addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", result.getTreeNext());
            }
        }
        return result;
    }
}

