/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.AssignmentExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.BinaryExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class ConditionalExpression {
    public static boolean parse(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker marker = builder.mark();
        if (BinaryExpression.parseLogicalExpression(builder, parser)) {
            ConditionalExpression.parseAfterCondition(builder, parser, marker);
            return true;
        }
        marker.drop();
        return false;
    }

    public static void parseAfterCondition(PsiBuilder builder, GroovyParser parser, PsiBuilder.Marker marker) {
        if (ParserUtils.getToken(builder, GroovyTokenTypes.mQUESTION)) {
            ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
            if (!AssignmentExpression.parse(builder, parser)) {
                builder.error(GroovyBundle.message("expression.expected", new Object[0]));
            }
            if (ParserUtils.lookAhead(builder, GroovyTokenTypes.mNLS, GroovyTokenTypes.mCOLON)) {
                ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
            }
            if (ParserUtils.getToken(builder, GroovyTokenTypes.mCOLON, GroovyBundle.message("colon.expected", new Object[0]))) {
                ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
                ConditionalExpression.parse(builder, parser);
            }
            marker.done((IElementType)GroovyElementTypes.CONDITIONAL_EXPRESSION);
        } else if (ParserUtils.getToken(builder, GroovyTokenTypes.mELVIS)) {
            ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
            if (!ConditionalExpression.parse(builder, parser)) {
                builder.error(GroovyBundle.message("expression.expected", new Object[0]));
            }
            marker.done((IElementType)GroovyElementTypes.ELVIS_EXPRESSION);
        } else {
            marker.drop();
        }
    }
}

