/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.ivy;

import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.ivy.AbstractAttachSourceProvider;

public class IvyAttachSourceProvider
extends AbstractAttachSourceProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.ivy.IvyAttachSourceProvider");

    @Nullable
    private static String extractUrl(PropertiesFile properties, String artifactName) {
        String prefix = "artifact:" + artifactName + "#source#jar#";
        for (IProperty property : properties.getProperties()) {
            String key = property.getUnescapedKey();
            if (key == null || !key.startsWith(prefix) || !key.endsWith(".location")) continue;
            return property.getUnescapedValue();
        }
        return null;
    }

    @NotNull
    public Collection<AttachSourcesProvider.AttachSourcesAction> getActions(List<LibraryOrderEntry> orderEntries, PsiFile psiFile) {
        VirtualFile srcFile;
        VirtualFile jar = IvyAttachSourceProvider.getJarByPsiFile(psiFile);
        if (jar == null) {
            List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/ivy/IvyAttachSourceProvider", "getActions"));
            }
            return list;
        }
        VirtualFile jarsDir = jar.getParent();
        if (jarsDir == null || !jarsDir.getName().equals("jars")) {
            List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/ivy/IvyAttachSourceProvider", "getActions"));
            }
            return list;
        }
        String jarNameWithoutExt = jar.getNameWithoutExtension();
        final VirtualFile artifactDir = jarsDir.getParent();
        if (artifactDir == null) {
            List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/ivy/IvyAttachSourceProvider", "getActions"));
            }
            return list;
        }
        String artifactName = artifactDir.getName();
        if (!jarNameWithoutExt.startsWith(artifactName) || !jarNameWithoutExt.substring(artifactName.length()).startsWith("-")) {
            List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/ivy/IvyAttachSourceProvider", "getActions"));
            }
            return list;
        }
        String version = jarNameWithoutExt.substring(artifactName.length() + 1);
        VirtualFile propertiesFile = artifactDir.findChild("ivydata-" + version + ".properties");
        if (propertiesFile == null) {
            List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/ivy/IvyAttachSourceProvider", "getActions"));
            }
            return list;
        }
        final Library library = IvyAttachSourceProvider.getLibraryFromOrderEntriesList(orderEntries);
        if (library == null) {
            List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/ivy/IvyAttachSourceProvider", "getActions"));
            }
            return list;
        }
        final String sourceFileName = artifactName + '-' + version + "-sources.jar";
        final VirtualFile sources = artifactDir.findChild("sources");
        if (sources != null && (srcFile = sources.findChild(sourceFileName)) != null) {
            VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(srcFile);
            if (jarRoot == null || ArrayUtil.contains((Object)jarRoot, (Object[])library.getFiles(OrderRootType.SOURCES))) {
                List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/ivy/IvyAttachSourceProvider", "getActions"));
                }
                return list;
            }
            Set<AttachSourcesProvider.AttachSourcesAction> set = Collections.singleton(new AbstractAttachSourceProvider.AttachExistingSourceAction(jarRoot, library, "Attache sources from Ivy repository"));
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/ivy/IvyAttachSourceProvider", "getActions"));
            }
            return set;
        }
        PsiFile propertiesFileFile = psiFile.getManager().findFile(propertiesFile);
        if (!(propertiesFileFile instanceof PropertiesFile)) {
            List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/ivy/IvyAttachSourceProvider", "getActions"));
            }
            return list;
        }
        String url = IvyAttachSourceProvider.extractUrl((PropertiesFile)propertiesFileFile, artifactName);
        if (StringUtil.isEmptyOrSpaces((String)url)) {
            List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/ivy/IvyAttachSourceProvider", "getActions"));
            }
            return list;
        }
        Set<AttachSourcesProvider.AttachSourcesAction> set = Collections.singleton(new AbstractAttachSourceProvider.DownloadSourcesAction(psiFile.getProject(), "Downloading Ivy Sources", url){

            @Override
            protected void storeFile(byte[] content) {
                try {
                    VirtualFile existingSourcesFolder = sources;
                    if (existingSourcesFolder == null) {
                        existingSourcesFolder = artifactDir.createChildDirectory((Object)this, "sources");
                    }
                    VirtualFile srcFile = existingSourcesFolder.createChildData((Object)this, sourceFileName);
                    srcFile.setBinaryContent(content);
                    IvyAttachSourceProvider.this.addSourceFile(JarFileSystem.getInstance().getJarRootForLocalFile(srcFile), library);
                }
                catch (IOException e) {
                    new Notification(this.myMessageGroupId, "IO Error", "Failed to save " + artifactDir.getPath() + "/sources/" + sourceFileName, NotificationType.ERROR).notify(this.myProject);
                    LOG.warn((Throwable)e);
                }
            }
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/ivy/IvyAttachSourceProvider", "getActions"));
        }
        return set;
    }
}

