/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import com.intellij.util.xmlb.XmlSerializerUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.PropertiesKt;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.compilerRunner.ArgumentUtils;
import org.jetbrains.kotlin.compilerRunner.CompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.CompilerOutputParser;
import org.jetbrains.kotlin.compilerRunner.CompilerRunnerUtil;
import org.jetbrains.kotlin.compilerRunner.KotlinCompilerRunner;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollector;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.daemon.client.CompilationServices;
import org.jetbrains.kotlin.daemon.client.DaemonReportMessage;
import org.jetbrains.kotlin.daemon.client.DaemonReportingTargets;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClient;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.DaemonReportCategory;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.PerfCounters;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.daemon.common.WallAndThreadAndMemoryTotalProfiler;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002CDB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J\u0012\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0002J'\u0010\u000e\u001a\u0002H\u000f\"\b\b\u0000\u0010\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u0002H\u000fH\u0002\u00a2\u0006\u0002\u0010\u0013J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J(\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#H\u0002J8\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)H\u0002JZ\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0018\u001a\u00020\u00192\f\u00100\u001a\b\u0012\u0004\u0012\u000202012\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u00104\u001a\u000202J>\u00105\u001a\u00020\u00152\u0006\u0010+\u001a\u00020\u00102\u0006\u00106\u001a\u0002072\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)2\u0006\u00108\u001a\u0002022\u0006\u0010\u0018\u001a\u00020\u0019J4\u00109\u001a\u00020\u00152\u0006\u0010:\u001a\u0002022\f\u00100\u001a\b\u0012\u0004\u0012\u000202012\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010<\u001a\u00020-H\u0002J\u0018\u0010=\u001a\u00020\u00152\u0006\u00108\u001a\u0002022\u0006\u0010<\u001a\u000207H\u0002J;\u0010>\u001a\u00020?2\u0006\u0010%\u001a\u00020\u00042\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00040A2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010BR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner;", "", "()V", "INTERNAL_ERROR", "", "K2JS_COMPILER", "K2JVM_COMPILER", "collectFieldsToCopy", "", "Ljava/lang/reflect/Field;", "clazz", "Ljava/lang/Class;", "getReturnCodeFromObject", "rc", "mergeBeans", "T", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "from", "to", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;)Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "processCompilerOutput", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "collector", "Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollector;", "stream", "Ljava/io/ByteArrayOutputStream;", "exitCode", "reportInternalCompilerError", "reportTotalAndThreadPerf", "message", "daemonOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;", "profiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "runCompiler", "compilerClassName", "arguments", "additionalArguments", "environment", "Lorg/jetbrains/kotlin/compilerRunner/CompilerEnvironment;", "runK2JsCompiler", "commonArguments", "k2jsArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;", "compilerSettings", "Lorg/jetbrains/kotlin/config/CompilerSettings;", "sourceFiles", "", "Ljava/io/File;", "libraryFiles", "outputFile", "runK2JvmCompiler", "k2jvmArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "moduleFile", "setupK2JsArguments", "_outputFile", "_libraryFiles", "settings", "setupK2JvmArguments", "tryCompileWithDaemon", "", "argsArray", "", "(Ljava/lang/String;[Ljava/lang/String;Lorg/jetbrains/kotlin/compilerRunner/CompilerEnvironment;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollector;)Z", "DaemonConnection", "getDaemonConnection", "jps-plugin"})
public final class KotlinCompilerRunner {
    private static final String K2JVM_COMPILER = "org.jetbrains.kotlin.cli.jvm.K2JVMCompiler";
    private static final String K2JS_COMPILER = "org.jetbrains.kotlin.cli.js.K2JSCompiler";
    private static final String INTERNAL_ERROR;
    public static final KotlinCompilerRunner INSTANCE;

    public final void runK2JvmCompiler(@NotNull CommonCompilerArguments commonArguments, @NotNull K2JVMCompilerArguments k2jvmArguments, @NotNull CompilerSettings compilerSettings, @NotNull MessageCollector messageCollector, @NotNull CompilerEnvironment environment, @NotNull File moduleFile, @NotNull OutputItemsCollector collector) {
        Intrinsics.checkParameterIsNotNull((Object)commonArguments, (String)"commonArguments");
        Intrinsics.checkParameterIsNotNull((Object)k2jvmArguments, (String)"k2jvmArguments");
        Intrinsics.checkParameterIsNotNull((Object)compilerSettings, (String)"compilerSettings");
        Intrinsics.checkParameterIsNotNull((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)moduleFile, (String)"moduleFile");
        Intrinsics.checkParameterIsNotNull((Object)collector, (String)"collector");
        K2JVMCompilerArguments arguments = (K2JVMCompilerArguments)this.mergeBeans(commonArguments, (CommonCompilerArguments)k2jvmArguments);
        this.setupK2JvmArguments(moduleFile, arguments);
        this.runCompiler(K2JVM_COMPILER, arguments, compilerSettings.getAdditionalArguments(), messageCollector, collector, environment);
    }

    public final void runK2JsCompiler(@NotNull CommonCompilerArguments commonArguments, @NotNull K2JSCompilerArguments k2jsArguments, @NotNull CompilerSettings compilerSettings, @NotNull MessageCollector messageCollector, @NotNull CompilerEnvironment environment, @NotNull OutputItemsCollector collector, @NotNull Collection<? extends File> sourceFiles, @NotNull List<String> libraryFiles, @NotNull File outputFile) {
        Intrinsics.checkParameterIsNotNull((Object)commonArguments, (String)"commonArguments");
        Intrinsics.checkParameterIsNotNull((Object)k2jsArguments, (String)"k2jsArguments");
        Intrinsics.checkParameterIsNotNull((Object)compilerSettings, (String)"compilerSettings");
        Intrinsics.checkParameterIsNotNull((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)collector, (String)"collector");
        Intrinsics.checkParameterIsNotNull(sourceFiles, (String)"sourceFiles");
        Intrinsics.checkParameterIsNotNull(libraryFiles, (String)"libraryFiles");
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        K2JSCompilerArguments arguments = (K2JSCompilerArguments)this.mergeBeans(commonArguments, (CommonCompilerArguments)k2jsArguments);
        this.setupK2JsArguments(outputFile, sourceFiles, libraryFiles, arguments);
        this.runCompiler(K2JS_COMPILER, arguments, compilerSettings.getAdditionalArguments(), messageCollector, collector, environment);
    }

    private final void processCompilerOutput(MessageCollector messageCollector, OutputItemsCollector collector, ByteArrayOutputStream stream, String exitCode) {
        BufferedReader reader = new BufferedReader(new StringReader(stream.toString()));
        CompilerOutputParser.parseCompilerMessagesFromReader(messageCollector, reader, collector);
        if (Intrinsics.areEqual((Object)INTERNAL_ERROR, (Object)exitCode)) {
            this.reportInternalCompilerError(messageCollector);
        }
    }

    private final void reportInternalCompilerError(MessageCollector messageCollector) {
        messageCollector.report(CompilerMessageSeverity.ERROR, "Compiler terminated with internal error", CompilerMessageLocation.NO_LOCATION);
    }

    /*
     * WARNING - void declaration
     */
    private final void runCompiler(String compilerClassName, CommonCompilerArguments arguments, String additionalArguments, MessageCollector messageCollector, OutputItemsCollector collector, CompilerEnvironment environment) {
        try {
            void $receiver$iv;
            messageCollector.report(CompilerMessageSeverity.INFO, "Using kotlin-home = " + environment.getKotlinPaths().getHomePath(), CompilerMessageLocation.NO_LOCATION);
            List<String> argumentsList = ArgumentUtils.convertArgumentsToStringList(arguments);
            argumentsList.addAll(StringsKt.split$default((CharSequence)additionalArguments, (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null));
            Collection collection = argumentsList;
            void v0 = $receiver$iv;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = (Collection)v0;
            String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] argsArray = (String[])((Object[])stringArray);
            if (!this.tryCompileWithDaemon(compilerClassName, argsArray, environment, messageCollector, collector)) {
                void $receiver$iv2;
                KotlinBuilder.Companion.getLOG().info("Compile in-process");
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                PrintStream out = new PrintStream(stream);
                String $i$f$toTypedArray = System.getProperty("compile.parallel", "false");
                if (Boolean.parseBoolean((String)$receiver$iv2)) {
                    System.setProperty(PropertiesKt.getKOTLIN_COMPILER_ENVIRONMENT_KEEPALIVE_PROPERTY(), "true");
                }
                Object rc = CompilerRunnerUtil.invokeExecMethod(compilerClassName, argsArray, environment, messageCollector, out);
                this.processCompilerOutput(messageCollector, collector, stream, this.getReturnCodeFromObject(rc));
            }
        }
        catch (Throwable e) {
            MessageCollectorUtil.reportException(messageCollector, e);
            this.reportInternalCompilerError(messageCollector);
        }
    }

    private final boolean tryCompileWithDaemon(String compilerClassName, String[] argsArray, CompilerEnvironment environment, MessageCollector messageCollector, OutputItemsCollector collector) {
        if (DaemonParamsKt.isDaemonEnabled()) {
            KotlinBuilder.Companion.getLOG().debug("Try to connect to daemon");
            DaemonConnection connection = getDaemonConnection.INSTANCE.invoke(environment, messageCollector);
            if (connection.getDaemon() != null) {
                CompileService.TargetPlatform targetPlatform;
                KotlinBuilder.Companion.getLOG().info("Connected to daemon");
                ByteArrayOutputStream compilerOut = new ByteArrayOutputStream();
                ByteArrayOutputStream daemonOut = new ByteArrayOutputStream();
                CompilationServices services = new CompilationServices(environment.getServices().get(IncrementalCompilationComponents.class), environment.getServices().get(CompilationCanceledStatus.class));
                String string = compilerClassName;
                if (Intrinsics.areEqual((Object)string, (Object)K2JVM_COMPILER)) {
                    targetPlatform = CompileService.TargetPlatform.JVM;
                } else if (Intrinsics.areEqual((Object)string, (Object)K2JS_COMPILER)) {
                    targetPlatform = CompileService.TargetPlatform.JS;
                } else {
                    throw (Throwable)new IllegalArgumentException("Unknown compiler type " + compilerClassName);
                }
                CompileService.TargetPlatform targetPlatform2 = targetPlatform;
                int res = KotlinCompilerClient.incrementalCompile$default(KotlinCompilerClient.INSTANCE, connection.getDaemon(), connection.getSessionId(), targetPlatform2, argsArray, services, compilerOut, daemonOut, 0, null, null, 896, null);
                this.processCompilerOutput(messageCollector, collector, compilerOut, String.valueOf(res));
                TextStreamsKt.forEachLine((Reader)new BufferedReader(new StringReader(daemonOut.toString())), (Function1)((Function1)new Function1<String, Unit>(messageCollector){
                    final /* synthetic */ MessageCollector $messageCollector;

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        this.$messageCollector.report(CompilerMessageSeverity.INFO, it, CompilerMessageLocation.NO_LOCATION);
                    }
                    {
                        this.$messageCollector = messageCollector;
                        super(1);
                    }
                }));
                return true;
            }
            KotlinBuilder.Companion.getLOG().info("Daemon not found");
        }
        return false;
    }

    private final void reportTotalAndThreadPerf(String message, DaemonOptions daemonOptions, MessageCollector messageCollector, Profiler profiler) {
        if (daemonOptions.getReportPerf()) {
            reportTotalAndThreadPerf.1 ms$ = reportTotalAndThreadPerf.1.INSTANCE;
            PerfCounters counters = profiler.getTotalCounters();
            messageCollector.report(CompilerMessageSeverity.INFO, "PERF: " + message + " " + ms$.invoke(counters.getTime()) + " ms, thread " + ms$.invoke(counters.getThreadTime()), CompilerMessageLocation.NO_LOCATION);
        }
    }

    private final String getReturnCodeFromObject(Object rc) {
        if (rc == null) {
            return INTERNAL_ERROR;
        }
        if (Intrinsics.areEqual((Object)ExitCode.class.getName(), (Object)rc.getClass().getName())) {
            return rc.toString();
        }
        throw (Throwable)new IllegalStateException("Unexpected return: " + rc);
    }

    private final <T extends CommonCompilerArguments> T mergeBeans(CommonCompilerArguments from, T to) {
        CommonCompilerArguments copy = (CommonCompilerArguments)XmlSerializerUtil.createCopy(to);
        List<Field> fromFields = this.collectFieldsToCopy(from.getClass());
        for (Field fromField : fromFields) {
            Field toField = copy.getClass().getField(fromField.getName());
            toField.set(copy, fromField.get(from));
        }
        CommonCompilerArguments commonCompilerArguments = copy;
        Intrinsics.checkExpressionValueIsNotNull((Object)commonCompilerArguments, (String)"copy");
        return (T)commonCompilerArguments;
    }

    private final List<Field> collectFieldsToCopy(Class<?> clazz) {
        ArrayList<Field> fromFields = new ArrayList<Field>();
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] fieldArray = currentClass.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
                fromFields.add(field);
            }
        }
        return fromFields;
    }

    private final void setupK2JvmArguments(File moduleFile, K2JVMCompilerArguments settings) {
        K2JVMCompilerArguments $receiver = settings;
        $receiver.module = moduleFile.getAbsolutePath();
        $receiver.noStdlib = true;
        $receiver.noJdk = true;
    }

    /*
     * WARNING - void declaration
     */
    private final void setupK2JsArguments(File _outputFile, Collection<? extends File> sourceFiles, List<String> _libraryFiles, K2JSCompilerArguments settings) {
        Object[] objectArray;
        void destination$iv$iv;
        void $receiver$iv$iv;
        Collection $receiver$iv;
        K2JSCompilerArguments $receiver = settings;
        $receiver.noStdlib = true;
        Iterable iterable = sourceFiles;
        K2JSCompilerArguments k2JSCompilerArguments = $receiver;
        void var8_8 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            objectArray = destination$iv$iv;
            String string = it.getPath();
            objectArray.add(string);
        }
        objectArray = (Object[])destination$iv$iv;
        k2JSCompilerArguments.freeArgs = objectArray;
        $receiver.outputFile = _outputFile.getPath();
        $receiver.metaInfo = true;
        $receiver$iv = _libraryFiles;
        k2JSCompilerArguments = $receiver;
        Collection collection2 = $receiver$iv;
        if (collection2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection2;
        String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        objectArray = stringArray;
        k2JSCompilerArguments.libraryFiles = (String[])objectArray;
    }

    private KotlinCompilerRunner() {
        INSTANCE = this;
        K2JVM_COMPILER = K2JVM_COMPILER;
        K2JS_COMPILER = K2JS_COMPILER;
        INTERNAL_ERROR = ExitCode.INTERNAL_ERROR.toString();
    }

    static {
        new KotlinCompilerRunner();
    }

    public static final /* synthetic */ void access$reportTotalAndThreadPerf(KotlinCompilerRunner $this, @NotNull String message, @NotNull DaemonOptions daemonOptions, @NotNull MessageCollector messageCollector, @NotNull Profiler profiler) {
        $this.reportTotalAndThreadPerf(message, daemonOptions, messageCollector, profiler);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner$DaemonConnection;", "", "daemon", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "sessionId", "", "(Lorg/jetbrains/kotlin/daemon/common/CompileService;I)V", "getDaemon", "()Lorg/jetbrains/kotlin/daemon/common/CompileService;", "getSessionId", "()I", "jps-plugin"})
    public static final class DaemonConnection {
        @Nullable
        private final CompileService daemon;
        private final int sessionId;

        @Nullable
        public final CompileService getDaemon() {
            return this.daemon;
        }

        public final int getSessionId() {
            return this.sessionId;
        }

        public DaemonConnection(@Nullable CompileService daemon, int sessionId) {
            this.daemon = daemon;
            this.sessionId = sessionId;
        }

        public /* synthetic */ DaemonConnection(CompileService compileService, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                n = CompileService.Companion.getNO_SESSION();
            }
            this(compileService, n);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0087\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner$getDaemonConnection;", "", "()V", "connection", "Lorg/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner$DaemonConnection;", "invoke", "environment", "Lorg/jetbrains/kotlin/compilerRunner/CompilerEnvironment;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "jps-plugin"})
    public static final class getDaemonConnection {
        private static volatile DaemonConnection connection;
        public static final getDaemonConnection INSTANCE;

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final synchronized DaemonConnection invoke(@NotNull CompilerEnvironment environment, @NotNull MessageCollector messageCollector) {
            block4: {
                Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
                Intrinsics.checkParameterIsNotNull((Object)messageCollector, (String)"messageCollector");
                if (getDaemonConnection.connection != null) break block4;
                libPath = CompilerRunnerUtil.getLibPath(environment.getKotlinPaths(), messageCollector);
                compilerId = CompilerId.Companion.makeCompilerId(new File[]{new File(libPath, "kotlin-compiler.jar")});
                daemonOptions = DaemonParamsKt.configureDaemonOptions();
                var7_6 = new String[]{};
                var8_7 = true;
                var9_9 = true;
                daemonJVMOptions = DaemonParamsKt.configureDaemonJVMOptions(var7_6, var9_9, var8_7);
                daemonReportMessages = new ArrayList<E>();
                profiler = daemonOptions.getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                profiler.withMeasure(null, (Function0)new Function0<Unit>(compilerId, daemonJVMOptions, daemonOptions, daemonReportMessages){
                    final /* synthetic */ CompilerId $compilerId;
                    final /* synthetic */ DaemonJVMOptions $daemonJVMOptions;
                    final /* synthetic */ DaemonOptions $daemonOptions;
                    final /* synthetic */ ArrayList $daemonReportMessages;

                    public final void invoke() {
                        CompileService daemon;
                        invoke.1 newFlagFile$ = invoke.1.INSTANCE;
                        Object object = daemon = KotlinCompilerClient.INSTANCE.connectToCompileService(this.$compilerId, this.$daemonJVMOptions, this.$daemonOptions, new DaemonReportingTargets(null, this.$daemonReportMessages), true, true);
                        getDaemonConnection.access$setConnection$p(getDaemonConnection.INSTANCE, new DaemonConnection(daemon, object != null && (object = object.leaseCompileSession(((File)newFlagFile$.invoke()).getAbsolutePath())) != null && (object = (Integer)((CompileService.CallResult)object).get()) != null ? ((Number)object).intValue() : CompileService.Companion.getNO_SESSION()));
                    }
                    {
                        this.$compilerId = compilerId;
                        this.$daemonJVMOptions = daemonJVMOptions;
                        this.$daemonOptions = daemonOptions;
                        this.$daemonReportMessages = arrayList;
                        super(0);
                    }
                });
                for (DaemonReportMessage msg : daemonReportMessages) {
                    v0 = new StringBuilder();
                    if (!Intrinsics.areEqual((Object)msg.getCategory(), (Object)DaemonReportCategory.EXCEPTION)) ** GOTO lbl-1000
                    v1 = getDaemonConnection.connection;
                    if ((v1 != null ? v1.getDaemon() : null) == null) {
                        v2 = "Falling  back to compilation without daemon due to error: ";
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = "";
                    }
                    messageCollector.report(CompilerMessageSeverity.INFO, v0.append(v2).append(msg.getMessage()).toString(), CompilerMessageLocation.NO_LOCATION);
                }
                KotlinCompilerRunner.access$reportTotalAndThreadPerf(KotlinCompilerRunner.INSTANCE, "Daemon connect", daemonOptions, messageCollector, profiler);
            }
            v3 = getDaemonConnection.connection;
            if (v3 == null) {
                Intrinsics.throwNpe();
            }
            return v3;
        }

        private getDaemonConnection() {
            INSTANCE = this;
        }

        static {
            new getDaemonConnection();
        }

        @Nullable
        public static final /* synthetic */ DaemonConnection access$getConnection$p(getDaemonConnection $this) {
            getDaemonConnection getDaemonConnection2 = $this;
            return connection;
        }

        public static final /* synthetic */ void access$setConnection$p(getDaemonConnection $this, @Nullable DaemonConnection daemonConnection) {
            getDaemonConnection getDaemonConnection2 = $this;
            connection = daemonConnection;
        }
    }
}

