/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.concurrency.SchedulingWrapper;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

class BoundedScheduledExecutorService
extends SchedulingWrapper {
    BoundedScheduledExecutorService(@NotNull ExecutorService backendExecutor, int maxSimultaneousTasks) {
        if (backendExecutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backendExecutor", "com/intellij/util/concurrency/BoundedScheduledExecutorService", "<init>"));
        }
        super(new BoundedTaskExecutor(backendExecutor, maxSimultaneousTasks), ((AppScheduledExecutorService)AppExecutorUtil.getAppScheduledExecutorService()).delayQueue);
        assert (!(backendExecutor instanceof ScheduledExecutorService)) : "backendExecutor is already ScheduledExecutorService: " + backendExecutor;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.backendExecutorService.shutdown();
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        List<Runnable> list = ContainerUtil.concat(super.shutdownNow(), this.backendExecutorService.shutdownNow());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/BoundedScheduledExecutorService", "shutdownNow"));
        }
        return list;
    }

    @Override
    public boolean isShutdown() {
        return super.isShutdown() && this.backendExecutorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return super.isTerminated() && this.backendExecutorService.isTerminated();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException {
        void unit;
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/util/concurrency/BoundedScheduledExecutorService", "awaitTermination"));
        }
        return super.awaitTermination(timeout, (TimeUnit)unit) && this.backendExecutorService.awaitTermination(timeout, (TimeUnit)unit);
    }
}

