/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.refactoring;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.intellij.lang.xpath.XPathFileType;
import org.intellij.lang.xpath.psi.XPathElement;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathVariable;
import org.intellij.lang.xpath.psi.XPathVariableReference;
import org.intellij.lang.xpath.psi.impl.XPathChangeUtil;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.psi.XsltElement;
import org.intellij.lang.xpath.xslt.psi.XsltParameter;
import org.intellij.lang.xpath.xslt.psi.XsltVariable;
import org.intellij.lang.xpath.xslt.psi.impl.XsltLanguage;
import org.intellij.lang.xpath.xslt.util.XsltCodeInsightUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableInlineHandler
extends InlineActionHandler {
    private static final String NAME = "Inline";
    private static final String TITLE = "XSLT - Inline";

    public boolean isEnabledForLanguage(Language l) {
        return l == XPathFileType.XPATH.getLanguage() || l == XMLLanguage.INSTANCE || l == XsltLanguage.INSTANCE;
    }

    public boolean canInlineElement(PsiElement element) {
        XPathVariableReference reference = (XPathVariableReference)PsiTreeUtil.getParentOfType((PsiElement)element, XPathVariableReference.class, (boolean)false);
        if (reference != null) {
            return VariableInlineHandler.canInline(reference.resolve());
        }
        return VariableInlineHandler.canInline(element);
    }

    private static boolean canInline(PsiElement element) {
        return element instanceof XsltVariable && !(element instanceof XsltParameter);
    }

    public void inlineElement(Project project, Editor editor, PsiElement element) {
        XPathVariable variable;
        XPathVariableReference reference = (XPathVariableReference)PsiTreeUtil.getParentOfType((PsiElement)element, XPathVariableReference.class, (boolean)false);
        if (reference != null && (variable = reference.resolve()) != null && VariableInlineHandler.canInline(variable)) {
            VariableInlineHandler.invoke(variable, editor);
        }
        if (VariableInlineHandler.canInline(element)) {
            VariableInlineHandler.invoke((XPathVariable)element, editor);
        }
    }

    public static void invoke(@NotNull XPathVariable variable, Editor editor) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/intellij/lang/xpath/xslt/refactoring/VariableInlineHandler", "invoke"));
        }
        String type = ((FindUsagesProvider)LanguageFindUsages.INSTANCE.forLanguage(variable.getLanguage())).getType((PsiElement)variable);
        Project project = variable.getProject();
        final XmlTag tag = ((XsltElement)((Object)variable)).getTag();
        final String expression = tag.getAttributeValue("select");
        if (expression == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)MessageFormat.format("{0} ''{1}'' has no value.", StringUtil.capitalize((String)type), variable.getName()), (String)TITLE, null);
            return;
        }
        final Collection references = ReferencesSearch.search((PsiElement)variable, (SearchScope)new LocalSearchScope((PsiElement)tag.getParentTag()), (boolean)false).findAll();
        if (references.size() == 0) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)MessageFormat.format("{0} ''{1}'' is never used.", variable.getName()), (String)TITLE, null);
            return;
        }
        boolean hasExternalRefs = false;
        if (XsltSupport.isTopLevelElement(tag)) {
            Query query = ReferencesSearch.search((PsiElement)variable, (SearchScope)GlobalSearchScope.allScope((Project)project), (boolean)false);
            hasExternalRefs = !query.forEach((Processor)new Processor<PsiReference>(){
                int allRefs = 0;

                public boolean process(PsiReference psiReference) {
                    if (++this.allRefs > references.size()) {
                        return false;
                    }
                    return references.contains(psiReference);
                }
            });
        }
        HighlightManager highlighter = HighlightManager.getInstance((Project)project);
        ArrayList highlighters = new ArrayList();
        Object[] psiReferences = references.toArray(new PsiReference[references.size()]);
        TextRange[] ranges = (TextRange[])ContainerUtil.map2Array((Object[])psiReferences, TextRange.class, (Function)new Function<PsiReference, TextRange>(){

            public TextRange fun(PsiReference s) {
                PsiElement psiElement = s.getElement();
                XmlAttributeValue context = (XmlAttributeValue)PsiTreeUtil.getContextOfType((PsiElement)psiElement, XmlAttributeValue.class, (boolean)true);
                if (psiElement instanceof XPathElement && context != null) {
                    return XsltCodeInsightUtil.getRangeInsideHostingFile((XPathElement)psiElement).cutOut(s.getRangeInElement());
                }
                return psiElement.getTextRange().cutOut(s.getRangeInElement());
            }
        });
        Editor e = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
        for (TextRange range : ranges) {
            TextAttributes textAttributes = EditorColors.SEARCH_RESULT_ATTRIBUTES.getDefaultAttributes();
            Color color = VariableInlineHandler.getScrollmarkColor(textAttributes);
            highlighter.addOccurrenceHighlight(e, range.getStartOffset(), range.getEndOffset(), textAttributes, 1, highlighters, color);
        }
        highlighter.addOccurrenceHighlights(e, new PsiElement[]{((XsltVariable)variable).getNameIdentifier()}, EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES.getDefaultAttributes(), false, highlighters);
        if (!hasExternalRefs) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                Object[] objectArray = new Object[4];
                objectArray[0] = type;
                objectArray[1] = variable.getName();
                objectArray[2] = String.valueOf(references.size());
                Object object = objectArray[3] = references.size() > 1 ? "s" : "";
                if (Messages.showYesNoDialog((String)MessageFormat.format("Inline {0} ''{1}''? ({2} occurrence{3})", objectArray), (String)TITLE, (Icon)Messages.getQuestionIcon()) != 0) {
                    return;
                }
            }
        } else if (!ApplicationManager.getApplication().isUnitTestMode()) {
            Object[] objectArray = new Object[4];
            objectArray[0] = type;
            objectArray[1] = variable.getName();
            objectArray[2] = String.valueOf(references.size());
            Object object = objectArray[3] = references.size() > 1 ? "s" : "";
            if (Messages.showYesNoDialog((String)MessageFormat.format("Inline {0} ''{1}''? ({2} local occurrence{3})\n\nWarning: It is being used in external files. Its declaration will not be removed.", objectArray), (String)TITLE, (Icon)Messages.getWarningIcon()) != 0) {
                return;
            }
        }
        final boolean hasRefs = hasExternalRefs;
        new WriteCommandAction.Simple(project, "XSLT.Inline", new PsiFile[]{tag.getContainingFile()}){

            protected void run() throws Throwable {
                try {
                    for (PsiReference psiReference : references) {
                        PsiElement element = psiReference.getElement();
                        if (element instanceof XPathElement) {
                            XPathExpression newExpr = XPathChangeUtil.createExpression(element, expression);
                            element.replace((PsiElement)newExpr);
                            continue;
                        }
                        assert (false);
                    }
                    if (!hasRefs) {
                        tag.delete();
                    }
                }
                catch (IncorrectOperationException e) {
                    Logger.getInstance((String)VariableInlineHandler.class.getName()).error((Throwable)e);
                }
            }
        }.execute();
    }

    @Nullable
    private static Color getScrollmarkColor(TextAttributes textAttributes) {
        if (textAttributes.getErrorStripeColor() != null) {
            return textAttributes.getErrorStripeColor();
        }
        if (textAttributes.getBackgroundColor() != null) {
            return textAttributes.getBackgroundColor().darker();
        }
        return null;
    }
}

