/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.CustomFormattingModelBuilder;
import com.intellij.formatting.DelegatingFormattingModel;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlPolicy;
import com.intellij.psi.xml.XmlTag;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class XsltFormattingModelBuilder
implements CustomFormattingModelBuilder {
    private final FormattingModelBuilder myBuilder;

    public XsltFormattingModelBuilder(FormattingModelBuilder builder) {
        this.myBuilder = builder;
    }

    public boolean isEngagedToFormat(PsiElement context) {
        PsiFile file = context.getContainingFile();
        if (file == null) {
            return false;
        }
        if (file.getFileType() == XmlFileType.INSTANCE && file.getLanguage() == XMLLanguage.INSTANCE) {
            return XsltSupport.isXsltFile(file);
        }
        return false;
    }

    @Nullable
    public TextRange getRangeAffectingIndent(PsiFile file, int offset, ASTNode elementAtOffset) {
        return this.myBuilder.getRangeAffectingIndent(file, offset, elementAtOffset);
    }

    @NotNull
    public FormattingModel createModel(PsiElement element, CodeStyleSettings settings) {
        FormattingModel baseModel = this.myBuilder.createModel(element, settings);
        DelegatingFormattingModel delegatingFormattingModel = new DelegatingFormattingModel(baseModel, XsltFormattingModelBuilder.getDelegatingBlock(settings, baseModel));
        if (delegatingFormattingModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/XsltFormattingModelBuilder", "createModel"));
        }
        return delegatingFormattingModel;
    }

    static Block getDelegatingBlock(CodeStyleSettings settings, FormattingModel baseModel) {
        Block block = baseModel.getRootBlock();
        if (block instanceof XmlBlock) {
            XmlBlock xmlBlock = (XmlBlock)block;
            XmlPolicy xmlPolicy = new XmlPolicy(settings, baseModel.getDocumentModel()){

                public boolean keepWhiteSpacesInsideTag(XmlTag xmlTag) {
                    return super.keepWhiteSpacesInsideTag(xmlTag) || XsltFormattingModelBuilder.isXslTextTag(xmlTag);
                }

                public boolean isTextElement(XmlTag tag) {
                    return super.isTextElement(tag) || XsltFormattingModelBuilder.isXslTextTag(tag) || XsltFormattingModelBuilder.isXslValueOfTag(tag);
                }
            };
            ASTNode node = xmlBlock.getNode();
            Wrap wrap = xmlBlock.getWrap();
            Alignment alignment = xmlBlock.getAlignment();
            Indent indent = xmlBlock.getIndent();
            TextRange textRange = xmlBlock.getTextRange();
            return new XmlBlock(node, wrap, alignment, (XmlFormattingPolicy)xmlPolicy, indent, textRange);
        }
        return block;
    }

    private static boolean isXslTextTag(XmlTag xmlTag) {
        return "text".equals(xmlTag.getLocalName()) && "http://www.w3.org/1999/XSL/Transform".equals(xmlTag.getNamespace());
    }

    private static boolean isXslValueOfTag(XmlTag xmlTag) {
        return "value-of".equals(xmlTag.getLocalName()) && "http://www.w3.org/1999/XSL/Transform".equals(xmlTag.getNamespace());
    }
}

