/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import git4idea.GitUtil;
import git4idea.repo.GitRepository;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.GithubShowCommitInBrowserAction;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubShowCommitInBrowserFromLogAction
extends GithubShowCommitInBrowserAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/github/GithubShowCommitInBrowserFromLogAction", "update"));
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        if (project == null || log == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        List selectedCommits = log.getSelectedCommits();
        if (selectedCommits.size() != 1) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        CommitId commit = (CommitId)ContainerUtil.getFirstItem((List)selectedCommits);
        if (commit == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager((Project)project).getRepositoryForRoot(commit.getRoot());
        e.getPresentation().setEnabledAndVisible(repository != null && GithubUtil.isRepositoryOnGitHub(repository));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/github/GithubShowCommitInBrowserFromLogAction", "actionPerformed"));
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        CommitId commit = (CommitId)ContainerUtil.getFirstItem((List)((VcsLog)e.getRequiredData(VcsLogDataKeys.VCS_LOG)).getSelectedCommits());
        assert (commit != null);
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager((Project)project).getRepositoryForRoot(commit.getRoot());
        GithubShowCommitInBrowserFromLogAction.openInBrowser(project, repository, commit.getHash().asString());
    }
}

