/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.tools.idea.sdk.SdkLoggerIntegration;
import com.android.tools.idea.welcome.install.InstallContext;
import com.google.common.base.Objects;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkManagerProgressIndicatorIntegration
extends SdkLoggerIntegration {
    private final ProgressIndicator myIndicator;
    private final InstallContext myContext;
    private final int myComponentCount;
    private int myCompletedOperations;
    private String previousTitle;
    private StringBuffer myErrors;

    public SdkManagerProgressIndicatorIntegration(@NotNull ProgressIndicator indicator, @NotNull InstallContext context, int componentCount) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/welcome/install/SdkManagerProgressIndicatorIntegration", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/welcome/install/SdkManagerProgressIndicatorIntegration", "<init>"));
        }
        this.myCompletedOperations = -1;
        this.myErrors = new StringBuffer();
        assert (componentCount > 0);
        this.myIndicator = indicator;
        this.myContext = context;
        this.myComponentCount = componentCount;
    }

    @Override
    protected void setProgress(int progress) {
        double completedOperations = (double)progress / 100.0 + (double)this.myCompletedOperations;
        double progressBar = completedOperations / (double)(this.myComponentCount * 2);
        this.myIndicator.setFraction(progressBar);
    }

    @Override
    protected void setDescription(String description) {
    }

    @Override
    protected void setTitle(String title) {
        if (!StringUtil.isEmptyOrSpaces((String)title) && !Objects.equal((Object)title, (Object)this.previousTitle)) {
            this.previousTitle = title;
            ++this.myCompletedOperations;
            this.myIndicator.setText(this.previousTitle);
            this.setProgress(0);
        }
    }

    @Override
    protected void lineAdded(String string) {
        this.myContext.print(string, ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    @Override
    public void error(@Nullable Throwable t, @Nullable String msgFormat, Object ... args) {
        if (t != null) {
            this.myErrors.append(String.format("%s: %s\n", t.getClass().getName(), t.getMessage()));
        }
        if (msgFormat != null) {
            this.myErrors.append(String.format(msgFormat, args));
        }
        super.error(t, msgFormat, args);
    }

    @Override
    public void warning(@NotNull String msgFormat, Object ... args) {
        if (msgFormat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msgFormat", "com/android/tools/idea/welcome/install/SdkManagerProgressIndicatorIntegration", "warning"));
        }
        this.myErrors.append(String.format("Warning: %s\n", String.format(msgFormat, args)));
        super.warning(msgFormat, args);
    }

    public String getErrors() {
        return this.myErrors.toString();
    }
}

