/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.sdklib.repository.FullRevision;
import com.android.tools.idea.stats.Distribution;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ResourceUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DistributionService {
    private static final Logger LOG = Logger.getInstance(DistributionService.class);
    private static final long REFRESH_INTERVAL = TimeUnit.DAYS.toMillis(1L);
    private static final long RETRY_INTERVAL = TimeUnit.HOURS.toMillis(1L);
    private static final String STATS_URL = "https://dl.google.com/android/studio/metadata/distributions.json";
    private static final String STATS_FILENAME = "distributions.json";
    private static final URL FALLBACK_URL = ResourceUtil.getResource(DistributionService.class, (String)"wizardData", (String)"distributions.json");
    private static final File CACHE_PATH = new File(PathManager.getSystemPath(), "stats");
    private static final String FILE_PATTERN = FileUtil.getNameWithoutExtension((String)"distributions.json") + "(_[0-9]+)?\\." + FileUtilRt.getExtension((String)"distributions.json");
    private List<Distribution> myDistributions = null;
    private long myRefreshTime;
    private long myAttemptTime;
    private final FileDownloader myDownloader;
    private final List<Runnable> mySuccesses = Lists.newLinkedList();
    private final List<Runnable> myFailures = Lists.newArrayList();
    private final Object myLock = new Object();
    private final File myCachePath;
    private volatile boolean myRunning = false;
    private static DistributionService ourInstance;

    public static DistributionService getInstance() {
        if (ourInstance == null) {
            DownloadableFileDescription description = DownloadableFileService.getInstance().createFileDescription(STATS_URL, STATS_FILENAME);
            FileDownloader downloader = DownloadableFileService.getInstance().createDownloader((List)ImmutableList.of((Object)description), "Distribution Stats");
            ourInstance = new DistributionService(downloader, CACHE_PATH);
        }
        return ourInstance;
    }

    @Nullable
    public List<Distribution> getDistributions() {
        if (this.myDistributions == null) {
            return null;
        }
        return ImmutableList.copyOf(this.myDistributions);
    }

    public double getSupportedDistributionForApiLevel(int apiLevel) {
        this.refreshSynchronously();
        if (this.myDistributions == null) {
            return -1.0;
        }
        double unsupportedSum = 0.0;
        for (Distribution d : this.myDistributions) {
            if (d.getApiLevel() >= apiLevel) break;
            unsupportedSum += d.getDistributionPercentage();
        }
        return 1.0 - unsupportedSum;
    }

    @Nullable
    public Distribution getDistributionForApiLevel(int apiLevel) {
        this.refreshSynchronously();
        for (Distribution d : this.myDistributions) {
            if (d.getApiLevel() != apiLevel) continue;
            return d;
        }
        return null;
    }

    public void refreshSynchronously() {
        final Semaphore completed = new Semaphore();
        completed.down();
        Runnable complete = new Runnable(){

            @Override
            public void run() {
                completed.up();
            }
        };
        this.refresh(complete, complete);
        completed.waitFor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(@Nullable Runnable success, @Nullable Runnable failure) {
        final long time = System.currentTimeMillis();
        Object object = this.myLock;
        synchronized (object) {
            if (success != null) {
                this.mySuccesses.add(success);
            }
            if (failure != null) {
                this.myFailures.add(failure);
            }
            if (this.myRunning && time < this.myAttemptTime + RETRY_INTERVAL) {
                return;
            }
            if (time < this.myRefreshTime + REFRESH_INTERVAL) {
                this.runContinuations(this.mySuccesses);
                return;
            }
            if (time < this.myAttemptTime + RETRY_INTERVAL) {
                this.runContinuations(this.myFailures);
                return;
            }
            this.myAttemptTime = time;
            this.myRunning = true;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, "Downloading Stats", false, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/stats/DistributionService$2", "run"));
                }
                DistributionService.this.loadStatsSynchronously(time);
            }

            public boolean isHeadless() {
                return false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadStatsSynchronously(long time) {
        try {
            File downloaded = null;
            try {
                List result = this.myDownloader.download(this.myCachePath);
                if (!result.isEmpty()) {
                    downloaded = this.fixupFile((File)((Pair)result.get(0)).getFirst());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (downloaded == null) {
                downloaded = this.findLatestDownload();
            }
            if (downloaded != null) {
                try {
                    this.loadFromFile(downloaded.toURI().toURL());
                    this.myRefreshTime = time;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        finally {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myDistributions == null) {
                    this.loadFromFile(FALLBACK_URL);
                    this.runContinuations(this.myFailures);
                } else {
                    this.runContinuations(this.mySuccesses);
                }
                this.myRunning = false;
            }
        }
    }

    private File findLatestDownload() {
        long latestModTime = 0L;
        File latestFile = null;
        File[] files = this.myCachePath.listFiles();
        if (files != null) {
            for (File f : files) {
                if (!f.getName().matches(FILE_PATTERN) || f.lastModified() <= latestModTime) continue;
                latestFile = f;
                latestModTime = f.lastModified();
            }
        }
        return latestFile;
    }

    private File fixupFile(File downloaded) {
        File target = new File(this.myCachePath, STATS_FILENAME).getAbsoluteFile();
        if (!FileUtil.filesEqual((File)downloaded.getAbsoluteFile(), (File)target)) {
            try {
                if (target.delete() && downloaded.renameTo(target)) {
                    downloaded = target;
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return downloaded;
    }

    private void runContinuations(List<Runnable> continuations) {
        for (Runnable r : continuations) {
            r.run();
        }
        this.mySuccesses.clear();
        this.myFailures.clear();
    }

    DistributionService(FileDownloader downloader, File cachePath) {
        this.myDownloader = downloader;
        this.myCachePath = cachePath;
    }

    private void loadFromFile(URL url) {
        try {
            String jsonString = ResourceUtil.loadText((URL)url);
            this.myDistributions = DistributionService.loadDistributionsFromJson(jsonString);
        }
        catch (IOException e) {
            LOG.error("Error while trying to load distributions file", (Throwable)e);
        }
    }

    @Nullable
    private static List<Distribution> loadDistributionsFromJson(String jsonString) {
        Type fullRevisionType = new TypeToken<FullRevision>(){}.getType();
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(fullRevisionType, (Object)new JsonDeserializer<FullRevision>(){

            public FullRevision deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return FullRevision.parseRevision((String)json.getAsString());
            }
        });
        Gson gson = gsonBuilder.create();
        Type listType = new TypeToken<ArrayList<Distribution>>(){}.getType();
        try {
            return (List)gson.fromJson(jsonString, listType);
        }
        catch (JsonParseException e) {
            LOG.error("Parse exception while reading distributions.json", (Throwable)e);
            return null;
        }
    }
}

