/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor;

import com.android.ddmlib.Client;
import com.android.tools.chartlib.TimelineData;
import com.android.tools.idea.monitor.TimelineEventListener;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeviceSampler
implements Runnable {
    public static final int TYPE_UNREACHABLE = 0;
    public static final int TYPE_DATA = 1;
    public static final int TYPE_TIMEOUT = 2;
    public static final int INHERITED_TYPE_START = 3;
    @NotNull
    protected TimelineData myTimelineData;
    @NotNull
    protected final List<TimelineEventListener> myListeners;
    protected int mySampleFrequencyMs;
    @Nullable
    protected volatile Future<?> myExecutingTask;
    @Nullable
    protected volatile Client myClient;
    @NotNull
    private final Semaphore myDataSemaphore;
    protected volatile boolean myRunning;
    protected volatile CountDownLatch myTaskStatus;
    protected volatile boolean myIsPaused;

    public DeviceSampler(@NotNull TimelineData timelineData, int sampleFrequencyMs) {
        if (timelineData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timelineData", "com/android/tools/idea/monitor/DeviceSampler", "<init>"));
        }
        this.myListeners = Lists.newLinkedList();
        this.myTimelineData = timelineData;
        this.mySampleFrequencyMs = sampleFrequencyMs;
        this.myDataSemaphore = new Semaphore(0, true);
    }

    public void start() {
        if (this.myExecutingTask == null && this.myClient != null) {
            this.myRunning = true;
            this.myTaskStatus = new CountDownLatch(1);
            this.myExecutingTask = ApplicationManager.getApplication().executeOnPooledThread((Runnable)this);
            this.myClient.setHeapInfoUpdateEnabled(true);
            for (TimelineEventListener listener : this.myListeners) {
                listener.onStart();
            }
        }
    }

    public void stop() {
        if (this.myExecutingTask != null) {
            this.myRunning = false;
            this.myDataSemaphore.release();
            this.myExecutingTask.cancel(true);
            try {
                this.myTaskStatus.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.myClient != null) {
                this.myClient.setHeapInfoUpdateEnabled(false);
            }
            this.myExecutingTask = null;
            for (TimelineEventListener listener : this.myListeners) {
                listener.onStop();
            }
        }
    }

    @NotNull
    public TimelineData getTimelineData() {
        TimelineData timelineData = this.myTimelineData;
        if (timelineData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/DeviceSampler", "getTimelineData"));
        }
        return timelineData;
    }

    protected boolean requiresSamplerRestart(@Nullable Client client) {
        return client != this.myClient;
    }

    public final void setClient(@Nullable Client client) {
        if (this.requiresSamplerRestart(client)) {
            this.stop();
            this.myClient = client;
            this.prepareSampler(client);
            this.myTimelineData.clear();
            if (!this.myIsPaused) {
                this.start();
            }
        }
    }

    public final void setIsPaused(boolean paused) {
        this.myIsPaused = paused;
        if (this.myIsPaused) {
            if (this.myClient != null) {
                this.stop();
            }
        } else {
            this.myTimelineData.clear();
            this.prepareSampler(this.myClient);
            this.start();
        }
    }

    public final boolean getIsPaused() {
        return this.myIsPaused;
    }

    protected void prepareSampler(@Nullable Client client) {
    }

    @Nullable
    public Client getClient() {
        return this.myClient;
    }

    public void addListener(TimelineEventListener listener) {
        this.myListeners.add(listener);
    }

    public boolean isRunning() {
        return this.myExecutingTask != null && this.myRunning;
    }

    protected void forceSample() {
        this.myDataSemaphore.release();
    }

    @Override
    public void run() {
        long timeToWait = this.mySampleFrequencyMs;
        while (this.myRunning) {
            try {
                Client client;
                long start = System.currentTimeMillis();
                boolean acquired = this.myDataSemaphore.tryAcquire(timeToWait, TimeUnit.MILLISECONDS);
                if (this.myRunning && !this.myIsPaused) {
                    this.sample(acquired);
                }
                if ((timeToWait -= System.currentTimeMillis() - start) <= 0L) {
                    timeToWait = this.mySampleFrequencyMs;
                }
                if ((client = this.myClient) != null && client.isValid()) continue;
                this.stop();
            }
            catch (InterruptedException e) {
                this.myRunning = false;
            }
        }
        this.myTaskStatus.countDown();
    }

    @NotNull
    public abstract String getName();

    protected abstract void sample(boolean var1) throws InterruptedException;
}

