/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.Log;
import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.ddmlib.logcat.LogCatTimestamp;
import com.android.tools.idea.logcat.AndroidLogcatConstants;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.ConfiguredFilter;
import com.intellij.diagnostic.logging.LogFilter;
import com.intellij.diagnostic.logging.LogFilterListener;
import com.intellij.diagnostic.logging.LogFilterModel;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidLogFilterModel
extends LogFilterModel {
    private final List<LogFilterListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final StringBuilder myMessageSoFar = new StringBuilder();
    @Nullable
    private LogCatHeader myPrevHeader;
    @Nullable
    private LogCatTimestamp myRejectBeforeTime;
    @Nullable
    private Pattern myCustomPattern;
    private boolean myCustomApplicable = false;
    private boolean myConfiguredApplicable = false;
    private final List<AndroidLogFilter> myLogFilters = new ArrayList<AndroidLogFilter>();

    public AndroidLogFilterModel() {
        for (Log.LogLevel logLevel : Log.LogLevel.values()) {
            this.myLogFilters.add(new AndroidLogFilter(logLevel));
        }
    }

    public String getCustomFilter() {
        return "";
    }

    public void updateCustomPattern(@Nullable Pattern pattern) {
        this.myCustomPattern = pattern;
        this.fireTextFilterChange();
    }

    public final void updateConfiguredFilter(@Nullable ConfiguredFilter filter) {
        this.setConfiguredFilter(filter);
        this.fireTextFilterChange();
    }

    protected void setConfiguredFilter(@Nullable ConfiguredFilter filter) {
    }

    @Nullable
    protected ConfiguredFilter getConfiguredFilter() {
        return null;
    }

    protected abstract void saveLogLevel(String var1);

    public final void addFilterListener(LogFilterListener listener) {
        this.myListeners.add(listener);
    }

    public final void removeFilterListener(LogFilterListener listener) {
        this.myListeners.remove(listener);
    }

    public void beginRejectingOldMessages() {
        if (this.myPrevHeader == null) {
            return;
        }
        this.myRejectBeforeTime = this.myPrevHeader.getTimestamp();
    }

    private void fireTextFilterChange() {
        for (LogFilterListener listener : this.myListeners) {
            listener.onTextFilterChange();
        }
    }

    private void fireFilterChange(LogFilter filter) {
        for (LogFilterListener listener : this.myListeners) {
            listener.onFilterStateChange(filter);
        }
    }

    private static Key getProcessOutputType(@NotNull Log.LogLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/android/tools/idea/logcat/AndroidLogFilterModel", "getProcessOutputType"));
        }
        switch (level) {
            case VERBOSE: {
                return AndroidLogcatConstants.VERBOSE;
            }
            case INFO: {
                return AndroidLogcatConstants.INFO;
            }
            case DEBUG: {
                return AndroidLogcatConstants.DEBUG;
            }
            case WARN: {
                return AndroidLogcatConstants.WARNING;
            }
            case ERROR: {
                return AndroidLogcatConstants.ERROR;
            }
            case ASSERT: {
                return AndroidLogcatConstants.ASSERT;
            }
        }
        return ProcessOutputTypes.STDOUT;
    }

    public final boolean isApplicable(String line) {
        if (this.myCustomPattern != null && !this.myCustomPattern.matcher(line).find()) {
            return false;
        }
        LogFilter selectedLogLevelFilter = this.getSelectedLogLevelFilter();
        return selectedLogLevelFilter == null || selectedLogLevelFilter.isAcceptable(line);
    }

    private boolean isApplicableByConfiguredFilter(String message) {
        ConfiguredFilter configuredFilter = this.getConfiguredFilter();
        if (configuredFilter == null) {
            return true;
        }
        assert (this.myPrevHeader != null);
        return configuredFilter.isApplicable(message, this.myPrevHeader.getTag(), this.myPrevHeader.getAppName(), this.myPrevHeader.getPid(), this.myPrevHeader.getLogLevel());
    }

    public final List<? extends LogFilter> getLogFilters() {
        return this.myLogFilters;
    }

    public abstract String getSelectedLogLevelName();

    @Nullable
    private LogFilter getSelectedLogLevelFilter() {
        String filterName = this.getSelectedLogLevelName();
        if (filterName != null) {
            for (AndroidLogFilter logFilter : this.myLogFilters) {
                if (!filterName.equals(logFilter.myLogLevel.name())) continue;
                return logFilter;
            }
        }
        return null;
    }

    public boolean isFilterSelected(LogFilter filter) {
        return filter == this.getSelectedLogLevelFilter();
    }

    public void selectFilter(LogFilter filter) {
        if (!(filter instanceof AndroidLogFilter)) {
            return;
        }
        String newFilterName = ((AndroidLogFilter)filter).myLogLevel.name();
        if (!Comparing.equal((String)newFilterName, (String)this.getSelectedLogLevelName())) {
            this.saveLogLevel(newFilterName);
            this.fireFilterChange(filter);
        }
    }

    public void processingStarted() {
        this.myPrevHeader = null;
        this.myCustomApplicable = false;
        this.myConfiguredApplicable = false;
        this.myMessageSoFar.setLength(0);
    }

    @NotNull
    public final LogFilterModel.MyProcessingResult processLine(String line) {
        boolean isApplicable;
        boolean validContinuation;
        LogCatMessage message = AndroidLogcatFormatter.tryParseMessage(line);
        String continuation = message == null ? AndroidLogcatFormatter.tryParseContinuation(line) : null;
        boolean bl = validContinuation = continuation != null && this.myPrevHeader != null;
        if (message == null && !validContinuation) {
            LogFilterModel.MyProcessingResult myProcessingResult = new LogFilterModel.MyProcessingResult(ProcessOutputTypes.STDOUT, false, null);
            if (myProcessingResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/AndroidLogFilterModel", "processLine"));
            }
            return myProcessingResult;
        }
        if (message != null) {
            this.myPrevHeader = message.getHeader();
            this.myCustomApplicable = this.isApplicable(line);
            this.myConfiguredApplicable = this.isApplicableByConfiguredFilter(message.getMessage());
            this.myMessageSoFar.setLength(0);
        } else {
            this.myCustomApplicable = this.myCustomApplicable || this.isApplicable(continuation);
            this.myConfiguredApplicable = this.myConfiguredApplicable || this.isApplicableByConfiguredFilter(continuation);
        }
        boolean bl2 = isApplicable = this.myCustomApplicable && this.myConfiguredApplicable;
        if (isApplicable && this.myRejectBeforeTime != null) {
            boolean bl3 = isApplicable = !this.myPrevHeader.getTimestamp().isBefore(this.myRejectBeforeTime);
        }
        if (!isApplicable) {
            this.myMessageSoFar.append(line);
            this.myMessageSoFar.append('\n');
        }
        Key key = AndroidLogFilterModel.getProcessOutputType(this.myPrevHeader.getLogLevel());
        LogFilterModel.MyProcessingResult result = new LogFilterModel.MyProcessingResult(key, isApplicable, this.myMessageSoFar.toString());
        if (isApplicable) {
            this.myMessageSoFar.setLength(0);
        }
        LogFilterModel.MyProcessingResult myProcessingResult = result;
        if (myProcessingResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/AndroidLogFilterModel", "processLine"));
        }
        return myProcessingResult;
    }

    private final class AndroidLogFilter
    extends LogFilter {
        final Log.LogLevel myLogLevel;

        private AndroidLogFilter(Log.LogLevel logLevel) {
            super(StringUtil.capitalize((String)logLevel.name().toLowerCase()));
            this.myLogLevel = logLevel;
        }

        public boolean isAcceptable(String line) {
            return AndroidLogFilterModel.this.myPrevHeader != null && AndroidLogFilterModel.this.myPrevHeader.getLogLevel().getPriority() >= this.myLogLevel.getPriority();
        }
    }
}

