/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.quickfix;

import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.dsl.dependencies.ExternalDependencySpec;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.quickfix.AbstractGradleAwareFix;
import com.android.tools.idea.gradle.service.notification.hyperlink.CustomNotificationListener;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenFileHyperlink;
import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractGradleDependencyFix
extends AbstractGradleAwareFix {
    @NotNull
    protected final Module myModule;
    @NotNull
    protected final PsiReference myReference;
    @NotNull
    private VirtualFile myCurrentFile;
    private static final Logger LOG = Logger.getInstance(AbstractGradleDependencyFix.class);
    @Nullable
    protected String myAddedDependency;
    @Nullable
    protected String myAddedDependencyConfiguration;

    protected AbstractGradleDependencyFix(@NotNull Module module, @NotNull PsiReference reference) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/quickfix/AbstractGradleDependencyFix", "<init>"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/android/tools/idea/gradle/quickfix/AbstractGradleDependencyFix", "<init>"));
        }
        this.myModule = module;
        this.myReference = reference;
        this.myCurrentFile = this.myReference.getElement().getContainingFile().getVirtualFile();
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/quickfix/AbstractGradleDependencyFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/quickfix/AbstractGradleDependencyFix", "isAvailable"));
        }
        return !project.isDisposed() && !this.myModule.isDisposed();
    }

    static boolean isTestScope(@NotNull Module module, @NotNull PsiReference reference) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/quickfix/AbstractGradleDependencyFix", "isTestScope"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/android/tools/idea/gradle/quickfix/AbstractGradleDependencyFix", "isTestScope"));
        }
        VirtualFile location = PsiUtilCore.getVirtualFile((PsiElement)reference.getElement());
        return AbstractGradleDependencyFix.isTestScope(module, location);
    }

    static boolean isTestScope(@NotNull Module module, @Nullable VirtualFile location) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/quickfix/AbstractGradleDependencyFix", "isTestScope"));
        }
        return location != null && ModuleRootManager.getInstance((Module)module).getFileIndex().isInTestSourceContent(location);
    }

    @NotNull
    static String getConfigurationName(@NotNull Module module, boolean testScope) {
        AndroidFacet androidFacet;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/quickfix/AbstractGradleDependencyFix", "getConfigurationName"));
        }
        if (testScope && (androidFacet = AndroidFacet.getInstance(module)) != null) {
            AndroidGradleModel androidModel = AndroidGradleModel.get(androidFacet);
            String configurationName = "testCompile";
            if (androidModel != null && "_android_test_".equals(androidModel.getSelectedTestArtifactName())) {
                configurationName = "androidTestCompile";
            }
            String string = configurationName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/quickfix/AbstractGradleDependencyFix", "getConfigurationName"));
            }
            return string;
        }
        if ("compile" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/quickfix/AbstractGradleDependencyFix", "getConfigurationName"));
        }
        return "compile";
    }

    void addDependencyAndSync(final @NotNull String configurationName, final @NotNull ExternalDependencySpec dependency, final @NotNull Computable<PsiClass[]> getTargetClasses, final @Nullable Editor editor) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/quickfix/AbstractGradleDependencyFix", "addDependencyAndSync"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/quickfix/AbstractGradleDependencyFix", "addDependencyAndSync"));
        }
        if (getTargetClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getTargetClasses", "com/android/tools/idea/gradle/quickfix/AbstractGradleDependencyFix", "addDependencyAndSync"));
        }
        final GradleBuildModel buildModel = GradleBuildModel.get(this.myModule);
        if (buildModel == null) {
            return;
        }
        buildModel.dependencies().add(configurationName, dependency);
        GradleSyncListener.Adapter listener = new GradleSyncListener.Adapter(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/quickfix/AbstractGradleDependencyFix$1", "syncSucceeded"));
                }
                AbstractGradleDependencyFix.this.runAddImportAction(project, (Computable<PsiClass[]>)getTargetClasses, editor);
            }

            @Override
            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/quickfix/AbstractGradleDependencyFix$1", "syncFailed"));
                }
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/idea/gradle/quickfix/AbstractGradleDependencyFix$1", "syncFailed"));
                }
                AbstractGradleDependencyFix.this.runAddImportAction(project, (Computable<PsiClass[]>)getTargetClasses, editor);
            }
        };
        final Project project = this.myModule.getProject();
        AbstractGradleDependencyFix.runWriteCommandActionAndSync(project, new Runnable(){

            @Override
            public void run() {
                buildModel.applyChanges();
                AbstractGradleAwareFix.registerUndoAction(project);
                AbstractGradleDependencyFix.this.myAddedDependency = dependency.compactNotation();
                AbstractGradleDependencyFix.this.myAddedDependencyConfiguration = configurationName;
            }
        }, listener);
    }

    protected void runWriteCommandActionAndSync(@NotNull Project project, @NotNull Runnable action, final @NotNull Computable<PsiClass[]> getTargetClasses, final @Nullable Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/quickfix/AbstractGradleDependencyFix", "runWriteCommandActionAndSync"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/android/tools/idea/gradle/quickfix/AbstractGradleDependencyFix", "runWriteCommandActionAndSync"));
        }
        if (getTargetClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getTargetClasses", "com/android/tools/idea/gradle/quickfix/AbstractGradleDependencyFix", "runWriteCommandActionAndSync"));
        }
        GradleSyncListener.Adapter listener = new GradleSyncListener.Adapter(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/quickfix/AbstractGradleDependencyFix$3", "syncSucceeded"));
                }
                AbstractGradleDependencyFix.this.runAddImportAction(project, (Computable<PsiClass[]>)getTargetClasses, editor);
            }

            @Override
            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/quickfix/AbstractGradleDependencyFix$3", "syncFailed"));
                }
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/idea/gradle/quickfix/AbstractGradleDependencyFix$3", "syncFailed"));
                }
                AbstractGradleDependencyFix.this.runAddImportAction(project, (Computable<PsiClass[]>)getTargetClasses, editor);
            }
        };
        AbstractGradleDependencyFix.runWriteCommandActionAndSync(project, action, listener);
    }

    private void runAddImportAction(final @NotNull Project project, final @NotNull Computable<PsiClass[]> getTargetClasses, final @Nullable Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/quickfix/AbstractGradleDependencyFix", "runAddImportAction"));
        }
        if (getTargetClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getTargetClasses", "com/android/tools/idea/gradle/quickfix/AbstractGradleDependencyFix", "runAddImportAction"));
        }
        if (editor != null) {
            DumbService.getInstance((Project)project).withAlternativeResolveEnabled(new Runnable(){

                @Override
                public void run() {
                    PsiClass[] targetClasses = (PsiClass[])getTargetClasses.compute();
                    if (targetClasses != null) {
                        new AddImportAction(project, AbstractGradleDependencyFix.this.myReference, editor, targetClasses).execute();
                    } else {
                        GradleBuildFile gradleBuildFile = GradleBuildFile.get(AbstractGradleDependencyFix.this.myModule);
                        assert (gradleBuildFile != null);
                        LOG.assertTrue(StringUtil.isNotEmpty((String)AbstractGradleDependencyFix.this.myAddedDependency) && StringUtil.isNotEmpty((String)AbstractGradleDependencyFix.this.myAddedDependencyConfiguration), (Object)("Dependency is not recorded correctly by the quickfix: " + this.getClass().getName()));
                        OpenFileHyperlink buildFileHyperlink = new OpenFileHyperlink(gradleBuildFile.getFile().getPath(), gradleBuildFile.getFile().getName(), -1, -1);
                        OpenFileHyperlink javaFileHyperlink = new OpenFileHyperlink(AbstractGradleDependencyFix.this.myCurrentFile.getPath(), AbstractGradleDependencyFix.this.myCurrentFile.getName(), -1, -1);
                        String referenceName = AbstractGradleDependencyFix.this.myReference.getRangeInElement().substring(AbstractGradleDependencyFix.this.myReference.getElement().getText());
                        CustomNotificationListener notificationListener = new CustomNotificationListener(project, buildFileHyperlink, javaFileHyperlink);
                        AndroidGradleNotification.getInstance(project).showBalloon("Quick Fix Error", "Failed to add dependency. To manually fix this, please do the following:\n<ul><li>Add dependency '" + AbstractGradleDependencyFix.this.myAddedDependency + "' for configuration '" + AbstractGradleDependencyFix.this.myAddedDependencyConfiguration + "' in '" + buildFileHyperlink.toHtml() + "'.</li>\n" + "<li>Import class '" + referenceName + "' to '" + javaFileHyperlink.toHtml() + "'. </li></ul>", NotificationType.ERROR, (NotificationListener)notificationListener);
                    }
                }
            });
        }
    }
}

